/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.scheduler.HostTaskLocation;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.streaming.scheduler.RateTestReceiver;
import org.apache.spark.streaming.scheduler.RateTestReceiver$;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicy;
import org.apache.spark.streaming.scheduler.ReceiverState$;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005}1A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!9\u0011\u0004\u0001b\u0001\n\u0003Q\u0002B\u0002\u0010\u0001A\u0003%1DA\u000fSK\u000e,\u0017N^3s'\u000eDW\rZ;mS:<\u0007k\u001c7jGf\u001cV/\u001b;f\u0015\t1q!A\u0005tG\",G-\u001e7fe*\u0011\u0001\"C\u0001\ngR\u0014X-Y7j]\u001eT!AC\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013'5\t\u0011\"\u0003\u0002\u0015\u0013\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"A\u0003\u00021I,7-Z5wKJ\u001c6\r[3ek2Lgn\u001a)pY&\u001c\u00170F\u0001\u001c!\tAB$\u0003\u0002\u001e\u000b\tA\"+Z2fSZ,'oU2iK\u0012,H.\u001b8h!>d\u0017nY=\u00023I,7-Z5wKJ\u001c6\r[3ek2Lgn\u001a)pY&\u001c\u0017\u0010\t")
public class ReceiverSchedulingPolicySuite
extends SparkFunSuite {
    private final ReceiverSchedulingPolicy receiverSchedulingPolicy = new ReceiverSchedulingPolicy();

    public ReceiverSchedulingPolicy receiverSchedulingPolicy() {
        return this.receiverSchedulingPolicy;
    }

    public static final /* synthetic */ ExecutorCacheTaskLocation $anonfun$new$4(int i) {
        return new ExecutorCacheTaskLocation("host" + i, String.valueOf(BoxesRunTime.boxToInteger((int)i)));
    }

    public static final /* synthetic */ RateTestReceiver $anonfun$new$7(int x$1) {
        return new RateTestReceiver(x$1, RateTestReceiver$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ ExecutorCacheTaskLocation $anonfun$new$8(int executorId) {
        return new ExecutorCacheTaskLocation("localhost", Integer.toString(executorId));
    }

    public static final /* synthetic */ void $anonfun$new$9(HashMap numReceiversOnExecutor$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq locations;
            Seq $org_scalatest_assert_macro_left = locations = (Seq)tuple2._2();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            TaskLocation $org_scalatest_assert_macro_left2 = (TaskLocation)locations.apply(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.scheduler.ExecutorCacheTaskLocation", $org_scalatest_assert_macro_left2 instanceof ExecutorCacheTaskLocation, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            numReceiversOnExecutor$1.update(locations.apply(0), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)numReceiversOnExecutor$1.getOrElse(locations.apply(0), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ RateTestReceiver $anonfun$new$13(int x$3) {
        return new RateTestReceiver(x$3, RateTestReceiver$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ ExecutorCacheTaskLocation $anonfun$new$14(int executorId) {
        return new ExecutorCacheTaskLocation("localhost", Integer.toString(executorId));
    }

    public static final /* synthetic */ void $anonfun$new$16(HashMap numReceiversOnExecutor$2, TaskLocation l) {
        TaskLocation $org_scalatest_assert_macro_left = l;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.scheduler.ExecutorCacheTaskLocation", $org_scalatest_assert_macro_left instanceof ExecutorCacheTaskLocation, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        numReceiversOnExecutor$2.update((Object)l, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)numReceiversOnExecutor$2.getOrElse((Object)l, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
    }

    public static final /* synthetic */ void $anonfun$new$15(HashMap numReceiversOnExecutor$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Seq locations;
            Seq $org_scalatest_assert_macro_left = locations = (Seq)tuple2._2();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            locations.foreach((Function1 & Serializable)l -> {
                ReceiverSchedulingPolicySuite.$anonfun$new$16(numReceiversOnExecutor$2, l);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ RateTestReceiver $anonfun$new$20(int x$5) {
        return new RateTestReceiver(x$5, RateTestReceiver$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ RateTestReceiver $anonfun$new$21(int x$6) {
        return new RateTestReceiver(x$6, (Option<String>)new Some((Object)"localhost"));
    }

    public static final /* synthetic */ ExecutorCacheTaskLocation $anonfun$new$22(int executorId) {
        return new ExecutorCacheTaskLocation("localhost", Integer.toString(executorId));
    }

    public static final /* synthetic */ ExecutorCacheTaskLocation $anonfun$new$23(int executorId) {
        return new ExecutorCacheTaskLocation("localhost2", Integer.toString(executorId));
    }

    public static final /* synthetic */ void $anonfun$new$25(HashMap numReceiversOnExecutor$3, TaskLocation l) {
        TaskLocation $org_scalatest_assert_macro_left = l;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.scheduler.ExecutorCacheTaskLocation", $org_scalatest_assert_macro_left instanceof ExecutorCacheTaskLocation, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        numReceiversOnExecutor$3.update((Object)l, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)numReceiversOnExecutor$3.getOrElse((Object)l, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1)));
    }

    public static final /* synthetic */ void $anonfun$new$24(HashMap numReceiversOnExecutor$3, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Seq executors;
            Seq $org_scalatest_assert_macro_left = executors = (Seq)tuple2._2();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            executors.foreach((Function1 & Serializable)l -> {
                ReceiverSchedulingPolicySuite.$anonfun$new$25(numReceiversOnExecutor$3, l);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$28(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            int receiverId = tuple2._1$mcI$sp();
            return receiverId >= 3;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ ExecutorCacheTaskLocation $anonfun$new$30(int executorId) {
        return new ExecutorCacheTaskLocation("localhost", Integer.toString(executorId));
    }

    public static final /* synthetic */ RateTestReceiver $anonfun$new$33(int x$9) {
        return new RateTestReceiver(x$9, RateTestReceiver$.MODULE$.$lessinit$greater$default$2());
    }

    public ReceiverSchedulingPolicySuite() {
        this.test("rescheduleReceiver: empty executors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq scheduledLocations = this.receiverSchedulingPolicy().rescheduleReceiver(0, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty(), (Seq)package$.MODULE$.Seq().empty());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(scheduledLocations);
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().empty();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("rescheduleReceiver: receiver preferredLocation", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            .colon.colon executors = new .colon.colon((Object)new ExecutorCacheTaskLocation("host2", "2"), (List)Nil$.MODULE$);
            scala.collection.immutable.Map receiverTrackingInfoMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReceiverTrackingInfo(0, ReceiverState$.MODULE$.INACTIVE(), (Option)None$.MODULE$, (Option)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7()))}));
            Seq scheduledLocations = this.receiverSchedulingPolicy().rescheduleReceiver(0, (Option)new Some((Object)"host1"), (Map)receiverTrackingInfoMap, (Seq)executors);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(scheduledLocations.toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{new HostTaskLocation("host1"), (Product)executors.apply(0)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("rescheduleReceiver: return all idle executors if there are any idle executors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IndexedSeq executors = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable)i -> ReceiverSchedulingPolicySuite.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)i)));
            scala.collection.immutable.Map receiverTrackingInfoMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReceiverTrackingInfo(0, ReceiverState$.MODULE$.ACTIVE(), (Option)None$.MODULE$, (Option)new Some(executors.apply(0)), ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7()))}));
            Seq scheduledLocations = this.receiverSchedulingPolicy().rescheduleReceiver(1, (Option)None$.MODULE$, (Map)receiverTrackingInfoMap, (Seq)executors);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(scheduledLocations.toSet());
            Set $org_scalatest_assert_macro_right = ((IterableOnceOps)executors.tail()).toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("rescheduleReceiver: return all executors that have minimum weight if no idle executors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            .colon.colon executors = new .colon.colon((Object)new ExecutorCacheTaskLocation("host1", "1"), (List)new .colon.colon((Object)new ExecutorCacheTaskLocation("host2", "2"), (List)new .colon.colon((Object)new ExecutorCacheTaskLocation("host3", "3"), (List)new .colon.colon((Object)new ExecutorCacheTaskLocation("host4", "4"), (List)new .colon.colon((Object)new ExecutorCacheTaskLocation("host5", "5"), (List)Nil$.MODULE$)))));
            scala.collection.immutable.Map receiverTrackingInfoMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReceiverTrackingInfo(0, ReceiverState$.MODULE$.ACTIVE(), (Option)None$.MODULE$, (Option)new Some((Object)new ExecutorCacheTaskLocation("host1", "1")), ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ReceiverTrackingInfo(1, ReceiverState$.MODULE$.SCHEDULED(), (Option)new Some((Object)new .colon.colon((Object)new ExecutorCacheTaskLocation("host2", "2"), (List)new .colon.colon((Object)new ExecutorCacheTaskLocation("host3", "3"), (List)Nil$.MODULE$))), (Option)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ReceiverTrackingInfo(2, ReceiverState$.MODULE$.SCHEDULED(), (Option)new Some((Object)new .colon.colon((Object)new ExecutorCacheTaskLocation("host1", "1"), (List)new .colon.colon((Object)new ExecutorCacheTaskLocation("host3", "3"), (List)Nil$.MODULE$))), (Option)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ReceiverTrackingInfo(4, ReceiverState$.MODULE$.SCHEDULED(), (Option)new Some((Object)new .colon.colon((Object)new ExecutorCacheTaskLocation("host4", "4"), (List)new .colon.colon((Object)new ExecutorCacheTaskLocation("host5", "5"), (List)Nil$.MODULE$))), (Option)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7()))}));
            Seq scheduledLocations = this.receiverSchedulingPolicy().rescheduleReceiver(4, (Option)None$.MODULE$, (Map)receiverTrackingInfoMap, (Seq)executors);
            Set expectedScheduledLocations = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation("host2", "2"), new ExecutorCacheTaskLocation("host4", "4"), new ExecutorCacheTaskLocation("host5", "5")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(scheduledLocations.toSet());
            Set $org_scalatest_assert_macro_right = expectedScheduledLocations;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("scheduleReceivers: schedule receivers evenly when there are more receivers than executors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IndexedSeq receivers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).map((Function1 & Serializable)x$1 -> ReceiverSchedulingPolicySuite.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)x$1)));
            IndexedSeq executors = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable)executorId -> ReceiverSchedulingPolicySuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)executorId)));
            Map scheduledLocations = this.receiverSchedulingPolicy().scheduleReceivers((Seq)receivers, (Seq)executors);
            HashMap numReceiversOnExecutor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            scheduledLocations.foreach((Function1 & Serializable)x0$1 -> {
                ReceiverSchedulingPolicySuite.$anonfun$new$9(numReceiversOnExecutor, x0$1);
                return BoxedUnit.UNIT;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(numReceiversOnExecutor);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = ((IterableOnceOps)executors.map((Function1 & Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$2), (Object)BoxesRunTime.boxToInteger((int)2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("scheduleReceivers: schedule receivers evenly when there are more executors than receivers", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IndexedSeq receivers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable)x$3 -> ReceiverSchedulingPolicySuite.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)x$3)));
            IndexedSeq executors = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).map((Function1 & Serializable)executorId -> ReceiverSchedulingPolicySuite.$anonfun$new$14(BoxesRunTime.unboxToInt((Object)executorId)));
            Map scheduledLocations = this.receiverSchedulingPolicy().scheduleReceivers((Seq)receivers, (Seq)executors);
            HashMap numReceiversOnExecutor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            scheduledLocations.foreach((Function1 & Serializable)x0$2 -> {
                ReceiverSchedulingPolicySuite.$anonfun$new$15(numReceiversOnExecutor, x0$2);
                return BoxedUnit.UNIT;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(numReceiversOnExecutor);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = ((IterableOnceOps)executors.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)BoxesRunTime.boxToInteger((int)1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("scheduleReceivers: schedule receivers evenly when the preferredLocations are even", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IndexedSeq receivers = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable)x$5 -> ReceiverSchedulingPolicySuite.$anonfun$new$20(BoxesRunTime.unboxToInt((Object)x$5))).$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(3), 6).map((Function1 & Serializable)x$6 -> ReceiverSchedulingPolicySuite.$anonfun$new$21(BoxesRunTime.unboxToInt((Object)x$6))));
            IndexedSeq executors = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable)executorId -> ReceiverSchedulingPolicySuite.$anonfun$new$22(BoxesRunTime.unboxToInt((Object)executorId))).$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(3), 6).map((Function1 & Serializable)executorId -> ReceiverSchedulingPolicySuite.$anonfun$new$23(BoxesRunTime.unboxToInt((Object)executorId))));
            Map scheduledLocations = this.receiverSchedulingPolicy().scheduleReceivers((Seq)receivers, (Seq)executors);
            HashMap numReceiversOnExecutor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            scheduledLocations.foreach((Function1 & Serializable)x0$3 -> {
                ReceiverSchedulingPolicySuite.$anonfun$new$24(numReceiversOnExecutor, x0$3);
                return BoxedUnit.UNIT;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(numReceiversOnExecutor);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = ((IterableOnceOps)executors.map((Function1 & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$7), (Object)BoxesRunTime.boxToInteger((int)1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            Iterable executorsForReceiversWithPreferredLocation = (Iterable)((IterableOps)scheduledLocations.filter((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ReceiverSchedulingPolicySuite.$anonfun$new$28(x0$4)))).flatMap((Function1 & Serializable)x$8 -> (Seq)x$8._2());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(executorsForReceiversWithPreferredLocation.toSet());
            Set $org_scalatest_assert_macro_right2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable)executorId -> ReceiverSchedulingPolicySuite.$anonfun$new$30(BoxesRunTime.unboxToInt((Object)executorId))).toSet();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("scheduleReceivers: return empty if no receiver", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Map scheduledLocations;
            Map $org_scalatest_assert_macro_left = scheduledLocations = this.receiverSchedulingPolicy().scheduleReceivers((Seq)package$.MODULE$.Seq().empty(), (Seq)new .colon.colon((Object)new ExecutorCacheTaskLocation("localhost", "1"), (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("scheduleReceivers: return empty scheduled executors if no executors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq receivers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable)x$9 -> ReceiverSchedulingPolicySuite.$anonfun$new$33(BoxesRunTime.unboxToInt((Object)x$9)));
            Map scheduledLocations = this.receiverSchedulingPolicy().scheduleReceivers((Seq)receivers, (Seq)package$.MODULE$.Seq().empty());
            scheduledLocations.foreach((Function1 & Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    Seq executors;
                    Seq $org_scalatest_assert_macro_left = executors = (Seq)tuple2._2();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("ReceiverSchedulingPolicySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }
}

