/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.streaming.scheduler.ReceiverInfo;
import org.apache.spark.streaming.ui.BatchUIData;
import org.apache.spark.streaming.ui.MillisecondsStatUIData;
import org.apache.spark.streaming.ui.RecordRateUIData;
import org.apache.spark.streaming.ui.StreamingJobProgressListener;
import org.apache.spark.streaming.ui.StreamingPage$;
import org.apache.spark.streaming.ui.StreamingPagedTable;
import org.apache.spark.streaming.ui.StreamingTab;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.ui.GraphUIData;
import org.apache.spark.ui.GraphUIData$;
import org.apache.spark.ui.JsCollector;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f!B\u000e\u001d\u0001q1\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u000ba\u0002A\u0011A\u001d\t\u000fq\u0002!\u0019!C\u0005{!1\u0011\t\u0001Q\u0001\nyBQA\u0011\u0001\u0005\n\rCQA\u0013\u0001\u0005\u0002-CQA\u001b\u0001\u0005\n-DQ!\u001c\u0001\u0005\n9DQ\u0001\u001d\u0001\u0005\nEDQA\u001d\u0001\u0005\nMDQa\u001e\u0001\u0005\naDQA\u001f\u0001\u0005\nmDQ! \u0001\u0005\nyDq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002B\u0001!I!a\u0011\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j\u001dA\u0011Q\u000e\u000f\t\u0002q\tyGB\u0004\u001c9!\u0005A$!\u001d\t\ra\u0012B\u0011AA=\u0011%\tYH\u0005b\u0001\n\u0003\ti\b\u0003\u0005\u0002\u000eJ\u0001\u000b\u0011BA@\u0011%\tyI\u0005b\u0001\n\u0003\ti\b\u0003\u0005\u0002\u0012J\u0001\u000b\u0011BA@\u0011%\t\u0019J\u0005b\u0001\n\u0003\ti\b\u0003\u0005\u0002\u0016J\u0001\u000b\u0011BA@\u0011\u001d\t9J\u0005C\u0001\u00033\u0013Qb\u0015;sK\u0006l\u0017N\\4QC\u001e,'BA\u000f\u001f\u0003\t)\u0018N\u0003\u0002 A\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sON\u0019\u0001a\n\u0017\u0011\u0005!RS\"A\u0015\u000b\u0005u\u0001\u0013BA\u0016*\u0005%9VMY+J!\u0006<W\r\u0005\u0002.a5\taF\u0003\u00020A\u0005A\u0011N\u001c;fe:\fG.\u0003\u00022]\t9Aj\\4hS:<\u0017A\u00029be\u0016tGo\u0001\u0001\u0011\u0005U2T\"\u0001\u000f\n\u0005]b\"\u0001D*ue\u0016\fW.\u001b8h)\u0006\u0014\u0017A\u0002\u001fj]&$h\b\u0006\u0002;wA\u0011Q\u0007\u0001\u0005\u0006e\t\u0001\r\u0001N\u0001\tY&\u001cH/\u001a8feV\ta\b\u0005\u00026\u007f%\u0011\u0001\t\b\u0002\u001d'R\u0014X-Y7j]\u001eTuN\u0019)s_\u001e\u0014Xm]:MSN$XM\\3s\u0003%a\u0017n\u001d;f]\u0016\u0014\b%A\u0005ti\u0006\u0014H\u000fV5nKV\tA\t\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0003M_:<\u0017A\u0002:f]\u0012,'\u000f\u0006\u0002M=B\u0019Q*\u0016-\u000f\u00059\u001bfBA(S\u001b\u0005\u0001&BA)4\u0003\u0019a$o\\8u}%\tq)\u0003\u0002U\r\u00069\u0001/Y2lC\u001e,\u0017B\u0001,X\u0005\r\u0019V-\u001d\u0006\u0003)\u001a\u0003\"!\u0017/\u000e\u0003iS!a\u0017$\u0002\u0007alG.\u0003\u0002^5\n!aj\u001c3f\u0011\u0015yf\u00011\u0001a\u0003\u001d\u0011X-];fgR\u0004\"!\u00195\u000e\u0003\tT!a\u00193\u0002\t!$H\u000f\u001d\u0006\u0003K\u001a\fqa]3sm2,GOC\u0001h\u0003\u001dQ\u0017m[1si\u0006L!!\u001b2\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\u0016O\u0016tWM]1uK2{\u0017\r\u001a*fg>,(oY3t)\taE\u000eC\u0003`\u000f\u0001\u0007\u0001-A\u0010hK:,'/\u0019;f\u001f:\u001cE.[2l)&lW\r\\5oK\u001a+hn\u0019;j_:$\"\u0001T8\t\u000b}C\u0001\u0019\u00011\u0002#\u001d,g.\u001a:bi\u0016\u0014\u0015m]5d\u0013:4w\u000eF\u0001M\u0003=9WM\\3sCR,G+[7f\u001b\u0006\u0004HC\u0001'u\u0011\u0015)(\u00021\u0001w\u0003\u0015!\u0018.\\3t!\riU\u000bR\u0001\u0017O\u0016tWM]1uKRKW.\u001a+jaN#(/\u001b8hgR\u0011A*\u001f\u0005\u0006k.\u0001\rA^\u0001\u0012O\u0016tWM]1uKN#\u0018\r\u001e+bE2,GC\u0001'}\u0011\u0015yF\u00021\u0001a\u0003i9WM\\3sCR,\u0017J\u001c9vi\u0012\u001bFO]3b[N$\u0016M\u00197f)!au0!\u0003\u0002\u000e\u0005E\u0001bBA\u0001\u001b\u0001\u0007\u00111A\u0001\fUN\u001cu\u000e\u001c7fGR|'\u000fE\u0002)\u0003\u000bI1!a\u0002*\u0005-Q5oQ8mY\u0016\u001cGo\u001c:\t\r\u0005-Q\u00021\u0001E\u0003\u0011i\u0017N\u001c-\t\r\u0005=Q\u00021\u0001E\u0003\u0011i\u0017\r\u001f-\t\u000f\u0005MQ\u00021\u0001\u0002\u0016\u0005!Q.\u001b8Z!\r)\u0015qC\u0005\u0004\u000331%A\u0002#pk\ndW-A\fhK:,'/\u0019;f\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c*poRyA*a\b\u0002\"\u0005-\u0012qGA\u001d\u0003w\ti\u0004C\u0004\u0002\u00029\u0001\r!a\u0001\t\u000f\u0005\rb\u00021\u0001\u0002&\u0005A1\u000f\u001e:fC6LE\rE\u0002F\u0003OI1!!\u000bG\u0005\rIe\u000e\u001e\u0005\b\u0003[q\u0001\u0019AA\u0018\u0003-\u0011XmY8sIJ\u000bG/Z:\u0011\t5+\u0016\u0011\u0007\t\u0007\u000b\u0006MB)!\u0006\n\u0007\u0005UbI\u0001\u0004UkBdWM\r\u0005\u0007\u0003\u0017q\u0001\u0019\u0001#\t\r\u0005=a\u00021\u0001E\u0011\u001d\t\u0019B\u0004a\u0001\u0003+Aq!a\u0010\u000f\u0001\u0004\t)\"\u0001\u0003nCbL\u0016AD:ue\u0016\fW.\u001b8h)\u0006\u0014G.\u001a\u000b\b\u0019\u0006\u0015\u0013qIA*\u0011\u0015yv\u00021\u0001a\u0011\u001d\tIe\u0004a\u0001\u0003\u0017\nqAY1uG\",7\u000f\u0005\u0003N+\u00065\u0003cA\u001b\u0002P%\u0019\u0011\u0011\u000b\u000f\u0003\u0017\t\u000bGo\u00195V\u0013\u0012\u000bG/\u0019\u0005\b\u0003+z\u0001\u0019AA,\u0003!!\u0018M\u00197f)\u0006<\u0007\u0003BA-\u0003CrA!a\u0017\u0002^A\u0011qJR\u0005\u0004\u0003?2\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005\u0015$AB*ue&twMC\u0002\u0002`\u0019\u000bqcZ3oKJ\fG/\u001a\"bi\u000eDG*[:u)\u0006\u0014G.Z:\u0015\u00071\u000bY\u0007C\u0003`!\u0001\u0007\u0001-A\u0007TiJ,\u0017-\\5oOB\u000bw-\u001a\t\u0003kI\u00192AEA:!\r)\u0015QO\u0005\u0004\u0003o2%AB!osJ+g\r\u0006\u0002\u0002p\u0005I\"\tT!D\u0017~\u0013\u0016j\u0012%U?R\u0013\u0016*\u0011(H\u0019\u0016{\u0006\nV'M+\t\ty\b\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\u000bAA[1wC&!\u00111MAB\u0003i\u0011E*Q\"L?JKu\t\u0013+`)JK\u0015IT$M\u000b~CE+\u0014'!\u0003a\u0011E*Q\"L?\u0012{uKT0U%&\u000bej\u0012'F?\"#V\nT\u0001\u001a\u00052\u000b5iS0E\u001f^su\f\u0016*J\u0003:;E*R0I)6c\u0005%A\u0005f[B$\u0018pQ3mY\u0006QQ-\u001c9us\u000e+G\u000e\u001c\u0011\u0002)\u0019|'/\\1u\tV\u0014\u0018\r^5p]>\u0003H/[8o)\u0011\t9&a'\t\u000f\u0005u%\u00041\u0001\u0002 \u0006AQn](qi&|g\u000e\u0005\u0003F\u0003C#\u0015bAAR\r\n1q\n\u001d;j_:\u0004")
public class StreamingPage
extends WebUIPage
implements Logging {
    private final StreamingTab parent;
    private final StreamingJobProgressListener listener;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String formatDurationOption(Option<Object> msOption) {
        return StreamingPage$.MODULE$.formatDurationOption(msOption);
    }

    public static String emptyCell() {
        return StreamingPage$.MODULE$.emptyCell();
    }

    public static String BLACK_DOWN_TRIANGLE_HTML() {
        return StreamingPage$.MODULE$.BLACK_DOWN_TRIANGLE_HTML();
    }

    public static String BLACK_RIGHT_TRIANGLE_HTML() {
        return StreamingPage$.MODULE$.BLACK_RIGHT_TRIANGLE_HTML();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StreamingJobProgressListener listener() {
        return this.listener;
    }

    private long startTime() {
        return this.listener().startTime();
    }

    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        scala.collection.immutable.Seq seq;
        scala.collection.immutable.Seq<Node> resources = this.generateLoadResources(request);
        scala.collection.immutable.Seq<Node> onClickTimelineFunc = this.generateOnClickTimelineFunction(request);
        scala.collection.immutable.Seq<Node> basicInfo = this.generateBasicInfo();
        StreamingJobProgressListener streamingJobProgressListener = this.listener();
        synchronized (streamingJobProgressListener) {
            seq = (scala.collection.immutable.Seq)this.generateStatTable(request).$plus$plus(this.generateBatchListTables(request));
        }
        scala.collection.immutable.Seq content = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)resources.$plus$plus(onClickTimelineFunc)).$plus$plus(basicInfo)).$plus$plus((IterableOnce)seq);
        return org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage(request, "Streaming Statistics", (Function0 & Serializable)() -> content, (SparkUITab)this.parent, org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$5(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$6(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    private scala.collection.immutable.Seq<Node> generateLoadResources(HttpServletRequest request) {
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/d3.min.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/streaming-page.css", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, "/static/streaming-page.js", org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("type", (Seq)new Text("module"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    private scala.collection.immutable.Seq<Node> generateOnClickTimelineFunction(HttpServletRequest request) {
        String imported = org.apache.spark.ui.UIUtils$.MODULE$.formatImportJavaScript(request, "/static/streaming-page.js", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"getOnClickTimelineFunction"}));
        String js = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + imported + "\n         |\n         |onClickTimeline = getOnClickTimelineFunction();\n         |"));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("type", (Seq)new Text("module"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private scala.collection.immutable.Seq<Node> generateBasicInfo() {
        long timeSinceStart = System.currentTimeMillis() - this.startTime();
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Running batches of\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(this.listener().batchDuration()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      for\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(timeSinceStart));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n      since\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDate(this.startTime()));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n      ("));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)BoxesRunTime.boxToLong((long)this.listener().numTotalCompletedBatches()));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf2.$amp$plus((Object)new Text("\n      completed batches, "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)BoxesRunTime.boxToLong((long)this.listener().numTotalReceivedRecords()));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf2.$amp$plus((Object)new Text(" records)\n    "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<Node> generateTimeMap(scala.collection.immutable.Seq<Object> times) {
        void var3_3;
        String js = "var timeFormat = {};\n" + ((IterableOnceOps)times.map((Function1 & Serializable)time -> StreamingPage.$anonfun$generateTimeMap$1(this, BoxesRunTime.unboxToLong((Object)time)))).mkString("\n");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<Node> generateTimeTipStrings(scala.collection.immutable.Seq<Object> times) {
        void var3_3;
        String js = "var timeTipStrings = {};\n" + ((IterableOnceOps)times.map((Function1 & Serializable)time -> StreamingPage.$anonfun$generateTimeTipStrings$1(BoxesRunTime.unboxToLong((Object)time)))).mkString("\n");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
        return new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    private scala.collection.immutable.Seq<Node> generateStatTable(HttpServletRequest request) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Elem elem;
        scala.collection.immutable.Seq<BatchUIData> batches = this.listener().retainedBatches();
        scala.collection.immutable.Seq batchTimes = (scala.collection.immutable.Seq)batches.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StreamingPage.$anonfun$generateStatTable$1(x$6)));
        long minBatchTime = batchTimes.isEmpty() ? this.startTime() : BoxesRunTime.unboxToLong((Object)batchTimes.min((Ordering)Ordering.Long$.MODULE$));
        long maxBatchTime = batchTimes.isEmpty() ? this.startTime() : BoxesRunTime.unboxToLong((Object)batchTimes.max((Ordering)Ordering.Long$.MODULE$));
        RecordRateUIData recordRateForAllStreams = new RecordRateUIData((scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)batches.map((Function1 & Serializable)batchInfo -> new Tuple2.mcJD.sp(batchInfo.batchTime().milliseconds(), (double)batchInfo.numRecords() * 1000.0 / (double)this.listener().batchDuration()))));
        MillisecondsStatUIData schedulingDelay = new MillisecondsStatUIData((scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)batches.flatMap((Function1 & Serializable)batchInfo -> batchInfo.schedulingDelay().map((Function1 & Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batchInfo.batchTime().milliseconds())), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$7)))))));
        MillisecondsStatUIData processingTime = new MillisecondsStatUIData((scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)batches.flatMap((Function1 & Serializable)batchInfo -> batchInfo.processingDelay().map((Function1 & Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batchInfo.batchTime().milliseconds())), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$8)))))));
        MillisecondsStatUIData totalDelay = new MillisecondsStatUIData((scala.collection.immutable.Seq<Tuple2<Object, Object>>)((scala.collection.immutable.Seq)batches.flatMap((Function1 & Serializable)batchInfo -> batchInfo.totalDelay().map((Function1 & Serializable)x$9 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batchInfo.batchTime().milliseconds())), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$9)))))));
        long _maxTime = BoxesRunTime.unboxToLong((Object)schedulingDelay.max().flatMap((Function1 & Serializable)m1 -> StreamingPage.$anonfun$generateStatTable$9(processingTime, totalDelay, BoxesRunTime.unboxToLong((Object)m1))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long minTime = 0L;
        Tuple2<Object, TimeUnit> tuple2 = UIUtils$.MODULE$.normalizeDuration(_maxTime);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double maxTime = tuple2._1$mcD$sp();
        TimeUnit normalizedUnit = (TimeUnit)((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)maxTime), (Object)normalizedUnit);
        double maxTime2 = tuple22._1$mcD$sp();
        TimeUnit normalizedUnit2 = (TimeUnit)((Object)tuple22._2());
        String formattedUnit = UIUtils$.MODULE$.shortTimeUnitString(normalizedUnit2);
        long maxRecordRate = BoxesRunTime.unboxToLong((Object)recordRateForAllStreams.max().map((Function1)(JFunction1.mcJD.sp & Serializable)x$11 -> (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(x$11))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long minRecordRate = 0L;
        double batchInterval = UIUtils$.MODULE$.convertToTimeUnit(this.listener().batchDuration(), normalizedUnit2);
        JsCollector jsCollector = new JsCollector(request);
        GraphUIData graphUIDataForRecordRateOfAllStreams = new GraphUIData("all-stream-records-timeline", "all-stream-records-histogram", recordRateForAllStreams.data(), minBatchTime, maxBatchTime, (double)minRecordRate, (double)maxRecordRate, "records/sec", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForRecordRateOfAllStreams.generateDataJs(jsCollector);
        GraphUIData graphUIDataForSchedulingDelay = new GraphUIData("scheduling-delay-timeline", "scheduling-delay-histogram", schedulingDelay.timelineData(normalizedUnit2), minBatchTime, maxBatchTime, (double)minTime, maxTime2, formattedUnit, GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForSchedulingDelay.generateDataJs(jsCollector);
        GraphUIData graphUIDataForProcessingTime = new GraphUIData("processing-time-timeline", "processing-time-histogram", processingTime.timelineData(normalizedUnit2), minBatchTime, maxBatchTime, (double)minTime, maxTime2, formattedUnit, (Option)new Some((Object)BoxesRunTime.boxToDouble((double)batchInterval)));
        graphUIDataForProcessingTime.generateDataJs(jsCollector);
        GraphUIData graphUIDataForTotalDelay = new GraphUIData("total-delay-timeline", "total-delay-histogram", totalDelay.timelineData(normalizedUnit2), minBatchTime, maxBatchTime, (double)minTime, maxTime2, formattedUnit, GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForTotalDelay.generateDataJs(jsCollector);
        boolean hasStream = this.listener().streamIds().nonEmpty();
        int numCompletedBatches = this.listener().retainedCompletedBatches().size();
        int numActiveBatches = batchTimes.length() - numCompletedBatches;
        int numReceivers = this.listener().numInactiveReceivers() + this.listener().numActiveReceivers();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("width: auto"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("stat-table"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md2);
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("width: 492px;"), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Timelines (Last "));
        $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)batchTimes.length()));
        $buf4.$amp$plus((Object)new Text(" batches, "));
        $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numActiveBatches));
        $buf4.$amp$plus((Object)new Text(" active, "));
        $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numCompletedBatches));
        $buf4.$amp$plus((Object)new Text(" completed)"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("width: 350px;"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Histograms"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md6);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n              "));
        if (hasStream) {
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("expand-input-rate"), (MetaData)$md7);
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n                    "));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", (Seq)new Text("expand-input-rate-arrow arrow-closed"), (MetaData)$md8);
            $buf11.$amp$plus((Object)new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf11.$amp$plus((Object)new Text("\n                    "));
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("data-placement", (Seq)new Text("top"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("title", (Seq)new Text("Show/hide details of each receiver"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md9);
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("\n                      "));
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("Input Rate"));
            $buf12.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
            $buf12.$amp$plus((Object)new Text("\n                    "));
            $buf11.$amp$plus((Object)new Elem(null, "a", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
            $buf11.$amp$plus((Object)new Text("\n                  "));
            Elem elem2 = new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11));
            elem = elem2;
        } else {
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("Input Rate"));
            Elem elem3 = new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14));
            elem = elem3;
        }
        $buf10.$amp$plus((Object)elem);
        $buf10.$amp$plus((Object)new Text("\n              "));
        $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n              "));
        if (numReceivers > 0) {
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)new Text("Receivers: "));
            $buf15.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.listener().numActiveReceivers()));
            $buf15.$amp$plus((Object)new Text(" / "));
            $buf15.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numReceivers));
            $buf15.$amp$plus((Object)new Text(" active"));
            Elem elem4 = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15));
            boxedUnit2 = elem4;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $buf9.$amp$plus((Object)boxedUnit2);
        $buf9.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("Avg: "));
        $buf16.$amp$plus((Object)recordRateForAllStreams.formattedAvg());
        $buf16.$amp$plus((Object)new Text(" records/sec"));
        $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf9.$amp$plus((Object)new Text("\n            "));
        $buf8.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n          "));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n          "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md10);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)graphUIDataForRecordRateOfAllStreams.generateTimelineHtml(jsCollector));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
        $buf7.$amp$plus((Object)new Text("\n          "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md11);
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)graphUIDataForRecordRateOfAllStreams.generateHistogramHtml(jsCollector));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n      "));
        if (hasStream) {
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("style", (Seq)new Text("display: none;"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("id", (Seq)new Text("inputs-table"), (MetaData)$md12);
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)new Text("\n          "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("colspan", (Seq)new Text("3"), (MetaData)$md13);
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)new Text("\n            "));
            $buf20.$amp$plus(this.generateInputDStreamsTable(jsCollector, minBatchTime, maxBatchTime, minRecordRate));
            $buf20.$amp$plus((Object)new Text("\n          "));
            $buf19.$amp$plus((Object)new Elem(null, "td", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20)));
            $buf19.$amp$plus((Object)new Text("\n        "));
            Elem elem5 = new Elem(null, "tr", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19));
            boxedUnit = elem5;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $buf6.$amp$plus((Object)boxedUnit);
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf21 = new NodeBuffer();
        $buf21.$amp$plus((Object)new Text("\n          "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md14);
        NodeBuffer $buf22 = new NodeBuffer();
        $buf22.$amp$plus((Object)new Text("\n            "));
        Null$ $md15 = Null$.MODULE$;
        $md15 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md15);
        NodeBuffer $buf23 = new NodeBuffer();
        $buf23.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf24 = new NodeBuffer();
        NodeBuffer $buf25 = new NodeBuffer();
        $buf25.$amp$plus((Object)new Text("Scheduling Delay "));
        $buf25.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken by Streaming scheduler to submit jobs of a batch", "top"));
        $buf24.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf25)));
        $buf23.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf24)));
        $buf23.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf26 = new NodeBuffer();
        $buf26.$amp$plus((Object)new Text("Avg: "));
        $buf26.$amp$plus((Object)schedulingDelay.formattedAvg());
        $buf23.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf26)));
        $buf23.$amp$plus((Object)new Text("\n            "));
        $buf22.$amp$plus((Object)new Elem(null, "div", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf23)));
        $buf22.$amp$plus((Object)new Text("\n          "));
        $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf22)));
        $buf21.$amp$plus((Object)new Text("\n          "));
        Null$ $md16 = Null$.MODULE$;
        $md16 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md16);
        NodeBuffer $buf27 = new NodeBuffer();
        $buf27.$amp$plus((Object)graphUIDataForSchedulingDelay.generateTimelineHtml(jsCollector));
        $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf27)));
        $buf21.$amp$plus((Object)new Text("\n          "));
        Null$ $md17 = Null$.MODULE$;
        $md17 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md17);
        NodeBuffer $buf28 = new NodeBuffer();
        $buf28.$amp$plus((Object)graphUIDataForSchedulingDelay.generateHistogramHtml(jsCollector));
        $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf28)));
        $buf21.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf21)));
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf29 = new NodeBuffer();
        $buf29.$amp$plus((Object)new Text("\n          "));
        Null$ $md18 = Null$.MODULE$;
        $md18 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md18);
        NodeBuffer $buf30 = new NodeBuffer();
        $buf30.$amp$plus((Object)new Text("\n            "));
        Null$ $md19 = Null$.MODULE$;
        $md19 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md19);
        NodeBuffer $buf31 = new NodeBuffer();
        $buf31.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf32 = new NodeBuffer();
        NodeBuffer $buf33 = new NodeBuffer();
        $buf33.$amp$plus((Object)new Text("Processing Time "));
        $buf33.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken to process all jobs of a batch", "top"));
        $buf32.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf33)));
        $buf31.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf32)));
        $buf31.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf34 = new NodeBuffer();
        $buf34.$amp$plus((Object)new Text("Avg: "));
        $buf34.$amp$plus((Object)processingTime.formattedAvg());
        $buf31.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf34)));
        $buf31.$amp$plus((Object)new Text("\n            "));
        $buf30.$amp$plus((Object)new Elem(null, "div", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf31)));
        $buf30.$amp$plus((Object)new Text("\n          "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf30)));
        $buf29.$amp$plus((Object)new Text("\n          "));
        Null$ $md20 = Null$.MODULE$;
        $md20 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md20);
        NodeBuffer $buf35 = new NodeBuffer();
        $buf35.$amp$plus((Object)graphUIDataForProcessingTime.generateTimelineHtml(jsCollector));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf35)));
        $buf29.$amp$plus((Object)new Text("\n          "));
        Null$ $md21 = Null$.MODULE$;
        $md21 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md21);
        NodeBuffer $buf36 = new NodeBuffer();
        $buf36.$amp$plus((Object)graphUIDataForProcessingTime.generateHistogramHtml(jsCollector));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)$md21, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf36)));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf29)));
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf37 = new NodeBuffer();
        $buf37.$amp$plus((Object)new Text("\n          "));
        Null$ $md22 = Null$.MODULE$;
        $md22 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle;"), (MetaData)$md22);
        NodeBuffer $buf38 = new NodeBuffer();
        $buf38.$amp$plus((Object)new Text("\n            "));
        Null$ $md23 = Null$.MODULE$;
        $md23 = new UnprefixedAttribute("style", (Seq)new Text("width: 160px;"), (MetaData)$md23);
        NodeBuffer $buf39 = new NodeBuffer();
        $buf39.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf40 = new NodeBuffer();
        NodeBuffer $buf41 = new NodeBuffer();
        $buf41.$amp$plus((Object)new Text("Total Delay "));
        $buf41.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Total time taken to handle a batch", "top"));
        $buf40.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf41)));
        $buf39.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf40)));
        $buf39.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf42 = new NodeBuffer();
        $buf42.$amp$plus((Object)new Text("Avg: "));
        $buf42.$amp$plus((Object)totalDelay.formattedAvg());
        $buf39.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf42)));
        $buf39.$amp$plus((Object)new Text("\n            "));
        $buf38.$amp$plus((Object)new Elem(null, "div", (MetaData)$md23, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf39)));
        $buf38.$amp$plus((Object)new Text("\n          "));
        $buf37.$amp$plus((Object)new Elem(null, "td", (MetaData)$md22, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf38)));
        $buf37.$amp$plus((Object)new Text("\n          "));
        Null$ $md24 = Null$.MODULE$;
        $md24 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md24);
        NodeBuffer $buf43 = new NodeBuffer();
        $buf43.$amp$plus((Object)graphUIDataForTotalDelay.generateTimelineHtml(jsCollector));
        $buf37.$amp$plus((Object)new Elem(null, "td", (MetaData)$md24, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf43)));
        $buf37.$amp$plus((Object)new Text("\n          "));
        Null$ $md25 = Null$.MODULE$;
        $md25 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md25);
        NodeBuffer $buf44 = new NodeBuffer();
        $buf44.$amp$plus((Object)graphUIDataForTotalDelay.generateHistogramHtml(jsCollector));
        $buf37.$amp$plus((Object)new Elem(null, "td", (MetaData)$md25, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf44)));
        $buf37.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf37)));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem table = new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)this.generateTimeMap((scala.collection.immutable.Seq<Object>)batchTimes).$plus$plus(this.generateTimeTipStrings((scala.collection.immutable.Seq<Object>)batchTimes))).$plus$plus((IterableOnce)table)).$plus$plus((IterableOnce)jsCollector.toHtml());
    }

    private scala.collection.immutable.Seq<Node> generateInputDStreamsTable(JsCollector jsCollector, long minX, long maxX, double minY) {
        long maxYCalculated = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.listener().receivedRecordRateWithBatchTime().values().flatMap((Function1 & Serializable)x0$1 -> {
            scala.collection.immutable.Seq seq = x0$1;
            return (scala.collection.immutable.Seq)seq.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)StreamingPage.$anonfun$generateInputDStreamsTable$2(x0$2)));
        })).reduceOption((Function2)(JFunction2.mcDDD.sp & Serializable)(x, y) -> package$.MODULE$.max(x, y)).map((Function1)(JFunction1.mcJD.sp & Serializable)x$12 -> (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(x$12))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        List content = ((List)this.listener().receivedRecordRateWithBatchTime().toList().sortBy((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int streamId = tuple2._1$mcI$sp();
                scala.collection.immutable.Seq recordRates = (scala.collection.immutable.Seq)tuple2._2();
                return this.generateInputDStreamRow(jsCollector, streamId, (scala.collection.immutable.Seq<Tuple2<Object, Object>>)recordRates, minX, maxX, minY, maxYCalculated);
            }
            throw new MatchError((Object)tuple2);
        });
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("width: auto"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 151px;"), (MetaData)$md2);
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("width: 167px; padding: 8px 0 8px 0"), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("margin: 0 8px 0 8px"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Status"));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("width: 167px; padding: 8px 0 8px 0"), (MetaData)$md5);
        NodeBuffer $buf6 = new NodeBuffer();
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("style", (Seq)new Text("margin: 0 8px 0 8px"), (MetaData)$md6);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Executor ID / Host"));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("style", (Seq)new Text("width: 166px; padding: 8px 0 8px 0"), (MetaData)$md7);
        NodeBuffer $buf8 = new NodeBuffer();
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("style", (Seq)new Text("margin: 0 8px 0 8px"), (MetaData)$md8);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Last Error Time"));
        $buf8.$amp$plus((Object)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Last Error Message"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)content);
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private scala.collection.immutable.Seq<Node> generateInputDStreamRow(JsCollector jsCollector, int streamId, scala.collection.immutable.Seq<Tuple2<Object, Object>> recordRates, long minX, long maxX, double minY, double maxY) {
        Option<ReceiverInfo> receiverInfo = this.listener().receiverInfo(streamId);
        String receiverName = (String)receiverInfo.map((Function1 & Serializable)x$14 -> x$14.name()).orElse((Function0 & Serializable)() -> this.listener().streamName(streamId)).getOrElse((Function0 & Serializable)() -> "Stream-" + streamId);
        String receiverActive = (String)receiverInfo.map((Function1 & Serializable)info -> {
            if (info.active()) {
                return "ACTIVE";
            }
            return "INACTIVE";
        }).getOrElse((Function0 & Serializable)() -> StreamingPage$.MODULE$.emptyCell());
        String receiverLocation = (String)receiverInfo.map((Function1 & Serializable)info -> {
            String executorId = info.executorId().isEmpty() ? StreamingPage$.MODULE$.emptyCell() : info.executorId();
            String location = info.location().isEmpty() ? StreamingPage$.MODULE$.emptyCell() : info.location();
            return executorId + " / " + location;
        }).getOrElse((Function0 & Serializable)() -> StreamingPage$.MODULE$.emptyCell());
        String receiverLastError = (String)receiverInfo.map((Function1 & Serializable)info -> {
            String msg = info.lastErrorMessage() + " - " + info.lastError();
            if (msg.length() > 100) {
                return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(msg), 97) + "...";
            }
            return msg;
        }).getOrElse((Function0 & Serializable)() -> StreamingPage$.MODULE$.emptyCell());
        String receiverLastErrorTime = (String)receiverInfo.map((Function1 & Serializable)r -> {
            if (r.lastErrorTime() < 0L) {
                return "-";
            }
            return org.apache.spark.ui.UIUtils$.MODULE$.formatDate(r.lastErrorTime());
        }).getOrElse((Function0 & Serializable)() -> StreamingPage$.MODULE$.emptyCell());
        RecordRateUIData receivedRecords = new RecordRateUIData(recordRates);
        GraphUIData graphUIDataForRecordRate = new GraphUIData("stream-" + streamId + "-records-timeline", "stream-" + streamId + "-records-histogram", receivedRecords.data(), minX, maxX, minY, maxY, "records/sec", GraphUIData$.MODULE$.$lessinit$greater$default$9());
        graphUIDataForRecordRate.generateDataJs(jsCollector);
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle; width: 151px;"), (MetaData)$md);
        $md = new UnprefixedAttribute("rowspan", (Seq)new Text("2"), (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("width: 151px;"), (MetaData)$md2);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("word-wrap: break-word;"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)receiverName);
        $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Avg: "));
        $buf7.$amp$plus((Object)receivedRecords.formattedAvg());
        $buf7.$amp$plus((Object)new Text(" records/sec"));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)receiverActive);
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)receiverLocation);
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)receiverLastErrorTime);
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("width: 342px;"), (MetaData)$md4);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)receiverLastError);
        $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("timeline"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("colspan", (Seq)new Text("3"), (MetaData)$md5);
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n        "));
        $buf14.$amp$plus((Object)graphUIDataForRecordRate.generateTimelineHtml(jsCollector));
        $buf14.$amp$plus((Object)new Text("\n      "));
        $buf13.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf13.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("histogram"), (MetaData)$md6);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)graphUIDataForRecordRate.generateHistogramHtml(jsCollector));
        $buf13.$amp$plus((Object)new Elem(null, "td", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf13.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    private scala.collection.immutable.Seq<Node> streamingTable(HttpServletRequest request, scala.collection.immutable.Seq<BatchUIData> batches, String tableTag) {
        Elem elem;
        long interval = this.listener().batchDuration();
        int streamingPage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter(tableTag + ".page")).map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$15)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        try {
            elem = new StreamingPagedTable(request, tableTag, batches, org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), "streaming", interval).table(streamingPage);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException) {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("Error while rendering streaming table:"));
                $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
                $buf.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n            "));
                $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
                $buf3.$amp$plus((Object)new Text("\n          "));
                $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
                $buf.$amp$plus((Object)new Text("\n        "));
                Elem elem2 = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
                elem = elem2;
            }
            throw throwable;
        }
        return elem;
    }

    private scala.collection.immutable.Seq<Node> generateBatchListTables(HttpServletRequest request) {
        scala.collection.immutable.Seq runningBatches = (scala.collection.immutable.Seq)((SeqOps)this.listener().runningBatches().sortBy((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)StreamingPage.$anonfun$generateBatchListTables$1(x$16)), (Ordering)Ordering.Long$.MODULE$)).reverse();
        scala.collection.immutable.Seq waitingBatches = (scala.collection.immutable.Seq)((SeqOps)this.listener().waitingBatches().sortBy((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)StreamingPage.$anonfun$generateBatchListTables$2(x$17)), (Ordering)Ordering.Long$.MODULE$)).reverse();
        scala.collection.immutable.Seq completedBatches = (scala.collection.immutable.Seq)((SeqOps)this.listener().retainedCompletedBatches().sortBy((Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)StreamingPage.$anonfun$generateBatchListTables$3(x$18)), (Ordering)Ordering.Long$.MODULE$)).reverse();
        ListBuffer content = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        if (runningBatches.nonEmpty()) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n            "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-runningBatches',\n                  'aggregated-runningBatches')"), (MetaData)$md3);
            $md3 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-runningBatches collapse-table"), (MetaData)$md3);
            $md3 = new UnprefixedAttribute("id", (Seq)new Text("runningBatches"), (MetaData)$md3);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n                "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md4);
            $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf4.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("Running Batches ("));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)runningBatches.size()));
            $buf5.$amp$plus((Object)new Text(")"));
            $buf4.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf4.$amp$plus((Object)new Text("\n              "));
            $buf3.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n            "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-runningBatches collapsible-table"), (MetaData)$md5);
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n              "));
            $buf6.$amp$plus(this.streamingTable(request, (scala.collection.immutable.Seq<BatchUIData>)runningBatches, "runningBatches"));
            $buf6.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n        "));
            v0 = content.$plus$plus$eq((IterableOnce)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        if (waitingBatches.nonEmpty()) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md6);
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-waitingBatches',\n                  'aggregated-waitingBatches')"), (MetaData)$md7);
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-waitingBatches collapse-table"), (MetaData)$md7);
            $md7 = new UnprefixedAttribute("id", (Seq)new Text("waitingBatches"), (MetaData)$md7);
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n                "));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md8);
            $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf9.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("Waiting Batches ("));
            $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)waitingBatches.size()));
            $buf10.$amp$plus((Object)new Text(")"));
            $buf9.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
            $buf9.$amp$plus((Object)new Text("\n              "));
            $buf8.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
            $buf8.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
            $buf7.$amp$plus((Object)new Text("\n            "));
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-waitingBatches collapsible-table"), (MetaData)$md9);
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n              "));
            $buf11.$amp$plus(this.streamingTable(request, (scala.collection.immutable.Seq<BatchUIData>)waitingBatches, "waitingBatches"));
            $buf11.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf.$amp$plus((Object)new Text("\n        "));
            v1 = content.$plus$plus$eq((IterableOnce)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
        } else {
            v1 = BoxedUnit.UNIT;
        }
        if (completedBatches.nonEmpty()) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md10);
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("\n            "));
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-completedBatches',\n                  'aggregated-completedBatches')"), (MetaData)$md11);
            $md11 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-completedBatches collapse-table"), (MetaData)$md11);
            $md11 = new UnprefixedAttribute("id", (Seq)new Text("completedBatches"), (MetaData)$md11);
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("\n                "));
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md12);
            $buf14.$amp$plus((Object)new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf14.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)new Text("Completed Batches (last "));
            $buf15.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completedBatches.size()));
            $buf15.$amp$plus((Object)new Text("\n                  out of "));
            $buf15.$amp$plus((Object)BoxesRunTime.boxToLong((long)this.listener().numTotalCompletedBatches()));
            $buf15.$amp$plus((Object)new Text(")"));
            $buf14.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
            $buf14.$amp$plus((Object)new Text("\n              "));
            $buf13.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
            $buf13.$amp$plus((Object)new Text("\n            "));
            $buf12.$amp$plus((Object)new Elem(null, "span", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
            $buf12.$amp$plus((Object)new Text("\n            "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-completedBatches collapsible-table"), (MetaData)$md13);
            NodeBuffer $buf16 = new NodeBuffer();
            $buf16.$amp$plus((Object)new Text("\n              "));
            $buf16.$amp$plus(this.streamingTable(request, (scala.collection.immutable.Seq<BatchUIData>)completedBatches, "completedBatches"));
            $buf16.$amp$plus((Object)new Text("\n            "));
            $buf12.$amp$plus((Object)new Elem(null, "div", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
            $buf12.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
            $buf.$amp$plus((Object)new Text("\n        "));
            v2 = content.$plus$plus$eq((IterableOnce)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
        } else {
            v2 = BoxedUnit.UNIT;
        }
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)content);
    }

    public static final /* synthetic */ String $anonfun$generateTimeMap$1(StreamingPage $this, long time) {
        String formattedTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(time, $this.listener().batchDuration(), false, org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
        return "timeFormat[" + time + "] = '" + formattedTime + "';";
    }

    public static final /* synthetic */ String $anonfun$generateTimeTipStrings$1(long time) {
        return "timeTipStrings[" + time + "] = timeFormat[" + time + "];";
    }

    public static final /* synthetic */ long $anonfun$generateStatTable$1(BatchUIData x$6) {
        return x$6.batchTime().milliseconds();
    }

    public static final /* synthetic */ Option $anonfun$generateStatTable$10(MillisecondsStatUIData totalDelay$1, long m1$1, long m2) {
        return totalDelay$1.max().map((Function1)(JFunction1.mcJJ.sp & Serializable)m3 -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(m1$1), m2)), m3));
    }

    public static final /* synthetic */ Option $anonfun$generateStatTable$9(MillisecondsStatUIData processingTime$1, MillisecondsStatUIData totalDelay$1, long m1) {
        return processingTime$1.max().flatMap((Function1 & Serializable)m2 -> StreamingPage.$anonfun$generateStatTable$10(totalDelay$1, m1, BoxesRunTime.unboxToLong((Object)m2)));
    }

    public static final /* synthetic */ double $anonfun$generateInputDStreamsTable$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            double recordRate = tuple2._2$mcD$sp();
            return recordRate;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$generateBatchListTables$1(BatchUIData x$16) {
        return x$16.batchTime().milliseconds();
    }

    public static final /* synthetic */ long $anonfun$generateBatchListTables$2(BatchUIData x$17) {
        return x$17.batchTime().milliseconds();
    }

    public static final /* synthetic */ long $anonfun$generateBatchListTables$3(BatchUIData x$18) {
        return x$18.batchTime().milliseconds();
    }

    public StreamingPage(StreamingTab parent) {
        this.parent = parent;
        super("");
        Logging.$init$((Logging)this);
        this.listener = parent.listener();
    }
}

