/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.array;

import org.apache.spark.unsafe.PlatformDependent;

public class ByteArrayMethods {
    private ByteArrayMethods() {
    }

    public static int roundNumberOfBytesToNearestWord(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder == 0) {
            return numBytes;
        }
        return numBytes + (8 - remainder);
    }

    public static boolean wordAlignedArrayEquals(Object leftBaseObject, long leftBaseOffset, Object rightBaseObject, long rightBaseOffset, long arrayLengthInBytes) {
        int i = 0;
        while ((long)i < arrayLengthInBytes) {
            long right;
            long left = PlatformDependent.UNSAFE.getLong(leftBaseObject, leftBaseOffset + (long)i);
            if (left != (right = PlatformDependent.UNSAFE.getLong(rightBaseObject, rightBaseOffset + (long)i))) {
                return false;
            }
            i += 8;
        }
        return true;
    }
}

