/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.bitset;

import org.apache.spark.unsafe.PlatformDependent;

public final class BitSetMethods {
    private static final long WORD_SIZE = 8L;

    private BitSetMethods() {
    }

    public static void set(Object baseObject, long baseOffset, int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        long mask = 1L << (index & 0x3F);
        long wordOffset = baseOffset + (long)(index >> 6) * 8L;
        long word = PlatformDependent.UNSAFE.getLong(baseObject, wordOffset);
        PlatformDependent.UNSAFE.putLong(baseObject, wordOffset, word | mask);
    }

    public static void unset(Object baseObject, long baseOffset, int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        long mask = 1L << (index & 0x3F);
        long wordOffset = baseOffset + (long)(index >> 6) * 8L;
        long word = PlatformDependent.UNSAFE.getLong(baseObject, wordOffset);
        PlatformDependent.UNSAFE.putLong(baseObject, wordOffset, word & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static boolean isSet(Object baseObject, long baseOffset, int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        long mask = 1L << (index & 0x3F);
        long wordOffset = baseOffset + (long)(index >> 6) * 8L;
        long word = PlatformDependent.UNSAFE.getLong(baseObject, wordOffset);
        return (word & mask) != 0L;
    }

    public static boolean anySet(Object baseObject, long baseOffset, long bitSetWidthInWords) {
        long addr = baseOffset;
        int i = 0;
        while ((long)i < bitSetWidthInWords) {
            if (PlatformDependent.UNSAFE.getLong(baseObject, addr) != 0L) {
                return true;
            }
            ++i;
            addr += 8L;
        }
        return false;
    }

    public static int nextSetBit(Object baseObject, long baseOffset, int fromIndex, int bitsetSizeInWords) {
        int wi = fromIndex >> 6;
        if (wi >= bitsetSizeInWords) {
            return -1;
        }
        int subIndex = fromIndex & 0x3F;
        long word = PlatformDependent.UNSAFE.getLong(baseObject, baseOffset + (long)wi * 8L) >> subIndex;
        if (word != 0L) {
            return (wi << 6) + subIndex + Long.numberOfTrailingZeros(word);
        }
        ++wi;
        while (wi < bitsetSizeInWords) {
            word = PlatformDependent.UNSAFE.getLong(baseObject, baseOffset + (long)wi * 8L);
            if (word != 0L) {
                return (wi << 6) + Long.numberOfTrailingZeros(word);
            }
            ++wi;
        }
        return -1;
    }
}

