/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.memory;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.unsafe.memory.HeapMemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;

public class ExecutorMemoryManager {
    public final MemoryAllocator allocator;
    final boolean inHeap;
    @GuardedBy(value="this")
    private final Map<Long, LinkedList<WeakReference<MemoryBlock>>> bufferPoolsBySize = new HashMap<Long, LinkedList<WeakReference<MemoryBlock>>>();
    private static final int POOLING_THRESHOLD_BYTES = 0x100000;

    public ExecutorMemoryManager(MemoryAllocator allocator) {
        this.inHeap = allocator instanceof HeapMemoryAllocator;
        this.allocator = allocator;
    }

    private boolean shouldPool(long size) {
        return size >= 0x100000L && this.allocator instanceof HeapMemoryAllocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MemoryBlock allocate(long size) throws OutOfMemoryError {
        if (this.shouldPool(size)) {
            ExecutorMemoryManager executorMemoryManager = this;
            synchronized (executorMemoryManager) {
                LinkedList<WeakReference<MemoryBlock>> pool = this.bufferPoolsBySize.get(size);
                if (pool != null) {
                    while (!pool.isEmpty()) {
                        WeakReference<MemoryBlock> blockReference = pool.pop();
                        MemoryBlock memory = (MemoryBlock)blockReference.get();
                        if (memory == null) continue;
                        assert (memory.size() == size);
                        return memory;
                    }
                    this.bufferPoolsBySize.remove(size);
                }
            }
            return this.allocator.allocate(size);
        }
        return this.allocator.allocate(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(MemoryBlock memory) {
        long size = memory.size();
        if (this.shouldPool(size)) {
            ExecutorMemoryManager executorMemoryManager = this;
            synchronized (executorMemoryManager) {
                LinkedList<WeakReference<MemoryBlock>> pool = this.bufferPoolsBySize.get(size);
                if (pool == null) {
                    pool = new LinkedList();
                    this.bufferPoolsBySize.put(size, pool);
                }
                pool.add(new WeakReference<MemoryBlock>(memory));
            }
        } else {
            this.allocator.free(memory);
        }
    }
}

