/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.Client$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u00015\u0011abV8sW\u0016\u0014(+\u001e8oC\ndWM\u0003\u0002\u0004\t\u0005!\u00110\u0019:o\u0015\t)a!\u0001\u0004eKBdw.\u001f\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f-e\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003\u001f]I!\u0001\u0007\t\u0003\u0011I+hN\\1cY\u0016\u0004\"AG\u000e\u000e\u0003\u0019I!\u0001\b\u0004\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001B\u0001B\u0003%q$A\u0005d_:$\u0018-\u001b8feB\u0011\u0001\u0005K\u0007\u0002C)\u0011!eI\u0001\be\u0016\u001cwN\u001d3t\u0015\t!S%A\u0002ba&T!a\u0001\u0014\u000b\u0005\u001dB\u0011A\u00025bI>|\u0007/\u0003\u0002*C\tI1i\u001c8uC&tWM\u001d\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u0005!1m\u001c8g!\tis&D\u0001/\u0015\tYc%\u0003\u00021]\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\ngB\f'o[\"p]\u001a\u0004\"A\u0007\u001b\n\u0005U2!!C*qCJ\\7i\u001c8g\u0011!9\u0004A!A!\u0002\u0013A\u0014!D7bgR,'/\u00113ee\u0016\u001c8\u000f\u0005\u0002:\u007f9\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tq4\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u00039\u0003\u001d\u0019H.\u0019<f\u0013\u0012D\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\tQ>\u001cHO\\1nK\"Aq\t\u0001B\u0001B\u0003%\u0001*\u0001\u0007x_J\\WM]'f[>\u0014\u0018\u0010\u0005\u0002;\u0013&\u0011!j\u000f\u0002\u0004\u0013:$\b\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\u0002\u0017]|'o[3s\u0007>\u0014Xm\u001d\u0005\u0006\u001d\u0002!\taT\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013A\u00136\u000bV+W/bK\u0006CA)\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010N\u0001\u0004y\u0002\"B\u0016N\u0001\u0004a\u0003\"\u0002\u001aN\u0001\u0004\u0019\u0004\"B\u001cN\u0001\u0004A\u0004\"B\"N\u0001\u0004A\u0004\"B#N\u0001\u0004A\u0004\"B$N\u0001\u0004A\u0005\"\u0002'N\u0001\u0004A\u0005bB.\u0001\u0001\u0004%\t\u0001X\u0001\u0004eB\u001cW#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001,\u0013aA5qG&\u0011!m\u0018\u0002\b3\u0006\u0014hN\u0015)D\u0011\u001d!\u0007\u00011A\u0005\u0002\u0015\fqA\u001d9d?\u0012*\u0017\u000f\u0006\u0002gSB\u0011!hZ\u0005\u0003Qn\u0012A!\u00168ji\"9!nYA\u0001\u0002\u0004i\u0016a\u0001=%c!1A\u000e\u0001Q!\nu\u000bAA\u001d9dA!Ia\u000e\u0001a\u0001\u0002\u0004%\ta\\\u0001\t]6\u001cE.[3oiV\t\u0001\u000f\u0005\u0002rk6\t!O\u0003\u0002%g*\u0011A/J\u0001\u0007G2LWM\u001c;\n\u0005Y\u0014(\u0001\u0003(N\u00072LWM\u001c;\t\u0013a\u0004\u0001\u0019!a\u0001\n\u0003I\u0018\u0001\u00048n\u00072LWM\u001c;`I\u0015\fHC\u00014{\u0011\u001dQw/!AA\u0002ADa\u0001 \u0001!B\u0013\u0001\u0018!\u00038n\u00072LWM\u001c;!\u0011\u001dq\bA1A\u0005\u0002}\f\u0001\"_1s]\u000e{gNZ\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\b5\u0011\u0011Q\u0001\u0006\u0003W\u0015JA!!\u0003\u0002\u0006\t\t\u0012,\u0019:o\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u0003\t\u0011\"_1s]\u000e{gN\u001a\u0011\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\u0005\u0019!/\u001e8\u0015\u0003\u0019Dq!a\u0006\u0001\t\u0003\tI\"\u0001\bti\u0006\u0014HoQ8oi\u0006Lg.\u001a:\u0016\u0005\u0005m\u0001\u0003CA\u000f\u0003G\t9#a\u000b\u000e\u0005\u0005}!bAA\u0011%\u0005!Q\u000f^5m\u0013\u0011\t)#a\b\u0003\u00075\u000b\u0007\u000fE\u0002\u0010\u0003SI!\u0001\u0011\t\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r\u0013\u0003\rq\u0017n\\\u0005\u0005\u0003k\tyC\u0001\u0006CsR,')\u001e4gKJDq!!\u000f\u0001\t\u0013\tY$A\u000btKR,\b\u000fR5tiJL'-\u001e;fI\u000e\u000b7\r[3\u0015\u001b\u0019\fi$!\u0011\u0002L\u0005\u0015\u0014\u0011NA7\u0011\u001d\ty$a\u000eA\u0002a\nAAZ5mK\"A\u00111IA\u001c\u0001\u0004\t)%A\u0003sif\u0004X\rE\u0002!\u0003\u000fJ1!!\u0013\"\u0005EaunY1m%\u0016\u001cx.\u001e:dKRK\b/\u001a\u0005\t\u0003\u001b\n9\u00041\u0001\u0002P\u0005qAn\\2bYJ+7o\\;sG\u0016\u001c\bcBA)\u00037B\u0014qL\u0007\u0003\u0003'RA!!\u0016\u0002X\u00059Q.\u001e;bE2,'bAA-w\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00131\u000b\u0002\b\u0011\u0006\u001c\b.T1q!\r\u0001\u0013\u0011M\u0005\u0004\u0003G\n#!\u0004'pG\u0006d'+Z:pkJ\u001cW\rC\u0004\u0002h\u0005]\u0002\u0019\u0001\u001d\u0002\u0013QLW.Z:uC6\u0004\bbBA6\u0003o\u0001\r\u0001O\u0001\u0005g&TX\rC\u0004\u0002p\u0005]\u0002\u0019\u0001\u001d\u0002\u0007YL7\u000fC\u0004\u0002t\u0001!\t!!\u001e\u0002+A\u0014X\r]1sK2{7-\u00197SKN|WO]2fgV\u0011\u0011q\n\u0005\b\u0003s\u0002A\u0011AA>\u0003I\u0001(/\u001a9be\u0016,eN^5s_:lWM\u001c;\u0016\u0005\u0005u\u0004CBA)\u00037B\u0004\b")
public class WorkerRunnable
implements Runnable,
Logging {
    private final Container container;
    private final SparkConf sparkConf;
    private final String masterAddress;
    private final String slaveId;
    private final String hostname;
    private final int workerMemory;
    private final int workerCores;
    private YarnRPC rpc;
    private NMClient nmClient;
    private final YarnConfiguration yarnConf;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    public YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    @Override
    public void run() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting Worker Container";
            }
        });
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.yarnConf());
        this.nmClient().start();
        this.startContainer();
    }

    public Map<String, ByteBuffer> startContainer() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up ContainerLaunchContext";
            }
        });
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        HashMap<String, LocalResource> localResources = this.prepareLocalResources();
        ctx.setLocalResources(JavaConversions$.MODULE$.mutableMapAsJavaMap(localResources));
        HashMap<String, String> env = this.prepareEnvironment();
        ctx.setEnvironment(JavaConversions$.MODULE$.mutableMapAsJavaMap(env));
        String JAVA_OPTS = "";
        String workerMemoryString = new StringBuilder().append(this.workerMemory).append((Object)"m").toString();
        JAVA_OPTS = new StringBuilder().append((Object)JAVA_OPTS).append((Object)new StringBuilder().append((Object)"-Xms").append((Object)workerMemoryString).append((Object)" -Xmx").append((Object)workerMemoryString).append((Object)" ").toString()).toString();
        if (env.isDefinedAt((Object)"SPARK_JAVA_OPTS")) {
            JAVA_OPTS = new StringBuilder().append((Object)JAVA_OPTS).append((Object)new StringBuilder().append((Object)((String)env.apply((Object)"SPARK_JAVA_OPTS"))).append((Object)" ").toString()).toString();
        }
        JAVA_OPTS = new StringBuilder().append((Object)JAVA_OPTS).append((Object)new StringBuilder().append((Object)" -Djava.io.tmpdir=").append((Object)new Path(ApplicationConstants.Environment.PWD.$(), "./tmp")).append((Object)" ").toString()).toString();
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        String javaCommand = "java";
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null && !javaHome.isEmpty() || env.isDefinedAt((Object)"JAVA_HOME")) {
            javaCommand = new StringBuilder().append((Object)ApplicationConstants.Environment.JAVA_HOME.$()).append((Object)"/bin/java").toString();
        }
        List commands = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)javaCommand).append((Object)" -server ").append((Object)" -XX:OnOutOfMemoryError='kill %p' ").append((Object)JAVA_OPTS).append((Object)" org.apache.spark.executor.CoarseGrainedExecutorBackend ").append((Object)this.masterAddress).append((Object)" ").append((Object)this.slaveId).append((Object)" ").append((Object)this.hostname).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)this.workerCores)).append((Object)" 1> ").append((Object)"<LOG_DIR>").append((Object)"/stdout").append((Object)" 2> ").append((Object)"<LOG_DIR>").append((Object)"/stderr").toString()}));
        this.logInfo((Function0<String>)new Serializable(this, commands){
            public static final long serialVersionUID = 0L;
            private final List commands$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Setting up worker with commands: ").append((Object)this.commands$1).toString();
            }
            {
                this.commands$1 = commands$1;
            }
        });
        ctx.setCommands(JavaConversions$.MODULE$.seqAsJavaList((Seq)commands));
        return this.nmClient().startContainer(this.container, ctx);
    }

    public void org$apache$spark$deploy$yarn$WorkerRunnable$$setupDistributedCache(String file, LocalResourceType rtype, HashMap<String, LocalResource> localResources, String timestamp, String size, String vis) {
        URI uri = new URI(file);
        LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
        amJarRsrc.setType(rtype);
        amJarRsrc.setVisibility(LocalResourceVisibility.valueOf((String)vis));
        amJarRsrc.setResource(ConverterUtils.getYarnUrlFromURI((URI)uri));
        amJarRsrc.setTimestamp(new StringOps(Predef$.MODULE$.augmentString(timestamp)).toLong());
        amJarRsrc.setSize(new StringOps(Predef$.MODULE$.augmentString(size)).toLong());
        localResources.update((Object)uri.getFragment(), (Object)amJarRsrc);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, LocalResource> prepareLocalResources() {
        void var1_1;
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Preparing Local resources";
            }
        });
        HashMap localResources = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (System.getenv("SPARK_YARN_CACHE_FILES") != null) {
            String[] timeStamps = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES_TIME_STAMPS"))).split(',');
            String[] fileSizes = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES_FILE_SIZES"))).split(',');
            String[] distFiles = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES"))).split(',');
            String[] visibilities = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_FILES_VISIBILITIES"))).split(',');
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), distFiles.length - 1).foreach$mVc$sp((Function1)new Serializable(this, localResources, timeStamps, fileSizes, distFiles, visibilities){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WorkerRunnable $outer;
                private final HashMap localResources$1;
                private final String[] timeStamps$1;
                private final String[] fileSizes$1;
                private final String[] distFiles$1;
                private final String[] visibilities$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.$outer.org$apache$spark$deploy$yarn$WorkerRunnable$$setupDistributedCache(this.distFiles$1[i], LocalResourceType.FILE, (HashMap<String, LocalResource>)this.localResources$1, this.timeStamps$1[i], this.fileSizes$1[i], this.visibilities$1[i]);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.localResources$1 = localResources$1;
                    this.timeStamps$1 = timeStamps$1;
                    this.fileSizes$1 = fileSizes$1;
                    this.distFiles$1 = distFiles$1;
                    this.visibilities$1 = visibilities$1;
                }
            });
        }
        if (System.getenv("SPARK_YARN_CACHE_ARCHIVES") != null) {
            String[] timeStamps = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES_TIME_STAMPS"))).split(',');
            String[] fileSizes = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES_FILE_SIZES"))).split(',');
            String[] distArchives = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES"))).split(',');
            String[] visibilities = new StringOps(Predef$.MODULE$.augmentString(System.getenv("SPARK_YARN_CACHE_ARCHIVES_VISIBILITIES"))).split(',');
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), distArchives.length - 1).foreach$mVc$sp((Function1)new Serializable(this, localResources, timeStamps, fileSizes, distArchives, visibilities){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WorkerRunnable $outer;
                private final HashMap localResources$1;
                private final String[] timeStamps$2;
                private final String[] fileSizes$2;
                private final String[] distArchives$1;
                private final String[] visibilities$2;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.$outer.org$apache$spark$deploy$yarn$WorkerRunnable$$setupDistributedCache(this.distArchives$1[i], LocalResourceType.ARCHIVE, (HashMap<String, LocalResource>)this.localResources$1, this.timeStamps$2[i], this.fileSizes$2[i], this.visibilities$2[i]);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.localResources$1 = localResources$1;
                    this.timeStamps$2 = timeStamps$2;
                    this.fileSizes$2 = fileSizes$2;
                    this.distArchives$1 = distArchives$1;
                    this.visibilities$2 = visibilities$2;
                }
            });
        }
        this.logInfo((Function0<String>)new Serializable(this, localResources){
            public static final long serialVersionUID = 0L;
            private final HashMap localResources$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Prepared Local resources ").append((Object)this.localResources$1).toString();
            }
            {
                this.localResources$1 = localResources$1;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, String> prepareEnvironment() {
        void var1_1;
        HashMap env = new HashMap();
        Client$.MODULE$.populateClasspath((Configuration)this.yarnConf(), this.sparkConf, System.getenv("SPARK_YARN_LOG4J_PATH") != null, (HashMap<String, String>)env);
        Apps.setEnvFromInputString((Map)JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)env), (String)System.getenv("SPARK_YARN_USER_ENV"));
        JavaConversions$.MODULE$.mapAsScalaMap(System.getenv()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.startsWith("SPARK");
            }
        }).foreach((Function1)new Serializable(this, env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.env$1.update((Object)k, (Object)v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.env$1 = env$1;
            }
        });
        return var1_1;
    }

    public WorkerRunnable(Container container, Configuration conf, SparkConf sparkConf, String masterAddress, String slaveId, String hostname, int workerMemory, int workerCores) {
        this.container = container;
        this.sparkConf = sparkConf;
        this.masterAddress = masterAddress;
        this.slaveId = slaveId;
        this.hostname = hostname;
        this.workerMemory = workerMemory;
        this.workerCores = workerCores;
        Logging.class.$init$((Logging)this);
        this.rpc = YarnRPC.create((Configuration)conf);
        this.yarnConf = new YarnConfiguration(conf);
    }
}

