/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4Q!\u0001\u0002\u0001\r1\u0011!$W1s]\u000ec\u0017.\u001a8u'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012T!a\u0001\u0003\u0002\u000f\rdWo\u001d;fe*\u0011QAB\u0001\ng\u000eDW\rZ;mKJT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\t\u0002C\u0001\b\u0010\u001b\u0005\u0011\u0011B\u0001\t\u0003\u0005u\u0019u.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007C\u0001\n\u0014\u001b\u00051\u0011B\u0001\u000b\u0007\u0005\u001daunZ4j]\u001eD\u0001\"\u0002\u0001\u0003\u0002\u0003\u0006IaF\u0002\u0001!\tA\u0012$D\u0001\u0005\u0013\tQBAA\tUCN\\7k\u00195fIVdWM]%na2D\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0003g\u000e\u0004\"A\u0005\u0010\n\u0005}1!\u0001D*qCJ\\7i\u001c8uKb$\b\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\bF\u0002$I\u0015\u0002\"A\u0004\u0001\t\u000b\u0015\u0001\u0003\u0019A\f\t\u000bq\u0001\u0003\u0019A\u000f\t\u000f\u001d\u0002\u0001\u0019!C\u0001Q\u000511\r\\5f]R,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA!_1s]*\u0011aFB\u0001\u0007I\u0016\u0004Hn\\=\n\u0005AZ#AB\"mS\u0016tG\u000fC\u00043\u0001\u0001\u0007I\u0011A\u001a\u0002\u0015\rd\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u00025uA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t!QK\\5u\u0011\u001dY\u0014'!AA\u0002%\n1\u0001\u001f\u00132\u0011\u0019i\u0004\u0001)Q\u0005S\u000591\r\\5f]R\u0004\u0003bB \u0001\u0001\u0004%\t\u0001Q\u0001\u0006CB\u0004\u0018\nZ\u000b\u0002\u0003B\u0011!IS\u0007\u0002\u0007*\u0011A)R\u0001\be\u0016\u001cwN\u001d3t\u0015\t1u)A\u0002ba&T!\u0001\f%\u000b\u0005%C\u0011A\u00025bI>|\u0007/\u0003\u0002L\u0007\ni\u0011\t\u001d9mS\u000e\fG/[8o\u0013\u0012Dq!\u0014\u0001A\u0002\u0013\u0005a*A\u0005baBLEm\u0018\u0013fcR\u0011Ag\u0014\u0005\bw1\u000b\t\u00111\u0001B\u0011\u0019\t\u0006\u0001)Q\u0005\u0003\u00061\u0011\r\u001d9JI\u0002Baa\u0015\u0001\u0005\u0002\u0019!\u0016AB1eI\u0006\u0013x\r\u0006\u00035+z\u0003\u0007\"\u0002,S\u0001\u00049\u0016AC8qi&|gNT1nKB\u0011\u0001l\u0017\b\u0003keK!A\u0017\u001c\u0002\rA\u0013X\rZ3g\u0013\taVL\u0001\u0004TiJLgn\u001a\u0006\u00035ZBQa\u0018*A\u0002]\u000bQb\u001c9uS>t\u0017\r\u001c)be\u0006l\u0007\"B1S\u0001\u0004\u0011\u0017\u0001C1se\u0006L()\u001e4\u0011\u0007\rDw+D\u0001e\u0015\t)g-A\u0004nkR\f'\r\\3\u000b\u0005\u001d4\u0014AC2pY2,7\r^5p]&\u0011\u0011\u000e\u001a\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fC\u0003l\u0001\u0011\u0005C.A\u0003ti\u0006\u0014H\u000fF\u00015\u0011\u0015q\u0007\u0001\"\u0001m\u0003)9\u0018-\u001b;G_J\f\u0005\u000f\u001d\u0005\u0006a\u0002!\t\u0005\\\u0001\u0005gR|\u0007\u000f")
public class YarnClientSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private Client client = null;
    private ApplicationId appId = null;

    public Client client() {
        return this.client;
    }

    public void client_$eq(Client x$1) {
        this.client = x$1;
    }

    public ApplicationId appId() {
        return this.appId;
    }

    public void appId_$eq(ApplicationId x$1) {
        this.appId = x$1;
    }

    public void addArg(String optionName, String optionalParam, ArrayBuffer<String> arrayBuf) {
        Option$.MODULE$.apply((Object)System.getenv(optionalParam)).foreach((Function1)new Serializable(this, optionName, arrayBuf){
            public static final long serialVersionUID = 0L;
            private final String optionName$1;
            private final ArrayBuffer arrayBuf$1;

            public final ArrayBuffer<String> apply(String optParam) {
                return (ArrayBuffer)this.arrayBuf$1.$plus$eq((Object)this.optionName$1, (Object)optParam, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            }
            {
                this.optionName$1 = optionName$1;
                this.arrayBuf$1 = arrayBuf$1;
            }
        });
    }

    public void start() {
        super.start();
        String userJar = System.getenv("SPARK_YARN_APP_JAR");
        if (userJar == null) {
            throw new SparkException("env SPARK_YARN_APP_JAR is not set");
        }
        String driverHost = this.conf().get("spark.driver.host");
        String driverPort = this.conf().get("spark.driver.port");
        String hostport = new StringBuilder().append((Object)driverHost).append((Object)":").append((Object)driverPort).toString();
        ArrayBuffer argsArrayBuf = new ArrayBuffer();
        argsArrayBuf.$plus$eq((Object)"--class", (Object)"notused", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--jar", userJar, "--args", hostport, "--master-class", "org.apache.spark.deploy.yarn.WorkerLauncher"}));
        ((IterableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"--master-memory"), (Object)"SPARK_MASTER_MEMORY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"--num-workers"), (Object)"SPARK_WORKER_INSTANCES"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"--worker-memory"), (Object)"SPARK_WORKER_MEMORY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"--worker-cores"), (Object)"SPARK_WORKER_CORES"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"--queue"), (Object)"SPARK_YARN_QUEUE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"--name"), (Object)"SPARK_YARN_APP_NAME"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"--files"), (Object)"SPARK_YARN_DIST_FILES"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"--archives"), (Object)"SPARK_YARN_DIST_ARCHIVES")}))).foreach((Function1)new Serializable(this, argsArrayBuf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnClientSchedulerBackend $outer;
            private final ArrayBuffer argsArrayBuf$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String optName = (String)tuple2._1();
                    String optParam = (String)tuple2._2();
                    this.$outer.addArg(optName, optParam, (ArrayBuffer<String>)this.argsArrayBuf$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.argsArrayBuf$1 = argsArrayBuf$1;
            }
        });
        this.logDebug((Function0)new Serializable(this, argsArrayBuf){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer argsArrayBuf$1;

            public final String apply() {
                return new StringBuilder().append((Object)"ClientArguments called with: ").append((Object)this.argsArrayBuf$1).toString();
            }
            {
                this.argsArrayBuf$1 = argsArrayBuf$1;
            }
        });
        ClientArguments args = new ClientArguments((String[])argsArrayBuf.toArray(ClassTag$.MODULE$.apply(String.class)), this.conf());
        this.client_$eq(new Client(args, this.conf()));
        this.appId_$eq(this.client().runApp());
        this.waitForApp();
    }

    public void waitForApp() {
        while (true) {
            block6: {
                block5: {
                    YarnApplicationState state;
                    ApplicationReport report = this.client().getApplicationReport(this.appId());
                    this.logInfo((Function0)new Serializable(this, report){
                        public static final long serialVersionUID = 0L;
                        private final ApplicationReport report$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Application report from ASM: \n\t appMasterRpcPort: ").append((Object)BoxesRunTime.boxToInteger((int)this.report$1.getRpcPort())).append((Object)"\n").append((Object)"\t appStartTime: ").append((Object)BoxesRunTime.boxToLong((long)this.report$1.getStartTime())).append((Object)"\n").append((Object)"\t yarnAppState: ").append((Object)this.report$1.getYarnApplicationState()).append((Object)"\n").toString();
                        }
                        {
                            this.report$1 = report$1;
                        }
                    });
                    YarnApplicationState yarnApplicationState = state = report.getYarnApplicationState();
                    YarnApplicationState yarnApplicationState2 = YarnApplicationState.RUNNING;
                    if (!(yarnApplicationState != null ? !yarnApplicationState.equals(yarnApplicationState2) : yarnApplicationState2 != null)) {
                        return;
                    }
                    YarnApplicationState yarnApplicationState3 = state;
                    YarnApplicationState yarnApplicationState4 = YarnApplicationState.FINISHED;
                    if (!(yarnApplicationState3 == null ? yarnApplicationState4 != null : !yarnApplicationState3.equals(yarnApplicationState4))) break block5;
                    YarnApplicationState yarnApplicationState5 = state;
                    YarnApplicationState yarnApplicationState6 = YarnApplicationState.FAILED;
                    if (!(yarnApplicationState5 == null ? yarnApplicationState6 != null : !yarnApplicationState5.equals(yarnApplicationState6))) break block5;
                    YarnApplicationState yarnApplicationState7 = state;
                    YarnApplicationState yarnApplicationState8 = YarnApplicationState.KILLED;
                    if (yarnApplicationState7 != null ? !yarnApplicationState7.equals(yarnApplicationState8) : yarnApplicationState8 != null) break block6;
                }
                throw new SparkException("Yarn application already ended,might be killed or not able to launch application master.");
            }
            Thread.sleep(1000L);
        }
    }

    public void stop() {
        super.stop();
        this.client().stop();
        this.logInfo((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stoped";
            }
        });
    }

    public YarnClientSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        super(scheduler, sc.env().actorSystem());
    }
}

