/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.ApplicationMaster$;
import org.apache.spark.deploy.yarn.ApplicationMasterArguments;
import org.apache.spark.deploy.yarn.YarnAllocationHandler;
import org.apache.spark.deploy.yarn.YarnAllocationHandler$;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u0001\u0003\u00015\u0011\u0011#\u00119qY&\u001c\u0017\r^5p]6\u000b7\u000f^3s\u0015\t\u0019A!\u0001\u0003zCJt'BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AB\u0005\u0003/\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0011\t'oZ:\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!AG!qa2L7-\u0019;j_:l\u0015m\u001d;fe\u0006\u0013x-^7f]R\u001c\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\t\r|gN\u001a\t\u0003C\u0015j\u0011A\t\u0006\u0003?\rR!\u0001\n\u0005\u0002\r!\fGm\\8q\u0013\t1#EA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005I1\u000f]1sW\u000e{gN\u001a\t\u0003+)J!a\u000b\u0004\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\b\u0006\u00030aE\u0012\u0004CA\u000e\u0001\u0011\u0015IB\u00061\u0001\u001b\u0011\u0015yB\u00061\u0001!\u0011\u0015AC\u00061\u0001*\u0011\u0015i\u0003\u0001\"\u00015)\rySG\u000e\u0005\u00063M\u0002\rA\u0007\u0005\u0006QM\u0002\r!\u000b\u0005\u0006[\u0001!\t\u0001\u000f\u000b\u0003_eBQ!G\u001cA\u0002iAqa\u000f\u0001C\u0002\u0013%A(\u0001\u0005zCJt7i\u001c8g+\u0005i\u0004C\u0001 B\u001b\u0005y$BA\u0010A\u0015\t\u00191%\u0003\u0002C\u007f\t\t\u0012,\u0019:o\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\r\u0011\u0003\u0001\u0015!\u0003>\u0003%I\u0018M\u001d8D_:4\u0007\u0005C\u0005G\u0001\u0001\u0007\t\u0019!C\u0005\u000f\u0006a\u0011\r\u001d9BiR,W\u000e\u001d;JIV\t\u0001\n\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u00069!/Z2pe\u0012\u001c(BA'A\u0003\r\t\u0007/[\u0005\u0003\u001f*\u0013A#\u00119qY&\u001c\u0017\r^5p]\u0006#H/Z7qi&#\u0007\"C)\u0001\u0001\u0004\u0005\r\u0011\"\u0003S\u0003A\t\u0007\u000f]!ui\u0016l\u0007\u000f^%e?\u0012*\u0017\u000f\u0006\u0002T-B\u0011q\u0002V\u0005\u0003+B\u0011A!\u00168ji\"9q\u000bUA\u0001\u0002\u0004A\u0015a\u0001=%c!1\u0011\f\u0001Q!\n!\u000bQ\"\u00199q\u0003R$X-\u001c9u\u0013\u0012\u0004\u0003\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0003]\u0003))8/\u001a:UQJ,\u0017\rZ\u000b\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0005Y\u0006twMC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&A\u0002+ie\u0016\fG\rC\u0005g\u0001\u0001\u0007\t\u0019!C\u0005O\u0006qQo]3s)\"\u0014X-\u00193`I\u0015\fHCA*i\u0011\u001d9V-!AA\u0002uCaA\u001b\u0001!B\u0013i\u0016aC;tKJ$\u0006N]3bI\u0002Bq\u0001\u001c\u0001C\u0002\u0013%Q.\u0001\u0002ggV\ta\u000e\u0005\u0002pc6\t\u0001O\u0003\u0002mG%\u0011!\u000f\u001d\u0002\u000b\r&dWmU=ti\u0016l\u0007B\u0002;\u0001A\u0003%a.A\u0002gg\u0002B\u0011B\u001e\u0001A\u0002\u0003\u0007I\u0011B<\u0002\u001be\f'O\\!mY>\u001c\u0017\r^8s+\u0005A\bCA\u000ez\u0013\tQ(AA\u000bZCJt\u0017\t\u001c7pG\u0006$\u0018n\u001c8IC:$G.\u001a:\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\u0018!E=be:\fE\u000e\\8dCR|'o\u0018\u0013fcR\u00111K \u0005\b/n\f\t\u00111\u0001y\u0011\u001d\t\t\u0001\u0001Q!\na\fa\"_1s]\u0006cGn\\2bi>\u0014\b\u0005C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b\u0005Q\u0011n\u001d$j]&\u001c\b.\u001a3\u0016\u0005\u0005%\u0001cA\b\u0002\f%\u0019\u0011Q\u0002\t\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u0003\u0001A\u0002\u0013%\u00111C\u0001\u000fSN4\u0015N\\5tQ\u0016$w\fJ3r)\r\u0019\u0016Q\u0003\u0005\n/\u0006=\u0011\u0011!a\u0001\u0003\u0013A\u0001\"!\u0007\u0001A\u0003&\u0011\u0011B\u0001\fSN4\u0015N\\5tQ\u0016$\u0007\u0005C\u0006\u0002\u001e\u0001\u0001\r\u00111A\u0005\n\u0005}\u0011!C;j\u0003\u0012$'/Z:t+\t\t\t\u0003\u0005\u0003\u0002$\u0005%bbA\b\u0002&%\u0019\u0011q\u0005\t\u0002\rA\u0013X\rZ3g\u0013\u0011\tY#!\f\u0003\rM#(/\u001b8h\u0015\r\t9\u0003\u0005\u0005\f\u0003c\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019$A\u0007vS\u0006#GM]3tg~#S-\u001d\u000b\u0004'\u0006U\u0002\"C,\u00020\u0005\u0005\t\u0019AA\u0011\u0011!\tI\u0004\u0001Q!\n\u0005\u0005\u0012AC;j\u0003\u0012$'/Z:tA!I\u0011Q\b\u0001C\u0002\u0013%\u0011qH\u0001\u000f[\u0006D\u0018\t\u001d9BiR,W\u000e\u001d;t+\t\t\t\u0005E\u0002\u0010\u0003\u0007J1!!\u0012\u0011\u0005\rIe\u000e\u001e\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0003\u0002B\u0005yQ.\u0019=BaB\fE\u000f^3naR\u001c\b\u0005C\u0005\u0002N\u0001\u0001\r\u0011\"\u0003\u0002\b\u0005i\u0011n\u001d'bgR\fUJU3uefD\u0011\"!\u0015\u0001\u0001\u0004%I!a\u0015\u0002#%\u001cH*Y:u\u00036\u0013V\r\u001e:z?\u0012*\u0017\u000fF\u0002T\u0003+B\u0011bVA(\u0003\u0003\u0005\r!!\u0003\t\u0011\u0005e\u0003\u0001)Q\u0005\u0003\u0013\ta\"[:MCN$\u0018)\u0014*fiJL\b\u0005C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\n\u0005}\u0013\u0001C1n\u00072LWM\u001c;\u0016\u0005\u0005\u0005\u0004CBA2\u0003W\ny'\u0004\u0002\u0002f)\u0019Q*a\u001a\u000b\u0007\u0005%\u0004)\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003[\n)G\u0001\u0006B\u001bJk5\t\\5f]R\u0004B!!\u001d\u0002\u0016:!\u00111OAI\u001d\u0011\t)(a$\u000f\t\u0005]\u0014Q\u0012\b\u0005\u0003s\nYI\u0004\u0003\u0002|\u0005%e\u0002BA?\u0003\u000fsA!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007c\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002%\u0011%\u00111aI\u0005\u0004\u0003S\u0002\u0015bA'\u0002h%!\u00111SA3\u0003)\tUJU'DY&,g\u000e^\u0005\u0005\u0003/\u000bIJ\u0001\tD_:$\u0018-\u001b8feJ+\u0017/^3ti*!\u00111SA3\u0011-\ti\n\u0001a\u0001\u0002\u0004%I!a(\u0002\u0019\u0005l7\t\\5f]R|F%Z9\u0015\u0007M\u000b\t\u000bC\u0005X\u00037\u000b\t\u00111\u0001\u0002b!A\u0011Q\u0015\u0001!B\u0013\t\t'A\u0005b[\u000ec\u0017.\u001a8uA!I\u0011\u0011\u0016\u0001C\u0002\u0013%\u0011qH\u0001\u0015[\u0006Dh*^7X_J\\WM\u001d$bS2,(/Z:\t\u0011\u00055\u0006\u0001)A\u0005\u0003\u0003\nQ#\\1y\u001dVlwk\u001c:lKJ4\u0015-\u001b7ve\u0016\u001c\b\u0005C\u0005\u00022\u0002\u0001\r\u0011\"\u0003\u0002\b\u0005Q!/Z4jgR,'/\u001a3\t\u0013\u0005U\u0006\u00011A\u0005\n\u0005]\u0016A\u0004:fO&\u001cH/\u001a:fI~#S-\u001d\u000b\u0004'\u0006e\u0006\"C,\u00024\u0006\u0005\t\u0019AA\u0005\u0011!\ti\f\u0001Q!\n\u0005%\u0011a\u0003:fO&\u001cH/\u001a:fI\u0002B\u0011\"!1\u0001\u0005\u0004%I!a1\u0002\u0013M\u0004\u0018M]6Vg\u0016\u0014XCAAc!\rq\u0016qY\u0005\u0004\u0003Wy\u0006\u0002CAf\u0001\u0001\u0006I!!2\u0002\u0015M\u0004\u0018M]6Vg\u0016\u0014\b\u0005C\u0004\u0002P\u0002!\t!!5\u0002\u0007I,h\u000eF\u0001T\u0011\u001d\t)\u000e\u0001C\u0005\u0003/\fAbZ3u\u0019>\u001c\u0017\r\u001c#jeN$\"!!\t\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\u00069r-\u001a;BaBd\u0017nY1uS>t\u0017\t\u001e;f[B$\u0018\n\u001a\u000b\u0002\u0011\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\u0018!\u0007:fO&\u001cH/\u001a:BaBd\u0017nY1uS>tW*Y:uKJ$\"!!:\u0011\t\u0005\u001d\u0018Q^\u0007\u0003\u0003ST1!a;M\u0003=\u0001(o\u001c;pG>d'/Z2pe\u0012\u001c\u0018\u0002BAx\u0003S\u0014\u0011EU3hSN$XM]!qa2L7-\u0019;j_:l\u0015m\u001d;feJ+7\u000f]8og\u0016Dq!a=\u0001\t\u0013\t)0\u0001\bti\u0006\u0014H/V:fe\u000ec\u0017m]:\u0015\u0003uCq!!?\u0001\t\u0013\t\t.\u0001\u0010xC&$hi\u001c:Ta\u0006\u00148nQ8oi\u0016DH/\u00138ji&\fG.\u001b>fI\"9\u0011Q \u0001\u0005\n\u0005E\u0017aD1mY>\u001c\u0017\r^3X_J\\WM]:\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u0005!B.Y;oG\"\u0014V\r]8si\u0016\u0014H\u000b\u001b:fC\u0012$2!\u0018B\u0003\u0011!\u00119!a@A\u0002\t%\u0011AC0tY\u0016,\u0007\u000fV5nKB\u0019qBa\u0003\n\u0007\t5\u0001C\u0001\u0003M_:<\u0007b\u0002B\t\u0001\u0011%\u0011\u0011[\u0001\rg\u0016tG\r\u0015:pOJ,7o\u001d\u0005\b\u0005+\u0001A\u0011\u0001B\f\u0003]1\u0017N\\5tQ\u0006\u0003\b\u000f\\5dCRLwN\\'bgR,'\u000fF\u0003T\u00053\u0011\u0019\u0003\u0003\u0005\u0003\u001c\tM\u0001\u0019\u0001B\u000f\u0003\u0019\u0019H/\u0019;vgB\u0019\u0011Ja\b\n\u0007\t\u0005\"J\u0001\fGS:\fG.\u00119qY&\u001c\u0017\r^5p]N#\u0018\r^;t\u0011)\u0011)Ca\u0005\u0011\u0002\u0003\u0007\u0011\u0011E\u0001\fI&\fwM\\8ti&\u001c7\u000fC\u0004\u0003*\u0001!I!!5\u0002#\rdW-\u00198vaN#\u0018mZ5oO\u0012K'O\u0002\u0004\u0003.\u0001\u0001!q\u0006\u0002\u0016\u0003B\u0004X*Y:uKJ\u001c\u0006.\u001e;e_^t\u0007j\\8l'\u0019\u0011YC!\r\u00038A\u0019aLa\r\n\u0007\tUrL\u0001\u0004PE*,7\r\u001e\t\u0004=\ne\u0012b\u0001B\u001e?\nA!+\u001e8oC\ndW\r\u0003\u0006\u0003@\t-\"\u0011!Q\u0001\n=\n\u0011\"\u00199q\u001b\u0006\u001cH/\u001a:\t\u000f5\u0012Y\u0003\"\u0001\u0003DQ!!Q\tB%!\u0011\u00119Ea\u000b\u000e\u0003\u0001AqAa\u0010\u0003B\u0001\u0007q\u0006\u0003\u0005\u0002P\n-B\u0011AAi\u0011%\u0011y\u0005AI\u0001\n\u0003\u0011\t&A\u0011gS:L7\u000f[!qa2L7-\u0019;j_:l\u0015m\u001d;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003T)\"\u0011\u0011\u0005B+W\t\u00119\u0006\u0005\u0003\u0003Z\t\rTB\u0001B.\u0015\u0011\u0011iFa\u0018\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B1!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015$1\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,wa\u0002B5\u0005!\u0005!1N\u0001\u0012\u0003B\u0004H.[2bi&|g.T1ti\u0016\u0014\bcA\u000e\u0003n\u00191\u0011A\u0001E\u0001\u0005_\u001a2A!\u001c\u000f\u0011\u001di#Q\u000eC\u0001\u0005g\"\"Aa\u001b\t\u0015\t]$Q\u000eb\u0001\n\u0013\ty$A\rB\u00192{5)\u0011+P%~cuj\u0014)`/\u0006KEkX\"P+:#\u0006\"\u0003B>\u0005[\u0002\u000b\u0011BA!\u0003i\tE\nT(D\u0003R{%k\u0018'P\u001fB{v+Q%U?\u000e{UK\u0014+!\u0011)\u0011yH!\u001cC\u0002\u0013%!\u0011Q\u0001\u0013CB\u0004H.[2bi&|g.T1ti\u0016\u00148/\u0006\u0002\u0003\u0004B)!Q\u0011BH_5\u0011!q\u0011\u0006\u0005\u0005\u0013\u0013Y)\u0001\u0006d_:\u001cWO\u001d:f]RT1A!$b\u0003\u0011)H/\u001b7\n\t\tE%q\u0011\u0002\u0015\u0007>\u0004\u0018p\u00148Xe&$X-\u0011:sCfd\u0015n\u001d;\t\u0013\tU%Q\u000eQ\u0001\n\t\r\u0015aE1qa2L7-\u0019;j_:l\u0015m\u001d;feN\u0004\u0003B\u0003BM\u0005[\u0012\r\u0011\"\u0001\u0003\u001c\u0006y1\u000f]1sW\u000e{g\u000e^3yiJ+g-\u0006\u0002\u0003\u001eB1!q\u0014BS\u0005Sk!A!)\u000b\t\t\r&qQ\u0001\u0007CR|W.[2\n\t\t\u001d&\u0011\u0015\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0019QCa+\n\u0007\t5fA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0005\u00032\n5\u0004\u0015!\u0003\u0003\u001e\u0006\u00012\u000f]1sW\u000e{g\u000e^3yiJ+g\r\t\u0005\u000b\u0005k\u0013iG1A\u0005\u0002\t]\u0016!E=be:\fE\u000e\\8dCR|'\u000fT8paV\u0011!\u0011\u0018\t\u0005\u0005?\u0013Y,\u0003\u0003\u0003>\n\u0005&!D!u_6L7-\u00138uK\u001e,'\u000fC\u0005\u0003B\n5\u0004\u0015!\u0003\u0003:\u0006\u0011\u00120\u0019:o\u00032dwnY1u_Jdun\u001c9!\u0011!\u0011)M!\u001c\u0005\u0002\t\u001d\u0017AF5oGJ,W.\u001a8u\u00032dwnY1u_Jdun\u001c9\u0015\u0007M\u0013I\r\u0003\u0005\u0003L\n\r\u0007\u0019AA!\u0003\t\u0011\u0017\u0010\u0003\u0005\u0003P\n5D\u0011\u0001Bi\u0003!\u0011XmZ5ti\u0016\u0014HcA*\u0003T\"9!Q\u001bBg\u0001\u0004y\u0013AB7bgR,'\u000f\u0003\u0005\u0003Z\n5D\u0011\u0001Bn\u0003]\u0019\b/\u0019:l\u0007>tG/\u001a=u\u0013:LG/[1mSj,G\r\u0006\u0003\u0002\n\tu\u0007\u0002\u0003Bp\u0005/\u0004\rA!+\u0002\u0005M\u001c\u0007\u0002\u0003Br\u0005[\"\tA!:\u0002\t5\f\u0017N\u001c\u000b\u0004'\n\u001d\b\u0002\u0003Bu\u0005C\u0004\rAa;\u0002\u0015\u0005\u0014xm\u0015;sS:<7\u000fE\u0003\u0010\u0005[\f\t#C\u0002\u0003pB\u0011Q!\u0011:sCf\u0004")
public class ApplicationMaster
implements Logging {
    public final ApplicationMasterArguments org$apache$spark$deploy$yarn$ApplicationMaster$$args;
    private final SparkConf sparkConf;
    private final YarnConfiguration yarnConf;
    private ApplicationAttemptId appAttemptId;
    private Thread org$apache$spark$deploy$yarn$ApplicationMaster$$userThread;
    private final FileSystem fs;
    private YarnAllocationHandler org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator;
    private boolean isFinished;
    private String uiAddress;
    private final int maxAppAttempts;
    private boolean org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry;
    private AMRMClient<AMRMClient.ContainerRequest> amClient;
    private final int org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumWorkerFailures;
    private boolean registered;
    private final String org$apache$spark$deploy$yarn$ApplicationMaster$$sparkUser;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        ApplicationMaster$.MODULE$.main(stringArray);
    }

    public static boolean sparkContextInitialized(SparkContext sparkContext) {
        return ApplicationMaster$.MODULE$.sparkContextInitialized(sparkContext);
    }

    public static void register(ApplicationMaster applicationMaster) {
        ApplicationMaster$.MODULE$.register(applicationMaster);
    }

    public static void incrementAllocatorLoop(int n) {
        ApplicationMaster$.MODULE$.incrementAllocatorLoop(n);
    }

    public static AtomicInteger yarnAllocatorLoop() {
        return ApplicationMaster$.MODULE$.yarnAllocatorLoop();
    }

    public static AtomicReference<SparkContext> sparkContextRef() {
        return ApplicationMaster$.MODULE$.sparkContextRef();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    private ApplicationAttemptId appAttemptId() {
        return this.appAttemptId;
    }

    private void appAttemptId_$eq(ApplicationAttemptId x$1) {
        this.appAttemptId = x$1;
    }

    public Thread org$apache$spark$deploy$yarn$ApplicationMaster$$userThread() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$userThread_$eq(Thread x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread = x$1;
    }

    private FileSystem fs() {
        return this.fs;
    }

    public YarnAllocationHandler org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator_$eq(YarnAllocationHandler x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator = x$1;
    }

    private boolean isFinished() {
        return this.isFinished;
    }

    private void isFinished_$eq(boolean x$1) {
        this.isFinished = x$1;
    }

    private String uiAddress() {
        return this.uiAddress;
    }

    private void uiAddress_$eq(String x$1) {
        this.uiAddress = x$1;
    }

    private int maxAppAttempts() {
        return this.maxAppAttempts;
    }

    public boolean org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry;
    }

    public void org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry_$eq(boolean x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry = x$1;
    }

    private AMRMClient<AMRMClient.ContainerRequest> amClient() {
        return this.amClient;
    }

    private void amClient_$eq(AMRMClient<AMRMClient.ContainerRequest> x$1) {
        this.amClient = x$1;
    }

    public int org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumWorkerFailures() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumWorkerFailures;
    }

    private boolean registered() {
        return this.registered;
    }

    private void registered_$eq(boolean x$1) {
        this.registered = x$1;
    }

    public String org$apache$spark$deploy$yarn$ApplicationMaster$$sparkUser() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkUser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        System.setProperty("spark.local.dir", this.getLocalDirs());
        System.setProperty("spark.ui.port", "0");
        ShutdownHookManager.get().addShutdownHook((Runnable)new AppMasterShutdownHook(this, this), 30);
        this.appAttemptId_$eq(this.getApplicationAttemptId());
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry_$eq(this.appAttemptId().getAttemptId() >= this.maxAppAttempts());
        this.amClient_$eq((AMRMClient<AMRMClient.ContainerRequest>)AMRMClient.createAMRMClient());
        this.amClient().init((Configuration)this.yarnConf());
        this.amClient().start();
        ApplicationMaster$.MODULE$.register(this);
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread_$eq(this.startUserClass());
        this.waitForSparkContextInitialized();
        ApplicationMaster applicationMaster = this;
        synchronized (applicationMaster) {
            BoxedUnit boxedUnit;
            if (this.isFinished()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.registerApplicationMaster();
                this.registered_$eq(true);
                boxedUnit = BoxedUnit.UNIT;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl24 : MonitorExitStatement: MONITOREXIT : applicationMaster
            this.allocateWorkers();
        }
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread().join();
        System.exit(0);
    }

    private String getLocalDirs() {
        Option localDirs;
        Option option = localDirs = Option$.MODULE$.apply((Object)System.getenv("YARN_LOCAL_DIRS")).orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)System.getenv("LOCAL_DIRS"));
            }
        });
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new Exception("Yarn Local dirs can't be empty");
        }
        if (option instanceof Some) {
            String l;
            Some some = (Some)option;
            String string = l = (String)some.x();
            return string;
        }
        throw new MatchError((Object)option);
    }

    private ApplicationAttemptId getApplicationAttemptId() {
        java.util.Map<String, String> envs = System.getenv();
        String containerIdString = envs.get(ApplicationConstants.Environment.CONTAINER_ID.name());
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdString);
        ApplicationAttemptId appAttemptId = containerId.getApplicationAttemptId();
        this.logInfo((Function0<String>)new Serializable(this, appAttemptId){
            public static final long serialVersionUID = 0L;
            private final ApplicationAttemptId appAttemptId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"ApplicationAttemptId: ").append((Object)this.appAttemptId$1).toString();
            }
            {
                this.appAttemptId$1 = appAttemptId$1;
            }
        });
        return appAttemptId;
    }

    private RegisterApplicationMasterResponse registerApplicationMaster() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Registering the ApplicationMaster";
            }
        });
        return this.amClient().registerApplicationMaster(Utils$.MODULE$.localHostName(), 0, this.uiAddress());
    }

    /*
     * WARNING - void declaration
     */
    private Thread startUserClass() {
        void var2_2;
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting the user JAR in a separate Thread";
            }
        });
        Method mainMethod = Class.forName(this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.userClass(), false, Thread.currentThread().getContextClassLoader()).getMethod("main", String[].class);
        Thread t = new Thread(this, mainMethod){
            private final /* synthetic */ ApplicationMaster $outer;
            public final Method mainMethod$1;

            public void run() {
                SparkHadoopUtil$.MODULE$.get().runAsUser(this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkUser(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        boolean successed = false;
                        try {
                            String[] mainArgs = new String[this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().org$apache$spark$deploy$yarn$ApplicationMaster$$args.userArgs().size()];
                            this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().org$apache$spark$deploy$yarn$ApplicationMaster$$args.userArgs().copyToArray((Object)mainArgs, 0, this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().org$apache$spark$deploy$yarn$ApplicationMaster$$args.userArgs().size());
                            this.$outer.mainMethod$1.invoke(null, new Object[]{mainArgs});
                            successed = true;
                            this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().logDebug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "finishing main";
                                }
                            });
                            this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry_$eq(true);
                            if (successed) {
                                this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().finishApplicationMaster(FinalApplicationStatus.SUCCEEDED, this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().finishApplicationMaster$default$2());
                            } else {
                                this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().finishApplicationMaster(FinalApplicationStatus.FAILED, this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().finishApplicationMaster$default$2());
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().logDebug((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                            this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry_$eq(true);
                            if (successed) {
                                this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().finishApplicationMaster(FinalApplicationStatus.SUCCEEDED, this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().finishApplicationMaster$default$2());
                            } else {
                                this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().finishApplicationMaster(FinalApplicationStatus.FAILED, this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer().finishApplicationMaster$default$2());
                            }
                            throw throwable;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ApplicationMaster org$apache$spark$deploy$yarn$ApplicationMaster$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.mainMethod$1 = mainMethod$1;
            }
        };
        t.start();
        return var2_2;
    }

    private void waitForSparkContextInitialized() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting for Spark context initialization";
            }
        });
        try {
            SparkContext sparkContext = null;
            AtomicReference<SparkContext> atomicReference = ApplicationMaster$.MODULE$.sparkContextRef();
            synchronized (atomicReference) {
                BoxedUnit boxedUnit;
                IntRef numTries = new IntRef(0);
                long waitTime = 10000L;
                int maxNumTries = this.sparkConf.getInt("spark.yarn.applicationMaster.waitTries", 10);
                while (ApplicationMaster$.MODULE$.sparkContextRef().get() == null && numTries.elem < maxNumTries && !this.isFinished()) {
                    this.logInfo((Function0<String>)new Serializable(this, numTries){
                        public static final long serialVersionUID = 0L;
                        private final IntRef numTries$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Waiting for Spark context initialization ... ").append((Object)BoxesRunTime.boxToInteger((int)this.numTries$1.elem)).toString();
                        }
                        {
                            this.numTries$1 = numTries$1;
                        }
                    });
                    ++numTries.elem;
                    ApplicationMaster$.MODULE$.sparkContextRef().wait(waitTime);
                }
                sparkContext = ApplicationMaster$.MODULE$.sparkContextRef().get();
                Predef$.MODULE$.assert(sparkContext != null || numTries.elem >= maxNumTries);
                if (sparkContext == null) {
                    this.logWarning((Function0<String>)new Serializable(this, numTries, waitTime, maxNumTries){
                        public static final long serialVersionUID = 0L;
                        private final IntRef numTries$1;
                        private final long waitTime$1;
                        private final int maxNumTries$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Unable to retrieve SparkContext inspite of waiting for %d, maxNumTries = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((long)this.numTries$1.elem * this.waitTime$1)), BoxesRunTime.boxToInteger((int)this.maxNumTries$1)}));
                        }
                        {
                            this.numTries$1 = numTries$1;
                            this.waitTime$1 = waitTime$1;
                            this.maxNumTries$1 = maxNumTries$1;
                        }
                    });
                    this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator_$eq(YarnAllocationHandler$.MODULE$.newAllocator((Configuration)this.yarnConf(), this.amClient(), this.appAttemptId(), this.org$apache$spark$deploy$yarn$ApplicationMaster$$args, sparkContext.getConf()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.uiAddress_$eq(sparkContext.ui().appUIAddress());
                    this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator_$eq(YarnAllocationHandler$.MODULE$.newAllocator((Configuration)this.yarnConf(), this.amClient(), this.appAttemptId(), this.org$apache$spark$deploy$yarn$ApplicationMaster$$args, (Map<String, Set<SplitInfo>>)sparkContext.preferredNodeLocationData(), sparkContext.getConf()));
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        }
        finally {
            ApplicationMaster$.MODULE$.incrementAllocatorLoop(ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$ALLOCATOR_LOOP_WAIT_COUNT());
        }
    }

    private void allocateWorkers() {
        block5: {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ApplicationMaster $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Allocating ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numWorkers())).append((Object)" workers.").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().addResourceRequests(this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numWorkers());
            while (this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().getNumWorkersRunning() < this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numWorkers() && this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread().isAlive()) {
                if (this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().getNumWorkersFailed() >= this.org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumWorkerFailures()) {
                    this.finishApplicationMaster(FinalApplicationStatus.FAILED, "max number of worker failures reached");
                }
                this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().allocateResources();
                ApplicationMaster$.MODULE$.incrementAllocatorLoop(1);
                Thread.sleep(100L);
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "All workers have launched.";
                }
            });
            if (!this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread().isAlive()) break block5;
            int timeoutInterval = this.yarnConf().getInt("yarn.am.liveness-monitor.expiry-interval-ms", 120000);
            long schedulerInterval = this.sparkConf.getLong("spark.yarn.scheduler.heartbeat.interval-ms", 5000L);
            long interval = package$.MODULE$.min((long)(timeoutInterval / 2), schedulerInterval);
            this.launchReporterThread(interval);
        }
        return;
        finally {
            ApplicationMaster$.MODULE$.incrementAllocatorLoop(ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$ALLOCATOR_LOOP_WAIT_COUNT());
        }
    }

    private Thread launchReporterThread(long _sleepTime) {
        long sleepTime = _sleepTime <= 0L ? 0L : _sleepTime;
        Thread t = new Thread(this, sleepTime){
            private final /* synthetic */ ApplicationMaster $outer;
            private final long sleepTime$1;

            public void run() {
                while (this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread().isAlive()) {
                    int missingWorkerCount;
                    if (this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().getNumWorkersFailed() >= this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumWorkerFailures()) {
                        this.$outer.finishApplicationMaster(FinalApplicationStatus.FAILED, "max number of worker failures reached");
                    }
                    if ((missingWorkerCount = this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numWorkers() - this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().getNumWorkersRunning() - this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().getNumPendingAllocate()) > 0) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this, missingWorkerCount){
                            public static final long serialVersionUID = 0L;
                            private final int missingWorkerCount$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Allocating %d containers to make up for (potentially) lost containers")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.missingWorkerCount$1)}));
                            }
                            {
                                this.missingWorkerCount$1 = missingWorkerCount$1;
                            }
                        });
                        this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().addResourceRequests(missingWorkerCount);
                    }
                    this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$sendProgress();
                    Thread.sleep(this.sleepTime$1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sleepTime$1 = sleepTime$1;
            }
        };
        t.setDaemon(true);
        t.start();
        this.logInfo((Function0<String>)new Serializable(this, sleepTime){
            public static final long serialVersionUID = 0L;
            private final long sleepTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Started progress reporter thread - sleep time : ").append((Object)BoxesRunTime.boxToLong((long)this.sleepTime$1)).toString();
            }
            {
                this.sleepTime$1 = sleepTime$1;
            }
        });
        return t;
    }

    public void org$apache$spark$deploy$yarn$ApplicationMaster$$sendProgress() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Sending progress";
            }
        });
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().allocateResources();
    }

    public synchronized void finishApplicationMaster(FinalApplicationStatus status, String diagnostics) {
        if (this.isFinished()) {
            return;
        }
        this.isFinished_$eq(true);
        this.logInfo((Function0<String>)new Serializable(this, status){
            public static final long serialVersionUID = 0L;
            private final FinalApplicationStatus status$1;

            public final String apply() {
                return new StringBuilder().append((Object)"finishApplicationMaster with ").append((Object)this.status$1).toString();
            }
            {
                this.status$1 = status$1;
            }
        });
        if (this.registered()) {
            this.amClient().unregisterApplicationMaster(status, "", "");
        }
    }

    public String finishApplicationMaster$default$2() {
        return "";
    }

    public void org$apache$spark$deploy$yarn$ApplicationMaster$$cleanupStagingDir() {
        ObjectRef stagingDirPath = new ObjectRef(null);
        try {
            boolean preserveFiles = new StringOps(Predef$.MODULE$.augmentString(this.sparkConf.get("spark.yarn.preserve.staging.files", "false"))).toBoolean();
            if (!preserveFiles) {
                stagingDirPath.elem = new Path(System.getenv("SPARK_YARN_STAGING_DIR"));
                if ((Path)stagingDirPath.elem == null) {
                    this.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Staging directory is null";
                        }
                    });
                    return;
                }
                this.logInfo((Function0<String>)new Serializable(this, stagingDirPath){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef stagingDirPath$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Deleting staging directory ").append((Object)((Path)this.stagingDirPath$1.elem)).toString();
                    }
                    {
                        this.stagingDirPath$1 = stagingDirPath$1;
                    }
                });
                this.fs().delete((Path)stagingDirPath.elem, true);
            }
        }
        catch (IOException iOException) {
            this.logError((Function0<String>)new Serializable(this, stagingDirPath){
                public static final long serialVersionUID = 0L;
                private final ObjectRef stagingDirPath$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to cleanup staging dir ").append((Object)((Path)this.stagingDirPath$1.elem)).toString();
                }
                {
                    this.stagingDirPath$1 = stagingDirPath$1;
                }
            }, iOException);
        }
    }

    public ApplicationMaster(ApplicationMasterArguments args, Configuration conf, SparkConf sparkConf) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$args = args;
        this.sparkConf = sparkConf;
        Logging.class.$init$((Logging)this);
        this.yarnConf = new YarnConfiguration(conf);
        this.fs = FileSystem.get((Configuration)this.yarnConf());
        this.isFinished = false;
        this.maxAppAttempts = conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry = true;
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$maxNumWorkerFailures = sparkConf.getInt("spark.yarn.max.worker.failures", package$.MODULE$.max(args.numWorkers() * 2, 3));
        this.registered = false;
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$sparkUser = (String)Option$.MODULE$.apply((Object)System.getenv("SPARK_USER")).getOrElse((Function0)new $anonfun$1(this));
    }

    public ApplicationMaster(ApplicationMasterArguments args, SparkConf sparkConf) {
        this(args, new Configuration(), sparkConf);
    }

    public ApplicationMaster(ApplicationMasterArguments args) {
        this(args, new SparkConf());
    }

    public class AppMasterShutdownHook
    implements Runnable {
        private final ApplicationMaster appMaster;
        public final /* synthetic */ ApplicationMaster $outer;

        @Override
        public void run() {
            this.org$apache$spark$deploy$yarn$ApplicationMaster$AppMasterShutdownHook$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "AppMaster received a signal.";
                }
            });
            if (this.appMaster.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry()) {
                this.appMaster.org$apache$spark$deploy$yarn$ApplicationMaster$$cleanupStagingDir();
            }
        }

        public /* synthetic */ ApplicationMaster org$apache$spark$deploy$yarn$ApplicationMaster$AppMasterShutdownHook$$$outer() {
            return this.$outer;
        }

        public AppMasterShutdownHook(ApplicationMaster $outer, ApplicationMaster appMaster) {
            this.appMaster = appMaster;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

