/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.AllocationType$;
import org.apache.spark.deploy.yarn.ApplicationMasterArguments;
import org.apache.spark.deploy.yarn.ExecutorRunnable;
import org.apache.spark.deploy.yarn.YarnAllocationHandler$;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.scheduler.TaskSchedulerImpl$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\reb!B\u0001\u0003\u0001\ta!!F-be:\fE\u000e\\8dCRLwN\u001c%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\tA!_1s]*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011A#F\u0007\u0002\r%\u0011aC\u0002\u0002\b\u0019><w-\u001b8h\u0011!A\u0002A!b\u0001\n\u0003Q\u0012\u0001B2p]\u001a\u001c\u0001!F\u0001\u001c!\ta\u0002%D\u0001\u001e\u0015\tAbD\u0003\u0002 \u0011\u00051\u0001.\u00193p_BL!!I\u000f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!\u0019\u0003A!A!\u0002\u0013Y\u0012!B2p]\u001a\u0004\u0003\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\u0002\u0011\u0005l7\t\\5f]R,\u0012a\n\t\u0004Q9\u0002T\"A\u0015\u000b\u0005)Z\u0013aA1qS*\u0011A&L\u0001\u0007G2LWM\u001c;\u000b\u0005\rq\u0012BA\u0018*\u0005)\tUJU'DY&,g\u000e\u001e\t\u0003c\rs!AM!\u000f\u0005M\u0002eB\u0001\u001b@\u001d\t)dH\u0004\u00027{9\u0011q\u0007\u0010\b\u0003qmj\u0011!\u000f\u0006\u0003ue\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0010\t\u0013\t\u0019a$\u0003\u0002-[%\u0011!fK\u0005\u0003\u0005&\n!\"Q'S\u001b\u000ec\u0017.\u001a8u\u0013\t!UI\u0001\tD_:$\u0018-\u001b8feJ+\u0017/^3ti*\u0011!)\u000b\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005O\u0005I\u0011-\\\"mS\u0016tG\u000f\t\u0005\t\u0013\u0002\u0011)\u0019!C\u0001\u0015\u0006a\u0011\r\u001d9BiR,W\u000e\u001d;JIV\t1\n\u0005\u0002M!6\tQJ\u0003\u0002O\u001f\u00069!/Z2pe\u0012\u001c(B\u0001\u0016.\u0013\t\tVJ\u0001\u000bBaBd\u0017nY1uS>t\u0017\t\u001e;f[B$\u0018\n\u001a\u0005\t'\u0002\u0011\t\u0011)A\u0005\u0017\u0006i\u0011\r\u001d9BiR,W\u000e\u001d;JI\u0002B\u0001\"\u0016\u0001\u0003\u0006\u0004%\tAV\u0001\r[\u0006DX\t_3dkR|'o]\u000b\u0002/B\u0011a\u0002W\u0005\u00033>\u00111!\u00138u\u0011!Y\u0006A!A!\u0002\u00139\u0016!D7bq\u0016CXmY;u_J\u001c\b\u0005\u0003\u0005^\u0001\t\u0015\r\u0011\"\u0001W\u00039)\u00070Z2vi>\u0014X*Z7pefD\u0001b\u0018\u0001\u0003\u0002\u0003\u0006IaV\u0001\u0010Kb,7-\u001e;pe6+Wn\u001c:zA!A\u0011\r\u0001BC\u0002\u0013\u0005a+A\u0007fq\u0016\u001cW\u000f^8s\u0007>\u0014Xm\u001d\u0005\tG\u0002\u0011\t\u0011)A\u0005/\u0006qQ\r_3dkR|'oQ8sKN\u0004\u0003\u0002C3\u0001\u0005\u000b\u0007I\u0011\u00014\u0002)A\u0014XMZ3se\u0016$\u0007j\\:u)>\u001cu.\u001e8u+\u00059\u0007\u0003\u00025l]^s!AD5\n\u0005)|\u0011A\u0002)sK\u0012,g-\u0003\u0002m[\n\u0019Q*\u00199\u000b\u0005)|\u0001C\u00015p\u0013\t\u0001XN\u0001\u0004TiJLgn\u001a\u0005\te\u0002\u0011\t\u0011)A\u0005O\u0006)\u0002O]3gKJ\u0014X\r\u001a%pgR$vnQ8v]R\u0004\u0003\u0002\u0003;\u0001\u0005\u000b\u0007I\u0011\u00014\u0002)A\u0014XMZ3se\u0016$'+Y2l)>\u001cu.\u001e8u\u0011!1\bA!A!\u0002\u00139\u0017!\u00069sK\u001a,'O]3e%\u0006\u001c7\u000eV8D_VtG\u000f\t\u0005\tq\u0002\u0011)\u0019!C\u0001s\u0006I1\u000f]1sW\u000e{gNZ\u000b\u0002uB\u0011Ac_\u0005\u0003y\u001a\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011y\u0004!\u0011!Q\u0001\ni\f!b\u001d9be.\u001cuN\u001c4!\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007\ta\u0001P5oSRtD\u0003FA\u0003\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\u0002E\u0002\u0002\b\u0001i\u0011A\u0001\u0005\u00061}\u0004\ra\u0007\u0005\u0006K}\u0004\ra\n\u0005\u0006\u0013~\u0004\ra\u0013\u0005\u0006+~\u0004\ra\u0016\u0005\u0006;~\u0004\ra\u0016\u0005\u0006C~\u0004\ra\u0016\u0005\u0006K~\u0004\ra\u001a\u0005\u0006i~\u0004\ra\u001a\u0005\u0006q~\u0004\rA\u001f\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003?\tA$\u00197m_\u000e\fG/\u001a3I_N$Hk\\\"p]R\f\u0017N\\3sg6\u000b\u0007/\u0006\u0002\u0002\"A9\u00111EA\u0017]\u0006ERBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u000f5,H/\u00192mK*\u0019\u00111F\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00020\u0005\u0015\"a\u0002%bg\"l\u0015\r\u001d\t\u0007\u0003G\t\u0019$a\u000e\n\t\u0005U\u0012Q\u0005\u0002\u0004'\u0016$\bc\u0001'\u0002:%\u0019\u00111H'\u0003\u0017\r{g\u000e^1j]\u0016\u0014\u0018\n\u001a\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002\"\u0005i\u0012\r\u001c7pG\u0006$X\r\u001a%pgR$vnQ8oi\u0006Lg.\u001a:t\u001b\u0006\u0004\b\u0005C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F\u0005Y\u0012\r\u001c7pG\u0006$X\rZ\"p]R\f\u0017N\\3s)>Dun\u001d;NCB,\"!a\u0012\u0011\u000f\u0005\r\u0012QFA\u001c]\"A\u00111\n\u0001!\u0002\u0013\t9%\u0001\u000fbY2|7-\u0019;fI\u000e{g\u000e^1j]\u0016\u0014Hk\u001c%pgRl\u0015\r\u001d\u0011\t\u0013\u0005=\u0003A1A\u0005\n\u0005E\u0013AE1mY>\u001c\u0017\r^3e%\u0006\u001c7nQ8v]R,\"!a\u0015\u0011\r\u0005\r\u0012Q\u00068X\u0011!\t9\u0006\u0001Q\u0001\n\u0005M\u0013aE1mY>\u001c\u0017\r^3e%\u0006\u001c7nQ8v]R\u0004\u0003\"CA.\u0001\t\u0007I\u0011BA/\u0003U\u0011X\r\\3bg\u0016$7i\u001c8uC&tWM\u001d'jgR,\"!a\u0018\u0011\r\u0005\u0005\u0014qNA\u001c\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014AC2p]\u000e,(O]3oi*!\u0011\u0011NA6\u0003\u0011)H/\u001b7\u000b\u0005\u00055\u0014\u0001\u00026bm\u0006LA!!\u001d\u0002d\t!2i\u001c9z\u001f:<&/\u001b;f\u0003J\u0014\u0018-\u001f'jgRD\u0001\"!\u001e\u0001A\u0003%\u0011qL\u0001\u0017e\u0016dW-Y:fI\u000e{g\u000e^1j]\u0016\u0014H*[:uA!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111P\u0001\u0019a\u0016tG-\u001b8h%\u0016dW-Y:f\u0007>tG/Y5oKJ\u001cXCAA?!!\t\t'a \u00028\u0005\r\u0015\u0002BAA\u0003G\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\rq\u0011QQ\u0005\u0004\u0003\u000f{!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002~\u0005I\u0002/\u001a8eS:<'+\u001a7fCN,7i\u001c8uC&tWM]:!\u0011%\ty\t\u0001b\u0001\n\u0013\t\t*\u0001\nok6\u0004VM\u001c3j]\u001e\fE\u000e\\8dCR,WCAAJ!\u0011\t)*a'\u000e\u0005\u0005]%\u0002BAM\u0003G\na!\u0019;p[&\u001c\u0017\u0002BAO\u0003/\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\b\u0002CAQ\u0001\u0001\u0006I!a%\u0002'9,X\u000eU3oI&tw-\u00117m_\u000e\fG/\u001a\u0011\t\u0013\u0005\u0015\u0006A1A\u0005\n\u0005E\u0015a\u00058v[\u0016CXmY;u_J\u001c(+\u001e8oS:<\u0007\u0002CAU\u0001\u0001\u0006I!a%\u0002)9,X.\u0012=fGV$xN]:Sk:t\u0017N\\4!\u0011%\ti\u000b\u0001b\u0001\n\u0013\t\t*A\tfq\u0016\u001cW\u000f^8s\u0013\u0012\u001cu.\u001e8uKJD\u0001\"!-\u0001A\u0003%\u00111S\u0001\u0013Kb,7-\u001e;pe&#7i\\;oi\u0016\u0014\b\u0005C\u0005\u00026\u0002\u0011\r\u0011\"\u0003\u0002\u0012\u0006qA.Y:u%\u0016\u001c\bo\u001c8tK&#\u0007\u0002CA]\u0001\u0001\u0006I!a%\u0002\u001f1\f7\u000f\u001e*fgB|gn]3JI\u0002B\u0011\"!0\u0001\u0005\u0004%I!!%\u0002%9,X.\u0012=fGV$xN]:GC&dW\r\u001a\u0005\t\u0003\u0003\u0004\u0001\u0015!\u0003\u0002\u0014\u0006\u0019b.^7Fq\u0016\u001cW\u000f^8sg\u001a\u000b\u0017\u000e\\3eA!1\u0011Q\u0019\u0001\u0005\u0002Y\u000bQcZ3u\u001dVl\u0007+\u001a8eS:<\u0017\t\u001c7pG\u0006$X\r\u0003\u0004\u0002J\u0002!\tAV\u0001\u0017O\u0016$h*^7Fq\u0016\u001cW\u000f^8sgJ+hN\\5oO\"1\u0011Q\u001a\u0001\u0005\u0002Y\u000bQcZ3u\u001dVlW\t_3dkR|'o\u001d$bS2,G\rC\u0004\u0002R\u0002!\t!a5\u0002;%\u001c(+Z:pkJ\u001cWmQ8ogR\u0014\u0018-\u001b8u'\u0006$\u0018n\u001d4jK\u0012$B!a!\u0002V\"A\u0011q[Ah\u0001\u0004\tI.A\u0005d_:$\u0018-\u001b8feB\u0019A*a7\n\u0007\u0005uWJA\u0005D_:$\u0018-\u001b8fe\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\u0018\u0001\u0005:fY\u0016\f7/Z\"p]R\f\u0017N\\3s)\u0011\t)/a;\u0011\u00079\t9/C\u0002\u0002j>\u0011A!\u00168ji\"A\u0011q[Ap\u0001\u0004\tI\u000eC\u0004\u0002p\u0002!\t!!=\u0002#\u0005dGn\\2bi\u0016\u0014Vm]8ve\u000e,7\u000f\u0006\u0002\u0002f\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\u0018AG2sK\u0006$XMU1dWJ+7o\\;sG\u0016\u0014V-];fgR\u001cH\u0003BA}\u0003\u007f\u0004R!a\t\u0002|BJA!!@\u0002&\tY\u0011I\u001d:bs\n+hMZ3s\u0011!\u0011\t!a=A\u0002\u0005e\u0018A\u00045pgR\u001cuN\u001c;bS:,'o\u001d\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0003e\tG\u000e\\8dCR,GmQ8oi\u0006Lg.\u001a:t\u001f:Dun\u001d;\u0015\u0007]\u0013I\u0001C\u0004\u0003\f\t\r\u0001\u0019\u00018\u0002\t!|7\u000f\u001e\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0003e\tG\u000e\\8dCR,GmQ8oi\u0006Lg.\u001a:t\u001f:\u0014\u0016mY6\u0015\u0007]\u0013\u0019\u0002C\u0004\u0003\u0016\t5\u0001\u0019\u00018\u0002\tI\f7m\u001b\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0003M\tG\r\u001a*fg>,(oY3SKF,Xm\u001d;t)\u0011\t)O!\b\t\u000f\t}!q\u0003a\u0001/\u0006aa.^7Fq\u0016\u001cW\u000f^8sg\"9!1\u0005\u0001\u0005\n\t\u0015\u0012AF2sK\u0006$XMU3t_V\u00148-\u001a*fcV,7\u000f^:\u0015\u0015\u0005e(q\u0005B\u001d\u0005{\u0011y\u0004\u0003\u0005\u0003*\t\u0005\u0002\u0019\u0001B\u0016\u0003-\u0011X-];fgR$\u0016\u0010]3\u0011\t\t5\"1\u0007\b\u0005\u0003\u000f\u0011y#C\u0002\u00032\t\ta\"\u00117m_\u000e\fG/[8o)f\u0004X-\u0003\u0003\u00036\t]\"AD!mY>\u001c\u0017\r^5p]RK\b/\u001a\u0006\u0004\u0005c\u0011\u0001b\u0002B\u001e\u0005C\u0001\rA\\\u0001\te\u0016\u001cx.\u001e:dK\"9!q\u0004B\u0011\u0001\u00049\u0006b\u0002B!\u0005C\u0001\raV\u0001\taJLwN]5us\"9!Q\t\u0001\u0005\n\t\u001d\u0013AG2p]N$(/^2u\u0007>tG/Y5oKJ\u0014V-];fgR\u001cHCCA}\u0005\u0013\u0012\u0019Fa\u0016\u0003Z!A!1\nB\"\u0001\u0004\u0011i%A\u0003i_N$8\u000f\u0005\u0003\u000f\u0005\u001fr\u0017b\u0001B)\u001f\t)\u0011I\u001d:bs\"A!Q\u000bB\"\u0001\u0004\u0011i%A\u0003sC\u000e\\7\u000fC\u0004\u0003 \t\r\u0003\u0019A,\t\u000f\t\u0005#1\ta\u0001/\u001e9!Q\f\u0002\t\u0002\t}\u0013!F-be:\fE\u000e\\8dCRLwN\u001c%b]\u0012dWM\u001d\t\u0005\u0003\u000f\u0011\tG\u0002\u0004\u0002\u0005!\u0005!1M\n\u0004\u0005Cj\u0001\u0002CA\u0001\u0005C\"\tAa\u001a\u0015\u0005\t}\u0003B\u0003B6\u0005C\u0012\r\u0011\"\u0001\u0003n\u0005A\u0011IT-`\u0011>\u001bF+\u0006\u0002\u0003pA!!\u0011\u000fB<\u001b\t\u0011\u0019H\u0003\u0003\u0003v\u0005-\u0014\u0001\u00027b]\u001eL1\u0001\u001dB:\u0011%\u0011YH!\u0019!\u0002\u0013\u0011y'A\u0005B\u001df{\u0006jT*UA!I!q\u0010B1\u0005\u0004%\tAV\u0001\t!JKuJU%U3\"A!1\u0011B1A\u0003%q+A\u0005Q%&{%+\u0013+ZA!I!q\u0011B1\u0005\u0004%\tAV\u0001\u0010\u001b\u0016kuJU-`\u001fZ+%\u000bS#B\t\"A!1\u0012B1A\u0003%q+\u0001\tN\u000b6{%+W0P-\u0016\u0013\u0006*R!EA!Q!q\u0012B1\u0005\u0004%IA!%\u0002\u0015!|7\u000f\u001e+p%\u0006\u001c7.\u0006\u0002\u0003\u0014B1\u0011\u0011MA@]:D\u0011Ba&\u0003b\u0001\u0006IAa%\u0002\u0017!|7\u000f\u001e+p%\u0006\u001c7\u000e\t\u0005\u000b\u00057\u0013\tG1A\u0005\n\tu\u0015!\u0004:bG.$v\u000eS8tiN+G/\u0006\u0002\u0003 B9\u0011\u0011MA@]\n\u0005\u0006#\u0002BR\u0005KsWBAA4\u0013\u0011\t)$a\u001a\t\u0013\t%&\u0011\rQ\u0001\n\t}\u0015A\u0004:bG.$v\u000eS8tiN+G\u000f\t\u0005\t\u0005[\u0013\t\u0007\"\u0001\u00030\u0006aa.Z<BY2|7-\u0019;peRa\u0011Q\u0001BY\u0005g\u0013)La.\u0003B\"1\u0001Da+A\u0002mAa!\nBV\u0001\u00049\u0003BB%\u0003,\u0002\u00071\n\u0003\u0005\u0003:\n-\u0006\u0019\u0001B^\u0003\u0011\t'oZ:\u0011\t\u0005\u001d!QX\u0005\u0004\u0005\u007f\u0013!AG!qa2L7-\u0019;j_:l\u0015m\u001d;fe\u0006\u0013x-^7f]R\u001c\bB\u0002=\u0003,\u0002\u0007!\u0010\u0003\u0005\u0003.\n\u0005D\u0011\u0001Bc)9\t)Aa2\u0003J\n-'Q\u001aBh\u0005SDa\u0001\u0007Bb\u0001\u0004Y\u0002BB\u0013\u0003D\u0002\u0007q\u0005\u0003\u0004J\u0005\u0007\u0004\ra\u0013\u0005\t\u0005s\u0013\u0019\r1\u0001\u0003<\"A!\u0011\u001bBb\u0001\u0004\u0011\u0019.A\u0002nCB\u0004rA!6\u0003X:\u0014I.\u0004\u0002\u0002*%\u0019A.!\u000b\u0011\r\tU'1\u001cBo\u0013\u0011\t)$!\u000b\u0011\t\t}'Q]\u0007\u0003\u0005CT1Aa9\u0007\u0003%\u00198\r[3ek2,'/\u0003\u0003\u0003h\n\u0005(!C*qY&$\u0018J\u001c4p\u0011\u0019A(1\u0019a\u0001u\"A!Q\u0016B1\t\u0003\u0011i\u000f\u0006\n\u0002\u0006\t=(\u0011\u001fBz\u0005k\u00149P!?\u0003|\nu\bB\u0002\r\u0003l\u0002\u00071\u0004\u0003\u0004&\u0005W\u0004\ra\n\u0005\u0007\u0013\n-\b\u0019A&\t\rU\u0013Y\u000f1\u0001X\u0011\u0019i&1\u001ea\u0001/\"1\u0011Ma;A\u0002]C\u0001B!5\u0003l\u0002\u0007!1\u001b\u0005\u0007q\n-\b\u0019\u0001>\t\u0011\r\u0005!\u0011\rC\u0005\u0007\u0007\tAcZ3oKJ\fG/\u001a(pI\u0016$vnV3jO\"$HCBB\u0003\u0007\u0017\u0019i\u0001E\u0003\u000f\u0007\u000f9w-C\u0002\u0004\n=\u0011a\u0001V;qY\u0016\u0014\u0004B\u0002\r\u0003\u0000\u0002\u00071\u0004\u0003\u0005\u0004\u0010\t}\b\u0019\u0001Bj\u0003\u0015Ig\u000e];u\u0011!\u0019\u0019B!\u0019\u0005\u0002\rU\u0011A\u00037p_.,\bOU1dWR)ana\u0006\u0004\u001a!1\u0001d!\u0005A\u0002mAqAa\u0003\u0004\u0012\u0001\u0007a\u000e\u0003\u0005\u0004\u001e\t\u0005D\u0011AB\u0010\u0003]1W\r^2i\u0007\u0006\u001c\u0007.\u001a3I_N$8OR8s%\u0006\u001c7\u000e\u0006\u0003\u0004\"\r-\u0002#\u0002\b\u0004$\r\u001d\u0012bAB\u0013\u001f\t1q\n\u001d;j_:\u0004B\u0001[B\u0015]&\u0019\u0011QG7\t\u000f\tU11\u0004a\u0001]\"A1q\u0006B1\t\u0003\u0019\t$\u0001\tq_B,H.\u0019;f%\u0006\u001c7.\u00138g_R1\u0011Q]B\u001a\u0007kAa\u0001GB\u0017\u0001\u0004Y\u0002bBB\u001c\u0007[\u0001\rA\\\u0001\tQ>\u001cHO\\1nK\u0002")
public class YarnAllocationHandler
implements Logging {
    private final Configuration conf;
    private final AMRMClient<AMRMClient.ContainerRequest> amClient;
    private final ApplicationAttemptId appAttemptId;
    private final int maxExecutors;
    private final int executorMemory;
    private final int executorCores;
    private final scala.collection.immutable.Map<String, Object> preferredHostToCount;
    private final scala.collection.immutable.Map<String, Object> preferredRackToCount;
    private final SparkConf sparkConf;
    private final HashMap<String, scala.collection.mutable.Set<ContainerId>> org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap;
    private final HashMap<ContainerId, String> org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedContainerToHostMap;
    private final HashMap<String, Object> org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount;
    private final CopyOnWriteArrayList<ContainerId> org$apache$spark$deploy$yarn$YarnAllocationHandler$$releasedContainerList;
    private final ConcurrentHashMap<ContainerId, Object> org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers;
    private final AtomicInteger numPendingAllocate;
    private final AtomicInteger org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning;
    private final AtomicInteger org$apache$spark$deploy$yarn$YarnAllocationHandler$$executorIdCounter;
    private final AtomicInteger lastResponseId;
    private final AtomicInteger org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsFailed;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void populateRackInfo(Configuration configuration, String string) {
        YarnAllocationHandler$.MODULE$.populateRackInfo(configuration, string);
    }

    public static Option<scala.collection.immutable.Set<String>> fetchCachedHostsForRack(String string) {
        return YarnAllocationHandler$.MODULE$.fetchCachedHostsForRack(string);
    }

    public static String lookupRack(Configuration configuration, String string) {
        return YarnAllocationHandler$.MODULE$.lookupRack(configuration, string);
    }

    public static YarnAllocationHandler newAllocator(Configuration configuration, AMRMClient<AMRMClient.ContainerRequest> aMRMClient, ApplicationAttemptId applicationAttemptId, int n, int n2, int n3, Map<String, Set<SplitInfo>> map, SparkConf sparkConf) {
        return YarnAllocationHandler$.MODULE$.newAllocator(configuration, aMRMClient, applicationAttemptId, n, n2, n3, map, sparkConf);
    }

    public static YarnAllocationHandler newAllocator(Configuration configuration, AMRMClient<AMRMClient.ContainerRequest> aMRMClient, ApplicationAttemptId applicationAttemptId, ApplicationMasterArguments applicationMasterArguments, Map<String, Set<SplitInfo>> map, SparkConf sparkConf) {
        return YarnAllocationHandler$.MODULE$.newAllocator(configuration, aMRMClient, applicationAttemptId, applicationMasterArguments, map, sparkConf);
    }

    public static YarnAllocationHandler newAllocator(Configuration configuration, AMRMClient<AMRMClient.ContainerRequest> aMRMClient, ApplicationAttemptId applicationAttemptId, ApplicationMasterArguments applicationMasterArguments, SparkConf sparkConf) {
        return YarnAllocationHandler$.MODULE$.newAllocator(configuration, aMRMClient, applicationAttemptId, applicationMasterArguments, sparkConf);
    }

    public static int MEMORY_OVERHEAD() {
        return YarnAllocationHandler$.MODULE$.MEMORY_OVERHEAD();
    }

    public static int PRIORITY() {
        return YarnAllocationHandler$.MODULE$.PRIORITY();
    }

    public static String ANY_HOST() {
        return YarnAllocationHandler$.MODULE$.ANY_HOST();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Configuration conf() {
        return this.conf;
    }

    public AMRMClient<AMRMClient.ContainerRequest> amClient() {
        return this.amClient;
    }

    public ApplicationAttemptId appAttemptId() {
        return this.appAttemptId;
    }

    public int maxExecutors() {
        return this.maxExecutors;
    }

    public int executorMemory() {
        return this.executorMemory;
    }

    public int executorCores() {
        return this.executorCores;
    }

    public scala.collection.immutable.Map<String, Object> preferredHostToCount() {
        return this.preferredHostToCount;
    }

    public scala.collection.immutable.Map<String, Object> preferredRackToCount() {
        return this.preferredRackToCount;
    }

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public HashMap<String, scala.collection.mutable.Set<ContainerId>> org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap;
    }

    public HashMap<ContainerId, String> org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedContainerToHostMap() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedContainerToHostMap;
    }

    public HashMap<String, Object> org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount;
    }

    public CopyOnWriteArrayList<ContainerId> org$apache$spark$deploy$yarn$YarnAllocationHandler$$releasedContainerList() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$releasedContainerList;
    }

    public ConcurrentHashMap<ContainerId, Object> org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers;
    }

    private AtomicInteger numPendingAllocate() {
        return this.numPendingAllocate;
    }

    public AtomicInteger org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning;
    }

    public AtomicInteger org$apache$spark$deploy$yarn$YarnAllocationHandler$$executorIdCounter() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$executorIdCounter;
    }

    private AtomicInteger lastResponseId() {
        return this.lastResponseId;
    }

    public AtomicInteger org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsFailed() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsFailed;
    }

    public int getNumPendingAllocate() {
        return this.numPendingAllocate().intValue();
    }

    public int getNumExecutorsRunning() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning().intValue();
    }

    public int getNumExecutorsFailed() {
        return this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsFailed().intValue();
    }

    public boolean isResourceConstraintSatisfied(Container container) {
        return container.getResource().getMemory() >= this.executorMemory() + YarnAllocationHandler$.MODULE$.MEMORY_OVERHEAD();
    }

    public void releaseContainer(Container container) {
        ContainerId containerId = container.getId();
        this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers().put(containerId, BoxesRunTime.boxToBoolean((boolean)true));
        this.amClient().releaseAssignedContainer(containerId);
    }

    public void allocateResources() {
        java.util.List completedContainers;
        float progressIndicator = 0.1f;
        AllocateResponse allocateResponse = this.amClient().allocate(progressIndicator);
        java.util.List allocatedContainers = allocateResponse.getAllocatedContainers();
        if (allocatedContainers.size() > 0) {
            int numPendingAllocateNow = this.numPendingAllocate().addAndGet(-1 * allocatedContainers.size());
            if (numPendingAllocateNow < 0) {
                numPendingAllocateNow = this.numPendingAllocate().addAndGet(-1 * numPendingAllocateNow);
            }
            this.logDebug((Function0<String>)new Serializable(this, allocateResponse, allocatedContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;
                private final AllocateResponse allocateResponse$1;
                private final java.util.List allocatedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("\n        Allocated containers: %d\n        Current executor count: %d\n        Containers released: %s\n        Containers to-be-released: %s\n        Cluster resources: %s\n        ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.allocatedContainers$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning().get()), this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$releasedContainerList(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers(), this.allocateResponse$1.getAvailableResources()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.allocateResponse$1 = allocateResponse$1;
                    this.allocatedContainers$1 = allocatedContainers$1;
                }
            });
            HashMap hostToContainers = new HashMap();
            JavaConversions$.MODULE$.asScalaBuffer(allocatedContainers).foreach((Function1)new Serializable(this, hostToContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;
                private final HashMap hostToContainers$1;

                public final Object apply(Container container) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.isResourceConstraintSatisfied(container)) {
                        String host = container.getNodeId().getHost();
                        ArrayBuffer containersForHost = (ArrayBuffer)this.hostToContainers$1.getOrElseUpdate((Object)host, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ArrayBuffer<Container> apply() {
                                return new ArrayBuffer();
                            }
                        });
                        boxedUnit = containersForHost.$plus$eq((Object)container);
                    } else {
                        this.$outer.releaseContainer(container);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.hostToContainers$1 = hostToContainers$1;
                }
            });
            HashMap dataLocalContainers = new HashMap();
            HashMap rackLocalContainers = new HashMap();
            HashMap offRackContainers = new HashMap();
            hostToContainers.keySet().foreach((Function1)new Serializable(this, hostToContainers, dataLocalContainers, rackLocalContainers, offRackContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;
                private final HashMap hostToContainers$1;
                private final HashMap dataLocalContainers$1;
                private final HashMap rackLocalContainers$1;
                private final HashMap offRackContainers$1;

                public final Object apply(String candidateHost) {
                    String rack;
                    int maxExpectedHostCount = BoxesRunTime.unboxToInt((Object)this.$outer.preferredHostToCount().getOrElse((Object)candidateHost, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }));
                    int requiredHostCount = maxExpectedHostCount - this.$outer.allocatedContainersOnHost(candidateHost);
                    Option remainingContainersOpt = this.hostToContainers$1.get((Object)candidateHost);
                    Predef$.MODULE$.assert(remainingContainersOpt.isDefined());
                    ArrayBuffer remainingContainers = (ArrayBuffer)remainingContainersOpt.get();
                    if (requiredHostCount >= remainingContainers.size()) {
                        this.dataLocalContainers$1.put((Object)candidateHost, (Object)remainingContainers);
                        remainingContainers = null;
                    } else if (requiredHostCount > 0) {
                        Tuple2 tuple2 = remainingContainers.splitAt(remainingContainers.size() - requiredHostCount);
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            ArrayBuffer dataLocal = (ArrayBuffer)tuple2._1();
                            ArrayBuffer remaining = (ArrayBuffer)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataLocal, (Object)remaining);
                            ArrayBuffer dataLocal2 = (ArrayBuffer)tuple23._1();
                            ArrayBuffer remaining2 = (ArrayBuffer)tuple23._2();
                            this.dataLocalContainers$1.put((Object)candidateHost, (Object)dataLocal2);
                            remaining2.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$allocateResources$3 $outer;

                                public final void apply(Container container) {
                                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$anonfun$$$outer().releaseContainer(container);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            remainingContainers = null;
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                    }
                    if (remainingContainers != null && (rack = YarnAllocationHandler$.MODULE$.lookupRack(this.$outer.conf(), candidateHost)) != null) {
                        int maxExpectedRackCount = BoxesRunTime.unboxToInt((Object)this.$outer.preferredRackToCount().getOrElse((Object)rack, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }));
                        int requiredRackCount = maxExpectedRackCount - this.$outer.allocatedContainersOnRack(rack) - ((SeqLike)this.rackLocalContainers$1.getOrElse((Object)rack, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final List<Nothing$> apply() {
                                return Nil$.MODULE$;
                            }
                        })).size();
                        if (requiredRackCount >= remainingContainers.size()) {
                            this.dataLocalContainers$1.put((Object)rack, (Object)remainingContainers);
                            remainingContainers = null;
                        } else if (requiredRackCount > 0) {
                            Tuple2 tuple2 = remainingContainers.splitAt(remainingContainers.size() - requiredRackCount);
                            if (tuple2 != null) {
                                Tuple2 tuple24;
                                ArrayBuffer rackLocal = (ArrayBuffer)tuple2._1();
                                ArrayBuffer remaining = (ArrayBuffer)tuple2._2();
                                Tuple2 tuple25 = tuple24 = new Tuple2((Object)rackLocal, (Object)remaining);
                                ArrayBuffer rackLocal2 = (ArrayBuffer)tuple25._1();
                                ArrayBuffer remaining3 = (ArrayBuffer)tuple25._2();
                                ArrayBuffer existingRackLocal = (ArrayBuffer)this.rackLocalContainers$1.getOrElseUpdate((Object)rack, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final ArrayBuffer<Container> apply() {
                                        return new ArrayBuffer();
                                    }
                                });
                                existingRackLocal.$plus$plus$eq((TraversableOnce)rackLocal2);
                                remainingContainers = remaining3;
                            } else {
                                throw new MatchError((Object)tuple2);
                            }
                        }
                    }
                    return remainingContainers == null ? BoxedUnit.UNIT : this.offRackContainers$1.put((Object)candidateHost, (Object)remainingContainers);
                }

                public /* synthetic */ YarnAllocationHandler org$apache$spark$deploy$yarn$YarnAllocationHandler$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.hostToContainers$1 = hostToContainers$1;
                    this.dataLocalContainers$1 = dataLocalContainers$1;
                    this.rackLocalContainers$1 = rackLocalContainers$1;
                    this.offRackContainers$1 = offRackContainers$1;
                }
            });
            ArrayBuffer allocatedContainersToProcess = new ArrayBuffer(allocatedContainers.size());
            allocatedContainersToProcess.$plus$plus$eq((TraversableOnce)TaskSchedulerImpl$.MODULE$.prioritizeContainers(dataLocalContainers));
            allocatedContainersToProcess.$plus$plus$eq((TraversableOnce)TaskSchedulerImpl$.MODULE$.prioritizeContainers(rackLocalContainers));
            allocatedContainersToProcess.$plus$plus$eq((TraversableOnce)TaskSchedulerImpl$.MODULE$.prioritizeContainers(offRackContainers));
            allocatedContainersToProcess.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object apply(Container container) {
                    Integer n;
                    int numExecutorsRunningNow = this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning().incrementAndGet();
                    String executorHostname = container.getNodeId().getHost();
                    ContainerId containerId = container.getId();
                    int executorMemoryOverhead = this.$outer.executorMemory() + YarnAllocationHandler$.MODULE$.MEMORY_OVERHEAD();
                    Predef$.MODULE$.assert(container.getResource().getMemory() >= executorMemoryOverhead);
                    if (numExecutorsRunningNow > this.$outer.maxExecutors()) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname, containerId){
                            public static final long serialVersionUID = 0L;
                            private final String executorHostname$1;
                            private final ContainerId containerId$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Ignoring container %s at host %s, since we already have the required number of\n            containers for it.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$1, this.executorHostname$1}));
                            }
                            {
                                this.executorHostname$1 = executorHostname$1;
                                this.containerId$1 = containerId$1;
                            }
                        });
                        this.$outer.releaseContainer(container);
                        n = BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning().decrementAndGet());
                        return n;
                    }
                    String executorId = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$executorIdCounter().incrementAndGet())).toString();
                    String driverUrl = new StringOps(Predef$.MODULE$.augmentString("akka.tcp://spark@%s:%s/user/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sparkConf().get("spark.driver.host"), this.$outer.sparkConf().get("spark.driver.port"), CoarseGrainedSchedulerBackend$.MODULE$.ACTOR_NAME()}));
                    this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname, containerId){
                        public static final long serialVersionUID = 0L;
                        private final String executorHostname$1;
                        private final ContainerId containerId$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Launching container %s for on host %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$1, this.executorHostname$1}));
                        }
                        {
                            this.executorHostname$1 = executorHostname$1;
                            this.containerId$1 = containerId$1;
                        }
                    });
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers().remove(containerId);
                    String rack = YarnAllocationHandler$.MODULE$.lookupRack(this.$outer.conf(), executorHostname);
                    HashMap<String, scala.collection.mutable.Set<ContainerId>> hashMap = this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap();
                    synchronized (hashMap) {
                        scala.collection.mutable.Set containerSet = (scala.collection.mutable.Set)this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap().getOrElseUpdate((Object)executorHostname, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final HashSet<ContainerId> apply() {
                                return new HashSet();
                            }
                        });
                        containerSet.$plus$eq((Object)containerId);
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedContainerToHostMap().put((Object)containerId, (Object)executorHostname);
                        Object object = rack == null ? BoxedUnit.UNIT : this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount().put((Object)rack, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount().getOrElse((Object)rack, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        })) + 1)));
                        // MONITOREXIT @DISABLED, blocks:[0, 1] lbl26 : MonitorExitStatement: MONITOREXIT : hashMap
                        this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname, driverUrl){
                            public static final long serialVersionUID = 0L;
                            private final String executorHostname$1;
                            private final String driverUrl$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Launching ExecutorRunnable. driverUrl: %s,  executorHostname: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.driverUrl$1, this.executorHostname$1}));
                            }
                            {
                                this.executorHostname$1 = executorHostname$1;
                                this.driverUrl$1 = driverUrl$1;
                            }
                        });
                        ExecutorRunnable executorRunnable = new ExecutorRunnable(container, this.$outer.conf(), this.$outer.sparkConf(), driverUrl, executorId, executorHostname, this.$outer.executorMemory(), this.$outer.executorCores());
                        new Thread(executorRunnable).start();
                        n = BoxedUnit.UNIT;
                        return n;
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.logDebug((Function0<String>)new Serializable(this, allocatedContainers, allocatedContainersToProcess){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;
                private final java.util.List allocatedContainers$1;
                private final ArrayBuffer allocatedContainersToProcess$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("\n        Finished allocating %s containers (from %s originally).\n        Current number of executors running: %d,\n        releasedContainerList: %s,\n        pendingReleaseContainers: %s\n        ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.allocatedContainersToProcess$1, this.allocatedContainers$1, BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning().get()), this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$releasedContainerList(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.allocatedContainers$1 = allocatedContainers$1;
                    this.allocatedContainersToProcess$1 = allocatedContainersToProcess$1;
                }
            });
        }
        if ((completedContainers = allocateResponse.getCompletedContainersStatuses()).size() > 0) {
            this.logDebug((Function0<String>)new Serializable(this, completedContainers){
                public static final long serialVersionUID = 0L;
                private final java.util.List completedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Completed %d containers")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.completedContainers$1.size())}));
                }
                {
                    this.completedContainers$1 = completedContainers$1;
                }
            });
            JavaConversions$.MODULE$.asScalaBuffer(completedContainers).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;

                public final Object apply(ContainerStatus completedContainer) {
                    Object object;
                    ContainerId containerId = completedContainer.getContainerId();
                    if (this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers().containsKey(containerId)) {
                        object = this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers().remove(containerId);
                    } else {
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning().decrementAndGet();
                        this.$outer.logInfo((Function0<String>)new Serializable(this, completedContainer, containerId){
                            public static final long serialVersionUID = 0L;
                            private final ContainerStatus completedContainer$1;
                            private final ContainerId containerId$2;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Completed container %s (state: %s, exit status: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$2, this.completedContainer$1.getState(), BoxesRunTime.boxToInteger((int)this.completedContainer$1.getExitStatus())}));
                            }
                            {
                                this.completedContainer$1 = completedContainer$1;
                                this.containerId$2 = containerId$2;
                            }
                        });
                        if (completedContainer.getExitStatus() != 0) {
                            this.$outer.logInfo((Function0<String>)new Serializable(this, containerId){
                                public static final long serialVersionUID = 0L;
                                private final ContainerId containerId$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Container marked as failed: ").append((Object)this.containerId$2).toString();
                                }
                                {
                                    this.containerId$2 = containerId$2;
                                }
                            });
                            object = BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsFailed().incrementAndGet());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    }
                    HashMap<String, scala.collection.mutable.Set<ContainerId>> hashMap = this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap();
                    synchronized (hashMap) {
                        Object object2;
                        if (JavaConversions$.MODULE$.mutableMapAsJavaMap(this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedContainerToHostMap()).containsKey(containerId)) {
                            int rackCount;
                            Option option;
                            Option hostOpt = this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedContainerToHostMap().get((Object)containerId);
                            Predef$.MODULE$.assert(hostOpt.isDefined());
                            String host = (String)hostOpt.get();
                            Option containerSetOpt = this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap().get((Object)host);
                            Predef$.MODULE$.assert(containerSetOpt.isDefined());
                            scala.collection.mutable.Set containerSet = (scala.collection.mutable.Set)containerSetOpt.get();
                            containerSet.remove((Object)containerId);
                            if (containerSet.isEmpty()) {
                                option = this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap().remove((Object)host);
                            } else {
                                this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap().update((Object)host, (Object)containerSet);
                                option = BoxedUnit.UNIT;
                            }
                            this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedContainerToHostMap().remove((Object)containerId);
                            String rack = YarnAllocationHandler$.MODULE$.lookupRack(this.$outer.conf(), host);
                            object2 = rack == null ? BoxedUnit.UNIT : ((rackCount = BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount().getOrElse((Object)rack, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply() {
                                    return this.apply$mcI$sp();
                                }

                                public int apply$mcI$sp() {
                                    return 0;
                                }
                            })) - 1) > 0 ? this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount().put((Object)rack, (Object)BoxesRunTime.boxToInteger((int)rackCount)) : this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount().remove((Object)rack));
                        } else {
                            object2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = object2;
                        return boxedUnit;
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.logDebug((Function0<String>)new Serializable(this, completedContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;
                private final java.util.List completedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("\n        Finished processing %d completed containers.\n        Current number of executors running: %d,\n        releasedContainerList: %s,\n        pendingReleaseContainers: %s\n        ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.completedContainers$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning().get()), this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$releasedContainerList(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.completedContainers$1 = completedContainers$1;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public ArrayBuffer<AMRMClient.ContainerRequest> createRackResourceRequests(ArrayBuffer<AMRMClient.ContainerRequest> hostContainers) {
        void var3_3;
        HashMap rackToCounts = new HashMap();
        hostContainers.foreach((Function1)new Serializable(this, rackToCounts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocationHandler $outer;
            private final HashMap rackToCounts$1;

            public final Object apply(AMRMClient.ContainerRequest container) {
                BoxedUnit boxedUnit;
                String candidateHost = (String)JavaConversions$.MODULE$.asScalaBuffer(container.getNodes()).last();
                String string = YarnAllocationHandler$.MODULE$.ANY_HOST();
                String string2 = candidateHost;
                Predef$.MODULE$.assert(string != null ? !string.equals(string2) : string2 != null);
                String rack = YarnAllocationHandler$.MODULE$.lookupRack(this.$outer.conf(), candidateHost);
                if (rack == null) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    int count = BoxesRunTime.unboxToInt((Object)this.rackToCounts$1.getOrElse((Object)rack, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }));
                    boxedUnit = this.rackToCounts$1.put((Object)rack, (Object)BoxesRunTime.boxToInteger((int)(++count)));
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.rackToCounts$1 = rackToCounts$1;
            }
        });
        ArrayBuffer requestedContainers = new ArrayBuffer(rackToCounts.size());
        rackToCounts.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, requestedContainers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocationHandler $outer;
            private final ArrayBuffer requestedContainers$1;

            public final ArrayBuffer<AMRMClient.ContainerRequest> apply(Tuple2<String, Object> x$3) {
                Tuple2<String, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    String rack = (String)tuple2._1();
                    int count = tuple2._2$mcI$sp();
                    ArrayBuffer arrayBuffer = this.requestedContainers$1.$plus$plus$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$createResourceRequests(AllocationType$.MODULE$.RACK(), rack, count, YarnAllocationHandler$.MODULE$.PRIORITY()));
                    return arrayBuffer;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.requestedContainers$1 = requestedContainers$1;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int allocatedContainersOnHost(String host) {
        int retval = 0;
        HashMap<String, scala.collection.mutable.Set<ContainerId>> hashMap = this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap();
        synchronized (hashMap) {
            void var2_2;
            retval = ((TraversableOnce)this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap().getOrElse((Object)host, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Set<Nothing$> apply() {
                    return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                }
            })).size();
            return (int)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int allocatedContainersOnRack(String rack) {
        int retval = 0;
        HashMap<String, scala.collection.mutable.Set<ContainerId>> hashMap = this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap();
        synchronized (hashMap) {
            void var2_2;
            retval = BoxesRunTime.unboxToInt((Object)this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount().getOrElse((Object)rack, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return 0;
                }
            }));
            return (int)var2_2;
        }
    }

    public void addResourceRequests(int numExecutors) {
        List list;
        if (numExecutors <= 0 || this.preferredHostToCount().isEmpty()) {
            this.logDebug((Function0<String>)new Serializable(this, numExecutors){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;
                private final int numExecutors$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"numExecutors: ").append((Object)BoxesRunTime.boxToInteger((int)this.numExecutors$1)).append((Object)", host preferences: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.preferredHostToCount().isEmpty())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.numExecutors$1 = numExecutors$1;
                }
            });
            list = this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$createResourceRequests(AllocationType$.MODULE$.ANY(), null, numExecutors, YarnAllocationHandler$.MODULE$.PRIORITY()).toList();
        } else {
            ArrayBuffer hostContainerRequests = new ArrayBuffer(this.preferredHostToCount().size());
            this.preferredHostToCount().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$2) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, hostContainerRequests){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;
                private final ArrayBuffer hostContainerRequests$1;

                public final Object apply(Tuple2<String, Object> x$4) {
                    Tuple2<String, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        String candidateHost = (String)tuple2._1();
                        int candidateCount = tuple2._2$mcI$sp();
                        int requiredCount = candidateCount - this.$outer.allocatedContainersOnHost(candidateHost);
                        BoxedUnit boxedUnit = requiredCount > 0 ? this.hostContainerRequests$1.$plus$plus$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocationHandler$$createResourceRequests(AllocationType$.MODULE$.HOST(), candidateHost, requiredCount, YarnAllocationHandler$.MODULE$.PRIORITY())) : BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.hostContainerRequests$1 = hostContainerRequests$1;
                }
            });
            List rackContainerRequests = this.createRackResourceRequests((ArrayBuffer<AMRMClient.ContainerRequest>)hostContainerRequests).toList();
            ArrayBuffer<AMRMClient.ContainerRequest> anyContainerRequests = this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$createResourceRequests(AllocationType$.MODULE$.ANY(), null, numExecutors, YarnAllocationHandler$.MODULE$.PRIORITY());
            ArrayBuffer containerRequestBuffer = new ArrayBuffer(hostContainerRequests.size() + JavaConversions$.MODULE$.seqAsJavaList((Seq)rackContainerRequests).size() + anyContainerRequests.size());
            containerRequestBuffer.$plus$plus$eq((TraversableOnce)hostContainerRequests);
            containerRequestBuffer.$plus$plus$eq((TraversableOnce)rackContainerRequests);
            containerRequestBuffer.$plus$plus$eq(anyContainerRequests);
            list = containerRequestBuffer.toList();
        }
        List containerRequests = list;
        containerRequests.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocationHandler $outer;

            public final void apply(AMRMClient.ContainerRequest request) {
                this.$outer.amClient().addContainerRequest(request);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (numExecutors > 0) {
            this.numPendingAllocate().addAndGet(numExecutors);
            this.logInfo((Function0<String>)new Serializable(this, numExecutors){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocationHandler $outer;
                private final int numExecutors$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Will Allocate %d executor containers, each with %d memory")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numExecutors$1), BoxesRunTime.boxToInteger((int)(this.$outer.executorMemory() + YarnAllocationHandler$.MODULE$.MEMORY_OVERHEAD()))}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.numExecutors$1 = numExecutors$1;
                }
            });
        } else {
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Empty allocation request ...";
                }
            });
        }
        containerRequests.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocationHandler $outer;

            public final void apply(AMRMClient.ContainerRequest request) {
                java.util.List nodes = request.getNodes();
                ObjectRef hostStr = nodes == null || nodes.isEmpty() ? new ObjectRef((Object)"Any") : new ObjectRef((Object)((String)JavaConversions$.MODULE$.asScalaBuffer(nodes).last()));
                this.$outer.logInfo((Function0<String>)new Serializable(this, request, hostStr){
                    public static final long serialVersionUID = 0L;
                    private final AMRMClient.ContainerRequest request$1;
                    private final ObjectRef hostStr$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Container request (host: %s, priority: %s, capability: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.hostStr$1.elem, BoxesRunTime.boxToInteger((int)this.request$1.getPriority().getPriority()), this.request$1.getCapability()}));
                    }
                    {
                        this.request$1 = request$1;
                        this.hostStr$1 = hostStr$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public ArrayBuffer<AMRMClient.ContainerRequest> org$apache$spark$deploy$yarn$YarnAllocationHandler$$createResourceRequests(Enumeration.Value requestType, String resource, int numExecutors, int priority) {
        block5: {
            ArrayBuffer<AMRMClient.ContainerRequest> arrayBuffer;
            block3: {
                Enumeration.Value value;
                block4: {
                    block2: {
                        value = requestType;
                        Enumeration.Value value2 = AllocationType$.MODULE$.HOST();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        String string = YarnAllocationHandler$.MODULE$.ANY_HOST();
                        String string2 = resource;
                        Predef$.MODULE$.assert(string != null ? !string.equals(string2) : string2 != null);
                        String hostname = resource;
                        ArrayBuffer<AMRMClient.ContainerRequest> nodeLocal = this.constructContainerRequests((String[])((Object[])new String[]{hostname}), null, numExecutors, priority);
                        YarnAllocationHandler$.MODULE$.populateRackInfo(this.conf(), hostname);
                        arrayBuffer = nodeLocal;
                        break block3;
                    }
                    Enumeration.Value value4 = AllocationType$.MODULE$.RACK();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    String rack = resource;
                    arrayBuffer = this.constructContainerRequests(null, (String[])((Object[])new String[]{rack}), numExecutors, priority);
                    break block3;
                }
                Enumeration.Value value6 = AllocationType$.MODULE$.ANY();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                arrayBuffer = this.constructContainerRequests(null, null, numExecutors, priority);
            }
            return arrayBuffer;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Unexpected/unsupported request type: ").append((Object)requestType).toString());
    }

    private ArrayBuffer<AMRMClient.ContainerRequest> constructContainerRequests(String[] hosts, String[] racks, int numExecutors, int priority) {
        int memoryRequest = this.executorMemory() + YarnAllocationHandler$.MODULE$.MEMORY_OVERHEAD();
        Resource resource = Resource.newInstance((int)memoryRequest, (int)this.executorCores());
        Priority prioritySetting = (Priority)Records.newRecord(Priority.class);
        prioritySetting.setPriority(priority);
        ArrayBuffer requests = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutors).foreach((Function1)new Serializable(this, hosts, racks, resource, prioritySetting, requests){
            public static final long serialVersionUID = 0L;
            private final String[] hosts$1;
            private final String[] racks$1;
            private final Resource resource$1;
            private final Priority prioritySetting$1;
            private final ArrayBuffer requests$1;

            public final ArrayBuffer<AMRMClient.ContainerRequest> apply(int i) {
                return this.requests$1.$plus$eq((Object)new AMRMClient.ContainerRequest(this.resource$1, this.hosts$1, this.racks$1, this.prioritySetting$1));
            }
            {
                this.hosts$1 = hosts$1;
                this.racks$1 = racks$1;
                this.resource$1 = resource$1;
                this.prioritySetting$1 = prioritySetting$1;
                this.requests$1 = requests$1;
            }
        });
        return requests;
    }

    public YarnAllocationHandler(Configuration conf, AMRMClient<AMRMClient.ContainerRequest> amClient, ApplicationAttemptId appAttemptId, int maxExecutors, int executorMemory, int executorCores, scala.collection.immutable.Map<String, Object> preferredHostToCount, scala.collection.immutable.Map<String, Object> preferredRackToCount, SparkConf sparkConf) {
        this.conf = conf;
        this.amClient = amClient;
        this.appAttemptId = appAttemptId;
        this.maxExecutors = maxExecutors;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.preferredHostToCount = preferredHostToCount;
        this.preferredRackToCount = preferredRackToCount;
        this.sparkConf = sparkConf;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedHostToContainersMap = new HashMap();
        this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedContainerToHostMap = new HashMap();
        this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$allocatedRackCount = new HashMap();
        this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$releasedContainerList = new CopyOnWriteArrayList();
        this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$pendingReleaseContainers = new ConcurrentHashMap();
        this.numPendingAllocate = new AtomicInteger();
        this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsRunning = new AtomicInteger();
        this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$executorIdCounter = new AtomicInteger();
        this.lastResponseId = new AtomicInteger();
        this.org$apache$spark$deploy$yarn$YarnAllocationHandler$$numExecutorsFailed = new AtomicInteger();
    }
}

