/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ExecutorRunnableUtil;
import org.apache.spark.deploy.yarn.ExecutorRunnableUtil$class;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u00015\u0011\u0001#\u0012=fGV$xN\u001d*v]:\f'\r\\3\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u000191\u0012$\b\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qbF\u0005\u00031A\u0011\u0001BU;o]\u0006\u0014G.\u001a\t\u00035mi\u0011AA\u0005\u00039\t\u0011A#\u0012=fGV$xN\u001d*v]:\f'\r\\3Vi&d\u0007C\u0001\u0010 \u001b\u00051\u0011B\u0001\u0011\u0007\u0005\u001daunZ4j]\u001eD\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\nG>tG/Y5oKJ\u0004\"\u0001\n\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\u000fI,7m\u001c:eg*\u0011\u0001&K\u0001\u0004CBL'BA\u0002+\u0015\tY\u0003\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003[\u0015\u0012\u0011bQ8oi\u0006Lg.\u001a:\t\u0011=\u0002!\u0011!Q\u0001\nA\nAaY8oMB\u0011\u0011gM\u0007\u0002e)\u0011qFK\u0005\u0003iI\u0012QbQ8oM&<WO]1uS>t\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\rM\u00048i\u001c8g!\tq\u0002(\u0003\u0002:\r\tI1\u000b]1sW\u000e{gN\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u0005iQ.Y:uKJ\fE\r\u001a:fgN\u0004\"!P\"\u000f\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005~B\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\bg2\fg/Z%e\u0011!I\u0005A!A!\u0002\u0013a\u0014\u0001\u00035pgRt\u0017-\\3\t\u0011-\u0003!\u0011!Q\u0001\n1\u000ba\"\u001a=fGV$xN]'f[>\u0014\u0018\u0010\u0005\u0002?\u001b&\u0011aj\u0010\u0002\u0004\u0013:$\b\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u001b\u0015DXmY;u_J\u001cuN]3t\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003\u0019a\u0014N\\5u}QIA+\u0016,X1fS6\f\u0018\t\u00035\u0001AQAI)A\u0002\rBQaL)A\u0002ABQAN)A\u0002]BQaO)A\u0002qBQaR)A\u0002qBQ!S)A\u0002qBQaS)A\u00021CQ\u0001U)A\u00021CqA\u0018\u0001A\u0002\u0013\u0005q,A\u0002sa\u000e,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G&\n1!\u001b9d\u0013\t)'MA\u0004ZCJt'\u000bU\"\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\u00069!\u000f]2`I\u0015\fHCA5m!\tq$.\u0003\u0002l\u007f\t!QK\\5u\u0011\u001dig-!AA\u0002\u0001\f1\u0001\u001f\u00132\u0011\u0019y\u0007\u0001)Q\u0005A\u0006!!\u000f]2!\u0011%\t\b\u00011AA\u0002\u0013\u0005!/\u0001\u0005o[\u000ec\u0017.\u001a8u+\u0005\u0019\bC\u0001;y\u001b\u0005)(B\u0001\u0015w\u0015\t9\u0018&\u0001\u0004dY&,g\u000e^\u0005\u0003sV\u0014\u0001BT'DY&,g\u000e\u001e\u0005\nw\u0002\u0001\r\u00111A\u0005\u0002q\fAB\\7DY&,g\u000e^0%KF$\"![?\t\u000f5T\u0018\u0011!a\u0001g\"1q\u0010\u0001Q!\nM\f\u0011B\\7DY&,g\u000e\u001e\u0011\t\u0013\u0005\r\u0001A1A\u0005\u0002\u0005\u0015\u0011!C:qCJ\\7i\u001c8g+\u00059\u0004bBA\u0005\u0001\u0001\u0006IaN\u0001\u000bgB\f'o[\"p]\u001a\u0004\u0003\"CA\u0007\u0001\t\u0007I\u0011AA\b\u0003!I\u0018M\u001d8D_:4WCAA\t!\u0011\t\u0019\"a\u0006\u000e\u0005\u0005U!BA\u0018*\u0013\u0011\tI\"!\u0006\u0003#e\u000b'O\\\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\u0003%I\u0018M\u001d8D_:4\u0007\u0005C\u0004\u0002\"\u0001!\t!a\t\u0002\u0007I,h\u000eF\u0001j\u0011\u001d\t9\u0003\u0001C\u0001\u0003S\tab\u001d;beR\u001cuN\u001c;bS:,'/\u0006\u0002\u0002,AA\u0011QFA\u001a\u0003o\tY$\u0004\u0002\u00020)\u0019\u0011\u0011\u0007\n\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003k\tyCA\u0002NCB\u00042aDA\u001d\u0013\t!\u0005\u0003\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\tEE\u0001\u0004]&|\u0017\u0002BA#\u0003\u007f\u0011!BQ=uK\n+hMZ3s\u0001")
public class ExecutorRunnable
implements Runnable,
ExecutorRunnableUtil {
    private final Container container;
    private final String masterAddress;
    private final String slaveId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private YarnRPC rpc;
    private NMClient nmClient;
    private final SparkConf sparkConf;
    private final YarnConfiguration yarnConf;
    private final HashMap<String, String> env;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    private HashMap env$lzycompute() {
        ExecutorRunnable executorRunnable = this;
        synchronized (executorRunnable) {
            if (!this.bitmap$0) {
                this.env = ExecutorRunnableUtil$class.env(this);
                this.bitmap$0 = true;
            }
            return this.env;
        }
    }

    @Override
    public HashMap<String, String> env() {
        return this.bitmap$0 ? this.env : this.env$lzycompute();
    }

    @Override
    public List<String> prepareCommand(String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores, HashMap<String, LocalResource> localResources) {
        return ExecutorRunnableUtil$class.prepareCommand(this, masterAddress, slaveId, hostname, executorMemory, executorCores, localResources);
    }

    @Override
    public HashMap<String, LocalResource> prepareLocalResources() {
        return ExecutorRunnableUtil$class.prepareLocalResources(this);
    }

    @Override
    public HashMap<String, String> prepareEnvironment() {
        return ExecutorRunnableUtil$class.prepareEnvironment(this);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    @Override
    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    @Override
    public YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    @Override
    public void run() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting Executor Container";
            }
        });
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.yarnConf());
        this.nmClient().start();
        this.startContainer();
    }

    public Map<String, ByteBuffer> startContainer() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting up ContainerLaunchContext";
            }
        });
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        HashMap<String, LocalResource> localResources = this.prepareLocalResources();
        ctx.setLocalResources(JavaConversions$.MODULE$.mutableMapAsJavaMap(localResources));
        ctx.setEnvironment(JavaConversions$.MODULE$.mutableMapAsJavaMap(this.env()));
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand(this.masterAddress, this.slaveId, this.hostname, this.executorMemory, this.executorCores, localResources);
        this.logInfo((Function0<String>)new Serializable(this, commands){
            public static final long serialVersionUID = 0L;
            private final List commands$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Setting up executor with commands: ").append((Object)this.commands$1).toString();
            }
            {
                this.commands$1 = commands$1;
            }
        });
        ctx.setCommands(JavaConversions$.MODULE$.seqAsJavaList(commands));
        return this.nmClient().startContainer(this.container, ctx);
    }

    public ExecutorRunnable(Container container, Configuration conf, SparkConf spConf, String masterAddress, String slaveId, String hostname, int executorMemory, int executorCores) {
        this.container = container;
        this.masterAddress = masterAddress;
        this.slaveId = slaveId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        Logging.class.$init$((Logging)this);
        ExecutorRunnableUtil$class.$init$(this);
        this.rpc = YarnRPC.create((Configuration)conf);
        this.sparkConf = spConf;
        this.yarnConf = new YarnConfiguration(conf);
    }
}

