/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.Logging;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.yarn.ApplicationMaster$;
import org.apache.spark.deploy.yarn.ApplicationMasterArguments;
import org.apache.spark.deploy.yarn.YarnAllocationHandler;
import org.apache.spark.deploy.yarn.YarnAllocationHandler$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.YarnStableUtils$;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u0001\u0003\u00015\u0011\u0011#\u00119qY&\u001c\u0017\r^5p]6\u000b7\u000f^3s\u0015\t\u0019A!\u0001\u0003zCJt'BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AB\u0005\u0003/\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0011\t'oZ:\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!AG!qa2L7-\u0019;j_:l\u0015m\u001d;fe\u0006\u0013x-^7f]R\u001c\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\t\r|gN\u001a\t\u0003C\u0015j\u0011A\t\u0006\u0003?\rR!\u0001\n\u0005\u0002\r!\fGm\\8q\u0013\t1#EA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005I1\u000f]1sW\u000e{gN\u001a\t\u0003+)J!a\u000b\u0004\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\b\u0006\u00030aE\u0012\u0004CA\u000e\u0001\u0011\u0015IB\u00061\u0001\u001b\u0011\u0015yB\u00061\u0001!\u0011\u0015AC\u00061\u0001*\u0011\u0015i\u0003\u0001\"\u00015)\rySG\u000e\u0005\u00063M\u0002\rA\u0007\u0005\u0006QM\u0002\r!\u000b\u0005\u0006[\u0001!\t\u0001\u000f\u000b\u0003_eBQ!G\u001cA\u0002iAqa\u000f\u0001C\u0002\u0013%A(\u0001\u0005zCJt7i\u001c8g+\u0005i\u0004C\u0001 B\u001b\u0005y$BA\u0010A\u0015\t\u00191%\u0003\u0002C\u007f\t\t\u0012,\u0019:o\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\r\u0011\u0003\u0001\u0015!\u0003>\u0003%I\u0018M\u001d8D_:4\u0007\u0005C\u0005G\u0001\u0001\u0007\t\u0019!C\u0005\u000f\u0006a\u0011\r\u001d9BiR,W\u000e\u001d;JIV\t\u0001\n\u0005\u0002J\u001d6\t!J\u0003\u0002L\u0019\u00069!/Z2pe\u0012\u001c(BA'A\u0003\r\t\u0007/[\u0005\u0003\u001f*\u0013A#\u00119qY&\u001c\u0017\r^5p]\u0006#H/Z7qi&#\u0007\"C)\u0001\u0001\u0004\u0005\r\u0011\"\u0003S\u0003A\t\u0007\u000f]!ui\u0016l\u0007\u000f^%e?\u0012*\u0017\u000f\u0006\u0002T-B\u0011q\u0002V\u0005\u0003+B\u0011A!\u00168ji\"9q\u000bUA\u0001\u0002\u0004A\u0015a\u0001=%c!1\u0011\f\u0001Q!\n!\u000bQ\"\u00199q\u0003R$X-\u001c9u\u0013\u0012\u0004\u0003\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0003]\u0003))8/\u001a:UQJ,\u0017\rZ\u000b\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0005Y\u0006twMC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&A\u0002+ie\u0016\fG\rC\u0005g\u0001\u0001\u0007\t\u0019!C\u0005O\u0006qQo]3s)\"\u0014X-\u00193`I\u0015\fHCA*i\u0011\u001d9V-!AA\u0002uCaA\u001b\u0001!B\u0013i\u0016aC;tKJ$\u0006N]3bI\u0002Bq\u0001\u001c\u0001C\u0002\u0013%Q.\u0001\u0002ggV\ta\u000e\u0005\u0002pc6\t\u0001O\u0003\u0002mG%\u0011!\u000f\u001d\u0002\u000b\r&dWmU=ti\u0016l\u0007B\u0002;\u0001A\u0003%a.A\u0002gg\u0002B\u0011B\u001e\u0001A\u0002\u0003\u0007I\u0011B<\u0002\u001be\f'O\\!mY>\u001c\u0017\r^8s+\u0005A\bCA\u000ez\u0013\tQ(AA\u000bZCJt\u0017\t\u001c7pG\u0006$\u0018n\u001c8IC:$G.\u001a:\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\u0018!E=be:\fE\u000e\\8dCR|'o\u0018\u0013fcR\u00111K \u0005\b/n\f\t\u00111\u0001y\u0011\u001d\t\t\u0001\u0001Q!\na\fa\"_1s]\u0006cGn\\2bi>\u0014\b\u0005C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b\u0005Q\u0011n\u001d$j]&\u001c\b.\u001a3\u0016\u0005\u0005%\u0001cA\b\u0002\f%\u0019\u0011Q\u0002\t\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u0003\u0001A\u0002\u0013%\u00111C\u0001\u000fSN4\u0015N\\5tQ\u0016$w\fJ3r)\r\u0019\u0016Q\u0003\u0005\n/\u0006=\u0011\u0011!a\u0001\u0003\u0013A\u0001\"!\u0007\u0001A\u0003&\u0011\u0011B\u0001\fSN4\u0015N\\5tQ\u0016$\u0007\u0005C\u0006\u0002\u001e\u0001\u0001\r\u00111A\u0005\n\u0005}\u0011!C;j\u0003\u0012$'/Z:t+\t\t\t\u0003\u0005\u0003\u0002$\u0005%bbA\b\u0002&%\u0019\u0011q\u0005\t\u0002\rA\u0013X\rZ3g\u0013\u0011\tY#!\f\u0003\rM#(/\u001b8h\u0015\r\t9\u0003\u0005\u0005\f\u0003c\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019$A\u0007vS\u0006#GM]3tg~#S-\u001d\u000b\u0004'\u0006U\u0002\"C,\u00020\u0005\u0005\t\u0019AA\u0011\u0011!\tI\u0004\u0001Q!\n\u0005\u0005\u0012AC;j\u0003\u0012$'/Z:tA!Y\u0011Q\b\u0001A\u0002\u0003\u0007I\u0011BA\u0010\u0003A)\u0018\u000eS5ti>\u0014\u00180\u00113ee\u0016\u001c8\u000fC\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0013\u0001F;j\u0011&\u001cHo\u001c:z\u0003\u0012$'/Z:t?\u0012*\u0017\u000fF\u0002T\u0003\u000bB\u0011bVA \u0003\u0003\u0005\r!!\t\t\u0011\u0005%\u0003\u0001)Q\u0005\u0003C\t\u0011#^5ISN$xN]=BI\u0012\u0014Xm]:!\u0011%\ti\u0005\u0001b\u0001\n\u0013\ty%\u0001\bnCb\f\u0005\u000f]!ui\u0016l\u0007\u000f^:\u0016\u0005\u0005E\u0003cA\b\u0002T%\u0019\u0011Q\u000b\t\u0003\u0007%sG\u000f\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA)\u0003=i\u0017\r_!qa\u0006#H/Z7qiN\u0004\u0003\"CA/\u0001\u0001\u0007I\u0011BA\u0004\u00035I7\u000fT1ti\u0006k%+\u001a;ss\"I\u0011\u0011\r\u0001A\u0002\u0013%\u00111M\u0001\u0012SNd\u0015m\u001d;B\u001bJ+GO]=`I\u0015\fHcA*\u0002f!Iq+a\u0018\u0002\u0002\u0003\u0007\u0011\u0011\u0002\u0005\t\u0003S\u0002\u0001\u0015)\u0003\u0002\n\u0005q\u0011n\u001d'bgR\fUJU3uef\u0004\u0003bCA7\u0001\u0001\u0007\t\u0019!C\u0005\u0003_\n\u0001\"Y7DY&,g\u000e^\u000b\u0003\u0003c\u0002b!a\u001d\u0002|\u0005}TBAA;\u0015\ri\u0015q\u000f\u0006\u0004\u0003s\u0002\u0015AB2mS\u0016tG/\u0003\u0003\u0002~\u0005U$AC!N%6\u001bE.[3oiB!\u0011\u0011QAS\u001d\u0011\t\u0019)!)\u000f\t\u0005\u0015\u0015q\u0014\b\u0005\u0003\u000f\u000biJ\u0004\u0003\u0002\n\u0006me\u0002BAF\u00033sA!!$\u0002\u0018:!\u0011qRAK\u001b\t\t\tJC\u0002\u0002\u00142\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011B\u0001\u0013\t\u0013\t\u00191%C\u0002\u0002z\u0001K1!TA<\u0013\u0011\t\u0019+!\u001e\u0002\u0015\u0005k%+T\"mS\u0016tG/\u0003\u0003\u0002(\u0006%&\u0001E\"p]R\f\u0017N\\3s%\u0016\fX/Z:u\u0015\u0011\t\u0019+!\u001e\t\u0017\u00055\u0006\u00011AA\u0002\u0013%\u0011qV\u0001\rC6\u001cE.[3oi~#S-\u001d\u000b\u0004'\u0006E\u0006\"C,\u0002,\u0006\u0005\t\u0019AA9\u0011!\t)\f\u0001Q!\n\u0005E\u0014!C1n\u00072LWM\u001c;!\u0011%\tI\f\u0001b\u0001\n\u0013\ty%\u0001\fnCbtU/\\#yK\u000e,Ho\u001c:GC&dWO]3t\u0011!\ti\f\u0001Q\u0001\n\u0005E\u0013aF7bq:+X.\u0012=fGV$xN\u001d$bS2,(/Z:!\u0011%\t\t\r\u0001a\u0001\n\u0013\t9!\u0001\u0006sK\u001eL7\u000f^3sK\u0012D\u0011\"!2\u0001\u0001\u0004%I!a2\u0002\u001dI,w-[:uKJ,Gm\u0018\u0013fcR\u00191+!3\t\u0013]\u000b\u0019-!AA\u0002\u0005%\u0001\u0002CAg\u0001\u0001\u0006K!!\u0003\u0002\u0017I,w-[:uKJ,G\r\t\u0005\b\u0003#\u0004A\u0011AAj\u0003\r\u0011XO\u001c\u000b\u0002'\"9\u0011q\u001b\u0001\u0005\n\u0005M\u0017!D1eI\u0006k\u0017\n\u001d$jYR,'\u000fC\u0004\u0002\\\u0002!I!!8\u00023I,w-[:uKJ\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8NCN$XM\u001d\u000b\u0003\u0003?\u0004B!!9\u0002h6\u0011\u00111\u001d\u0006\u0004\u0003Kd\u0015a\u00049s_R|7m\u001c7sK\u000e|'\u000fZ:\n\t\u0005%\u00181\u001d\u0002\"%\u0016<\u0017n\u001d;fe\u0006\u0003\b\u000f\\5dCRLwN\\'bgR,'OU3ta>t7/\u001a\u0005\b\u0003[\u0004A\u0011BAx\u00039\u0019H/\u0019:u+N,'o\u00117bgN$\u0012!\u0018\u0005\b\u0003g\u0004A\u0011BAj\u0003y9\u0018-\u001b;G_J\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0013:LG/[1mSj,G\rC\u0004\u0002x\u0002!I!a5\u0002#\u0005dGn\\2bi\u0016,\u00050Z2vi>\u00148\u000fC\u0004\u0002|\u0002!I!a5\u0002/\u0005dGn\\2bi\u0016l\u0015n]:j]\u001e,\u00050Z2vi>\u0014\bbBA\u0000\u0001\u0011%\u00111[\u0001\u0018G\",7m\u001b(v[\u0016CXmY;u_J\u001ch)Y5mK\u0012DqAa\u0001\u0001\t\u0013\ty/\u0001\u000bmCVt7\r\u001b*fa>\u0014H/\u001a:UQJ,\u0017\r\u001a\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0003]1\u0017N\\5tQ\u0006\u0003\b\u000f\\5dCRLwN\\'bgR,'\u000fF\u0003T\u0005\u0017\u0011)\u0002\u0003\u0005\u0003\u000e\t\u0015\u0001\u0019\u0001B\b\u0003\u0019\u0019H/\u0019;vgB\u0019\u0011J!\u0005\n\u0007\tM!J\u0001\fGS:\fG.\u00119qY&\u001c\u0017\r^5p]N#\u0018\r^;t\u0011)\u00119B!\u0002\u0011\u0002\u0003\u0007\u0011\u0011E\u0001\fI&\fwM\\8ti&\u001c7\u000fC\u0004\u0003\u001c\u0001!I!a5\u0002#\rdW-\u00198vaN#\u0018mZ5oO\u0012K'O\u0002\u0004\u0003 \u0001\u0001!\u0011\u0005\u0002\u0016\u0003B\u0004X*Y:uKJ\u001c\u0006.\u001e;e_^t\u0007j\\8l'\u0019\u0011iBa\t\u0003*A\u0019aL!\n\n\u0007\t\u001drL\u0001\u0004PE*,7\r\u001e\t\u0004=\n-\u0012b\u0001B\u0017?\nA!+\u001e8oC\ndW\r\u0003\u0006\u00032\tu!\u0011!Q\u0001\n=\n\u0011\"\u00199q\u001b\u0006\u001cH/\u001a:\t\u000f5\u0012i\u0002\"\u0001\u00036Q!!q\u0007B\u001e!\u0011\u0011ID!\b\u000e\u0003\u0001AqA!\r\u00034\u0001\u0007q\u0006\u0003\u0005\u0002R\nuA\u0011AAj\u0011%\u0011\t\u0005AI\u0001\n\u0003\u0011\u0019%A\u0011gS:L7\u000f[!qa2L7-\u0019;j_:l\u0015m\u001d;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003F)\"\u0011\u0011\u0005B$W\t\u0011I\u0005\u0005\u0003\u0003L\tUSB\u0001B'\u0015\u0011\u0011yE!\u0015\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B*!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t]#Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,wa\u0002B.\u0005!\u0005!QL\u0001\u0012\u0003B\u0004H.[2bi&|g.T1ti\u0016\u0014\bcA\u000e\u0003`\u00191\u0011A\u0001E\u0001\u0005C\u001aBAa\u0018\u000f)!9QFa\u0018\u0005\u0002\t\u0015DC\u0001B/\u0011)\u0011IGa\u0018C\u0002\u0013%\u0011qJ\u0001\u001c\u00032cujQ!U\u000b~CU)\u0011*U\u0005\u0016\u000bEkX%O)\u0016\u0013f+\u0011'\t\u0013\t5$q\fQ\u0001\n\u0005E\u0013\u0001H!M\u0019>\u001b\u0015\tV#`\u0011\u0016\u000b%\u000b\u0016\"F\u0003R{\u0016J\u0014+F%Z\u000bE\n\t\u0005\u000b\u0005c\u0012yF1A\u0005\n\tM\u0014AE1qa2L7-\u0019;j_:l\u0015m\u001d;feN,\"A!\u001e\u0011\u000b\t]$\u0011Q\u0018\u000e\u0005\te$\u0002\u0002B>\u0005{\n!bY8oGV\u0014(/\u001a8u\u0015\r\u0011y(Y\u0001\u0005kRLG.\u0003\u0003\u0003\u0004\ne$\u0001F\"paf|en\u0016:ji\u0016\f%O]1z\u0019&\u001cH\u000fC\u0005\u0003\b\n}\u0003\u0015!\u0003\u0003v\u0005\u0019\u0012\r\u001d9mS\u000e\fG/[8o\u001b\u0006\u001cH/\u001a:tA!Q!1\u0012B0\u0005\u0004%\tA!$\u0002\u001fM\u0004\u0018M]6D_:$X\r\u001f;SK\u001a,\"Aa$\u0011\r\tE%q\u0013BN\u001b\t\u0011\u0019J\u0003\u0003\u0003\u0016\ne\u0014AB1u_6L7-\u0003\u0003\u0003\u001a\nM%aD!u_6L7MU3gKJ,gnY3\u0011\u0007U\u0011i*C\u0002\u0003 \u001a\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0011Ba)\u0003`\u0001\u0006IAa$\u0002!M\u0004\u0018M]6D_:$X\r\u001f;SK\u001a\u0004\u0003\u0002\u0003BT\u0005?\"\tA!+\u0002\u0011I,w-[:uKJ$2a\u0015BV\u0011\u001d\u0011iK!*A\u0002=\na!\\1ti\u0016\u0014\b\u0002\u0003BY\u0005?\"\tAa-\u0002/M\u0004\u0018M]6D_:$X\r\u001f;J]&$\u0018.\u00197ju\u0016$G\u0003BA\u0005\u0005kC\u0001Ba.\u00030\u0002\u0007!1T\u0001\u0003g\u000eD\u0001Ba/\u0003`\u0011\u0005!QX\u0001\u0018O\u0016$\u0018\t\u001d9mS\u000e\fG/[8o\u0003R$X-\u001c9u\u0013\u0012$\u0012\u0001\u0013\u0005\t\u0005\u0003\u0014y\u0006\"\u0001\u0003D\u0006!Q.Y5o)\r\u0019&Q\u0019\u0005\t\u0005\u000f\u0014y\f1\u0001\u0003J\u0006Q\u0011M]4TiJLgnZ:\u0011\u000b=\u0011Y-!\t\n\u0007\t5\u0007CA\u0003BeJ\f\u0017\u0010")
public class ApplicationMaster
implements Logging {
    public final ApplicationMasterArguments org$apache$spark$deploy$yarn$ApplicationMaster$$args;
    private final SparkConf sparkConf;
    private final YarnConfiguration yarnConf;
    private ApplicationAttemptId org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId;
    private Thread org$apache$spark$deploy$yarn$ApplicationMaster$$userThread;
    private final FileSystem fs;
    private YarnAllocationHandler org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator;
    private boolean org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished;
    private String uiAddress;
    private String uiHistoryAddress;
    private final int maxAppAttempts;
    private boolean org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry;
    private AMRMClient<AMRMClient.ContainerRequest> amClient;
    private final int maxNumExecutorFailures;
    private boolean registered;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        ApplicationMaster$.MODULE$.main(stringArray);
    }

    public static ApplicationAttemptId getApplicationAttemptId() {
        return ApplicationMaster$.MODULE$.getApplicationAttemptId();
    }

    public static boolean sparkContextInitialized(SparkContext sparkContext) {
        return ApplicationMaster$.MODULE$.sparkContextInitialized(sparkContext);
    }

    public static void register(ApplicationMaster applicationMaster) {
        ApplicationMaster$.MODULE$.register(applicationMaster);
    }

    public static AtomicReference<SparkContext> sparkContextRef() {
        return ApplicationMaster$.MODULE$.sparkContextRef();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    public ApplicationAttemptId org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId_$eq(ApplicationAttemptId x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId = x$1;
    }

    public Thread org$apache$spark$deploy$yarn$ApplicationMaster$$userThread() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$userThread_$eq(Thread x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread = x$1;
    }

    private FileSystem fs() {
        return this.fs;
    }

    public YarnAllocationHandler org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator_$eq(YarnAllocationHandler x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator = x$1;
    }

    public boolean org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished;
    }

    private void org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished_$eq(boolean x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished = x$1;
    }

    private String uiAddress() {
        return this.uiAddress;
    }

    private void uiAddress_$eq(String x$1) {
        this.uiAddress = x$1;
    }

    private String uiHistoryAddress() {
        return this.uiHistoryAddress;
    }

    private void uiHistoryAddress_$eq(String x$1) {
        this.uiHistoryAddress = x$1;
    }

    private int maxAppAttempts() {
        return this.maxAppAttempts;
    }

    public boolean org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry() {
        return this.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry;
    }

    public void org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry_$eq(boolean x$1) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry = x$1;
    }

    private AMRMClient<AMRMClient.ContainerRequest> amClient() {
        return this.amClient;
    }

    private void amClient_$eq(AMRMClient<AMRMClient.ContainerRequest> x$1) {
        this.amClient = x$1;
    }

    private int maxNumExecutorFailures() {
        return this.maxNumExecutorFailures;
    }

    private boolean registered() {
        return this.registered;
    }

    private void registered_$eq(boolean x$1) {
        this.registered = x$1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        System.setProperty("spark.ui.port", "0");
        System.setProperty("spark.master", "yarn-cluster");
        ShutdownHookManager.get().addShutdownHook((Runnable)new AppMasterShutdownHook(this, this), 30);
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId_$eq(ApplicationMaster$.MODULE$.getApplicationAttemptId());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApplicationMaster $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"ApplicationAttemptId: ").append((Object)this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry_$eq(this.org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId().getAttemptId() >= this.maxAppAttempts());
        this.amClient_$eq((AMRMClient<AMRMClient.ContainerRequest>)AMRMClient.createAMRMClient());
        this.amClient().init((Configuration)this.yarnConf());
        this.amClient().start();
        this.addAmIpFilter();
        ApplicationMaster$.MODULE$.register(this);
        SecurityManager securityMgr = new SecurityManager(this.sparkConf);
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread_$eq(this.startUserClass());
        this.waitForSparkContextInitialized();
        ApplicationMaster applicationMaster = this;
        synchronized (applicationMaster) {
            BoxedUnit boxedUnit;
            if (this.org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.registerApplicationMaster();
                this.registered_$eq(true);
                boxedUnit = BoxedUnit.UNIT;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl27 : MonitorExitStatement: MONITOREXIT : applicationMaster
            this.allocateExecutors();
            this.launchReporterThread();
        }
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread().join();
        System.exit(0);
    }

    private void addAmIpFilter() {
        String amFilter = "org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter";
        System.setProperty("spark.ui.filters", amFilter);
        String proxyBase = System.getenv("APPLICATION_WEB_PROXY_BASE");
        scala.collection.immutable.Map<String, String> params = YarnStableUtils$.MODULE$.getAmIpFilterParams(this.yarnConf(), proxyBase);
        params.foreach((Function1)new Serializable(this, amFilter){
            public static final long serialVersionUID = 0L;
            private final String amFilter$1;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = System.setProperty(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".param.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.amFilter$1, k})), v);
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.amFilter$1 = amFilter$1;
            }
        });
    }

    private RegisterApplicationMasterResponse registerApplicationMaster() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Registering the ApplicationMaster";
            }
        });
        return this.amClient().registerApplicationMaster(Utils$.MODULE$.localHostName(), 0, this.uiAddress());
    }

    /*
     * WARNING - void declaration
     */
    private Thread startUserClass() {
        void var2_2;
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting the user JAR in a separate Thread";
            }
        });
        System.setProperty("spark.executor.instances", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numExecutors())).toString());
        Method mainMethod = Class.forName(this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.userClass(), false, Thread.currentThread().getContextClassLoader()).getMethod("main", String[].class);
        Thread t = new Thread(this, mainMethod){
            private final /* synthetic */ ApplicationMaster $outer;
            private final Method mainMethod$1;

            public void run() {
                boolean succeeded = false;
                try {
                    String[] mainArgs = new String[this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$args.userArgs().size()];
                    this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$args.userArgs().copyToArray((Object)mainArgs, 0, this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$args.userArgs().size());
                    this.mainMethod$1.invoke(null, new Object[]{mainArgs});
                    succeeded = true;
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Finishing main";
                        }
                    });
                    this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry_$eq(true);
                    if (succeeded) {
                        this.$outer.finishApplicationMaster(FinalApplicationStatus.SUCCEEDED, this.$outer.finishApplicationMaster$default$2());
                    } else {
                        this.$outer.finishApplicationMaster(FinalApplicationStatus.FAILED, this.$outer.finishApplicationMaster$default$2());
                    }
                    return;
                }
                catch (Throwable throwable) {
                    this.$outer.logDebug((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                    this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry_$eq(true);
                    if (succeeded) {
                        this.$outer.finishApplicationMaster(FinalApplicationStatus.SUCCEEDED, this.$outer.finishApplicationMaster$default$2());
                    } else {
                        this.$outer.finishApplicationMaster(FinalApplicationStatus.FAILED, this.$outer.finishApplicationMaster$default$2());
                    }
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.mainMethod$1 = mainMethod$1;
            }
        };
        t.setName("Driver");
        t.start();
        return var2_2;
    }

    private void waitForSparkContextInitialized() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Waiting for Spark context initialization";
            }
        });
        SparkContext sparkContext = null;
        AtomicReference<SparkContext> atomicReference = ApplicationMaster$.MODULE$.sparkContextRef();
        synchronized (atomicReference) {
            BoxedUnit boxedUnit;
            IntRef numTries = new IntRef(0);
            long waitTime = 10000L;
            int maxNumTries = this.sparkConf.getInt("spark.yarn.applicationMaster.waitTries", 10);
            while (ApplicationMaster$.MODULE$.sparkContextRef().get() == null && numTries.elem < maxNumTries && !this.org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished()) {
                this.logInfo((Function0<String>)new Serializable(this, numTries){
                    public static final long serialVersionUID = 0L;
                    private final IntRef numTries$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Waiting for Spark context initialization ... ").append((Object)BoxesRunTime.boxToInteger((int)this.numTries$1.elem)).toString();
                    }
                    {
                        this.numTries$1 = numTries$1;
                    }
                });
                ++numTries.elem;
                ApplicationMaster$.MODULE$.sparkContextRef().wait(waitTime);
            }
            sparkContext = ApplicationMaster$.MODULE$.sparkContextRef().get();
            Predef$.MODULE$.assert(sparkContext != null || numTries.elem >= maxNumTries);
            if (sparkContext == null) {
                this.logWarning((Function0<String>)new Serializable(this, numTries, waitTime, maxNumTries){
                    public static final long serialVersionUID = 0L;
                    private final IntRef numTries$1;
                    private final long waitTime$1;
                    private final int maxNumTries$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Unable to retrieve SparkContext in spite of waiting for %d, maxNumTries = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((long)this.numTries$1.elem * this.waitTime$1)), BoxesRunTime.boxToInteger((int)this.maxNumTries$1)}));
                    }
                    {
                        this.numTries$1 = numTries$1;
                        this.waitTime$1 = waitTime$1;
                        this.maxNumTries$1 = maxNumTries$1;
                    }
                });
                this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator_$eq(YarnAllocationHandler$.MODULE$.newAllocator((Configuration)this.yarnConf(), this.amClient(), this.org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId(), this.org$apache$spark$deploy$yarn$ApplicationMaster$$args, sparkContext.getConf()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.uiAddress_$eq((String)sparkContext.ui().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(SparkUI x$1) {
                        return x$1.appUIHostPort();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                this.uiHistoryAddress_$eq(YarnSparkHadoopUtil$.MODULE$.getUIHistoryAddress(sparkContext, this.sparkConf));
                this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator_$eq(YarnAllocationHandler$.MODULE$.newAllocator((Configuration)this.yarnConf(), this.amClient(), this.org$apache$spark$deploy$yarn$ApplicationMaster$$appAttemptId(), this.org$apache$spark$deploy$yarn$ApplicationMaster$$args, (Map<String, Set<SplitInfo>>)sparkContext.preferredNodeLocationData(), sparkContext.getConf()));
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private void allocateExecutors() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApplicationMaster $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Requesting").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numExecutors())).append((Object)" executors.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().addResourceRequests(this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numExecutors());
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().allocateResources();
        while (this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().getNumExecutorsRunning() < this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numExecutors() && this.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread().isAlive() && !this.org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished()) {
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$checkNumExecutorsFailed();
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$allocateMissingExecutor();
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().allocateResources();
            Thread.sleep(ApplicationMaster$.MODULE$.org$apache$spark$deploy$yarn$ApplicationMaster$$ALLOCATE_HEARTBEAT_INTERVAL());
        }
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "All executors have launched.";
            }
        });
    }

    public void org$apache$spark$deploy$yarn$ApplicationMaster$$allocateMissingExecutor() {
        int missingExecutorCount = this.org$apache$spark$deploy$yarn$ApplicationMaster$$args.numExecutors() - this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().getNumExecutorsRunning() - this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().getNumPendingAllocate();
        if (missingExecutorCount > 0) {
            this.logInfo((Function0<String>)new Serializable(this, missingExecutorCount){
                public static final long serialVersionUID = 0L;
                private final int missingExecutorCount$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Allocating %d containers to make up for (potentially) lost containers")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.missingExecutorCount$1)}));
                }
                {
                    this.missingExecutorCount$1 = missingExecutorCount$1;
                }
            });
            this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().addResourceRequests(missingExecutorCount);
        }
    }

    public void org$apache$spark$deploy$yarn$ApplicationMaster$$checkNumExecutorsFailed() {
        if (this.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().getNumExecutorsFailed() >= this.maxNumExecutorFailures()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "max number of executor failures reached";
                }
            });
            this.finishApplicationMaster(FinalApplicationStatus.FAILED, "max number of executor failures reached");
            SparkContext sparkContext = ApplicationMaster$.MODULE$.sparkContextRef().get();
            if (sparkContext == null) {
                this.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "sparkContext is null when should shutdown";
                    }
                });
            } else {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Invoking sc stop from checkNumExecutorsFailed";
                    }
                });
                sparkContext.stop();
            }
        }
    }

    private Thread launchReporterThread() {
        int expiryInterval = this.yarnConf().getInt("yarn.am.liveness-monitor.expiry-interval-ms", 120000);
        long schedulerInterval = this.sparkConf.getLong("spark.yarn.scheduler.heartbeat.interval-ms", 5000L);
        long interval = package$.MODULE$.max(0L, package$.MODULE$.min((long)(expiryInterval / 2), schedulerInterval));
        Thread t = new Thread(this, interval){
            private final /* synthetic */ ApplicationMaster $outer;
            private final long interval$1;

            public void run() {
                while (this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$userThread().isAlive() && !this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished()) {
                    this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$checkNumExecutorsFailed();
                    this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$allocateMissingExecutor();
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Sending progress";
                        }
                    });
                    this.$outer.org$apache$spark$deploy$yarn$ApplicationMaster$$yarnAllocator().allocateResources();
                    Thread.sleep(this.interval$1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.interval$1 = interval$1;
            }
        };
        t.setDaemon(true);
        t.start();
        this.logInfo((Function0<String>)new Serializable(this, interval){
            public static final long serialVersionUID = 0L;
            private final long interval$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Started progress reporter thread - heartbeat interval : ").append((Object)BoxesRunTime.boxToLong((long)this.interval$1)).toString();
            }
            {
                this.interval$1 = interval$1;
            }
        });
        return t;
    }

    public synchronized void finishApplicationMaster(FinalApplicationStatus status, String diagnostics) {
        if (this.org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished()) {
            return;
        }
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished_$eq(true);
        this.logInfo((Function0<String>)new Serializable(this, status){
            public static final long serialVersionUID = 0L;
            private final FinalApplicationStatus status$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Unregistering ApplicationMaster with ").append((Object)this.status$1).toString();
            }
            {
                this.status$1 = status$1;
            }
        });
        if (this.registered()) {
            this.amClient().unregisterApplicationMaster(status, diagnostics, this.uiHistoryAddress());
        }
    }

    public String finishApplicationMaster$default$2() {
        return "";
    }

    public void org$apache$spark$deploy$yarn$ApplicationMaster$$cleanupStagingDir() {
        ObjectRef stagingDirPath = new ObjectRef(null);
        try {
            boolean preserveFiles = new StringOps(Predef$.MODULE$.augmentString(this.sparkConf.get("spark.yarn.preserve.staging.files", "false"))).toBoolean();
            if (!preserveFiles) {
                stagingDirPath.elem = new Path(System.getenv("SPARK_YARN_STAGING_DIR"));
                if ((Path)stagingDirPath.elem == null) {
                    this.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Staging directory is null";
                        }
                    });
                    return;
                }
                this.logInfo((Function0<String>)new Serializable(this, stagingDirPath){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef stagingDirPath$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Deleting staging directory ").append((Object)((Path)this.stagingDirPath$1.elem)).toString();
                    }
                    {
                        this.stagingDirPath$1 = stagingDirPath$1;
                    }
                });
                this.fs().delete((Path)stagingDirPath.elem, true);
            }
        }
        catch (IOException iOException) {
            this.logError((Function0<String>)new Serializable(this, stagingDirPath){
                public static final long serialVersionUID = 0L;
                private final ObjectRef stagingDirPath$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to cleanup staging dir ").append((Object)((Path)this.stagingDirPath$1.elem)).toString();
                }
                {
                    this.stagingDirPath$1 = stagingDirPath$1;
                }
            }, iOException);
        }
    }

    public ApplicationMaster(ApplicationMasterArguments args, Configuration conf, SparkConf sparkConf) {
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$args = args;
        this.sparkConf = sparkConf;
        Logging.class.$init$((Logging)this);
        this.yarnConf = new YarnConfiguration(conf);
        this.fs = FileSystem.get((Configuration)this.yarnConf());
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$isFinished = false;
        this.maxAppAttempts = conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        this.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry = true;
        this.maxNumExecutorFailures = sparkConf.getInt("spark.yarn.max.executor.failures", sparkConf.getInt("spark.yarn.max.worker.failures", package$.MODULE$.max(args.numExecutors() * 2, 3)));
        this.registered = false;
    }

    public ApplicationMaster(ApplicationMasterArguments args, SparkConf sparkConf) {
        this(args, new Configuration(), sparkConf);
    }

    public ApplicationMaster(ApplicationMasterArguments args) {
        this(args, new SparkConf());
    }

    public class AppMasterShutdownHook
    implements Runnable {
        private final ApplicationMaster appMaster;
        public final /* synthetic */ ApplicationMaster $outer;

        @Override
        public void run() {
            this.org$apache$spark$deploy$yarn$ApplicationMaster$AppMasterShutdownHook$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "AppMaster received a signal.";
                }
            });
            if (this.appMaster.org$apache$spark$deploy$yarn$ApplicationMaster$$isLastAMRetry()) {
                this.appMaster.org$apache$spark$deploy$yarn$ApplicationMaster$$cleanupStagingDir();
            }
        }

        public /* synthetic */ ApplicationMaster org$apache$spark$deploy$yarn$ApplicationMaster$AppMasterShutdownHook$$$outer() {
            return this.$outer;
        }

        public AppMasterShutdownHook(ApplicationMaster $outer, ApplicationMaster appMaster) {
            this.appMaster = appMaster;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

