/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.log4j.Level;
import org.apache.spark.Logging;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.yarn.ApplicationMasterArguments;
import org.apache.spark.deploy.yarn.ExecutorRunnable;
import org.apache.spark.deploy.yarn.YarnAllocator$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.AkkaUtils$;
import org.slf4j.Logger;
import org.spark-project.guava.util.concurrent.ThreadFactoryBuilder;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015g!B\u0001\u0003\u0001\ta!!D-be:\fE\u000e\\8dCR|'O\u0003\u0002\u0004\t\u0005!\u00110\u0019:o\u0015\t)a!\u0001\u0004eKBdw.\u001f\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!\u0011!Q\u0001\ni\tAaY8oM\u000e\u0001\u0001CA\u000e \u001b\u0005a\"B\u0001\r\u001e\u0015\tq\u0002\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003Aq\u0011QbQ8oM&<WO]1uS>t\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u0013M\u0004\u0018M]6D_:4\u0007C\u0001\u000b%\u0013\t)cAA\u0005Ta\u0006\u00148nQ8oM\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0005b[\u000ec\u0017.\u001a8u!\rIs&M\u0007\u0002U)\u00111\u0006L\u0001\u0004CBL'BA\u0017/\u0003\u0019\u0019G.[3oi*\u00111!H\u0005\u0003a)\u0012!\"Q'S\u001b\u000ec\u0017.\u001a8u!\t\u0011DI\u0004\u00024\u0005:\u0011A'\u0011\b\u0003k\u0001s!AN \u000f\u0005]rdB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tY\u0014$\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003=!I!aA\u000f\n\u00055r\u0013BA\u0016-\u0013\t\u0019%&\u0001\u0006B\u001bJk5\t\\5f]RL!!\u0012$\u0003!\r{g\u000e^1j]\u0016\u0014(+Z9vKN$(BA\"+\u0011!A\u0005A!A!\u0002\u0013I\u0015\u0001D1qa\u0006#H/Z7qi&#\u0007C\u0001&O\u001b\u0005Y%B\u0001'N\u0003\u001d\u0011XmY8sINT!a\u000b\u0018\n\u0005=[%\u0001F!qa2L7-\u0019;j_:\fE\u000f^3naRLE\r\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0003\u0011\t'oZ:\u0011\u0005M#V\"\u0001\u0002\n\u0005U\u0013!AG!qa2L7-\u0019;j_:l\u0015m\u001d;fe\u0006\u0013x-^7f]R\u001c\b\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\u0002\u0017M,7-\u001e:jifluM\u001d\t\u0003)eK!A\u0017\u0004\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJDQ\u0001\u0018\u0001\u0005\u0002u\u000ba\u0001P5oSRtDc\u00020`A\u0006\u00147\r\u001a\t\u0003'\u0002AQ\u0001G.A\u0002iAQAI.A\u0002\rBQaJ.A\u0002!BQ\u0001S.A\u0002%CQ!U.A\u0002ICQaV.A\u0002aCqA\u001a\u0001C\u0002\u0013\u0005q-\u0001\u000fbY2|7-\u0019;fI\"{7\u000f\u001e+p\u0007>tG/Y5oKJ\u001cX*\u00199\u0016\u0003!\u0004B!\u001b8qo6\t!N\u0003\u0002lY\u00069Q.\u001e;bE2,'BA7\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003_*\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002ri:\u0011aB]\u0005\u0003g>\ta\u0001\u0015:fI\u00164\u0017BA;w\u0005\u0019\u0019FO]5oO*\u00111o\u0004\t\u0004SbT\u0018BA=k\u0005\r\u0019V\r\u001e\t\u0003\u0015nL!\u0001`&\u0003\u0017\r{g\u000e^1j]\u0016\u0014\u0018\n\u001a\u0005\u0007}\u0002\u0001\u000b\u0011\u00025\u0002;\u0005dGn\\2bi\u0016$\u0007j\\:u)>\u001cuN\u001c;bS:,'o]'ba\u0002B\u0011\"!\u0001\u0001\u0005\u0004%\t!a\u0001\u00027\u0005dGn\\2bi\u0016$7i\u001c8uC&tWM\u001d+p\u0011>\u001cH/T1q+\t\t)\u0001\u0005\u0003j]j\u0004\b\u0002CA\u0005\u0001\u0001\u0006I!!\u0002\u00029\u0005dGn\\2bi\u0016$7i\u001c8uC&tWM\u001d+p\u0011>\u001cH/T1qA!I\u0011Q\u0002\u0001C\u0002\u0013%\u0011qB\u0001\u0013e\u0016dW-Y:fI\u000e{g\u000e^1j]\u0016\u00148/\u0006\u0002\u0002\u0012A)\u00111CA\u000fu6\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003vi&d'BAA\u000e\u0003\u0011Q\u0017M^1\n\u0007e\f)\u0002\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\t\u0003M\u0011X\r\\3bg\u0016$7i\u001c8uC&tWM]:!\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9#A\tfq\u0016\u001cW\u000f^8s\u0013\u0012\u001cu.\u001e8uKJ,\"!!\u000b\u0011\u00079\tY#C\u0002\u0002.=\u00111!\u00138u\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019$A\u000bfq\u0016\u001cW\u000f^8s\u0013\u0012\u001cu.\u001e8uKJ|F%Z9\u0015\t\u0005U\u00121\b\t\u0004\u001d\u0005]\u0012bAA\u001d\u001f\t!QK\\5u\u0011)\ti$a\f\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0004q\u0012\n\u0004\u0002CA!\u0001\u0001\u0006K!!\u000b\u0002%\u0015DXmY;u_JLEmQ8v]R,'\u000f\t\u0005\n\u0003\u000b\u0002!\u0019!C\u0005\u0003\u000f\nQ#\u001a=fGV$xN]%e)>\u001cuN\u001c;bS:,'/\u0006\u0002\u0002JA)\u0011N\u001c9\u0002LA\u0019!*!\u0014\n\u0007\u0005=3JA\u0005D_:$\u0018-\u001b8fe\"A\u00111\u000b\u0001!\u0002\u0013\tI%\u0001\ffq\u0016\u001cW\u000f^8s\u0013\u0012$vnQ8oi\u0006Lg.\u001a:!\u0011%\t9\u0006\u0001b\u0001\n#\t9#\u0001\bfq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=\t\u0011\u0005m\u0003\u0001)A\u0005\u0003S\tq\"\u001a=fGV$xN]'f[>\u0014\u0018\u0010\t\u0005\n\u0003?\u0002!\u0019!C\t\u0003O\ta\"\\3n_JLxJ^3sQ\u0016\fG\r\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA\u0015\u0003=iW-\\8ss>3XM\u001d5fC\u0012\u0004\u0003\"CA4\u0001\t\u0007I\u0011CA\u0014\u00035)\u00070Z2vi>\u00148i\u001c:fg\"A\u00111\u000e\u0001!\u0002\u0013\tI#\u0001\bfq\u0016\u001cW\u000f^8s\u0007>\u0014Xm\u001d\u0011\t\u0013\u0005=\u0004A1A\u0005\n\u0005E\u0014\u0001\u0003:fg>,(oY3\u0016\u0005\u0005M\u0004c\u0001&\u0002v%\u0019\u0011qO&\u0003\u0011I+7o\\;sG\u0016D\u0001\"a\u001f\u0001A\u0003%\u00111O\u0001\ne\u0016\u001cx.\u001e:dK\u0002B\u0011\"a \u0001\u0005\u0004%I!!!\u0002\u00191\fWO\\2iKJ\u0004vn\u001c7\u0016\u0005\u0005\r\u0005\u0003BAC\u0003\u0017k!!a\"\u000b\t\u0005%\u0015QC\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAG\u0003\u000f\u0013!\u0003\u00165sK\u0006$\u0007k\\8m\u000bb,7-\u001e;pe\"A\u0011\u0011\u0013\u0001!\u0002\u0013\t\u0019)A\u0007mCVt7\r[3s!>|G\u000e\t\u0005\n\u0003+\u0003!\u0019!C\u0005\u0003/\u000b\u0011\u0002\u001a:jm\u0016\u0014XK\u001d7\u0016\u0003ADq!a'\u0001A\u0003%\u0001/\u0001\u0006ee&4XM]+sY\u0002B\u0011\"a(\u0001\u0005\u0004%I!!)\u0002!1\fWO\\2i\u0007>tG/Y5oKJ\u001cXCAAR!\rq\u0011QU\u0005\u0004\u0003O{!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003W\u0003\u0001\u0015!\u0003\u0002$\u0006\tB.Y;oG\"\u001cuN\u001c;bS:,'o\u001d\u0011\t\u000f\u0005=\u0006\u0001\"\u0001\u0002(\u00051r-\u001a;Ok6,\u00050Z2vi>\u00148OU;o]&tw\rC\u0004\u00024\u0002!\t!a\n\u0002+\u001d,GOT;n\u000bb,7-\u001e;peN4\u0015-\u001b7fI\"9\u0011q\u0017\u0001\u0005\u0002\u0005\u001d\u0012!F4fi:+X\u000eU3oI&tw-\u00117m_\u000e\fG/\u001a\u0005\b\u0003w\u0003A\u0011BA_\u0003]9W\r\u001e(v[B+g\u000eZ5oO\u0006#Hj\\2bi&|g\u000e\u0006\u0003\u0002*\u0005}\u0006bBAa\u0003s\u0003\r\u0001]\u0001\tY>\u001c\u0017\r^5p]\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0017!\u0006:fcV,7\u000f\u001e+pi\u0006dW\t_3dkR|'o\u001d\u000b\u0005\u0003k\tI\r\u0003\u0005\u0002L\u0006\r\u0007\u0019AA\u0015\u00039\u0011X-];fgR,G\rV8uC2Dq!a4\u0001\t\u0003\t\t.\u0001\u0007lS2dW\t_3dkR|'\u000f\u0006\u0003\u00026\u0005M\u0007bBAk\u0003\u001b\u0004\r\u0001]\u0001\u000bKb,7-\u001e;pe&#\u0007bBAm\u0001\u0011\u0005\u00111\\\u0001\u0012C2dwnY1uKJ+7o\\;sG\u0016\u001cHCAA\u001b\u0011\u001d\ty\u000e\u0001C\u0001\u00037\fa#\u001e9eCR,'+Z:pkJ\u001cWMU3rk\u0016\u001cHo\u001d\u0005\b\u0003G\u0004A\u0011AAs\u0003eA\u0017M\u001c3mK\u0006cGn\\2bi\u0016$7i\u001c8uC&tWM]:\u0015\t\u0005U\u0012q\u001d\u0005\t\u0003S\f\t\u000f1\u0001\u0002l\u0006\u0019\u0012\r\u001c7pG\u0006$X\rZ\"p]R\f\u0017N\\3sgB1\u0011Q^A|\u0003\u0017rA!a<\u0002t:\u0019\u0011(!=\n\u0003AI1!!>\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LA!!?\u0002|\n\u00191+Z9\u000b\u0007\u0005Ux\u0002C\u0004\u0002\u0000\u0002!IA!\u0001\u0002/5\fGo\u00195D_:$\u0018-\u001b8feR{'+Z9vKN$HCCA\u001b\u0005\u0007\u00119A!\u0003\u0003\u0014!A!QAA\u007f\u0001\u0004\tY%\u0001\nbY2|7-\u0019;fI\u000e{g\u000e^1j]\u0016\u0014\bbBAa\u0003{\u0004\r\u0001\u001d\u0005\t\u0005\u0017\ti\u00101\u0001\u0003\u000e\u0005y1m\u001c8uC&tWM]:U_V\u001bX\rE\u0003j\u0005\u001f\tY%C\u0002\u0003\u0012)\u00141\"\u0011:sCf\u0014UO\u001a4fe\"A!QCA\u007f\u0001\u0004\u0011i!A\u0005sK6\f\u0017N\\5oO\"9!\u0011\u0004\u0001\u0005\n\tm\u0011A\u0006:v]\u0006cGn\\2bi\u0016$7i\u001c8uC&tWM]:\u0015\t\u0005U\"Q\u0004\u0005\t\u0005\u0017\u00119\u00021\u0001\u0003\u000e!9!\u0011\u0005\u0001\u0005\n\t\r\u0012A\u00079s_\u000e,7o]\"p[BdW\r^3e\u0007>tG/Y5oKJ\u001cH\u0003BA\u001b\u0005KA\u0001Ba\n\u0003 \u0001\u0007!\u0011F\u0001\u0014G>l\u0007\u000f\\3uK\u0012\u001cuN\u001c;bS:,'o\u001d\t\u0007\u0003[\f9Pa\u000b\u0011\u0007)\u0013i#C\u0002\u00030-\u0013qbQ8oi\u0006Lg.\u001a:Ti\u0006$Xo\u001d\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u0003aIg\u000e^3s]\u0006d'+\u001a7fCN,7i\u001c8uC&tWM\u001d\u000b\u0005\u0003k\u00119\u0004\u0003\u0005\u0003:\tE\u0002\u0019AA&\u0003%\u0019wN\u001c;bS:,'\u000fC\u0005\u0003>\u0001\u0001\r\u0011\"\u0003\u0002(\u0005\u0019b.^7Fq\u0016\u001cW\u000f^8sgJ+hN\\5oO\"I!\u0011\t\u0001A\u0002\u0013%!1I\u0001\u0018]VlW\t_3dkR|'o\u001d*v]:LgnZ0%KF$B!!\u000e\u0003F!Q\u0011Q\bB \u0003\u0003\u0005\r!!\u000b\t\u0011\t%\u0003\u0001)Q\u0005\u0003S\tAC\\;n\u000bb,7-\u001e;peN\u0014VO\u001c8j]\u001e\u0004\u0003\u0006\u0002B$\u0005\u001b\u00022A\u0004B(\u0013\r\u0011\tf\u0004\u0002\tm>d\u0017\r^5mK\"I!Q\u000b\u0001A\u0002\u0013%\u0011qE\u0001\u0013]VlW\t_3dkR|'o\u001d$bS2,G\rC\u0005\u0003Z\u0001\u0001\r\u0011\"\u0003\u0003\\\u00051b.^7Fq\u0016\u001cW\u000f^8sg\u001a\u000b\u0017\u000e\\3e?\u0012*\u0017\u000f\u0006\u0003\u00026\tu\u0003BCA\u001f\u0005/\n\t\u00111\u0001\u0002*!A!\u0011\r\u0001!B\u0013\tI#A\nok6,\u00050Z2vi>\u00148OR1jY\u0016$\u0007\u0005\u000b\u0003\u0003`\t5\u0003\"\u0003B4\u0001\u0001\u0007I\u0011BA\u0014\u0003I!\u0018M]4fi:+X.\u0012=fGV$xN]:\t\u0013\t-\u0004\u00011A\u0005\n\t5\u0014A\u0006;be\u001e,GOT;n\u000bb,7-\u001e;peN|F%Z9\u0015\t\u0005U\"q\u000e\u0005\u000b\u0003{\u0011I'!AA\u0002\u0005%\u0002\u0002\u0003B:\u0001\u0001\u0006K!!\u000b\u0002'Q\f'oZ3u\u001dVlW\t_3dkR|'o\u001d\u0011)\t\tE$QJ\u0004\b\u0005s\u0012\u0001\u0012\u0002B>\u00035I\u0016M\u001d8BY2|7-\u0019;peB\u00191K! \u0007\r\u0005\u0011\u0001\u0012\u0002B@'\r\u0011i(\u0004\u0005\b9\nuD\u0011\u0001BB)\t\u0011Y\b\u0003\u0006\u0003\b\nu$\u0019!C\u0001\u0005\u0013\u000b\u0011\"T#N?J+u)\u0012-\u0016\u0005\t-\u0005\u0003\u0002BG\u0005'k!Aa$\u000b\t\tE\u0015\u0011D\u0001\u0005Y\u0006tw-C\u0002v\u0005\u001fC\u0011Ba&\u0003~\u0001\u0006IAa#\u0002\u00155+Uj\u0018*F\u000f\u0016C\u0006\u0005\u0003\u0006\u0003\u001c\nu$\u0019!C\u0001\u0005;\u000bQ\u0003U'F\u001b~+\u0005lQ#F\t\u0016#u\fU!U)\u0016\u0013f*\u0006\u0002\u0003 B!!\u0011\u0015BT\u001b\t\u0011\u0019K\u0003\u0003\u0003&\u0006U\u0011!\u0002:fO\u0016D\u0018\u0002\u0002BU\u0005G\u0013q\u0001U1ui\u0016\u0014h\u000eC\u0005\u0003.\nu\u0004\u0015!\u0003\u0003 \u00061\u0002+T#N?\u0016C6)R#E\u000b\u0012{\u0006+\u0011+U\u000bJs\u0005\u0005\u0003\u0006\u00032\nu$\u0019!C\u0001\u0005;\u000bQCV'F\u001b~+\u0005lQ#F\t\u0016#u\fU!U)\u0016\u0013f\nC\u0005\u00036\nu\u0004\u0015!\u0003\u0003 \u00061b+T#N?\u0016C6)R#E\u000b\u0012{\u0006+\u0011+U\u000bJs\u0005\u0005\u0003\u0005\u0003:\nuD\u0011\u0001B^\u0003iiW-\u001c'j[&$X\t_2fK\u0012,G\rT8h\u001b\u0016\u001c8/Y4f)\u0015\u0001(Q\u0018Ba\u0011\u001d\u0011yLa.A\u0002A\f1\u0002Z5bO:|7\u000f^5dg\"A!1\u0019B\\\u0001\u0004\u0011y*A\u0004qCR$XM\u001d8")
public class YarnAllocator
implements Logging {
    public final Configuration org$apache$spark$deploy$yarn$YarnAllocator$$conf;
    public final SparkConf org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf;
    public final AMRMClient<AMRMClient.ContainerRequest> org$apache$spark$deploy$yarn$YarnAllocator$$amClient;
    public final ApplicationAttemptId org$apache$spark$deploy$yarn$YarnAllocator$$appAttemptId;
    public final SecurityManager org$apache$spark$deploy$yarn$YarnAllocator$$securityMgr;
    private final HashMap<String, scala.collection.mutable.Set<ContainerId>> allocatedHostToContainersMap;
    private final HashMap<ContainerId, String> allocatedContainerToHostMap;
    private final Set<ContainerId> org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers;
    private int org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter;
    private final HashMap<String, Container> org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer;
    private final int executorMemory;
    private final int memoryOverhead;
    private final int executorCores;
    private final Resource org$apache$spark$deploy$yarn$YarnAllocator$$resource;
    private final ThreadPoolExecutor org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool;
    private final String org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl;
    private final boolean org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers;
    private volatile int org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning;
    private volatile int org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed;
    private volatile int org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String memLimitExceededLogMessage(String string, Pattern pattern) {
        return YarnAllocator$.MODULE$.memLimitExceededLogMessage(string, pattern);
    }

    public static Pattern VMEM_EXCEEDED_PATTERN() {
        return YarnAllocator$.MODULE$.VMEM_EXCEEDED_PATTERN();
    }

    public static Pattern PMEM_EXCEEDED_PATTERN() {
        return YarnAllocator$.MODULE$.PMEM_EXCEEDED_PATTERN();
    }

    public static String MEM_REGEX() {
        return YarnAllocator$.MODULE$.MEM_REGEX();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public HashMap<String, scala.collection.mutable.Set<ContainerId>> allocatedHostToContainersMap() {
        return this.allocatedHostToContainersMap;
    }

    public HashMap<ContainerId, String> allocatedContainerToHostMap() {
        return this.allocatedContainerToHostMap;
    }

    public Set<ContainerId> org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers;
    }

    public int org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning;
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning = x$1;
    }

    public int org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter;
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter = x$1;
    }

    public int org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed;
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed = x$1;
    }

    public int org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors;
    }

    private void org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors = x$1;
    }

    public HashMap<String, Container> org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer;
    }

    public int executorMemory() {
        return this.executorMemory;
    }

    public int memoryOverhead() {
        return this.memoryOverhead;
    }

    public int executorCores() {
        return this.executorCores;
    }

    public Resource org$apache$spark$deploy$yarn$YarnAllocator$$resource() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$resource;
    }

    public ThreadPoolExecutor org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool;
    }

    public String org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl;
    }

    public boolean org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers;
    }

    public int getNumExecutorsRunning() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning();
    }

    public int getNumExecutorsFailed() {
        return this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed();
    }

    public int getNumPendingAllocate() {
        return this.getNumPendingAtLocation(YarnSparkHadoopUtil$.MODULE$.ANY_HOST());
    }

    private int getNumPendingAtLocation(String location) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.getMatchingRequests(YarnSparkHadoopUtil$.MODULE$.RM_REQUEST_PRIORITY(), location, this.org$apache$spark$deploy$yarn$YarnAllocator$$resource())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Collection x$1) {
                return x$1.size();
            }
        }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public synchronized void requestTotalExecutors(int requestedTotal) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors_$eq(requestedTotal);
    }

    public synchronized void killExecutor(String executorId) {
        if (this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer().contains((Object)executorId)) {
            Container container = (Container)this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer().remove((Object)executorId).get();
            this.org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(container);
            this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning_$eq(this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() - 1);
            this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors_$eq(this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors() - 1);
            Predef$.MODULE$.assert(this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors() >= 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Allocator killed more executors than are allocated!";
                }
            });
        } else {
            this.logWarning((Function0<String>)new Serializable(this, executorId){
                public static final long serialVersionUID = 0L;
                private final String executorId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to kill unknown executor ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$1}));
                }
                {
                    this.executorId$1 = executorId$1;
                }
            });
        }
    }

    public synchronized void allocateResources() {
        List completedContainers;
        this.updateResourceRequests();
        float progressIndicator = 0.1f;
        AllocateResponse allocateResponse = this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.allocate(progressIndicator);
        List allocatedContainers = allocateResponse.getAllocatedContainers();
        if (allocatedContainers.size() > 0) {
            this.logDebug((Function0<String>)new Serializable(this, allocateResponse, allocatedContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final AllocateResponse allocateResponse$1;
                private final List allocatedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Allocated containers: %d. Current executor count: %d. Cluster resources: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.allocatedContainers$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning()), this.allocateResponse$1.getAvailableResources()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.allocateResponse$1 = allocateResponse$1;
                    this.allocatedContainers$1 = allocatedContainers$1;
                }
            });
            this.handleAllocatedContainers((Seq<Container>)JavaConversions$.MODULE$.asScalaBuffer(allocatedContainers));
        }
        if ((completedContainers = allocateResponse.getCompletedContainersStatuses()).size() > 0) {
            this.logDebug((Function0<String>)new Serializable(this, completedContainers){
                public static final long serialVersionUID = 0L;
                private final List completedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Completed %d containers")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.completedContainers$1.size())}));
                }
                {
                    this.completedContainers$1 = completedContainers$1;
                }
            });
            this.processCompletedContainers((Seq<ContainerStatus>)JavaConversions$.MODULE$.asScalaBuffer(completedContainers));
            this.logDebug((Function0<String>)new Serializable(this, completedContainers){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final List completedContainers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Finished processing %d completed containers. Current running executor count: %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.completedContainers$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.completedContainers$1 = completedContainers$1;
                }
            });
        }
    }

    public void updateResourceRequests() {
        int numPendingAllocate = this.getNumPendingAllocate();
        int missing = this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors() - numPendingAllocate - this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning();
        if (missing > 0) {
            this.logInfo((Function0<String>)new Serializable(this, missing){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;
                private final int missing$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will request ", " executor containers, each with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.missing$1), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$resource().getVirtualCores())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cores and ", " MB memory including ", " MB overhead"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$resource().getMemory()), BoxesRunTime.boxToInteger((int)this.$outer.memoryOverhead())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.missing$1 = missing$1;
                }
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), missing).foreach$mVc$sp((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$resource(), null, null, YarnSparkHadoopUtil$.MODULE$.RM_REQUEST_PRIORITY());
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.addContainerRequest(request);
                    List nodes = request.getNodes();
                    String hostStr = nodes == null || nodes.isEmpty() ? "Any" : (String)JavaConversions$.MODULE$.asScalaBuffer(nodes).last();
                    this.$outer.logInfo((Function0<String>)new Serializable(this, hostStr){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$updateResourceRequests$1 $outer;
                        private final String hostStr$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Container request (host: ", ", capability: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostStr$1, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer().org$apache$spark$deploy$yarn$YarnAllocator$$resource()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.hostStr$1 = hostStr$1;
                        }
                    });
                }

                public /* synthetic */ YarnAllocator org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else if (missing < 0) {
            int numToCancel = package$.MODULE$.min(numPendingAllocate, -missing);
            this.logInfo((Function0<String>)new Serializable(this, numToCancel){
                public static final long serialVersionUID = 0L;
                private final int numToCancel$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Canceling requests for ", " executor containers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numToCancel$1)}));
                }
                {
                    this.numToCancel$1 = numToCancel$1;
                }
            });
            List matchingRequests = this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.getMatchingRequests(YarnSparkHadoopUtil$.MODULE$.RM_REQUEST_PRIORITY(), YarnSparkHadoopUtil$.MODULE$.ANY_HOST(), this.org$apache$spark$deploy$yarn$YarnAllocator$$resource());
            if (matchingRequests.isEmpty()) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Expected to find pending requests, but found none.";
                    }
                });
            } else {
                ((IterableLike)JavaConversions$.MODULE$.collectionAsScalaIterable((Collection)JavaConversions$.MODULE$.asScalaBuffer(matchingRequests).head()).take(numToCancel)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ YarnAllocator $outer;

                    public final void apply(AMRMClient.ContainerRequest x$1) {
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.removeContainerRequest(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
    }

    public void handleAllocatedContainers(Seq<Container> allocatedContainers) {
        ArrayBuffer containersToUse = new ArrayBuffer(allocatedContainers.size());
        ArrayBuffer remainingAfterHostMatches = new ArrayBuffer();
        allocatedContainers.foreach((Function1)new Serializable(this, containersToUse, remainingAfterHostMatches){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;
            private final ArrayBuffer containersToUse$1;
            private final ArrayBuffer remainingAfterHostMatches$1;

            public final void apply(Container allocatedContainer) {
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$matchContainerToRequest(allocatedContainer, allocatedContainer.getNodeId().getHost(), (ArrayBuffer<Container>)this.containersToUse$1, (ArrayBuffer<Container>)this.remainingAfterHostMatches$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.containersToUse$1 = containersToUse$1;
                this.remainingAfterHostMatches$1 = remainingAfterHostMatches$1;
            }
        });
        ArrayBuffer remainingAfterRackMatches = new ArrayBuffer();
        remainingAfterHostMatches.foreach((Function1)new Serializable(this, containersToUse, remainingAfterRackMatches){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;
            private final ArrayBuffer containersToUse$1;
            private final ArrayBuffer remainingAfterRackMatches$1;

            public final void apply(Container allocatedContainer) {
                String rack = RackResolver.resolve((Configuration)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$conf, (String)allocatedContainer.getNodeId().getHost()).getNetworkLocation();
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$matchContainerToRequest(allocatedContainer, rack, (ArrayBuffer<Container>)this.containersToUse$1, (ArrayBuffer<Container>)this.remainingAfterRackMatches$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.containersToUse$1 = containersToUse$1;
                this.remainingAfterRackMatches$1 = remainingAfterRackMatches$1;
            }
        });
        ArrayBuffer remainingAfterOffRackMatches = new ArrayBuffer();
        remainingAfterRackMatches.foreach((Function1)new Serializable(this, containersToUse, remainingAfterOffRackMatches){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;
            private final ArrayBuffer containersToUse$1;
            private final ArrayBuffer remainingAfterOffRackMatches$1;

            public final void apply(Container allocatedContainer) {
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$matchContainerToRequest(allocatedContainer, YarnSparkHadoopUtil$.MODULE$.ANY_HOST(), (ArrayBuffer<Container>)this.containersToUse$1, (ArrayBuffer<Container>)this.remainingAfterOffRackMatches$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.containersToUse$1 = containersToUse$1;
                this.remainingAfterOffRackMatches$1 = remainingAfterOffRackMatches$1;
            }
        });
        if (!remainingAfterOffRackMatches.isEmpty()) {
            this.logDebug((Function0<String>)new Serializable(this, remainingAfterOffRackMatches){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer remainingAfterOffRackMatches$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Releasing ", " unneeded containers that were "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.remainingAfterOffRackMatches$1.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"allocated to us"})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    this.remainingAfterOffRackMatches$1 = remainingAfterOffRackMatches$1;
                }
            });
            remainingAfterOffRackMatches.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnAllocator $outer;

                public final void apply(Container container) {
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(container);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.runAllocatedContainers((ArrayBuffer<Container>)containersToUse);
        this.logInfo((Function0<String>)new Serializable(this, allocatedContainers, containersToUse){
            public static final long serialVersionUID = 0L;
            private final Seq allocatedContainers$2;
            private final ArrayBuffer containersToUse$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Received %d containers from YARN, launching executors on %d of them.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.allocatedContainers$2.size()), BoxesRunTime.boxToInteger((int)this.containersToUse$1.size())}));
            }
            {
                this.allocatedContainers$2 = allocatedContainers$2;
                this.containersToUse$1 = containersToUse$1;
            }
        });
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$matchContainerToRequest(Container allocatedContainer, String location, ArrayBuffer<Container> containersToUse, ArrayBuffer<Container> remaining) {
        Resource matchingResource = Resource.newInstance((int)allocatedContainer.getResource().getMemory(), (int)this.org$apache$spark$deploy$yarn$YarnAllocator$$resource().getVirtualCores());
        List matchingRequests = this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.getMatchingRequests(allocatedContainer.getPriority(), location, matchingResource);
        if (matchingRequests.isEmpty()) {
            remaining.$plus$eq((Object)allocatedContainer);
        } else {
            AMRMClient.ContainerRequest containerRequest = (AMRMClient.ContainerRequest)((Collection)matchingRequests.get(0)).iterator().next();
            this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.removeContainerRequest(containerRequest);
            containersToUse.$plus$eq((Object)allocatedContainer);
        }
    }

    private void runAllocatedContainers(ArrayBuffer<Container> containersToUse) {
        containersToUse.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;

            public final void apply(Container container) {
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning_$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() + 1);
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() <= this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors());
                String executorHostname = container.getNodeId().getHost();
                ContainerId containerId = container.getId();
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter_$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter() + 1);
                String executorId = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter())).toString();
                Predef$.MODULE$.assert(container.getResource().getMemory() >= this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$resource().getMemory());
                this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname, containerId){
                    public static final long serialVersionUID = 0L;
                    private final String executorHostname$1;
                    private final ContainerId containerId$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Launching container %s for on host %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$1, this.executorHostname$1}));
                    }
                    {
                        this.executorHostname$1 = executorHostname$1;
                        this.containerId$1 = containerId$1;
                    }
                });
                this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer().update((Object)executorId, (Object)container);
                scala.collection.mutable.Set containerSet = (scala.collection.mutable.Set)this.$outer.allocatedHostToContainersMap().getOrElseUpdate((Object)executorHostname, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final HashSet<ContainerId> apply() {
                        return new HashSet();
                    }
                });
                containerSet.$plus$eq((Object)containerId);
                this.$outer.allocatedContainerToHostMap().put((Object)containerId, (Object)executorHostname);
                ExecutorRunnable executorRunnable = new ExecutorRunnable(container, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$conf, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf, this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl(), executorId, executorHostname, this.$outer.executorMemory(), this.$outer.executorCores(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$appAttemptId.getApplicationId().toString(), this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$securityMgr);
                if (this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers()) {
                    this.$outer.logInfo((Function0<String>)new Serializable(this, executorHostname){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$runAllocatedContainers$1 $outer;
                        private final String executorHostname$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Launching ExecutorRunnable. driverUrl: %s,  executorHostname: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer().org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl(), this.executorHostname$1}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executorHostname$1 = executorHostname$1;
                        }
                    });
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool().execute(executorRunnable);
                }
            }

            public /* synthetic */ YarnAllocator org$apache$spark$deploy$yarn$YarnAllocator$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void processCompletedContainers(Seq<ContainerStatus> completedContainers) {
        completedContainers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnAllocator $outer;

            public final Object apply(ContainerStatus completedContainer) {
                BoxedUnit boxedUnit;
                Boolean bl;
                ContainerId containerId = completedContainer.getContainerId();
                if (this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers().contains(containerId)) {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers().remove(containerId));
                } else {
                    this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning_$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning() - 1);
                    this.$outer.logInfo((Function0<String>)new Serializable(this, completedContainer, containerId){
                        public static final long serialVersionUID = 0L;
                        private final ContainerStatus completedContainer$1;
                        private final ContainerId containerId$2;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Completed container %s (state: %s, exit status: %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerId$2, this.completedContainer$1.getState(), BoxesRunTime.boxToInteger((int)this.completedContainer$1.getExitStatus())}));
                        }
                        {
                            this.completedContainer$1 = completedContainer$1;
                            this.containerId$2 = containerId$2;
                        }
                    });
                    if (completedContainer.getExitStatus() == -103) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this, completedContainer){
                            public static final long serialVersionUID = 0L;
                            private final ContainerStatus completedContainer$1;

                            public final String apply() {
                                return YarnAllocator$.MODULE$.memLimitExceededLogMessage(this.completedContainer$1.getDiagnostics(), YarnAllocator$.MODULE$.VMEM_EXCEEDED_PATTERN());
                            }
                            {
                                this.completedContainer$1 = completedContainer$1;
                            }
                        });
                    } else if (completedContainer.getExitStatus() == -104) {
                        this.$outer.logWarning((Function0<String>)new Serializable(this, completedContainer){
                            public static final long serialVersionUID = 0L;
                            private final ContainerStatus completedContainer$1;

                            public final String apply() {
                                return YarnAllocator$.MODULE$.memLimitExceededLogMessage(this.completedContainer$1.getDiagnostics(), YarnAllocator$.MODULE$.PMEM_EXCEEDED_PATTERN());
                            }
                            {
                                this.completedContainer$1 = completedContainer$1;
                            }
                        });
                    } else if (completedContainer.getExitStatus() != 0) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this, completedContainer, containerId){
                            public static final long serialVersionUID = 0L;
                            private final ContainerStatus completedContainer$1;
                            private final ContainerId containerId$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Container marked as failed: ").append((Object)this.containerId$2).append((Object)". Exit status: ").append((Object)BoxesRunTime.boxToInteger((int)this.completedContainer$1.getExitStatus())).append((Object)". Diagnostics: ").append((Object)this.completedContainer$1.getDiagnostics()).toString();
                            }
                            {
                                this.completedContainer$1 = completedContainer$1;
                                this.containerId$2 = containerId$2;
                            }
                        });
                        this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed_$eq(this.$outer.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed() + 1);
                    }
                    bl = BoxedUnit.UNIT;
                }
                if (JavaConversions$.MODULE$.mutableMapAsJavaMap(this.$outer.allocatedContainerToHostMap()).containsKey(containerId)) {
                    Option option;
                    String host = (String)this.$outer.allocatedContainerToHostMap().get((Object)containerId).get();
                    scala.collection.mutable.Set containerSet = (scala.collection.mutable.Set)this.$outer.allocatedHostToContainersMap().get((Object)host).get();
                    containerSet.remove((Object)containerId);
                    if (containerSet.isEmpty()) {
                        option = this.$outer.allocatedHostToContainersMap().remove((Object)host);
                    } else {
                        this.$outer.allocatedHostToContainersMap().update((Object)host, (Object)containerSet);
                        option = BoxedUnit.UNIT;
                    }
                    boxedUnit = this.$outer.allocatedContainerToHostMap().remove((Object)containerId);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$apache$spark$deploy$yarn$YarnAllocator$$internalReleaseContainer(Container container) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers().add(container.getId());
        this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient.releaseAssignedContainer(container.getId());
    }

    public YarnAllocator(Configuration conf, SparkConf sparkConf, AMRMClient<AMRMClient.ContainerRequest> amClient, ApplicationAttemptId appAttemptId, ApplicationMasterArguments args, SecurityManager securityMgr) {
        this.org$apache$spark$deploy$yarn$YarnAllocator$$conf = conf;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$sparkConf = sparkConf;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$amClient = amClient;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$appAttemptId = appAttemptId;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$securityMgr = securityMgr;
        Logging.class.$init$((Logging)this);
        if (org.apache.log4j.Logger.getLogger(RackResolver.class).getLevel() == null) {
            org.apache.log4j.Logger.getLogger(RackResolver.class).setLevel(Level.WARN);
        }
        this.allocatedHostToContainersMap = new HashMap();
        this.allocatedContainerToHostMap = new HashMap();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$releasedContainers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsRunning = 0;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdCounter = 0;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$numExecutorsFailed = 0;
        this.org$apache$spark$deploy$yarn$YarnAllocator$$targetNumExecutors = args.numExecutors();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$executorIdToContainer = new HashMap();
        this.executorMemory = args.executorMemory();
        this.memoryOverhead = sparkConf.getInt("spark.yarn.executor.memoryOverhead", package$.MODULE$.max((int)(YarnSparkHadoopUtil$.MODULE$.MEMORY_OVERHEAD_FACTOR() * (double)this.executorMemory()), YarnSparkHadoopUtil$.MODULE$.MEMORY_OVERHEAD_MIN()));
        this.executorCores = args.executorCores();
        this.org$apache$spark$deploy$yarn$YarnAllocator$$resource = Resource.newInstance((int)(this.executorMemory() + this.memoryOverhead()), (int)this.executorCores());
        this.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool = new ThreadPoolExecutor(sparkConf.getInt("spark.yarn.containerLauncherMaxThreads", 25), Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build());
        this.org$apache$spark$deploy$yarn$YarnAllocator$$launcherPool().allowCoreThreadTimeOut(true);
        this.org$apache$spark$deploy$yarn$YarnAllocator$$driverUrl = AkkaUtils$.MODULE$.address(AkkaUtils$.MODULE$.protocol(securityMgr.akkaSSLOptions().enabled()), SparkEnv$.MODULE$.driverActorSystemName(), sparkConf.get("spark.driver.host"), (Object)sparkConf.get("spark.driver.port"), CoarseGrainedSchedulerBackend$.MODULE$.ACTOR_NAME());
        this.org$apache$spark$deploy$yarn$YarnAllocator$$launchContainers = sparkConf.getBoolean("spark.yarn.launchContainers", true);
    }
}

