/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.deploy.yarn.security.CredentialUpdater;
import org.apache.spark.deploy.yarn.security.YARNHadoopDelegationTokenManager;
import org.apache.spark.launcher.YarnCommandBuilderUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;

public final class YarnSparkHadoopUtil$ {
    public static final YarnSparkHadoopUtil$ MODULE$;
    private CredentialUpdater credentialUpdater;
    private final double MEMORY_OVERHEAD_FACTOR;
    private final long MEMORY_OVERHEAD_MIN;
    private final String ANY_HOST;
    private final Priority RM_REQUEST_PRIORITY;
    private final String environmentVariableRegex;

    static {
        new YarnSparkHadoopUtil$();
    }

    private CredentialUpdater credentialUpdater() {
        return this.credentialUpdater;
    }

    private void credentialUpdater_$eq(CredentialUpdater x$1) {
        this.credentialUpdater = x$1;
    }

    public double MEMORY_OVERHEAD_FACTOR() {
        return this.MEMORY_OVERHEAD_FACTOR;
    }

    public long MEMORY_OVERHEAD_MIN() {
        return this.MEMORY_OVERHEAD_MIN;
    }

    public String ANY_HOST() {
        return this.ANY_HOST;
    }

    public Priority RM_REQUEST_PRIORITY() {
        return this.RM_REQUEST_PRIORITY;
    }

    public void addPathToEnvironment(HashMap<String, String> env, String key, String value) {
        String newValue = env.contains((Object)key) ? new StringBuilder().append((Object)((String)env.apply((Object)key))).append((Object)"<CPS>").append((Object)value).toString() : value;
        env.put((Object)key, (Object)newValue);
    }

    public void setEnvFromInputString(HashMap<String, String> env, String inputString) {
        if (inputString != null && inputString.length() > 0) {
            String[] childEnvs = inputString.split(",");
            Pattern p = Pattern.compile(this.environmentVariableRegex());
            Predef$.MODULE$.refArrayOps((Object[])childEnvs).foreach((Function1)new Serializable(env, p){
                public static final long serialVersionUID = 0L;
                private final HashMap env$1;
                private final Pattern p$1;

                public final void apply(String cEnv) {
                    String[] parts = cEnv.split("=");
                    Matcher m = this.p$1.matcher(parts[1]);
                    StringBuffer sb = new StringBuffer();
                    while (m.find()) {
                        String variable = m.group(1);
                        String replace = "";
                        if (this.env$1.contains((Object)variable)) {
                            replace = (String)this.env$1.apply((Object)variable);
                        } else {
                            replace = System.getenv(variable);
                            if (replace == null) {
                                replace = "";
                            }
                        }
                        m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                    }
                    m.appendTail(sb);
                    YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$1, parts[0], sb.toString());
                }
                {
                    this.env$1 = env$1;
                    this.p$1 = p$1;
                }
            });
        }
    }

    private String environmentVariableRegex() {
        return this.environmentVariableRegex;
    }

    public void addOutOfMemoryErrorArgument(ListBuffer<String> javaOpts) {
        if (!javaOpts.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.contains("-XX:OnOutOfMemoryError");
            }
        })) {
            if (Utils$.MODULE$.isWindows()) {
                javaOpts.$plus$eq((Object)this.escapeForShell("-XX:OnOutOfMemoryError=taskkill /F /PID %%%%p"));
            } else {
                javaOpts.$plus$eq((Object)"-XX:OnOutOfMemoryError='kill %p'");
            }
        }
    }

    public String escapeForShell(String arg) {
        String string;
        if (arg == null) {
            string = arg;
        } else if (Utils$.MODULE$.isWindows()) {
            string = YarnCommandBuilderUtils$.MODULE$.quoteForBatchScript(arg);
        } else {
            StringBuilder escaped = new StringBuilder("'");
            new StringOps(Predef$.MODULE$.augmentString(arg)).foreach((Function1)new Serializable(escaped){
                public static final long serialVersionUID = 0L;
                private final StringBuilder escaped$1;

                public final StringBuilder apply(char x0$1) {
                    StringBuilder stringBuilder;
                    char c = x0$1;
                    switch (c) {
                        default: {
                            stringBuilder = this.escaped$1.append(c);
                            break;
                        }
                        case '\'': {
                            stringBuilder = this.escaped$1.append("'\\''");
                            break;
                        }
                        case '\"': {
                            stringBuilder = this.escaped$1.append("\\\"");
                            break;
                        }
                        case '$': {
                            stringBuilder = this.escaped$1.append("\\$");
                        }
                    }
                    return stringBuilder;
                }
                {
                    this.escaped$1 = escaped$1;
                }
            });
            string = escaped.append("'").toString();
        }
        return string;
    }

    public Map<ApplicationAccessType, String> getApplicationAclsForYarn(SecurityManager securityMgr) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.VIEW_APP), (Object)new StringBuilder().append((Object)securityMgr.getViewAcls()).append((Object)" ").append((Object)securityMgr.getViewAclsGroups()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.MODIFY_APP), (Object)new StringBuilder().append((Object)securityMgr.getModifyAcls()).append((Object)" ").append((Object)securityMgr.getModifyAclsGroups()).toString())}));
    }

    public ContainerId getContainerId() {
        String containerIdString = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
        return ConverterUtils.toContainerId((String)containerIdString);
    }

    public Set<FileSystem> hadoopFSsToAccess(SparkConf sparkConf, Configuration hadoopConf) {
        Set filesystemsToAccess = ((TraversableOnce)((TraversableLike)sparkConf.get(package$.MODULE$.FILESYSTEMS_TO_ACCESS())).map((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final FileSystem apply(String x$2) {
                return new Path(x$2).getFileSystem(this.hadoopConf$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        FileSystem stagingFS = (FileSystem)((Option)sparkConf.get(package$.MODULE$.STAGING_DIR())).map((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final FileSystem apply(String x$3) {
                return new Path(x$3).getFileSystem(this.hadoopConf$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        }).getOrElse((Function0)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final FileSystem apply() {
                return FileSystem.get((Configuration)this.hadoopConf$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        });
        return (Set)filesystemsToAccess.$plus((Object)stagingFS);
    }

    public void startCredentialUpdater(SparkConf sparkConf) {
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(sparkConf);
        YARNHadoopDelegationTokenManager credentialManager = new YARNHadoopDelegationTokenManager(sparkConf, hadoopConf, (Function1<Configuration, Set<FileSystem>>)new Serializable(sparkConf){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;

            public final Set<FileSystem> apply(Configuration conf) {
                return YarnSparkHadoopUtil$.MODULE$.hadoopFSsToAccess(this.sparkConf$1, conf);
            }
            {
                this.sparkConf$1 = sparkConf$1;
            }
        });
        this.credentialUpdater_$eq(new CredentialUpdater(sparkConf, hadoopConf, credentialManager));
        this.credentialUpdater().start();
    }

    public void stopCredentialUpdater() {
        if (this.credentialUpdater() != null) {
            this.credentialUpdater().stop();
            this.credentialUpdater_$eq(null);
        }
    }

    private YarnSparkHadoopUtil$() {
        MODULE$ = this;
        this.MEMORY_OVERHEAD_FACTOR = 0.1;
        this.MEMORY_OVERHEAD_MIN = 384L;
        this.ANY_HOST = "*";
        this.RM_REQUEST_PRIORITY = Priority.newInstance((int)1);
        this.environmentVariableRegex = Utils$.MODULE$.isWindows() ? "%([A-Za-z_][A-Za-z0-9_]*?)%" : "\\$([A-Za-z_][A-Za-z0-9_]*)";
    }
}

