/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import org.apache.spark.deploy.yarn.YarnAllocator;
import org.apache.spark.deploy.yarn.YarnAllocator$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf!B\u0001\u0003\u0001\u0019a!\u0001D-be:\u0014Vj\u00117jK:$(BA\u0002\u0005\u0003\u0011I\u0018M\u001d8\u000b\u0005\u00151\u0011A\u00023fa2|\u0017P\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q9R\"A\u000b\u000b\u0005Y1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005a)\"a\u0002'pO\u001eLgn\u001a\u0005\u00065\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0005!\u0001\u0001\u0007\t\u0019!C\u0005C\u0005A\u0011-\\\"mS\u0016tG/F\u0001#!\r\u00193&L\u0007\u0002I)\u0011QEJ\u0001\u0004CBL'BA\u0014)\u0003\u0019\u0019G.[3oi*\u00111!\u000b\u0006\u0003U!\ta\u0001[1e_>\u0004\u0018B\u0001\u0017%\u0005)\tUJU'DY&,g\u000e\u001e\t\u0003]\u0001s!a\f \u000f\u0005AjdBA\u0019=\u001d\t\u00114H\u0004\u00024u9\u0011A'\u000f\b\u0003kaj\u0011A\u000e\u0006\u0003om\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011B\u0001\u0016\t\u0013\t\u0019\u0011&\u0003\u0002(Q%\u0011QEJ\u0005\u0003\u007f\u0011\n!\"Q'S\u001b\u000ec\u0017.\u001a8u\u0013\t\t%I\u0001\tD_:$\u0018-\u001b8feJ+\u0017/^3ti*\u0011q\b\n\u0005\n\t\u0002\u0001\r\u00111A\u0005\n\u0015\u000bA\"Y7DY&,g\u000e^0%KF$\"AR%\u0011\u000599\u0015B\u0001%\u0010\u0005\u0011)f.\u001b;\t\u000f)\u001b\u0015\u0011!a\u0001E\u0005\u0019\u0001\u0010J\u0019\t\r1\u0003\u0001\u0015)\u0003#\u0003%\tWn\u00117jK:$\b\u0005C\u0005O\u0001\u0001\u0007\t\u0019!C\u0005\u001f\u0006\u0001R/\u001b%jgR|'/_!eIJ,7o]\u000b\u0002!B\u0011\u0011\u000b\u0016\b\u0003\u001dIK!aU\b\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'>A\u0011\u0002\u0017\u0001A\u0002\u0003\u0007I\u0011B-\u0002)UL\u0007*[:u_JL\u0018\t\u001a3sKN\u001cx\fJ3r)\t1%\fC\u0004K/\u0006\u0005\t\u0019\u0001)\t\rq\u0003\u0001\u0015)\u0003Q\u0003E)\u0018\u000eS5ti>\u0014\u00180\u00113ee\u0016\u001c8\u000f\t\u0005\b=\u0002\u0001\r\u0011\"\u0003`\u0003)\u0011XmZ5ti\u0016\u0014X\rZ\u000b\u0002AB\u0011a\"Y\u0005\u0003E>\u0011qAQ8pY\u0016\fg\u000eC\u0004e\u0001\u0001\u0007I\u0011B3\u0002\u001dI,w-[:uKJ,Gm\u0018\u0013fcR\u0011aI\u001a\u0005\b\u0015\u000e\f\t\u00111\u0001a\u0011\u0019A\u0007\u0001)Q\u0005A\u0006Y!/Z4jgR,'/\u001a3!\u0011\u0015Q\u0007\u0001\"\u0001l\u0003!\u0011XmZ5ti\u0016\u0014H#\u0003$m]NT\u0018\u0011AA\u0006\u0011\u0015i\u0017\u000e1\u0001Q\u0003)!'/\u001b<fe\"{7\u000f\u001e\u0005\u0006_&\u0004\r\u0001]\u0001\u000bIJLg/\u001a:Q_J$\bC\u0001\br\u0013\t\u0011xBA\u0002J]RDQ\u0001^5A\u0002U\fAaY8oMB\u0011a\u000f_\u0007\u0002o*\u0011A\u000fK\u0005\u0003s^\u0014\u0011#W1s]\u000e{gNZ5hkJ\fG/[8o\u0011\u0015Y\u0018\u000e1\u0001}\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002~}6\ta!\u0003\u0002\u0000\r\tI1\u000b]1sW\u000e{gN\u001a\u0005\b\u0003\u0007I\u0007\u0019AA\u0003\u0003%)\u0018.\u00113ee\u0016\u001c8\u000f\u0005\u0003\u000f\u0003\u000f\u0001\u0016bAA\u0005\u001f\t1q\n\u001d;j_:DQAT5A\u0002ACq!a\u0004\u0001\t\u0003\t\t\"A\bde\u0016\fG/Z!mY>\u001c\u0017\r^8s)9\t\u0019\"!\u0007\u0002\u001c\u0005u\u0011\u0011EA\u0019\u0003w\u00012AHA\u000b\u0013\r\t9B\u0001\u0002\u000e3\u0006\u0014h.\u00117m_\u000e\fGo\u001c:\t\rQ\fi\u00011\u0001v\u0011\u0019Y\u0018Q\u0002a\u0001y\"9\u0011qDA\u0007\u0001\u0004\u0001\u0016!\u00033sSZ,'/\u0016:m\u0011!\t\u0019#!\u0004A\u0002\u0005\u0015\u0012!\u00033sSZ,'OU3g!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016\r\u0005\u0019!\u000f]2\n\t\u0005=\u0012\u0011\u0006\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011!\t\u0019$!\u0004A\u0002\u0005U\u0012aC:fGV\u0014\u0018\u000e^=NOJ\u00042!`A\u001c\u0013\r\tID\u0002\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\"A\u0011QHA\u0007\u0001\u0004\ty$\u0001\bm_\u000e\fGNU3t_V\u00148-Z:\u0011\rE\u000b\t\u0005UA#\u0013\r\t\u0019E\u0016\u0002\u0004\u001b\u0006\u0004\b\u0003BA$\u0003\u001fj!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\be\u0016\u001cwN\u001d3t\u0015\t)\u0003&\u0003\u0003\u0002R\u0005%#!\u0004'pG\u0006d'+Z:pkJ\u001cW\rC\u0004\u0002V\u0001!\t!a\u0016\u0002\u0015Ut'/Z4jgR,'\u000fF\u0003G\u00033\n\u0019\u0007\u0003\u0005\u0002\\\u0005M\u0003\u0019AA/\u0003\u0019\u0019H/\u0019;vgB!\u0011qIA0\u0013\u0011\t\t'!\u0013\u0003-\u0019Kg.\u00197BaBd\u0017nY1uS>t7\u000b^1ukND\u0011\"!\u001a\u0002TA\u0005\t\u0019\u0001)\u0002\u0017\u0011L\u0017m\u001a8pgRL7m\u001d\u0005\b\u0003S\u0002A\u0011AA6\u000319W\r^!ui\u0016l\u0007\u000f^%e)\t\ti\u0007\u0005\u0003\u0002H\u0005=\u0014\u0002BA9\u0003\u0013\u0012A#\u00119qY&\u001c\u0017\r^5p]\u0006#H/Z7qi&#\u0007bBA;\u0001\u0011\u0005\u0011qO\u0001\u0014O\u0016$\u0018)\\%q\r&dG/\u001a:QCJ\fWn\u001d\u000b\u0007\u0003s\nY(! \u0011\u000bE\u000b\t\u0005\u0015)\t\rQ\f\u0019\b1\u0001v\u0011\u001d\ty(a\u001dA\u0002A\u000b\u0011\u0002\u001d:pqf\u0014\u0015m]3\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\u0006\tr-\u001a;NCb\u0014VmZ!ui\u0016l\u0007\u000f^:\u0015\u000bA\f9)!#\t\rm\f\t\t1\u0001}\u0011\u001d\tY)!!A\u0002U\f\u0001\"_1s]\u000e{gN\u001a\u0005\b\u0003\u001f\u0003A\u0011BAI\u000319W\r^+sY\nK(+\\%e)\u0015\u0001\u00161SAP\u0011\u001d!\u0018Q\u0012a\u0001\u0003+\u0003B!a&\u0002\u001c6\u0011\u0011\u0011\u0014\u0006\u0003i&JA!!(\u0002\u001a\ni1i\u001c8gS\u001e,(/\u0019;j_:Dq!!)\u0002\u000e\u0002\u0007\u0001+\u0001\u0003s[&#\u0007\"CAS\u0001E\u0005I\u0011AAT\u0003Q)hN]3hSN$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0016\u0016\u0004!\u0006-6FAAW!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]v\"\u0001\u0006b]:|G/\u0019;j_:LA!a/\u00022\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class YarnRMClient
implements Logging {
    private AMRMClient<AMRMClient.ContainerRequest> amClient;
    private String uiHistoryAddress;
    private boolean registered;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private AMRMClient<AMRMClient.ContainerRequest> amClient() {
        return this.amClient;
    }

    private void amClient_$eq(AMRMClient<AMRMClient.ContainerRequest> x$1) {
        this.amClient = x$1;
    }

    private String uiHistoryAddress() {
        return this.uiHistoryAddress;
    }

    private void uiHistoryAddress_$eq(String x$1) {
        this.uiHistoryAddress = x$1;
    }

    private boolean registered() {
        return this.registered;
    }

    private void registered_$eq(boolean x$1) {
        this.registered = x$1;
    }

    public void register(String driverHost, int driverPort, YarnConfiguration conf, SparkConf sparkConf, Option<String> uiAddress, String uiHistoryAddress) {
        this.amClient_$eq((AMRMClient<AMRMClient.ContainerRequest>)AMRMClient.createAMRMClient());
        this.amClient().init((Configuration)conf);
        this.amClient().start();
        this.uiHistoryAddress_$eq(uiHistoryAddress);
        String trackingUrl = (String)uiAddress.getOrElse((Function0)new Serializable(this, sparkConf, uiHistoryAddress){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;
            private final String uiHistoryAddress$1;

            public final String apply() {
                return BoxesRunTime.unboxToBoolean((Object)this.sparkConf$1.get(package$.MODULE$.ALLOW_HISTORY_SERVER_TRACKING_URL())) ? this.uiHistoryAddress$1 : "";
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.uiHistoryAddress$1 = uiHistoryAddress$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Registering the ApplicationMaster";
            }
        });
        YarnRMClient yarnRMClient = this;
        synchronized (yarnRMClient) {
            this.amClient().registerApplicationMaster(driverHost, driverPort, trackingUrl);
            this.registered_$eq(true);
            return;
        }
    }

    public YarnAllocator createAllocator(YarnConfiguration conf, SparkConf sparkConf, String driverUrl, RpcEndpointRef driverRef, SecurityManager securityMgr, Map<String, LocalResource> localResources) {
        Predef$.MODULE$.require(this.registered(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Must register AM before creating allocator.";
            }
        });
        return new YarnAllocator(driverUrl, driverRef, conf, sparkConf, this.amClient(), this.getAttemptId(), securityMgr, localResources, new SparkRackResolver(), YarnAllocator$.MODULE$.$lessinit$greater$default$10());
    }

    public synchronized void unregister(FinalApplicationStatus status, String diagnostics) {
        if (this.registered()) {
            this.amClient().unregisterApplicationMaster(status, diagnostics, this.uiHistoryAddress());
        }
        if (this.amClient() != null) {
            this.amClient().stop();
        }
    }

    public String unregister$default$2() {
        return "";
    }

    public ApplicationAttemptId getAttemptId() {
        return YarnSparkHadoopUtil$.MODULE$.getContainerId().getApplicationAttemptId();
    }

    public Map<String, String> getAmIpFilterParams(YarnConfiguration conf, String proxyBase) {
        String prefix = WebAppUtils.getHttpSchemePrefix((Configuration)conf);
        List proxies = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Buffer hosts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(proxies).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return (String)Predef$.MODULE$.refArrayOps((Object[])x$1.split(":")).head();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer uriBases = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(proxies).asScala()).map((Function1)new Serializable(this, proxyBase, prefix){
            public static final long serialVersionUID = 0L;
            private final String proxyBase$1;
            private final String prefix$1;

            public final String apply(String proxy) {
                return new StringBuilder().append((Object)this.prefix$1).append((Object)proxy).append((Object)this.proxyBase$1).toString();
            }
            {
                this.proxyBase$1 = proxyBase$1;
                this.prefix$1 = prefix$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PROXY_HOSTS"), (Object)hosts.mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PROXY_URI_BASES"), (Object)uriBases.mkString(","))}));
        Iterable rmIds = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(conf.getStringCollection("yarn.resourcemanager.ha.rm-ids")).asScala();
        return rmIds != null && rmIds.nonEmpty() ? params.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"RM_HA_URLS"), (Object)((TraversableOnce)rmIds.map((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ YarnRMClient $outer;
            private final YarnConfiguration conf$1;

            public final String apply(String x$2) {
                return this.$outer.org$apache$spark$deploy$yarn$YarnRMClient$$getUrlByRmId((Configuration)this.conf$1, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conf$1 = conf$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(","))) : params;
    }

    public int getMaxRegAttempts(SparkConf sparkConf, YarnConfiguration yarnConf) {
        Option option;
        block4: {
            int n;
            block3: {
                int yarnMaxAttempts;
                block2: {
                    Option sparkMaxAttempts = ((Option)sparkConf.get(package$.MODULE$.MAX_APP_ATTEMPTS())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(int x$3) {
                            return this.apply$mcII$sp(x$3);
                        }

                        public int apply$mcII$sp(int x$3) {
                            return x$3;
                        }
                    });
                    yarnMaxAttempts = yarnConf.getInt("yarn.resourcemanager.am.max-attempts", 2);
                    option = sparkMaxAttempts;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    int x = BoxesRunTime.unboxToInt((Object)some.x());
                    n = x <= yarnMaxAttempts ? x : yarnMaxAttempts;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                n = yarnMaxAttempts;
            }
            return n;
        }
        throw new MatchError((Object)option);
    }

    public String org$apache$spark$deploy$yarn$YarnRMClient$$getUrlByRmId(Configuration conf, String rmId) {
        String string;
        String addressPropertyPrefix;
        String string2 = addressPropertyPrefix = YarnConfiguration.useHttps((Configuration)conf) ? "yarn.resourcemanager.webapp.https.address" : "yarn.resourcemanager.webapp.address";
        if (rmId == null || rmId.isEmpty()) {
            string = addressPropertyPrefix;
        } else {
            if (rmId.startsWith(".")) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rmId ", " should not already have '.' prepended."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rmId})));
            }
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{addressPropertyPrefix, rmId}));
        }
        String addressWithRmId = string;
        return conf.get(addressWithRmId);
    }

    public YarnRMClient() {
        Logging.class.$init$((Logging)this);
        this.registered = false;
    }
}

