/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!\u0002\r\u001a\u0001e\u0019\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005C\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"Aq\u000b\u0001B\u0001B\u0003%A\n\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003M\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!\u0011!Q\u0001\n1C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tG\u0002\u0011\t\u0011)A\u0005I\")!\u000e\u0001C\u0001W\"9\u0011\u0010\u0001a\u0001\n\u0003Q\b\"CA\u0002\u0001\u0001\u0007I\u0011AA\u0003\u0011\u001d\t\t\u0002\u0001Q!\nmD1\"a\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0016!Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0014\u0011-\tY\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0006\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\tI\u0007\u0001C\u0005\u0003W\u0012\u0001#\u0012=fGV$xN\u001d*v]:\f'\r\\3\u000b\u0005iY\u0012\u0001B=be:T!\u0001H\u000f\u0002\r\u0011,\u0007\u000f\\8z\u0015\tqr$A\u0003ta\u0006\u00148N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u0018\u000e\u00031R!!L\u000f\u0002\u0011%tG/\u001a:oC2L!a\f\u0017\u0003\u000f1{wmZ5oO\u0006I1m\u001c8uC&tWM]\u0002\u0001!\r)3'N\u0005\u0003i\u0019\u0012aa\u00149uS>t\u0007C\u0001\u001c?\u001b\u00059$B\u0001\u001d:\u0003\u001d\u0011XmY8sINT!AO\u001e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u001by)\u0011QhH\u0001\u0007Q\u0006$wn\u001c9\n\u0005}:$!C\"p]R\f\u0017N\\3s\u0003\u0011\u0019wN\u001c4\u0011\u0005\t#U\"A\"\u000b\u0005\u0001[\u0014BA#D\u0005EI\u0016M\u001d8D_:4\u0017nZ;sCRLwN\\\u0001\ngB\f'o[\"p]\u001a\u0004\"\u0001S%\u000e\u0003uI!AS\u000f\u0003\u0013M\u0003\u0018M]6D_:4\u0017!D7bgR,'/\u00113ee\u0016\u001c8\u000f\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001f\u001aj\u0011\u0001\u0015\u0006\u0003#F\na\u0001\u0010:p_Rt\u0014BA*'\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M3\u0013AC3yK\u000e,Ho\u001c:JI\u0006A\u0001n\\:u]\u0006lW-\u0001\bfq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=\u0011\u0005\u0015Z\u0016B\u0001/'\u0005\rIe\u000e^\u0001\u000eKb,7-\u001e;pe\u000e{'/Z:\u0002\u000b\u0005\u0004\b/\u00133\u0002\u0017M,7-\u001e:jifluM\u001d\t\u0003\u0011\u0006L!AY\u000f\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJ\fa\u0002\\8dC2\u0014Vm]8ve\u000e,7\u000f\u0005\u0003NK2;\u0017B\u00014W\u0005\ri\u0015\r\u001d\t\u0003m!L!![\u001c\u0003\u001b1{7-\u00197SKN|WO]2f\u0003\u0019a\u0014N\\5u}QaAN\\8qcJ\u001cH/\u001e<xqB\u0011Q\u000eA\u0007\u00023!)\u0001\u0007\u0004a\u0001e!)\u0001\t\u0004a\u0001\u0003\")a\t\u0004a\u0001\u000f\")1\n\u0004a\u0001\u0019\")q\u000b\u0004a\u0001\u0019\")\u0001\f\u0004a\u0001\u0019\")\u0011\f\u0004a\u00015\")Q\f\u0004a\u00015\")a\f\u0004a\u0001\u0019\")q\f\u0004a\u0001A\")1\r\u0004a\u0001I\u0006\u0019!\u000f]2\u0016\u0003m\u0004\"\u0001`@\u000e\u0003uT!A`\u001e\u0002\u0007%\u00048-C\u0002\u0002\u0002u\u0014q!W1s]J\u00036)A\u0004sa\u000e|F%Z9\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004K\u0005%\u0011bAA\u0006M\t!QK\\5u\u0011!\tyADA\u0001\u0002\u0004Y\u0018a\u0001=%c\u0005!!\u000f]2!\u0003!qWn\u00117jK:$XCAA\f!\u0011\tI\"!\t\u000e\u0005\u0005m!b\u0001\u001e\u0002\u001e)\u0019\u0011qD\u001e\u0002\r\rd\u0017.\u001a8u\u0013\u0011\t\u0019#a\u0007\u0003\u00119k5\t\\5f]R\fAB\\7DY&,g\u000e^0%KF$B!a\u0002\u0002*!I\u0011qB\t\u0002\u0002\u0003\u0007\u0011qC\u0001\n]6\u001cE.[3oi\u0002\n1A];o)\t\t9!\u0001\fmCVt7\r[\"p]R,\u0007\u0010\u001e#fEV<\u0017J\u001c4p)\u0005a\u0015AD:uCJ$8i\u001c8uC&tWM\u001d\u000b\u0003\u0003s\u0001r!a\u000f\u0002F1\u000b9%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0013\u0001\u00026bm\u0006L1AZA\u001f!\u0011\tI%a\u0014\u000e\u0005\u0005-#\u0002BA'\u0003\u0003\n1A\\5p\u0013\u0011\t\t&a\u0013\u0003\u0015\tKH/\u001a\"vM\u001a,'/\u0001\bqe\u0016\u0004\u0018M]3D_6l\u0017M\u001c3\u0015\u0005\u0005]\u0003#BA-\u0003Gbe\u0002BA.\u0003?r1aTA/\u0013\u00059\u0013bAA1M\u00059\u0001/Y2lC\u001e,\u0017\u0002BA3\u0003O\u0012A\u0001T5ti*\u0019\u0011\u0011\r\u0014\u0002%A\u0014X\r]1sK\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0003\u0003[\u0002b!a\u001c\u0002z1cUBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u000f5,H/\u00192mK*\u0019\u0011q\u000f\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002|\u0005E$a\u0002%bg\"l\u0015\r\u001d")
public class ExecutorRunnable
implements Logging {
    private final Option<Container> container;
    private final YarnConfiguration conf;
    private final SparkConf sparkConf;
    private final String masterAddress;
    private final String executorId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private final String appId;
    private final SecurityManager securityMgr;
    private final scala.collection.immutable.Map<String, LocalResource> localResources;
    private YarnRPC rpc;
    private NMClient nmClient;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    public void run() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting Executor Container");
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.conf);
        this.nmClient().start();
        this.startContainer();
    }

    public String launchContextDebugInfo() {
        List<String> commands = this.prepareCommand();
        HashMap<String, String> env = this.prepareEnvironment();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(279).append("\n    |===============================================================================\n    |YARN executor launch context:\n    |  env:\n    |").append(((TraversableOnce)Utils$.MODULE$.redact(this.sparkConf, env.toSeq()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(9).append("    ").append(k).append(" -> ").append(v).append("\n").toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString()).append("\n    |  command:\n    |    ").append(commands.mkString(" \\ \n      ")).append("\n    |\n    |  resources:\n    |").append(((TraversableOnce)this.localResources.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            LocalResource v = (LocalResource)tuple2._2();
            String string = new StringBuilder(9).append("    ").append(k).append(" -> ").append(v).append("\n").toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString()).append("\n    |===============================================================================").toString())).stripMargin();
    }

    public Map<String, ByteBuffer> startContainer() {
        Map map;
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        Map env = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(this.prepareEnvironment()).asJava();
        ctx.setLocalResources((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.localResources).asJava());
        ctx.setEnvironment(env);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand();
        ctx.setCommands((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(commands).asJava());
        ctx.setApplicationACLs((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(this.securityMgr)).asJava());
        if (BoxesRunTime.unboxToBoolean((Object)this.sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) {
            String secretString = this.securityMgr.getSecretKey();
            ByteBuffer secretBytes = secretString != null ? JavaUtils.stringToBytes((String)secretString) : ByteBuffer.allocate(0);
            ctx.setServiceData(Collections.singletonMap("spark_shuffle", secretBytes));
        }
        try {
            map = this.nmClient().startContainer((Container)this.container.get(), ctx);
        }
        catch (Exception ex) {
            throw new SparkException(new StringBuilder(35).append("Exception while starting container ").append(((Container)this.container.get()).getId()).append(new StringBuilder(9).append(" on host ").append(this.hostname).toString()).toString(), (Throwable)ex);
        }
        return map;
    }

    private List<String> prepareCommand() {
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String executorMemoryString = new StringBuilder(1).append(this.executorMemory).append("m").toString();
        javaOpts.$plus$eq((Object)new StringBuilder(4).append("-Xmx").append(executorMemoryString).toString());
        ((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            String subsOpt = Utils$.MODULE$.substituteAppNExecIds(opts, $this.appId, $this.executorId);
            return javaOpts.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(subsOpt).map((Function1 & Serializable & scala.Serializable)arg -> YarnSparkHadoopUtil$.MODULE$.escapeForShell((String)arg), Seq$.MODULE$.canBuildFrom()));
        });
        Option prefixEnv = ((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_LIBRARY_PATH())).map((Function1 & Serializable & scala.Serializable)libPath -> Client$.MODULE$.createLibraryPathPrefix((String)libPath, $this.sparkConf));
        javaOpts.$plus$eq((Object)new StringBuilder(17).append("-Djava.io.tmpdir=").append(new Path(ApplicationConstants.Environment.PWD.$$(), "./tmp")).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparkConf.getAll())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRunnable.$anonfun$prepareCommand$4(x0$1))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ListBuffer listBuffer = javaOpts.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringBuilder(3).append("-D").append(k).append("=").append(v).toString()));
            return listBuffer;
        });
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        Seq userClassPath = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Client$.MODULE$.getUserClasspath(this.sparkConf))).flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            String absPath = new File(uri.getPath()).isAbsolute() ? Client$.MODULE$.getClusterPath($this.sparkConf, uri.getPath()) : Client$.MODULE$.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$(), uri.getPath()}));
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--user-class-path", new StringBuilder(5).append("file:").append(absPath).toString()}));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq();
        YarnSparkHadoopUtil$.MODULE$.addOutOfMemoryErrorArgument((ListBuffer<String>)javaOpts);
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(prefixEnv).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(9).append(ApplicationConstants.Environment.JAVA_HOME.$$()).append("/bin/java").toString(), "-server"})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.executor.CoarseGrainedExecutorBackend", "--driver-url", this.masterAddress, "--executor-id", this.executorId, "--hostname", this.hostname, "--cores", ((Object)BoxesRunTime.boxToInteger((int)this.executorCores)).toString(), "--app-id", this.appId})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)userClassPath, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append("1>").append("<LOG_DIR>").append("/stdout").toString(), new StringBuilder(18).append("2>").append("<LOG_DIR>").append("/stderr").toString()})), scala.collection.Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)commands.map((Function1 & Serializable & scala.Serializable)s -> s == null ? "null" : s, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList();
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> prepareEnvironment() {
        void var1_1;
        String yarnHttpPolicy;
        HashMap env = new HashMap();
        Client$.MODULE$.populateClasspath(null, (Configuration)this.conf, this.sparkConf, (HashMap<String, String>)env, (Option<String>)((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_CLASS_PATH())));
        String string = yarnHttpPolicy = this.conf.get("yarn.http.policy", YarnConfiguration.YARN_HTTP_POLICY_DEFAULT);
        String string2 = "HTTPS_ONLY";
        String httpScheme = !(string != null ? !string.equals(string2) : string2 != null) ? "https://" : "http://";
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(System.getenv()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("SPARK"))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$2(env, x0$1);
            return BoxedUnit.UNIT;
        });
        this.sparkConf.getExecutorEnv().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$3(env, x0$2);
            return BoxedUnit.UNIT;
        });
        this.container.foreach((Function1 & Serializable & scala.Serializable)c -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$4(httpScheme, env, c);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommand$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = SparkConf$.MODULE$.isExecutorStartupConf(k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$2(HashMap env$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        env$1.update((Object)k, (Object)v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$3(HashMap env$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = key;
            String string2 = ApplicationConstants.Environment.CLASSPATH.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)env$1, key, value);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                env$1.update((Object)key, (Object)value);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$5(Container c$1, String httpScheme$1, HashMap env$1, String user) {
        String containerId = ConverterUtils.toString((ContainerId)c$1.getId());
        String address = c$1.getNodeHttpAddress();
        String baseUrl = new StringBuilder(21).append(httpScheme$1).append(address).append("/node/containerlogs/").append(containerId).append("/").append(user).toString();
        env$1.update((Object)"SPARK_LOG_URL_STDERR", (Object)new StringBuilder(19).append(baseUrl).append("/stderr?start=-4096").toString());
        env$1.update((Object)"SPARK_LOG_URL_STDOUT", (Object)new StringBuilder(19).append(baseUrl).append("/stdout?start=-4096").toString());
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$4(String httpScheme$1, HashMap env$1, Container c) {
        scala.sys.package$.MODULE$.env().get((Object)"SPARK_USER").foreach((Function1 & Serializable & scala.Serializable)user -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$5(c, httpScheme$1, env$1, user);
            return BoxedUnit.UNIT;
        });
    }

    public ExecutorRunnable(Option<Container> container, YarnConfiguration conf, SparkConf sparkConf, String masterAddress, String executorId, String hostname, int executorMemory, int executorCores, String appId, SecurityManager securityMgr, scala.collection.immutable.Map<String, LocalResource> localResources) {
        this.container = container;
        this.conf = conf;
        this.sparkConf = sparkConf;
        this.masterAddress = masterAddress;
        this.executorId = executorId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.appId = appId;
        this.securityMgr = securityMgr;
        this.localResources = localResources;
        Logging.$init$((Logging)this);
        this.rpc = YarnRPC.create((Configuration)conf);
    }
}

