/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import org.apache.spark.deploy.yarn.YarnAllocator;
import org.apache.spark.deploy.yarn.YarnAllocator$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}f!B\n\u0015\u0001aq\u0002\"B\u0016\u0001\t\u0003i\u0003\"\u0003\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00032\u0011%\u0019\u0006\u00011AA\u0002\u0013%A\u000bC\u0005[\u0001\u0001\u0007\t\u0011)Q\u0005e!I1\f\u0001a\u0001\u0002\u0004%I\u0001\u0018\u0005\nK\u0002\u0001\r\u00111A\u0005\n\u0019D\u0011\u0002\u001b\u0001A\u0002\u0003\u0005\u000b\u0015B/\t\u000f%\u0004\u0001\u0019!C\u0005U\"9a\u000e\u0001a\u0001\n\u0013y\u0007BB9\u0001A\u0003&1\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!I\u00111\u000f\u0001\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\t)\n\u0001C\u0001\u0003/Cq!!)\u0001\t\u0003\t\u0019\u000bC\u0004\u0002,\u0002!I!!,\u0003\u0019e\u000b'O\u001c*N\u00072LWM\u001c;\u000b\u0005U1\u0012\u0001B=be:T!a\u0006\r\u0002\r\u0011,\u0007\u000f\\8z\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7c\u0001\u0001 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\r\u0002\u0011%tG/\u001a:oC2L!AK\u0014\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001/!\ty\u0003!D\u0001\u0015\u0003!\tWn\u00117jK:$X#\u0001\u001a\u0011\u0007MZT(D\u00015\u0015\t)d'A\u0002ba&T!a\u000e\u001d\u0002\r\rd\u0017.\u001a8u\u0015\t)\u0012H\u0003\u0002;5\u00051\u0001.\u00193p_BL!\u0001\u0010\u001b\u0003\u0015\u0005k%+T\"mS\u0016tG\u000f\u0005\u0002?!:\u0011qH\u0014\b\u0003\u00016s!!\u0011'\u000f\u0005\t[eBA\"K\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002HY\u00051AH]8pizJ\u0011!H\u0005\u00037qI!A\u000f\u000e\n\u0005UI\u0014BA\u001c9\u0013\t)d'\u0003\u0002Pi\u0005Q\u0011)\u0014*N\u00072LWM\u001c;\n\u0005E\u0013&\u0001E\"p]R\f\u0017N\\3s%\u0016\fX/Z:u\u0015\tyE'\u0001\u0007b[\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002V1B\u0011\u0001EV\u0005\u0003/\u0006\u0012A!\u00168ji\"9\u0011lAA\u0001\u0002\u0004\u0011\u0014a\u0001=%c\u0005I\u0011-\\\"mS\u0016tG\u000fI\u0001\u0011k&D\u0015n\u001d;pef\fE\r\u001a:fgN,\u0012!\u0018\t\u0003=\nt!a\u00181\u0011\u0005\u0015\u000b\u0013BA1\"\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\f\u0013\u0001F;j\u0011&\u001cHo\u001c:z\u0003\u0012$'/Z:t?\u0012*\u0017\u000f\u0006\u0002VO\"9\u0011LBA\u0001\u0002\u0004i\u0016!E;j\u0011&\u001cHo\u001c:z\u0003\u0012$'/Z:tA\u0005Q!/Z4jgR,'/\u001a3\u0016\u0003-\u0004\"\u0001\t7\n\u00055\f#a\u0002\"p_2,\u0017M\\\u0001\u000fe\u0016<\u0017n\u001d;fe\u0016$w\fJ3r)\t)\u0006\u000fC\u0004Z\u0013\u0005\u0005\t\u0019A6\u0002\u0017I,w-[:uKJ,G\rI\u0001\te\u0016<\u0017n\u001d;feRQQ\u000b\u001e<|\u0003\u000b\t\t\"a\u0007\t\u000bU\\\u0001\u0019A/\u0002\u0015\u0011\u0014\u0018N^3s\u0011>\u001cH\u000fC\u0003x\u0017\u0001\u0007\u00010\u0001\u0006ee&4XM\u001d)peR\u0004\"\u0001I=\n\u0005i\f#aA%oi\")Ap\u0003a\u0001{\u0006!1m\u001c8g!\rq\u0018\u0011A\u0007\u0002\u007f*\u0011A\u0010O\u0005\u0004\u0003\u0007y(!E-be:\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011qA\u0006A\u0002\u0005%\u0011!C:qCJ\\7i\u001c8g!\u0011\tY!!\u0004\u000e\u0003aI1!a\u0004\u0019\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u0004\u0002\u0014-\u0001\r!!\u0006\u0002\u0013UL\u0017\t\u001a3sKN\u001c\b\u0003\u0002\u0011\u0002\u0018uK1!!\u0007\"\u0005\u0019y\u0005\u000f^5p]\")1l\u0003a\u0001;\u0006y1M]3bi\u0016\fE\u000e\\8dCR|'\u000f\u0006\b\u0002\"\u0005\u001d\u0012\u0011FA\u0016\u0003_\ty$!\u0013\u0011\u0007=\n\u0019#C\u0002\u0002&Q\u0011Q\"W1s]\u0006cGn\\2bi>\u0014\b\"\u0002?\r\u0001\u0004i\bbBA\u0004\u0019\u0001\u0007\u0011\u0011\u0002\u0005\u0007\u0003[a\u0001\u0019A/\u0002\u0013\u0011\u0014\u0018N^3s+Jd\u0007bBA\u0019\u0019\u0001\u0007\u00111G\u0001\nIJLg/\u001a:SK\u001a\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sA\u0012a\u0001:qG&!\u0011QHA\u001c\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001aDq!!\u0011\r\u0001\u0004\t\u0019%A\u0006tK\u000e,(/\u001b;z\u001b\u001e\u0014\b\u0003BA\u0006\u0003\u000bJ1!a\u0012\u0019\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\bbBA&\u0019\u0001\u0007\u0011QJ\u0001\u000fY>\u001c\u0017\r\u001c*fg>,(oY3t!\u0019q\u0016qJ/\u0002T%\u0019\u0011\u0011\u000b3\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002V\u0005uSBAA,\u0015\u0011\tI&a\u0017\u0002\u000fI,7m\u001c:eg*\u0011Q\u0007O\u0005\u0005\u0003?\n9FA\u0007M_\u000e\fGNU3t_V\u00148-Z\u0001\u000bk:\u0014XmZ5ti\u0016\u0014H#B+\u0002f\u0005=\u0004bBA4\u001b\u0001\u0007\u0011\u0011N\u0001\u0007gR\fG/^:\u0011\t\u0005U\u00131N\u0005\u0005\u0003[\n9F\u0001\fGS:\fG.\u00119qY&\u001c\u0017\r^5p]N#\u0018\r^;t\u0011!\t\t(\u0004I\u0001\u0002\u0004i\u0016a\u00033jC\u001etwn\u001d;jGN\fA#\u001e8sK\u001eL7\u000f^3sI\u0011,g-Y;mi\u0012\u0012TCAA<U\ri\u0016\u0011P\u0016\u0003\u0003w\u0002B!! \u0002\b6\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)A\u0005v]\u000eDWmY6fI*\u0019\u0011QQ\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\n\u0006}$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006aq-\u001a;BiR,W\u000e\u001d;JIR\u0011\u0011q\u0012\t\u0005\u0003+\n\t*\u0003\u0003\u0002\u0014\u0006]#\u0001F!qa2L7-\u0019;j_:\fE\u000f^3naRLE-A\nhKR\fU.\u00139GS2$XM\u001d)be\u0006l7\u000f\u0006\u0004\u0002\u001a\u0006m\u0015Q\u0014\t\u0006=\u0006=S,\u0018\u0005\u0006yB\u0001\r! \u0005\u0007\u0003?\u0003\u0002\u0019A/\u0002\u0013A\u0014x\u000e_=CCN,\u0017!E4fi6\u000b\u0007PU3h\u0003R$X-\u001c9ugR)\u00010!*\u0002(\"9\u0011qA\tA\u0002\u0005%\u0001BBAU#\u0001\u0007Q0\u0001\u0005zCJt7i\u001c8g\u000319W\r^+sY\nK(+\\%e)\u0015i\u0016qVA^\u0011\u0019a(\u00031\u0001\u00022B!\u00111WA\\\u001b\t\t)L\u0003\u0002}s%!\u0011\u0011XA[\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"1\u0011Q\u0018\nA\u0002u\u000bAA]7JI\u0002")
public class YarnRMClient
implements Logging {
    private AMRMClient<AMRMClient.ContainerRequest> amClient;
    private String uiHistoryAddress;
    private boolean registered;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AMRMClient<AMRMClient.ContainerRequest> amClient() {
        return this.amClient;
    }

    private void amClient_$eq(AMRMClient<AMRMClient.ContainerRequest> x$1) {
        this.amClient = x$1;
    }

    private String uiHistoryAddress() {
        return this.uiHistoryAddress;
    }

    private void uiHistoryAddress_$eq(String x$1) {
        this.uiHistoryAddress = x$1;
    }

    private boolean registered() {
        return this.registered;
    }

    private void registered_$eq(boolean x$1) {
        this.registered = x$1;
    }

    public void register(String driverHost, int driverPort, YarnConfiguration conf, SparkConf sparkConf, Option<String> uiAddress, String uiHistoryAddress) {
        this.amClient_$eq((AMRMClient<AMRMClient.ContainerRequest>)AMRMClient.createAMRMClient());
        this.amClient().init((Configuration)conf);
        this.amClient().start();
        this.uiHistoryAddress_$eq(uiHistoryAddress);
        String trackingUrl = (String)uiAddress.getOrElse((Function0 & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.ALLOW_HISTORY_SERVER_TRACKING_URL())) ? uiHistoryAddress : "");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Registering the ApplicationMaster");
        YarnRMClient yarnRMClient = this;
        synchronized (yarnRMClient) {
            this.amClient().registerApplicationMaster(driverHost, driverPort, trackingUrl);
            this.registered_$eq(true);
        }
    }

    public YarnAllocator createAllocator(YarnConfiguration conf, SparkConf sparkConf, String driverUrl, RpcEndpointRef driverRef, SecurityManager securityMgr, Map<String, LocalResource> localResources) {
        Predef$.MODULE$.require(this.registered(), (Function0 & Serializable & scala.Serializable)() -> "Must register AM before creating allocator.");
        return new YarnAllocator(driverUrl, driverRef, conf, sparkConf, this.amClient(), this.getAttemptId(), securityMgr, localResources, new SparkRackResolver(), YarnAllocator$.MODULE$.$lessinit$greater$default$10());
    }

    public synchronized void unregister(FinalApplicationStatus status, String diagnostics) {
        block1: {
            if (this.registered()) {
                this.amClient().unregisterApplicationMaster(status, diagnostics, this.uiHistoryAddress());
            }
            if (this.amClient() == null) break block1;
            this.amClient().stop();
        }
    }

    public String unregister$default$2() {
        return "";
    }

    public ApplicationAttemptId getAttemptId() {
        return YarnSparkHadoopUtil$.MODULE$.getContainerId().getApplicationAttemptId();
    }

    public Map<String, String> getAmIpFilterParams(YarnConfiguration conf, String proxyBase) {
        String prefix = WebAppUtils.getHttpSchemePrefix((Configuration)conf);
        List proxies = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Buffer hosts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(proxies).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(":"))).head(), Buffer$.MODULE$.canBuildFrom());
        Buffer uriBases = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(proxies).asScala()).map((Function1 & Serializable & scala.Serializable)proxy -> new StringBuilder(0).append(prefix).append((String)proxy).append(proxyBase).toString(), Buffer$.MODULE$.canBuildFrom());
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PROXY_HOSTS"), (Object)hosts.mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PROXY_URI_BASES"), (Object)uriBases.mkString(","))}));
        Iterable rmIds = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(conf.getStringCollection("yarn.resourcemanager.ha.rm-ids")).asScala();
        return rmIds != null && rmIds.nonEmpty() ? params.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"RM_HA_URLS"), (Object)((TraversableOnce)rmIds.map((Function1 & Serializable & scala.Serializable)x$2 -> this.getUrlByRmId((Configuration)conf, (String)x$2), Iterable$.MODULE$.canBuildFrom())).mkString(","))) : params;
    }

    public int getMaxRegAttempts(SparkConf sparkConf, YarnConfiguration yarnConf) {
        int n;
        Option sparkMaxAttempts = ((Option)sparkConf.get(package$.MODULE$.MAX_APP_ATTEMPTS())).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$3 -> x$3);
        int yarnMaxAttempts = yarnConf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        Option option = sparkMaxAttempts;
        if (option instanceof Some) {
            Some some = (Some)option;
            int x = BoxesRunTime.unboxToInt((Object)some.value());
            n = x <= yarnMaxAttempts ? x : yarnMaxAttempts;
        } else if (None$.MODULE$.equals(option)) {
            n = yarnMaxAttempts;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    private String getUrlByRmId(Configuration conf, String rmId) {
        String string;
        String addressPropertyPrefix;
        String string2 = addressPropertyPrefix = YarnConfiguration.useHttps((Configuration)conf) ? "yarn.resourcemanager.webapp.https.address" : "yarn.resourcemanager.webapp.address";
        if (rmId == null || rmId.isEmpty()) {
            string = addressPropertyPrefix;
        } else {
            if (rmId.startsWith(".")) {
                throw new IllegalStateException(new StringBuilder(44).append("rmId ").append(rmId).append(" should not already have '.' prepended.").toString());
            }
            string = new StringBuilder(1).append(addressPropertyPrefix).append(".").append(rmId).toString();
        }
        String addressWithRmId = string;
        return conf.get(addressWithRmId);
    }

    public YarnRMClient() {
        Logging.$init$((Logging)this);
        this.registered = false;
    }
}

