/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.launcher.YarnCommandBuilderUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class YarnSparkHadoopUtil$ {
    public static YarnSparkHadoopUtil$ MODULE$;
    private final double MEMORY_OVERHEAD_FACTOR;
    private final long MEMORY_OVERHEAD_MIN;
    private final String ANY_HOST;
    private final Priority RM_REQUEST_PRIORITY;
    private final String environmentVariableRegex;

    static {
        new YarnSparkHadoopUtil$();
    }

    public double MEMORY_OVERHEAD_FACTOR() {
        return this.MEMORY_OVERHEAD_FACTOR;
    }

    public long MEMORY_OVERHEAD_MIN() {
        return this.MEMORY_OVERHEAD_MIN;
    }

    public String ANY_HOST() {
        return this.ANY_HOST;
    }

    public Priority RM_REQUEST_PRIORITY() {
        return this.RM_REQUEST_PRIORITY;
    }

    public void addPathToEnvironment(HashMap<String, String> env, String key, String value) {
        String newValue = env.contains((Object)key) ? new StringBuilder(5).append((String)env.apply((Object)key)).append("<CPS>").append(value).toString() : value;
        env.put((Object)key, (Object)newValue);
    }

    public void setEnvFromInputString(HashMap<String, String> env, String inputString) {
        block0: {
            if (inputString == null || inputString.length() <= 0) break block0;
            String[] childEnvs = inputString.split(",");
            Pattern p = Pattern.compile(this.environmentVariableRegex());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])childEnvs)).foreach((Function1 & Serializable & scala.Serializable)cEnv -> {
                YarnSparkHadoopUtil$.$anonfun$setEnvFromInputString$1(p, env, cEnv);
                return BoxedUnit.UNIT;
            });
        }
    }

    private String environmentVariableRegex() {
        return this.environmentVariableRegex;
    }

    public void addOutOfMemoryErrorArgument(ListBuffer<String> javaOpts) {
        block2: {
            if (javaOpts.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("-XX:OnOutOfMemoryError")))) break block2;
            if (Utils$.MODULE$.isWindows()) {
                javaOpts.$plus$eq((Object)this.escapeForShell("-XX:OnOutOfMemoryError=taskkill /F /PID %%%%p"));
            } else {
                javaOpts.$plus$eq((Object)"-XX:OnOutOfMemoryError='kill %p'");
            }
        }
    }

    public String escapeForShell(String arg) {
        String string;
        if (arg != null) {
            if (Utils$.MODULE$.isWindows()) {
                string = YarnCommandBuilderUtils$.MODULE$.quoteForBatchScript(arg);
            } else {
                scala.collection.mutable.StringBuilder escaped = new scala.collection.mutable.StringBuilder("'");
                new StringOps(Predef$.MODULE$.augmentString(arg)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> YarnSparkHadoopUtil$.$anonfun$escapeForShell$1(escaped, BoxesRunTime.unboxToChar((Object)x0$1)));
                string = escaped.append("'").toString();
            }
        } else {
            string = arg;
        }
        return string;
    }

    public Map<ApplicationAccessType, String> getApplicationAclsForYarn(SecurityManager securityMgr) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.VIEW_APP), (Object)new StringBuilder(1).append(securityMgr.getViewAcls()).append(" ").append(securityMgr.getViewAclsGroups()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.MODIFY_APP), (Object)new StringBuilder(1).append(securityMgr.getModifyAcls()).append(" ").append(securityMgr.getModifyAclsGroups()).toString())}));
    }

    public ContainerId getContainerId() {
        String containerIdString = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
        return ConverterUtils.toContainerId((String)containerIdString);
    }

    /*
     * WARNING - void declaration
     */
    public int executorOffHeapMemorySizeAsMb(SparkConf sparkConf) {
        int n;
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.MEMORY_OFFHEAP_ENABLED()))) {
            void var2_2;
            int sizeInMB = Utils$.MODULE$.memoryStringToMb(sparkConf.get(package$.MODULE$.MEMORY_OFFHEAP_SIZE()).toString());
            Predef$.MODULE$.require(sizeInMB > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(package$.MODULE$.MEMORY_OFFHEAP_SIZE().key()).append(" must be > 0 when ").append(package$.MODULE$.MEMORY_OFFHEAP_ENABLED().key()).append(" == true").toString());
            n = var2_2;
        } else {
            n = 0;
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$setEnvFromInputString$1(Pattern p$1, HashMap env$1, String cEnv) {
        String[] parts = cEnv.split("=");
        Matcher m = p$1.matcher(parts[1]);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String variable = m.group(1);
            String replace = "";
            if (env$1.contains((Object)variable)) {
                replace = (String)env$1.apply((Object)variable);
            } else {
                replace = System.getenv(variable);
                if (replace == null) {
                    replace = "";
                }
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(replace));
        }
        m.appendTail(sb);
        MODULE$.addPathToEnvironment((HashMap<String, String>)env$1, parts[0], sb.toString());
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$escapeForShell$1(scala.collection.mutable.StringBuilder escaped$1, char x0$1) {
        scala.collection.mutable.StringBuilder stringBuilder;
        char c = x0$1;
        switch (c) {
            case '$': {
                stringBuilder = escaped$1.append("\\$");
                break;
            }
            case '\"': {
                stringBuilder = escaped$1.append("\\\"");
                break;
            }
            case '\'': {
                stringBuilder = escaped$1.append("'\\''");
                break;
            }
            default: {
                stringBuilder = escaped$1.append(c);
                break;
            }
        }
        return stringBuilder;
    }

    private YarnSparkHadoopUtil$() {
        MODULE$ = this;
        this.MEMORY_OVERHEAD_FACTOR = 0.1;
        this.MEMORY_OVERHEAD_MIN = 384L;
        this.ANY_HOST = "*";
        this.RM_REQUEST_PRIORITY = Priority.newInstance((int)1);
        this.environmentVariableRegex = Utils$.MODULE$.isWindows() ? "%([A-Za-z_][A-Za-z0-9_]*?)%" : "\\$([A-Za-z_][A-Za-z0-9_]*)";
    }
}

