/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\re!B\r\u001b\u0001i!\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0011\u0005\u0003!\u0011!Q\u0001\n\tC\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\f\u0001B\u0001B\u0003%Q\n\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003N\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011}\u0003!\u0011!Q\u0001\n5C\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A1\u000e\u0001B\u0001B\u0003%1\fC\u0003m\u0001\u0011\u0005Q\u000eC\u0004}\u0001\u0001\u0007I\u0011A?\t\u0013\u0005%\u0001\u00011A\u0005\u0002\u0005-\u0001bBA\f\u0001\u0001\u0006KA \u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0003\tY\u0002C\u0006\u0002,\u0001\u0001\r\u00111A\u0005\u0002\u00055\u0002bCA\u0019\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA8\u0001\u0011%\u0011\u0011\u000f\u0002\u0011\u000bb,7-\u001e;peJ+hN\\1cY\u0016T!a\u0007\u000f\u0002\te\f'O\u001c\u0006\u0003;y\ta\u0001Z3qY>L(BA\u0010!\u0003\u0015\u0019\b/\u0019:l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0014\u0007\u0001)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y=j\u0011!\f\u0006\u0003]y\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003a5\u0012q\u0001T8hO&tw-A\u0005d_:$\u0018-\u001b8fe\u000e\u0001\u0001c\u0001\u00145m%\u0011Qg\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005]zT\"\u0001\u001d\u000b\u0005eR\u0014a\u0002:fG>\u0014Hm\u001d\u0006\u0003wq\n1!\u00199j\u0015\tYRH\u0003\u0002?A\u00051\u0001.\u00193p_BL!\u0001\u0011\u001d\u0003\u0013\r{g\u000e^1j]\u0016\u0014\u0018\u0001B2p]\u001a\u0004\"aQ#\u000e\u0003\u0011S!!\u0011\u001f\n\u0005\u0019#%!E-be:\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006I1\u000f]1sW\u000e{gN\u001a\t\u0003\u0013*k\u0011AH\u0005\u0003\u0017z\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u001b5\f7\u000f^3s\u0003\u0012$'/Z:t!\tqUK\u0004\u0002P'B\u0011\u0001kJ\u0007\u0002#*\u0011!KM\u0001\u0007yI|w\u000e\u001e \n\u0005Q;\u0013A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001V\u0014\u0002\u0015\u0015DXmY;u_JLE-\u0001\u0005i_N$h.Y7f\u00039)\u00070Z2vi>\u0014X*Z7pef\u0004\"A\n/\n\u0005u;#aA%oi\u0006iQ\r_3dkR|'oQ8sKN\fQ!\u00199q\u0013\u0012\f1b]3dkJLG/_'heB\u0011\u0011JY\u0005\u0003Gz\u0011qbU3dkJLG/_'b]\u0006<WM]\u0001\u000fY>\u001c\u0017\r\u001c*fg>,(oY3t!\u0011qe-\u00145\n\u0005\u001d<&aA'baB\u0011q'[\u0005\u0003Ub\u0012Q\u0002T8dC2\u0014Vm]8ve\u000e,\u0017!\u0005:fg>,(oY3Qe>4\u0017\u000e\\3JI\u00061A(\u001b8jiz\"RB\u001c9reN$XO^<ysj\\\bCA8\u0001\u001b\u0005Q\u0002\"B\u0019\u000e\u0001\u0004\u0019\u0004\"B!\u000e\u0001\u0004\u0011\u0005\"B$\u000e\u0001\u0004A\u0005\"\u0002'\u000e\u0001\u0004i\u0005\"\u0002-\u000e\u0001\u0004i\u0005\"B-\u000e\u0001\u0004i\u0005\"\u0002.\u000e\u0001\u0004Y\u0006\"\u00020\u000e\u0001\u0004Y\u0006\"B0\u000e\u0001\u0004i\u0005\"\u00021\u000e\u0001\u0004\t\u0007\"\u00023\u000e\u0001\u0004)\u0007\"B6\u000e\u0001\u0004Y\u0016a\u0001:qGV\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA(A\u0002ja\u000eLA!a\u0002\u0002\u0002\t9\u0011,\u0019:o%B\u001b\u0015a\u0002:qG~#S-\u001d\u000b\u0005\u0003\u001b\t\u0019\u0002E\u0002'\u0003\u001fI1!!\u0005(\u0005\u0011)f.\u001b;\t\u0011\u0005Uq\"!AA\u0002y\f1\u0001\u001f\u00132\u0003\u0011\u0011\bo\u0019\u0011\u0002\u00119l7\t\\5f]R,\"!!\b\u0011\t\u0005}\u0011qE\u0007\u0003\u0003CQ1aOA\u0012\u0015\r\t)\u0003P\u0001\u0007G2LWM\u001c;\n\t\u0005%\u0012\u0011\u0005\u0002\t\u001d6\u001bE.[3oi\u0006aa.\\\"mS\u0016tGo\u0018\u0013fcR!\u0011QBA\u0018\u0011%\t)BEA\u0001\u0002\u0004\ti\"A\u0005o[\u000ec\u0017.\u001a8uA\u0005\u0019!/\u001e8\u0015\u0005\u00055\u0011A\u00067bk:\u001c\u0007nQ8oi\u0016DH\u000fR3ck\u001eLeNZ8\u0015\u00035\u000bab\u001d;beR\u001cuN\u001c;bS:,'\u000f\u0006\u0002\u0002@A9\u0011\u0011IA&\u001b\u00065SBAA\"\u0015\u0011\t)%a\u0012\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0013\nAA[1wC&\u0019q-a\u0011\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#RA!a\u0015\u0002H\u0005\u0019a.[8\n\t\u0005]\u0013\u0011\u000b\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u00049sKB\f'/Z\"p[6\fg\u000e\u001a\u000b\u0003\u0003;\u0002R!a\u0018\u0002j5sA!!\u0019\u0002f9\u0019\u0001+a\u0019\n\u0003!J1!a\u001a(\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001b\u0002n\t!A*[:u\u0015\r\t9gJ\u0001\u0013aJ,\u0007/\u0019:f\u000b:4\u0018N]8o[\u0016tG\u000f\u0006\u0002\u0002tA1\u0011QOA@\u001b6k!!a\u001e\u000b\t\u0005e\u00141P\u0001\b[V$\u0018M\u00197f\u0015\r\tihJ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAA\u0003o\u0012q\u0001S1tQ6\u000b\u0007\u000f")
public class ExecutorRunnable
implements Logging {
    private final Option<Container> container;
    private final YarnConfiguration conf;
    private final SparkConf sparkConf;
    private final String masterAddress;
    private final String executorId;
    private final String hostname;
    private final int executorMemory;
    private final int executorCores;
    private final String appId;
    private final SecurityManager securityMgr;
    private final scala.collection.immutable.Map<String, LocalResource> localResources;
    private final int resourceProfileId;
    private YarnRPC rpc;
    private NMClient nmClient;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public YarnRPC rpc() {
        return this.rpc;
    }

    public void rpc_$eq(YarnRPC x$1) {
        this.rpc = x$1;
    }

    public NMClient nmClient() {
        return this.nmClient;
    }

    public void nmClient_$eq(NMClient x$1) {
        this.nmClient = x$1;
    }

    public void run() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting Executor Container");
        this.nmClient_$eq(NMClient.createNMClient());
        this.nmClient().init((Configuration)this.conf);
        this.nmClient().start();
        this.startContainer();
    }

    public String launchContextDebugInfo() {
        List<String> commands = this.prepareCommand();
        HashMap<String, String> env = this.prepareEnvironment();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(287).append("\n    |===============================================================================\n    |Default YARN executor launch context:\n    |  env:\n    |").append(((TraversableOnce)Utils$.MODULE$.redact(this.sparkConf, env.toSeq()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(9).append("    ").append(k).append(" -> ").append(v).append("\n").toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString()).append("\n    |  command:\n    |    ").append(Utils$.MODULE$.redactCommandLineArgs(this.sparkConf, commands).mkString(" \\ \n      ")).append("\n    |\n    |  resources:\n    |").append(((TraversableOnce)this.localResources.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            LocalResource v = (LocalResource)tuple2._2();
            String string = new StringBuilder(9).append("    ").append(k).append(" -> ").append(v).append("\n").toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString()).append("\n    |===============================================================================").toString())).stripMargin();
    }

    public Map<String, ByteBuffer> startContainer() {
        Map map;
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        Map env = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(this.prepareEnvironment()).asJava();
        ctx.setLocalResources((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.localResources).asJava());
        ctx.setEnvironment(env);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ctx.setTokens(ByteBuffer.wrap(dob.getData()));
        List<String> commands = this.prepareCommand();
        ctx.setCommands((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(commands).asJava());
        ctx.setApplicationACLs((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(YarnSparkHadoopUtil$.MODULE$.getApplicationAclsForYarn(this.securityMgr)).asJava());
        if (BoxesRunTime.unboxToBoolean((Object)this.sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) {
            String secretString = this.securityMgr.getSecretKey();
            ByteBuffer secretBytes = secretString != null ? JavaUtils.stringToBytes((String)secretString) : ByteBuffer.allocate(0);
            String serviceName = (String)this.sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_NAME());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Initializing service data for shuffle service using name '").append(serviceName).append("'").toString());
            ctx.setServiceData(Collections.singletonMap(serviceName, secretBytes));
        }
        try {
            map = this.nmClient().startContainer((Container)this.container.get(), ctx);
        }
        catch (Exception ex) {
            throw new SparkException(new StringBuilder(44).append("Exception while starting container ").append(((Container)this.container.get()).getId()).append(" on host ").append(this.hostname).toString(), (Throwable)ex);
        }
        return map;
    }

    private List<String> prepareCommand() {
        ListBuffer javaOpts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String executorMemoryString = new StringBuilder(1).append(this.executorMemory).append("m").toString();
        javaOpts.$plus$eq((Object)new StringBuilder(4).append("-Xmx").append(executorMemoryString).toString());
        ((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            String subsOpt = Utils$.MODULE$.substituteAppNExecIds(opts, $this.appId, $this.executorId);
            return javaOpts.$plus$plus$eq((TraversableOnce)Utils$.MODULE$.splitCommandString(subsOpt).map((Function1 & Serializable & scala.Serializable)arg -> YarnSparkHadoopUtil$.MODULE$.escapeForShell((String)arg), Seq$.MODULE$.canBuildFrom()));
        });
        Option prefixEnv = ((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_LIBRARY_PATH())).map((Function1 & Serializable & scala.Serializable)libPath -> Client$.MODULE$.createLibraryPathPrefix((String)libPath, $this.sparkConf));
        javaOpts.$plus$eq((Object)new StringBuilder(17).append("-Djava.io.tmpdir=").append(new Path(ApplicationConstants.Environment.PWD.$$(), "./tmp")).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparkConf.getAll())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorRunnable.$anonfun$prepareCommand$4(x0$1))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            ListBuffer listBuffer = javaOpts.$plus$eq((Object)YarnSparkHadoopUtil$.MODULE$.escapeForShell(new StringBuilder(3).append("-D").append(k).append("=").append(v).toString()));
            return listBuffer;
        });
        javaOpts.$plus$eq((Object)"-Dspark.yarn.app.container.log.dir=<LOG_DIR>");
        YarnSparkHadoopUtil$.MODULE$.addOutOfMemoryErrorArgument((ListBuffer<String>)javaOpts);
        Iterable commands = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(prefixEnv).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StringBuilder(9).append(ApplicationConstants.Environment.JAVA_HOME.$$()).append("/bin/java").toString(), (List)new .colon.colon((Object)"-server", (List)Nil$.MODULE$)), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)javaOpts, scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.executor.YarnCoarseGrainedExecutorBackend", "--driver-url", this.masterAddress, "--executor-id", this.executorId, "--hostname", this.hostname, "--cores", Integer.toString(this.executorCores), "--app-id", this.appId, "--resourceProfileId", Integer.toString(this.resourceProfileId)})), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StringBuilder(18).append("1>").append("<LOG_DIR>").append("/stdout").toString(), (List)new .colon.colon((Object)new StringBuilder(18).append("2>").append("<LOG_DIR>").append("/stderr").toString(), (List)Nil$.MODULE$)), scala.collection.Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)commands.map((Function1 & Serializable & scala.Serializable)s -> s == null ? "null" : s, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList();
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, String> prepareEnvironment() {
        void var1_1;
        HashMap env = new HashMap();
        Client$.MODULE$.populateClasspath(null, (Configuration)this.conf, this.sparkConf, (HashMap<String, String>)env, (Option<String>)((Option)this.sparkConf.get((ConfigEntry)package$.MODULE$.EXECUTOR_CLASS_PATH())));
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(System.getenv()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("SPARK"))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$2(env, x0$1);
            return BoxedUnit.UNIT;
        });
        this.sparkConf.getExecutorEnv().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExecutorRunnable.$anonfun$prepareEnvironment$3(env, x0$2);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommand$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = SparkConf$.MODULE$.isExecutorStartupConf(k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$2(HashMap env$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        env$1.update((Object)k, (Object)v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$prepareEnvironment$3(HashMap env$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = key;
            String string2 = ApplicationConstants.Environment.CLASSPATH.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)env$1, key, value);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                env$1.update((Object)key, (Object)value);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public ExecutorRunnable(Option<Container> container, YarnConfiguration conf, SparkConf sparkConf, String masterAddress, String executorId, String hostname, int executorMemory, int executorCores, String appId, SecurityManager securityMgr, scala.collection.immutable.Map<String, LocalResource> localResources, int resourceProfileId) {
        this.container = container;
        this.conf = conf;
        this.sparkConf = sparkConf;
        this.masterAddress = masterAddress;
        this.executorId = executorId;
        this.hostname = hostname;
        this.executorMemory = executorMemory;
        this.executorCores = executorCores;
        this.appId = appId;
        this.securityMgr = securityMgr;
        this.localResources = localResources;
        this.resourceProfileId = resourceProfileId;
        Logging.$init$((Logging)this);
        this.rpc = YarnRPC.create((Configuration)conf);
    }
}

