/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.util.LinkedHashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.NoCloseExecutor;
import org.apache.sshd.common.util.threads.SshThreadPoolExecutor;
import org.apache.sshd.common.util.threads.SshdThreadFactory;

public final class ThreadUtils {
    private ThreadUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static CloseableExecutorService protectExecutorServiceShutdown(CloseableExecutorService executorService, boolean shutdownOnExit) {
        if (executorService == null || shutdownOnExit || executorService instanceof NoCloseExecutor) {
            return executorService;
        }
        return new NoCloseExecutor(executorService);
    }

    public static CloseableExecutorService noClose(CloseableExecutorService executorService) {
        return ThreadUtils.protectExecutorServiceShutdown(executorService, false);
    }

    public static ClassLoader resolveDefaultClassLoader(Object anchor) {
        return ThreadUtils.resolveDefaultClassLoader(anchor == null ? null : anchor.getClass());
    }

    public static Iterable<ClassLoader> resolveDefaultClassLoaders(Object anchor) {
        return ThreadUtils.resolveDefaultClassLoaders(anchor == null ? null : anchor.getClass());
    }

    public static <T> T createDefaultInstance(Class<?> anchor, Class<T> targetType, String className) throws ReflectiveOperationException {
        return ThreadUtils.createDefaultInstance(ThreadUtils.resolveDefaultClassLoaders(anchor), targetType, className);
    }

    public static <T> T createDefaultInstance(ClassLoader cl, Class<T> targetType, String className) throws ReflectiveOperationException {
        Class<?> instanceType = cl.loadClass(className);
        Object instance = instanceType.newInstance();
        return targetType.cast(instance);
    }

    public static <T> T createDefaultInstance(Iterable<ClassLoader> cls, Class<T> targetType, String className) throws ReflectiveOperationException {
        for (ClassLoader cl : cls) {
            try {
                return ThreadUtils.createDefaultInstance(cl, targetType, className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    public static ClassLoader resolveDefaultClassLoader(Class<?> anchor) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        if (anchor != null) {
            cl = anchor.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static Iterable<ClassLoader> resolveDefaultClassLoaders(Class<?> anchor) {
        LinkedHashSet<ClassLoader> cls = new LinkedHashSet<ClassLoader>();
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        if (cl != null) {
            cls.add(cl);
        }
        if (anchor != null) {
            cls.add(anchor.getClassLoader());
        }
        cls.add(ClassLoader.getSystemClassLoader());
        return cls;
    }

    public static CloseableExecutorService newFixedThreadPoolIf(CloseableExecutorService executorService, String poolName, int nThreads) {
        return executorService == null ? ThreadUtils.newFixedThreadPool(poolName, nThreads) : executorService;
    }

    public static CloseableExecutorService newFixedThreadPool(String poolName, int nThreads) {
        return new SshThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new SshdThreadFactory(poolName), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static CloseableExecutorService newCachedThreadPoolIf(CloseableExecutorService executorService, String poolName) {
        return executorService == null ? ThreadUtils.newCachedThreadPool(poolName) : executorService;
    }

    public static CloseableExecutorService newCachedThreadPool(String poolName) {
        return new SshThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new SshdThreadFactory(poolName), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String poolName) {
        return new ScheduledThreadPoolExecutor(1, new SshdThreadFactory(poolName));
    }

    public static CloseableExecutorService newSingleThreadExecutor(String poolName) {
        return ThreadUtils.newFixedThreadPool(poolName, 1);
    }
}

