/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.util.test;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.ProtectionDomain;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProviderHolder;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.random.RandomFactory;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;

public final class CommonTestSupportUtils {
    public static final String FILE_URL_SCHEME = "file";
    public static final String FILE_URL_PREFIX = "file:";
    public static final char RESOURCE_SUBPATH_SEPARATOR = '!';
    public static final String JAR_FILE_SUFFIX = ".jar";
    public static final String JAR_URL_SCHEME = "jar";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String CLASS_FILE_SUFFIX = ".class";
    public static final List<String> TARGET_FOLDER_NAMES = Collections.unmodifiableList(Arrays.asList("target", "build"));
    public static final String DEFAULT_TEST_HOST_KEY_PROVIDER_ALGORITHM = "EC";
    public static final int DEFAULT_TEST_HOST_KEY_SIZE = 256;
    public static final String DEFAULT_TEST_HOST_KEY_TYPE = ECCurves.fromCurveSize((int)256).getKeyType();
    private static final AtomicReference<KeyPairProvider> KEYPAIR_PROVIDER_HOLDER = new AtomicReference();
    private static final Map<String, FileKeyPairProvider> PROVIDERS_MAP = new ConcurrentHashMap<String, FileKeyPairProvider>();

    private CommonTestSupportUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static URI getClassContainerLocationURI(Class<?> clazz) throws URISyntaxException {
        URL url = CommonTestSupportUtils.getClassContainerLocationURL(clazz);
        return url == null ? null : url.toURI();
    }

    public static URL getClassContainerLocationURL(Class<?> clazz) {
        URL url;
        ProtectionDomain pd = clazz.getProtectionDomain();
        CodeSource cs = pd == null ? null : pd.getCodeSource();
        URL uRL = url = cs == null ? null : cs.getLocation();
        if (url == null) {
            url = CommonTestSupportUtils.getClassBytesURL(clazz);
            if (url == null) {
                return null;
            }
            String srcForm = CommonTestSupportUtils.getURLSource(url);
            if (GenericUtils.isEmpty((CharSequence)srcForm)) {
                return null;
            }
            try {
                url = new URL(srcForm);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("getClassContainerLocationURL(" + clazz.getName() + ") Failed to create URL=" + srcForm + " from " + url.toExternalForm() + ": " + e.getMessage());
            }
        }
        return url;
    }

    public static String getURLSource(URI uri) {
        return CommonTestSupportUtils.getURLSource(uri == null ? null : uri.toString());
    }

    public static String getURLSource(URL url) {
        return CommonTestSupportUtils.getURLSource(url == null ? null : url.toExternalForm());
    }

    public static String getURLSource(String externalForm) {
        String url = externalForm;
        if (GenericUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        url = CommonTestSupportUtils.stripJarURLPrefix(externalForm);
        if (GenericUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        int sepPos = url.indexOf(33);
        if (sepPos < 0) {
            return CommonTestSupportUtils.adjustURLPathValue(url);
        }
        return CommonTestSupportUtils.adjustURLPathValue(url.substring(0, sepPos));
    }

    public static String adjustURLPathValue(URL url) {
        return CommonTestSupportUtils.adjustURLPathValue(url == null ? null : url.getPath());
    }

    public static String adjustURLPathValue(String path) {
        int pathLen;
        int n = pathLen = path == null ? 0 : path.length();
        if (pathLen <= 1 || path.charAt(pathLen - 1) != '/') {
            return path;
        }
        return path.substring(0, pathLen - 1);
    }

    public static String stripJarURLPrefix(String externalForm) {
        String url = externalForm;
        if (GenericUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        if (url.startsWith(JAR_URL_PREFIX)) {
            return url.substring(JAR_URL_PREFIX.length());
        }
        return url;
    }

    public static URL getClassBytesURL(Class<?> clazz) {
        String className = clazz.getName();
        int sepPos = className.indexOf(36);
        if (sepPos > 0) {
            sepPos = className.lastIndexOf(46);
            if (sepPos > 0) {
                className = className.substring(sepPos + 1);
            }
        } else {
            className = clazz.getSimpleName();
        }
        return clazz.getResource(className + CLASS_FILE_SUFFIX);
    }

    public static String getClassBytesResourceName(Class<?> clazz) {
        return CommonTestSupportUtils.getClassBytesResourceName(clazz == null ? null : clazz.getName());
    }

    public static String getClassBytesResourceName(String name) {
        if (GenericUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        return name.replace('.', '/') + CLASS_FILE_SUFFIX;
    }

    public static Path resolve(Path root, String ... children) {
        if (GenericUtils.isEmpty((Object[])children)) {
            return root;
        }
        return CommonTestSupportUtils.resolve(root, Arrays.asList(children));
    }

    public static Path resolve(Path root, Collection<String> children) {
        Path path = root;
        if (!GenericUtils.isEmpty(children)) {
            for (String child : children) {
                path = path.resolve(child);
            }
        }
        return path;
    }

    public static Path detectTargetFolder(Class<?> anchor) {
        Path path = CommonTestSupportUtils.detectTargetFolder(CommonTestSupportUtils.getClassContainerLocationPath(anchor));
        if (path == null) {
            String basedir = System.getProperty("basedir");
            path = CommonTestSupportUtils.detectTargetFolder(Paths.get(basedir, "target"));
        }
        return path;
    }

    public static Path getClassContainerLocationPath(Class<?> clazz) throws IllegalArgumentException {
        try {
            URI uri = CommonTestSupportUtils.getClassContainerLocationURI(clazz);
            return CommonTestSupportUtils.toPathSource(uri);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    public static Path toPathSource(URL url) throws MalformedURLException {
        if (url == null) {
            return null;
        }
        try {
            return CommonTestSupportUtils.toPathSource(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("toFileSource(" + url.toExternalForm() + ") cannot (" + e.getClass().getSimpleName() + ") convert to URI: " + e.getMessage());
        }
    }

    public static Path toPathSource(URI uri) throws MalformedURLException {
        String src = CommonTestSupportUtils.getURLSource(uri);
        if (GenericUtils.isEmpty((CharSequence)src)) {
            return null;
        }
        if (!src.startsWith(FILE_URL_PREFIX)) {
            throw new MalformedURLException("toFileSource(" + src + ") not a '" + FILE_URL_SCHEME + "' scheme");
        }
        try {
            return Paths.get(new URI(src));
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("toFileSource(" + src + ") cannot (" + e.getClass().getSimpleName() + ") convert to URI: " + e.getMessage());
        }
    }

    public static Path detectTargetFolder(Path anchorFile) {
        for (Path file = anchorFile; file != null; file = file.getParent()) {
            String name;
            if (!Files.isDirectory(file, new LinkOption[0]) || !TARGET_FOLDER_NAMES.contains(name = Objects.toString(file.getFileName(), ""))) continue;
            return file;
        }
        return null;
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) throws GeneralSecurityException {
        KeyPairGenerator gen = SecurityUtils.getKeyPairGenerator((String)algorithm);
        if (DEFAULT_TEST_HOST_KEY_PROVIDER_ALGORITHM.equalsIgnoreCase(algorithm)) {
            ECCurves curve = ECCurves.fromCurveSize((int)keySize);
            if (curve == null) {
                throw new InvalidKeySpecException("Unknown curve for key size=" + keySize);
            }
            gen.initialize(curve.getParameters());
        } else {
            gen.initialize(keySize);
        }
        return gen.generateKeyPair();
    }

    public static KeyPairProvider createTestHostKeyProvider(Class<?> anchor) {
        KeyPairProvider provider = KEYPAIR_PROVIDER_HOLDER.get();
        if (provider != null) {
            return provider;
        }
        Path targetFolder = Objects.requireNonNull(CommonTestSupportUtils.detectTargetFolder(anchor), "Failed to detect target folder");
        Path file = targetFolder.resolve("hostkey." + DEFAULT_TEST_HOST_KEY_PROVIDER_ALGORITHM.toLowerCase());
        provider = CommonTestSupportUtils.createTestHostKeyProvider(file);
        KeyPairProvider prev = KEYPAIR_PROVIDER_HOLDER.getAndSet(provider);
        if (prev != null) {
            return prev;
        }
        return provider;
    }

    public static KeyPairProvider createTestHostKeyProvider(Path path) {
        SimpleGeneratorHostKeyProvider keyProvider = new SimpleGeneratorHostKeyProvider();
        keyProvider.setPath(Objects.requireNonNull(path, "No path"));
        keyProvider.setAlgorithm(DEFAULT_TEST_HOST_KEY_PROVIDER_ALGORITHM);
        keyProvider.setKeySize(256);
        return (KeyPairProvider)CommonTestSupportUtils.validateKeyPairProvider(keyProvider);
    }

    public static KeyPair getFirstKeyPair(KeyPairProviderHolder holder) {
        return CommonTestSupportUtils.getFirstKeyPair((KeyIdentityProvider)Objects.requireNonNull(holder, "No holder").getKeyPairProvider());
    }

    public static KeyPair getFirstKeyPair(KeyIdentityProvider provider) {
        Iterable pairs;
        Objects.requireNonNull(provider, "No key pair provider");
        try {
            pairs = Objects.requireNonNull(provider.loadKeys(null), "No loaded keys");
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Unexpected " + e.getClass().getSimpleName() + ") keys loading exception: " + e.getMessage(), e);
        }
        Iterator iter = Objects.requireNonNull(pairs.iterator(), "No keys iterator");
        ValidateUtils.checkTrue((boolean)iter.hasNext(), (String)"Empty loaded kyes iterator");
        return Objects.requireNonNull((KeyPair)iter.next(), "No key pair in iterator");
    }

    private static Path getFile(String resource) {
        URL url = CommonTestSupportUtils.class.getClassLoader().getResource(resource);
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            return Paths.get(url.getPath(), new String[0]);
        }
    }

    public static Path deleteRecursive(Path path, LinkOption ... options) throws IOException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return path;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
                for (Path child : ds) {
                    CommonTestSupportUtils.deleteRecursive(child, options);
                }
            }
        }
        try {
            if (!Files.isWritable(path)) {
                path.toFile().setWritable(true, false);
            }
            Files.delete(path);
        }
        catch (IOException e) {
            System.err.append("Failed (").append(e.getClass().getSimpleName()).append(")").append(" to delete ").append(path.toString()).append(": ").println(e.getMessage());
        }
        return path;
    }

    public static String resolveRelativeRemotePath(Path root, Path file) {
        Path relPath = root.relativize(file);
        return relPath.toString().replace(File.separatorChar, '/');
    }

    public static FileKeyPairProvider createTestKeyPairProvider(String resource) {
        Path file = CommonTestSupportUtils.getFile(resource);
        String filePath = Objects.toString(file = file.toAbsolutePath(), "");
        FileKeyPairProvider provider = PROVIDERS_MAP.get(filePath);
        if (provider != null) {
            return provider;
        }
        provider = new FileKeyPairProvider();
        provider.setPaths(Collections.singletonList(file));
        provider = CommonTestSupportUtils.validateKeyPairProvider(provider);
        FileKeyPairProvider prev = PROVIDERS_MAP.put(filePath, provider);
        if (prev != null) {
            return prev;
        }
        return provider;
    }

    public static <P extends KeyIdentityProvider> P validateKeyPairProvider(P provider) {
        Iterable keys;
        Objects.requireNonNull(provider, "No provider");
        try {
            keys = Objects.requireNonNull(provider.loadKeys(null), "No keys loaded");
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Unexpected " + e.getClass().getSimpleName() + ") keys loading exception: " + e.getMessage(), e);
        }
        if (keys instanceof Collection) {
            ValidateUtils.checkNotNullAndNotEmpty((Collection)((Collection)keys), (String)"Empty keys loaded", (Object[])new Object[0]);
        }
        return provider;
    }

    public static Random getRandomizerInstance() {
        RandomFactory factory = SecurityUtils.getRandomFactory();
        return (Random)factory.create();
    }

    public static byte[] writeFile(Path path, String data) throws IOException {
        try (OutputStream fos = Files.newOutputStream(path, IoUtils.EMPTY_OPEN_OPTIONS);){
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            fos.write(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public static Optional<Boolean> verifySignatureMatch(KeyPair kp) throws Exception {
        return CommonTestSupportUtils.verifySignatureMatch(kp.getPrivate(), kp.getPublic());
    }

    public static Optional<Boolean> verifySignatureMatch(PrivateKey privateKey, PublicKey publicKey) throws Exception {
        Objects.requireNonNull(privateKey, "No private key provided");
        Objects.requireNonNull(publicKey, "No public key provided");
        if (privateKey instanceof RSAPrivateKey) {
            return Optional.of(CommonTestSupportUtils.verifySignatureMatch(privateKey, publicKey, (Factory<? extends Signature>)BuiltinSignatures.rsa));
        }
        if (privateKey instanceof DSAPrivateKey) {
            return Optional.of(CommonTestSupportUtils.verifySignatureMatch(privateKey, publicKey, (Factory<? extends Signature>)BuiltinSignatures.dsa));
        }
        if (SecurityUtils.isECCSupported() && privateKey instanceof ECKey) {
            ECCurves curve = ECCurves.fromECKey((ECKey)((ECKey)((Object)privateKey)));
            ValidateUtils.checkNotNull((Object)curve, (String)"Unsupported EC key: %s", (Object)privateKey);
            switch (curve) {
                case nistp256: {
                    return Optional.of(CommonTestSupportUtils.verifySignatureMatch(privateKey, publicKey, (Factory<? extends Signature>)BuiltinSignatures.nistp256));
                }
                case nistp384: {
                    return Optional.of(CommonTestSupportUtils.verifySignatureMatch(privateKey, publicKey, (Factory<? extends Signature>)BuiltinSignatures.nistp384));
                }
                case nistp521: {
                    return Optional.of(CommonTestSupportUtils.verifySignatureMatch(privateKey, publicKey, (Factory<? extends Signature>)BuiltinSignatures.nistp521));
                }
            }
        } else if (SecurityUtils.isEDDSACurveSupported() && privateKey instanceof EdDSAPrivateKey) {
            return Optional.of(CommonTestSupportUtils.verifySignatureMatch(privateKey, publicKey, (Factory<? extends Signature>)BuiltinSignatures.ed25519));
        }
        return Optional.empty();
    }

    public static boolean verifySignatureMatch(PrivateKey privateKey, PublicKey publicKey, Factory<? extends Signature> factory) throws Exception {
        Signature signer = (Signature)factory.create();
        signer.initSigner(null, privateKey);
        byte[] msg = ("[" + privateKey + "][" + publicKey + "]@" + signer).getBytes(StandardCharsets.UTF_8);
        signer.update(null, msg);
        byte[] signature = signer.sign(null);
        Signature verifier = (Signature)factory.create();
        verifier.initVerifier(null, publicKey);
        verifier.update(null, msg);
        return verifier.verify(null, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSensitiveDataToFile(Path file, byte[] sensitiveData) throws IOException {
        try (SeekableByteChannel out = Files.newByteChannel(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ByteBuffer buf = ByteBuffer.wrap(sensitiveData);
            while (buf.hasRemaining()) {
                out.write(buf);
            }
        }
        finally {
            Arrays.fill(sensitiveData, (byte)0);
        }
    }
}

