/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.util.test;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyPair;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.util.test.CommonTestSupportUtils;
import org.apache.sshd.util.test.JUnit4SingleInstanceClassRunner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@RunWith(value=JUnit4SingleInstanceClassRunner.class)
public abstract class JUnitTestSupport
extends Assert {
    public static final String TEMP_SUBFOLDER_NAME = "temp";
    public static final boolean OUTPUT_DEBUG_MESSAGES = Boolean.parseBoolean(System.getProperty("org.apache.sshd.test.outputDebugMessages", "false"));
    public static final String MAIN_SUBFOLDER = "main";
    public static final String TEST_SUBFOLDER = "test";
    public static final String RESOURCES_SUBFOLDER = "resources";
    public static final org.slf4j.event.Level DEFAULT_LOGGING_LEVEL = org.slf4j.event.Level.INFO;
    public static final List<Integer> DSS_SIZES = Collections.unmodifiableList(Arrays.asList(512, 768, 1024));
    public static final List<Integer> RSA_SIZES = Collections.unmodifiableList(Arrays.asList(1024, 2048, 3072, 4096));
    public static final List<Integer> ED25519_SIZES = Collections.unmodifiableList(Arrays.asList(256));
    @Rule
    public final TestName testNameHolder = new TestName();
    private Path targetFolder;
    private Path tempFolder;

    protected JUnitTestSupport() {
        JUnitTestSupport.replaceJULLoggers();
    }

    @BeforeClass
    public static void setupRootLoggerLevel() {
        String levelName = System.getProperty("org.apache.sshd.test.root.log.level", DEFAULT_LOGGING_LEVEL.toString());
        org.slf4j.event.Level level = LoggingUtils.slf4jLevelFromName((String)levelName);
        if (level == null) {
            level = DEFAULT_LOGGING_LEVEL;
        }
        JUnitTestSupport.replaceJULLoggers();
        Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
        if (rootLogger instanceof ch.qos.logback.classic.Logger) {
            Class<?> clazz = rootLogger.getClass();
            Level rawLevel = JUnitTestSupport.getRawLoggerLevel(level);
            ((ch.qos.logback.classic.Logger)rootLogger).setLevel(rawLevel);
            rootLogger.info("Using {} logger(s) at level={}", (Object)clazz.getName(), (Object)rawLevel);
        }
    }

    public static Level getRawLoggerLevel(org.slf4j.event.Level level) {
        if (org.slf4j.event.Level.ERROR.equals((Object)level)) {
            return Level.ERROR;
        }
        if (org.slf4j.event.Level.WARN.equals((Object)level)) {
            return Level.WARN;
        }
        if (org.slf4j.event.Level.INFO.equals((Object)level)) {
            return Level.INFO;
        }
        if (org.slf4j.event.Level.DEBUG.equals((Object)level)) {
            return Level.DEBUG;
        }
        if (org.slf4j.event.Level.TRACE.equals((Object)level)) {
            return Level.TRACE;
        }
        return Level.INFO;
    }

    public final String getCurrentTestName() {
        return this.testNameHolder.getMethodName();
    }

    protected Path getTempTargetRelativeFile(String ... comps) {
        return this.getTempTargetRelativeFile(GenericUtils.isEmpty((Object[])comps) ? Collections.emptyList() : Arrays.asList(comps));
    }

    protected Path getTempTargetRelativeFile(Collection<String> comps) {
        return CommonTestSupportUtils.resolve(this.getTempTargetFolder(), comps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path getTempTargetFolder() {
        String string = TEMP_SUBFOLDER_NAME;
        synchronized (TEMP_SUBFOLDER_NAME) {
            if (this.tempFolder == null) {
                this.tempFolder = Objects.requireNonNull(this.detectTargetFolder(), "No target folder detected").resolve(TEMP_SUBFOLDER_NAME);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.tempFolder;
        }
    }

    protected Path getTargetRelativeFile(String ... comps) {
        return this.getTargetRelativeFile(GenericUtils.isEmpty((Object[])comps) ? Collections.emptyList() : Arrays.asList(comps));
    }

    protected Path getTargetRelativeFile(Collection<String> comps) {
        return CommonTestSupportUtils.resolve(this.detectTargetFolder(), comps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path detectTargetFolder() throws IllegalArgumentException {
        String string = TEMP_SUBFOLDER_NAME;
        synchronized (TEMP_SUBFOLDER_NAME) {
            if (this.targetFolder == null) {
                Path path = CommonTestSupportUtils.detectTargetFolder(((Object)((Object)this)).getClass());
                this.targetFolder = Objects.requireNonNull(path, "Failed to detect target folder");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.targetFolder;
        }
    }

    protected Path createTempClassFolder() throws IOException {
        Path tmpDir = this.getTempTargetFolder();
        return JUnitTestSupport.assertHierarchyTargetFolderExists(tmpDir.resolve(((Object)((Object)this)).getClass().getSimpleName()), new LinkOption[0]);
    }

    protected Path detectSourcesFolder() throws IllegalStateException {
        Path target = this.detectTargetFolder();
        Path parent = target.getParent();
        return parent.resolve("src");
    }

    protected Path getTestResourcesFolder() {
        Path target = this.detectTargetFolder();
        String pkgFolder = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', File.separatorChar);
        return target.resolve("test-classes").resolve(pkgFolder);
    }

    protected Path getClassResourcesFolder(String resType) {
        return this.getClassResourcesFolder(resType, ((Object)((Object)this)).getClass());
    }

    protected Path getClassResourcesFolder(String resType, Class<?> clazz) {
        return this.getPackageResourcesFolder(resType, clazz.getPackage());
    }

    protected Path getPackageResourcesFolder(String resType, Package pkg) {
        return this.getPackageResourcesFolder(resType, pkg.getName());
    }

    protected Path getPackageResourcesFolder(String resType, String pkgName) {
        Path src = this.detectSourcesFolder();
        Path root = src.resolve(resType);
        Path resources = root.resolve(RESOURCES_SUBFOLDER);
        return resources.resolve(pkgName.replace('.', File.separatorChar));
    }

    protected KeyPairProvider createTestHostKeyProvider() {
        return CommonTestSupportUtils.createTestHostKeyProvider(((Object)((Object)this)).getClass());
    }

    public static String shuffleCase(CharSequence cs) {
        if (GenericUtils.isEmpty((CharSequence)cs)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(cs.length());
        for (int index = 0; index < cs.length(); ++index) {
            char ch = cs.charAt(index);
            double v = Math.random();
            if (Double.compare(v, 0.3) < 0) {
                ch = Character.toUpperCase(ch);
            } else if (Double.compare(v, 0.3) >= 0 && Double.compare(v, 0.6) < 0) {
                ch = Character.toLowerCase(ch);
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String repeat(CharSequence csq, int nTimes) {
        if (GenericUtils.isEmpty((CharSequence)csq) || nTimes <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(nTimes * csq.length());
        for (int index = 0; index < nTimes; ++index) {
            sb.append(csq);
        }
        return sb.toString();
    }

    public static List<Object[]> parameterize(Collection<?> params) {
        if (GenericUtils.isEmpty(params)) {
            return Collections.emptyList();
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>(params.size());
        for (Object p : params) {
            result.add(new Object[]{p});
        }
        return result;
    }

    public static void assertEquals(String message, boolean expected, boolean actual) {
        JUnitTestSupport.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public static <T> void assertEquals(String message, Iterable<? extends T> expected, Iterable<? extends T> actual) {
        if (expected != actual) {
            JUnitTestSupport.assertEquals(message, expected.iterator(), actual.iterator());
        }
    }

    public static <T> void assertEquals(String message, Iterator<? extends T> expected, Iterator<? extends T> actual) {
        if (expected == actual) {
            return;
        }
        int index = 0;
        while (expected.hasNext()) {
            JUnitTestSupport.assertTrue((String)(message + "[next actual index=" + index + "]"), (boolean)actual.hasNext());
            T expValue = expected.next();
            T actValue = actual.next();
            JUnitTestSupport.assertEquals((String)(message + "[iterator index=" + index + "]"), expValue, actValue);
            ++index;
        }
        JUnitTestSupport.assertFalse((String)(message + "[non-empty-actual]"), (boolean)actual.hasNext());
    }

    public static <T> void assertFieldsEqual(String extension, T expected, T actual) throws Exception {
        Field[] fields;
        for (Field f : fields = expected.getClass().getFields()) {
            String name = f.getName();
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod)) continue;
            Object expValue = f.get(expected);
            Object actValue = f.get(actual);
            JUnitTestSupport.assertEquals((String)(extension + "[" + name + "]"), (Object)expValue, (Object)actValue);
        }
    }

    public static Path assertHierarchyTargetFolderExists(Path folder, LinkOption ... options) throws IOException {
        if (Files.exists(folder, options)) {
            JUnitTestSupport.assertTrue((String)("Target is an existing file instead of a folder: " + folder), (boolean)Files.isDirectory(folder, options));
        } else {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        return folder;
    }

    public static void assertFileContentsEquals(String prefix, Path expected, Path actual) throws IOException {
        long cmpSize = Files.size(expected);
        JUnitTestSupport.assertEquals((String)(prefix + ": Mismatched file size"), (long)cmpSize, (long)Files.size(expected));
        try (InputStream expStream = Files.newInputStream(expected, new OpenOption[0]);
             InputStream actStream = Files.newInputStream(actual, new OpenOption[0]);){
            int expLen;
            byte[] expData = new byte[8192];
            byte[] actData = new byte[expData.length];
            for (long offset = 0L; offset < cmpSize; offset += (long)expLen) {
                Arrays.fill(expData, (byte)0);
                expLen = expStream.read(expData);
                Arrays.fill(actData, (byte)0);
                int actLen = actStream.read(actData);
                JUnitTestSupport.assertEquals((String)(prefix + ": Mismatched read size at offset=" + offset), (long)expLen, (long)actLen);
                JUnitTestSupport.assertArrayEquals((String)(prefix + ": Mismatched data at offset=" + offset), (byte[])expData, (byte[])actData);
            }
        }
    }

    public static File assertHierarchyTargetFolderExists(File folder) {
        if (folder.exists()) {
            JUnitTestSupport.assertTrue((String)("Target is an existing file instead of a folder: " + folder.getAbsolutePath()), (boolean)folder.isDirectory());
        } else {
            JUnitTestSupport.assertTrue((String)("Failed to create hierarchy of " + folder.getAbsolutePath()), (boolean)folder.mkdirs());
        }
        return folder;
    }

    public static <T> T assertObjectInstanceOf(String message, Class<? extends T> expected, Object obj) {
        JUnitTestSupport.assertNotNull((String)(message + " - no actual object"), (Object)obj);
        Class<?> actual = obj.getClass();
        if (!expected.isAssignableFrom(actual)) {
            JUnitTestSupport.fail((String)(message + " - actual object type (" + actual.getName() + ") incompatible with expected (" + expected.getName() + ")"));
        }
        return expected.cast(obj);
    }

    public static <E> void assertListEquals(String message, List<? extends E> expected, List<? extends E> actual) {
        JUnitTestSupport.assertListEquals(message, expected, actual, Objects::equals);
    }

    public static <E> void assertListEquals(String message, List<? extends E> expected, List<? extends E> actual, BiPredicate<? super E, ? super E> equator) {
        int expSize = GenericUtils.size(expected);
        int actSize = GenericUtils.size(actual);
        JUnitTestSupport.assertEquals((String)(message + "[size]"), (long)expSize, (long)actSize);
        for (int index = 0; index < expSize; ++index) {
            E actValue;
            E expValue = expected.get(index);
            if (equator.test(expValue, actValue = actual.get(index))) continue;
            JUnitTestSupport.fail((String)(message + "[" + index + "]: expected=" + expValue + ", actual=" + actValue));
        }
    }

    public static <K, V> void assertMapEquals(String message, Map<? extends K, ? extends V> expected, Map<? super K, ? extends V> actual) {
        JUnitTestSupport.assertMapEquals(message, expected, actual, Objects::equals);
    }

    public static <K, V> void assertMapEquals(String message, Map<? extends K, ? extends V> expected, Map<? super K, ? extends V> actual, BiPredicate<? super V, ? super V> equator) {
        int numItems = MapEntryUtils.size(expected);
        JUnitTestSupport.assertEquals((String)(message + "[size]"), (long)numItems, (long)MapEntryUtils.size(actual));
        if (numItems > 0) {
            expected.forEach((key, expValue) -> {
                Object actValue = actual.get(key);
                if (!equator.test((Object)expValue, (Object)actValue)) {
                    JUnitTestSupport.fail((String)(message + "[" + key + "]: expected=" + expValue + ", actual=" + actValue));
                }
            });
        }
    }

    public static void assertKeyPairEquals(String message, KeyPair expected, KeyPair actual) {
        JUnitTestSupport.assertKeyEquals(message + "[public]", expected.getPublic(), actual.getPublic());
        JUnitTestSupport.assertKeyEquals(message + "[private]", expected.getPrivate(), actual.getPrivate());
    }

    public static void assertKeyEncodingEquals(String message, Key expected, Key actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[format]"), (Object)expected.getFormat(), (Object)actual.getFormat());
        JUnitTestSupport.assertArrayEquals((String)(message + "[encoded-data]"), (byte[])expected.getEncoded(), (byte[])actual.getEncoded());
    }

    public static <T extends Key> void assertKeyListEquals(String message, List<? extends T> expected, List<? extends T> actual) {
        int numKeys = GenericUtils.size(expected);
        JUnitTestSupport.assertEquals((String)(message + "[size]"), (long)numKeys, (long)GenericUtils.size(actual));
        if (numKeys <= 0) {
            return;
        }
        for (int index = 0; index < numKeys; ++index) {
            JUnitTestSupport.assertKeyEquals(message + "[#" + index + "]", (Key)expected.get(index), (Key)actual.get(index));
        }
    }

    public static <T extends Key> void assertKeyEquals(String message, T expected, T actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[algorithm]"), (Object)JUnitTestSupport.resolveEffectiveAlgorithm(expected.getAlgorithm()), (Object)JUnitTestSupport.resolveEffectiveAlgorithm(actual.getAlgorithm()));
        if (expected instanceof RSAPublicKey) {
            JUnitTestSupport.assertRSAPublicKeyEquals(message, (RSAPublicKey)RSAPublicKey.class.cast(expected), (RSAPublicKey)RSAPublicKey.class.cast(actual));
        } else if (expected instanceof DSAPublicKey) {
            JUnitTestSupport.assertDSAPublicKeyEquals(message, (DSAPublicKey)DSAPublicKey.class.cast(expected), (DSAPublicKey)DSAPublicKey.class.cast(actual));
        } else if (expected instanceof ECPublicKey) {
            JUnitTestSupport.assertECPublicKeyEquals(message, (ECPublicKey)ECPublicKey.class.cast(expected), (ECPublicKey)ECPublicKey.class.cast(actual));
        } else if (expected instanceof RSAPrivateKey) {
            JUnitTestSupport.assertRSAPrivateKeyEquals(message, (RSAPrivateKey)RSAPrivateKey.class.cast(expected), (RSAPrivateKey)RSAPrivateKey.class.cast(actual));
        } else if (expected instanceof DSAPrivateKey) {
            JUnitTestSupport.assertDSAPrivateKeyEquals(message, (DSAPrivateKey)DSAPrivateKey.class.cast(expected), (DSAPrivateKey)DSAPrivateKey.class.cast(actual));
        } else if (expected instanceof ECPrivateKey) {
            JUnitTestSupport.assertECPrivateKeyEquals(message, (ECPrivateKey)ECPrivateKey.class.cast(expected), (ECPrivateKey)ECPrivateKey.class.cast(actual));
        }
    }

    public static KeyPair validateKeyPairSignable(Object hint, KeyPair kp) throws Exception {
        JUnitTestSupport.assertNotNull((String)(hint + ": no key pair provided"), (Object)kp);
        Optional<Boolean> signable = CommonTestSupportUtils.verifySignatureMatch(kp);
        JUnitTestSupport.assertTrue((String)(hint + ": Failed to validate signature"), (boolean)signable.orElse(Boolean.TRUE));
        return kp;
    }

    public static String resolveEffectiveAlgorithm(String algorithm) {
        if (GenericUtils.isEmpty((CharSequence)algorithm)) {
            return algorithm;
        }
        if ("ECDSA".equalsIgnoreCase(algorithm)) {
            return "EC";
        }
        return algorithm.toUpperCase(Locale.ENGLISH);
    }

    public static void assertRSAPublicKeyEquals(String message, RSAPublicKey expected, RSAPublicKey actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[e]"), (Object)expected.getPublicExponent(), (Object)actual.getPublicExponent());
        JUnitTestSupport.assertEquals((String)(message + "[n]"), (Object)expected.getModulus(), (Object)actual.getModulus());
    }

    public static void assertDSAPublicKeyEquals(String message, DSAPublicKey expected, DSAPublicKey actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[y]"), (Object)expected.getY(), (Object)actual.getY());
        JUnitTestSupport.assertDSAParamsEquals(message + "[params]", expected.getParams(), actual.getParams());
    }

    public static void assertECPublicKeyEquals(String message, ECPublicKey expected, ECPublicKey actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertECPointEquals(message + "[W]", expected.getW(), actual.getW());
        JUnitTestSupport.assertECParameterSpecEquals(message, expected, actual);
    }

    public static void assertRSAPrivateKeyEquals(String message, RSAPrivateKey expected, RSAPrivateKey actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[d]"), (Object)expected.getPrivateExponent(), (Object)actual.getPrivateExponent());
        JUnitTestSupport.assertEquals((String)(message + "[n]"), (Object)expected.getModulus(), (Object)actual.getModulus());
    }

    public static void assertDSAPrivateKeyEquals(String message, DSAPrivateKey expected, DSAPrivateKey actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[x]"), (Object)expected.getX(), (Object)actual.getX());
        JUnitTestSupport.assertDSAParamsEquals(message + "[params]", expected.getParams(), actual.getParams());
    }

    public static void assertDSAParamsEquals(String message, DSAParams expected, DSAParams actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[g]"), (Object)expected.getG(), (Object)actual.getG());
        JUnitTestSupport.assertEquals((String)(message + "[p]"), (Object)expected.getP(), (Object)actual.getP());
        JUnitTestSupport.assertEquals((String)(message + "[q]"), (Object)expected.getQ(), (Object)actual.getQ());
    }

    public static void assertECPrivateKeyEquals(String message, ECPrivateKey expected, ECPrivateKey actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[S]"), (Object)expected.getS(), (Object)actual.getS());
        JUnitTestSupport.assertECParameterSpecEquals(message, expected, actual);
    }

    public static void assertECParameterSpecEquals(String message, ECKey expected, ECKey actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertECParameterSpecEquals(message, expected.getParams(), actual.getParams());
    }

    public static void assertECParameterSpecEquals(String message, ECParameterSpec expected, ECParameterSpec actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[order]"), (Object)expected.getOrder(), (Object)actual.getOrder());
        JUnitTestSupport.assertEquals((String)(message + "[cofactor]"), (long)expected.getCofactor(), (long)actual.getCofactor());
        JUnitTestSupport.assertECPointEquals(message + "[generator]", expected.getGenerator(), actual.getGenerator());
        JUnitTestSupport.assertCurveEquals(message + "[curve]", expected.getCurve(), actual.getCurve());
    }

    public static void assertCurveEquals(String message, EllipticCurve expected, EllipticCurve actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[A]"), (Object)expected.getA(), (Object)actual.getA());
        JUnitTestSupport.assertEquals((String)(message + "[B]"), (Object)expected.getB(), (Object)actual.getB());
        JUnitTestSupport.assertArrayEquals((String)(message + "[seed]"), (byte[])expected.getSeed(), (byte[])actual.getSeed());
        JUnitTestSupport.assertECFieldEquals(message + "[field]", expected.getField(), actual.getField());
    }

    public static void assertECFieldEquals(String message, ECField expected, ECField actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[size]"), (long)expected.getFieldSize(), (long)actual.getFieldSize());
    }

    public static void assertECPointEquals(String message, ECPoint expected, ECPoint actual) {
        if (expected == actual) {
            return;
        }
        JUnitTestSupport.assertEquals((String)(message + "[x]"), (Object)expected.getAffineX(), (Object)actual.getAffineX());
        JUnitTestSupport.assertEquals((String)(message + "[y]"), (Object)expected.getAffineY(), (Object)actual.getAffineY());
    }

    public static void assertFileLength(File file, long length, long timeout) throws Exception {
        JUnitTestSupport.assertFileLength(file.toPath(), length, timeout);
    }

    public static void assertFileLength(File file, long length, Duration timeout) throws Exception {
        JUnitTestSupport.assertFileLength(file.toPath(), length, timeout);
    }

    public static void assertFileLength(Path file, long length, Duration timeout) throws Exception {
        JUnitTestSupport.assertFileLength(file, length, timeout.toMillis());
    }

    public static void assertFileLength(Path file, long length, long timeout) throws Exception {
        if (JUnitTestSupport.waitForFile(file, length, timeout)) {
            return;
        }
        JUnitTestSupport.assertTrue((String)("File not found: " + file), (boolean)Files.exists(file, new LinkOption[0]));
        JUnitTestSupport.assertEquals((String)("Mismatched file size for " + file), (long)length, (long)Files.size(file));
    }

    public static boolean waitForFile(Path file, long length, Duration timeout) throws Exception {
        return JUnitTestSupport.waitForFile(file, length, timeout.toMillis());
    }

    public static boolean waitForFile(Path file, long length, long timeout) throws Exception {
        while (timeout > 0L) {
            long sleepTime = Math.min(timeout, 100L);
            if (Files.exists(file, new LinkOption[0]) && Files.size(file) == length) {
                return true;
            }
            long sleepStart = System.nanoTime();
            Thread.sleep(sleepTime);
            long sleepEnd = System.nanoTime();
            long nanoSleep = sleepEnd - sleepStart;
            sleepTime = TimeUnit.NANOSECONDS.toMillis(nanoSleep);
            if (sleepTime <= 0L) {
                timeout -= 10L;
                continue;
            }
            timeout -= sleepTime;
        }
        return false;
    }

    public static void outputDebugMessage(String format, Object o) {
        if (OUTPUT_DEBUG_MESSAGES) {
            JUnitTestSupport.outputDebugMessage(String.format(format, o));
        }
    }

    public static void outputDebugMessage(String format, Object ... args) {
        if (OUTPUT_DEBUG_MESSAGES) {
            JUnitTestSupport.outputDebugMessage(String.format(format, args));
        }
    }

    public static void outputDebugMessage(Object message) {
        if (OUTPUT_DEBUG_MESSAGES) {
            System.out.append("===[DEBUG]=== ").println(message);
        }
    }

    public static void replaceJULLoggers() {
        if (!SLF4JBridgeHandler.isInstalled()) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }
}

