/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.util.test;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutputCountTrackingOutputStream
extends FilterOutputStream {
    protected long writeCount;

    public OutputCountTrackingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.updateWriteCount(1L);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.updateWriteCount(len);
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    protected long updateWriteCount(long delta) {
        this.writeCount += delta;
        return this.writeCount;
    }
}

