/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.pgm;

import org.apache.sshd.git.pgm.GitPgmCommand;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.command.UnknownCommand;

public class GitPgmCommandFactory
implements CommandFactory {
    private final String rootDir;
    private final CommandFactory delegate;

    public GitPgmCommandFactory(String rootDir) {
        this(rootDir, null);
    }

    public GitPgmCommandFactory(String rootDir, CommandFactory delegate) {
        this.rootDir = rootDir;
        this.delegate = delegate;
    }

    public Command createCommand(String command) {
        if (command.startsWith("git ")) {
            return new GitPgmCommand(this.rootDir, command.substring("git ".length()));
        }
        if (this.delegate != null) {
            return this.delegate.createCommand(command);
        }
        return new UnknownCommand(command);
    }
}

