/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.reply;

import org.apache.sshd.common.file.SshFile;

public class FileAttributes {
    int flags = 0;
    byte type;
    long size;
    long allocationSize;
    String owner;
    String group;
    int permissions;
    long accessTime;
    int accessTimeNanos;
    long modifyTime;
    int modifyTimeNanos;
    long createTime;
    int createTimeNanos;
    String acl;
    int attribBits;
    int attribBitsValid;
    byte textHint;
    String mimeType;
    int linkCount;
    String untranslatedName;
    int extended;

    public FileAttributes() {
    }

    public FileAttributes(SshFile file, int flags) {
        if (file.isFile()) {
            this.setType((byte)1);
        } else if (file.isDirectory()) {
            this.setType((byte)2);
        } else {
            this.setType((byte)5);
        }
        if ((flags & 1) != 0) {
            this.setSize(file.getSize());
        }
        if ((flags & 4) != 0) {
            this.setPermissions((file.isReadable() ? 256 : 0) | (file.isWritable() ? 128 : 0) | (file.isExecutable() ? 64 : 0));
        }
        if ((flags & 8) != 0) {
            this.setAccessTime(file.getLastModified() / 1000L);
        }
        if ((flags & 0x10) != 0) {
            this.setCreateTime(file.getLastModified() / 1000L);
        }
        if ((flags & 0x20) != 0) {
            this.setModifyTime(file.getLastModified() / 1000L);
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.flags |= 1;
        this.size = size;
    }

    public long getAllocationSize() {
        return this.allocationSize;
    }

    public void setAllocationSize(long allocationSize) {
        this.flags |= 0x400;
        this.allocationSize = allocationSize;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setOwnerGroup(String owner, String group) {
        this.flags |= 0x80;
        this.owner = owner;
        this.group = group;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int permissions) {
        this.flags |= 4;
        this.permissions = permissions;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long accessTime) {
        this.flags |= 8;
        this.accessTime = accessTime;
    }

    public long getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(long modifyTime) {
        this.flags |= 0x20;
        this.modifyTime = modifyTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.flags |= 0x10;
        this.createTime = createTime;
    }
}

