/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.reply;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.sftp.reply.BaseReply;
import org.apache.sshd.sftp.reply.FileAttributes;
import org.apache.sshd.sftp.subsystem.SftpConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshFxpNameReply
extends BaseReply {
    private List<ReplyFile> files = new ArrayList<ReplyFile>();
    private boolean eol;

    public SshFxpNameReply(int id) {
        super(id);
    }

    @Override
    public SftpConstants.Type getMessage() {
        return SftpConstants.Type.SSH_FXP_NAME;
    }

    public String toString() {
        StringBuffer fs = new StringBuffer();
        fs.append(this.getName());
        fs.append("[");
        fs.append("\n");
        for (ReplyFile f : this.files) {
            fs.append("    ");
            fs.append(f.toString());
            fs.append(",\n");
        }
        fs.append("]");
        return fs.toString();
    }

    public void addFile(SshFile sshFile, String filename, String longname, FileAttributes attrs) {
        this.files.add(new ReplyFile(sshFile, filename, longname, attrs));
    }

    public Collection<ReplyFile> getFiles() {
        return this.files;
    }

    public boolean isEol() {
        return this.eol;
    }

    public void setEol(boolean eol) {
        this.eol = eol;
    }

    public static class ReplyFile {
        private final SshFile file;
        private final String fileName;
        private final String longName;
        private final FileAttributes attrs;

        public ReplyFile(SshFile file, String fileName, String longName, FileAttributes attrs) {
            this.file = file;
            this.fileName = fileName;
            this.longName = longName;
            this.attrs = attrs;
        }

        public SshFile getFile() {
            return this.file;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getLongName() {
            return this.longName;
        }

        public FileAttributes getAttrs() {
            return this.attrs;
        }

        public String toString() {
            return "fileName=" + this.fileName + ", longName=" + this.longName;
        }
    }
}

