/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.reply;

import java.io.IOException;
import org.apache.sshd.sftp.reply.BaseReply;
import org.apache.sshd.sftp.subsystem.SftpConstants;

public class SshFxpStatusReply
extends BaseReply {
    private String substatusAsSTR;
    private String msg;
    private String lang;
    private final int substatus;

    public SshFxpStatusReply(int id, int substatus, String msg) throws IOException {
        this(id, substatus, msg, "");
    }

    public SshFxpStatusReply(int id, int substatus, String msg, String lang) throws IOException {
        super(id);
        this.substatus = substatus;
        this.lang = lang;
        this.msg = msg;
        switch (substatus) {
            case 11: {
                this.substatusAsSTR = "SSH_FX_FILE_ALREADY_EXISTS";
                break;
            }
            case 18: {
                this.substatusAsSTR = "SSH_FX_DIR_NOT_EMPTY";
                break;
            }
            case 1: {
                this.substatusAsSTR = "SSH_FX_EOF";
                break;
            }
            case 24: {
                this.substatusAsSTR = "SSH_FX_FILE_IS_A_DIRECTORY";
                break;
            }
            case 9: {
                this.substatusAsSTR = "SSH_FX_INVALID_HANDLE";
                break;
            }
            case 2: {
                this.substatusAsSTR = "SSH_FX_NO_SUCH_FILE";
                break;
            }
            case 10: {
                this.substatusAsSTR = "SSH_FX_NO_SUCH_PATH";
                break;
            }
            case 19: {
                this.substatusAsSTR = "SSH_FX_NOT_A_DIRECTORY";
                break;
            }
            case 0: {
                this.substatusAsSTR = "SSH_FX_OK";
                break;
            }
            case 8: {
                this.substatusAsSTR = "SSH_FX_OP_UNSUPPORTED";
                break;
            }
            case 4: {
                this.substatusAsSTR = "SSH_FX_FAILURE";
                break;
            }
            case 3: {
                this.substatusAsSTR = "SSH_FX_PERMISSION_DENIED";
                break;
            }
            case 14: {
                this.substatusAsSTR = "SSH_FXP_MKDIR";
                break;
            }
            case 13: {
                this.substatusAsSTR = "SSH_FXP_REMOVE";
                break;
            }
            case 15: {
                this.substatusAsSTR = "SSH_FXP_RMDIR";
                break;
            }
            case 12: {
                this.substatusAsSTR = "SSH_FX_WRITE_PROTECT";
                break;
            }
            default: {
                throw new IOException("Internal error - unexpected substatus: " + substatus);
            }
        }
    }

    public int getSubstatus() {
        return this.substatus;
    }

    public String toString() {
        return this.getName() + "[status=" + this.substatusAsSTR + ", msg=" + this.msg + "]";
    }

    public SftpConstants.Type getMessage() {
        return SftpConstants.Type.SSH_FXP_STATUS;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getLang() {
        return this.lang;
    }
}

