/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.subsystem;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.sftp.subsystem.BaseHandle;

public class FileHandle
extends BaseHandle {
    int flags;
    OutputStream output;
    long outputPos;
    InputStream input;
    long inputPos;
    long length;

    public FileHandle(String id, SshFile sshFile, int flags) {
        super(id, sshFile);
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public int read(byte[] data, long offset) throws IOException {
        if (this.input != null && offset >= this.length) {
            return -1;
        }
        if (this.input != null && offset != this.inputPos) {
            IoUtils.closeQuietly((Closeable[])new Closeable[]{this.input});
            this.input = null;
        }
        if (this.input == null) {
            this.input = this.getFile().createInputStream(offset);
            this.length = this.getFile().getSize();
            this.inputPos = offset;
        }
        if (offset >= this.length) {
            return -1;
        }
        int read = this.input.read(data);
        this.inputPos += (long)read;
        return read;
    }

    public void write(byte[] data, long offset) throws IOException {
        if (this.output != null && offset != this.outputPos) {
            IoUtils.closeQuietly((Closeable[])new Closeable[]{this.output});
            this.output = null;
        }
        if (this.output == null) {
            this.output = this.getFile().createOutputStream(offset);
        }
        this.output.write(data);
        this.outputPos += (long)data.length;
    }

    public void close() throws IOException {
        IoUtils.closeQuietly((Closeable[])new Closeable[]{this.output, this.input});
        this.output = null;
        this.input = null;
        super.close();
    }
}

