/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.opennlp;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.stanbol.commons.opennlp.PosTypeCollectionType;

public enum PosTagsCollectionEnum {
    EN_NOUN("en", PosTypeCollectionType.NOUN, "NN", "NNP", "NNPS", "NNS", "FW", "CD", "``"),
    EN_VERB("en", PosTypeCollectionType.VERB, "VB", "VBD", "VBG", "VBN", "VBP", "VBZ"),
    EN_FOLLOW("en", PosTypeCollectionType.FOLLOW, "#", "$", " ", "(", ")", ",", ".", ":", "POS", "IN", "JJ"),
    DE_NOUN("de", PosTypeCollectionType.NOUN, "NN", "NE", "FM", "XY"),
    DE_VERB("de", PosTypeCollectionType.VERB, "VVFIN", "VVIMP", "VVINF", "VVIZU", "VVPP", "VAFIN", "VAIMP", "VAINF", "VAPP", "VMFIN", "VMINF", "VMPP"),
    DE_FOLLOW("de", PosTypeCollectionType.FOLLOW, "$.", "$,", "$(", "APPR"),
    DA_NOUN("da", PosTypeCollectionType.NOUN, "N", "NP", "NC", "AC", "XX", "XR"),
    DA_VERB("da", PosTypeCollectionType.VERB, "V", "VA", "VE"),
    DA_FOLLOW("da", PosTypeCollectionType.FOLLOW, "XP", "XA", "SP", "CS", "CC", "U"),
    PT_NOUN("pt", PosTypeCollectionType.NOUN, "n", "num", "prop", "vp"),
    PT_VERB("pt", PosTypeCollectionType.VERB, "v-pcp", "v-fin", "v-inf", "v-ger"),
    PT_FOLLOW("pt", PosTypeCollectionType.FOLLOW, "punc", "prp"),
    NL_NOUN("nl", PosTypeCollectionType.NOUN, "N", "Num", "Misc"),
    NL_VERB("nl", PosTypeCollectionType.VERB, "V"),
    NL_FOLLOW("nl", PosTypeCollectionType.FOLLOW, "Punc", "Prep"),
    SV_NOUN("sv", PosTypeCollectionType.NOUN, "NN", "PN", "AN", "MN", "VN", "XX", "RO"),
    SV_VERB("sv", PosTypeCollectionType.VERB, "MV", "AV", "BV", "FV", "GV", "HV", "KV", "QV", "SV", "VV", "WV"),
    SV_FOLLOW("sv", PosTypeCollectionType.FOLLOW, "PR", "ID", "IM", "I?", "IC", "IG", "IK", "IP", "IQ", "IR", "IS", "IT", "IU");

    Set<String> tags;
    private String language;
    private PosTypeCollectionType type;
    private static final Map<CollectionType, PosTagsCollectionEnum> tagCollections;

    private PosTagsCollectionEnum(String lang, PosTypeCollectionType type, String ... tags) {
        this.tags = new HashSet<String>(Arrays.asList(tags));
        this.language = lang;
        this.type = type;
    }

    public final Set<String> getTags() {
        return this.tags;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final PosTypeCollectionType getType() {
        return this.type;
    }

    public static Set<String> getPosTagCollection(String lang, PosTypeCollectionType type) {
        PosTagsCollectionEnum collection = tagCollections.get(new CollectionType(lang, type));
        return collection == null ? null : collection.getTags();
    }

    static {
        HashMap<CollectionType, PosTagsCollectionEnum> tcm = new HashMap<CollectionType, PosTagsCollectionEnum>();
        for (PosTagsCollectionEnum collection : PosTagsCollectionEnum.values()) {
            CollectionType type = new CollectionType(collection.getLanguage(), collection.getType());
            if (tcm.put(type, collection) == null) continue;
            throw new IllegalStateException("The PosTagsCollectionEnum containsMultiple POS tags collections for the Language '" + collection.getLanguage() + "' and POS tag type '" + (Object)((Object)collection.getType()) + "'!");
        }
        tagCollections = Collections.unmodifiableMap(tcm);
    }

    private static class CollectionType {
        protected String lang;
        protected PosTypeCollectionType type;

        private CollectionType(String lang, PosTypeCollectionType type) {
            this.lang = lang;
            this.type = type;
        }

        public int hashCode() {
            return this.lang.hashCode() + this.type.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof CollectionType && ((CollectionType)obj).lang.equals(this.lang) && ((CollectionType)obj).type == this.type;
        }
    }
}

