/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.web.sparql.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.core.sparql.ParseException;
import org.apache.clerezza.rdf.core.sparql.QueryParser;
import org.apache.clerezza.rdf.core.sparql.query.ConstructQuery;
import org.apache.clerezza.rdf.core.sparql.query.DescribeQuery;
import org.apache.clerezza.rdf.core.sparql.query.Query;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@Path(value="/sparql")
public class SparqlEndpointResource
extends BaseStanbolResource {
    private static final Comparator<ServiceReference> SERVICE_RANKING_COMPARATOR = new Comparator<ServiceReference>(){

        @Override
        public int compare(ServiceReference ref1, ServiceReference ref2) {
            int r2;
            Object tmp = ref1.getProperty("service.ranking");
            int r1 = tmp != null ? (Integer)tmp : 0;
            tmp = (Integer)ref2.getProperty("service.ranking");
            int n = r2 = tmp != null ? (Integer)tmp : 0;
            if (r1 == r2) {
                long id2;
                tmp = (Long)ref1.getProperty("service.id");
                long id1 = tmp != null ? (Long)tmp : Long.MAX_VALUE;
                tmp = (Long)ref2.getProperty("service.id");
                long l = id2 = tmp != null ? (Long)tmp : Long.MAX_VALUE;
                return id1 < id2 ? -1 : (id2 == id1 ? 0 : 1);
            }
            return r1 < r2 ? 1 : -1;
        }
    };
    private ServletContext servletContext;
    protected TcManager tcManager;
    private static final String GRAPH_URI = "graph.uri";
    private List<TripleCollectionInfo> tripleCollections = new ArrayList<TripleCollectionInfo>();

    public SparqlEndpointResource(@Context ServletContext servletContext) {
        this.tcManager = (TcManager)ContextHelper.getServiceFromContext(TcManager.class, (ServletContext)servletContext);
        this.servletContext = servletContext;
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html;qs=2", "application/sparql-results+xml", "application/rdf+xml"})
    public Response sparql(@QueryParam(value="graphuri") String graphUri, @QueryParam(value="query") String sparqlQuery, @Context HttpHeaders headers) throws ParseException, InvalidSyntaxException {
        Response.ResponseBuilder rb;
        TripleCollection tripleCollection;
        if (sparqlQuery == null) {
            this.populateTripleCollectionList(this.getServices(null));
            return Response.ok((Object)new Viewable("index", (Object)this), (String)"text/html").build();
        }
        Query query = QueryParser.getInstance().parse(sparqlQuery);
        String mediaType = "application/sparql-results+xml";
        if (query instanceof DescribeQuery || query instanceof ConstructQuery) {
            mediaType = "application/rdf+xml";
        }
        if ((tripleCollection = this.getTripleCollection(graphUri)) != null) {
            Object result = this.tcManager.executeSparqlQuery(query, tripleCollection);
            rb = Response.ok((Object)result, (String)mediaType);
        } else {
            rb = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("There is no registered graph with given uri: %s", graphUri));
        }
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/sparql-results+xml", "application/rdf+xml"})
    public Response postSparql(@FormParam(value="graphuri") String graphUri, @FormParam(value="query") String sparqlQuery, @Context HttpHeaders headers) throws ParseException, InvalidSyntaxException {
        return this.sparql(graphUri, sparqlQuery, headers);
    }

    private TripleCollection getTripleCollection(String graphUri) throws InvalidSyntaxException {
        LinkedHashMap<ServiceReference, TripleCollection> services = this.getServices(graphUri);
        if (services != null && services.size() > 0) {
            return services.get(services.keySet().iterator().next());
        }
        return null;
    }

    private void populateTripleCollectionList(LinkedHashMap<ServiceReference, TripleCollection> services) {
        if (services != null) {
            for (ServiceReference service : services.keySet()) {
                Object graphUri = service.getProperty(GRAPH_URI);
                if (service.getProperty(GRAPH_URI) instanceof UriRef) {
                    graphUri = ((UriRef)graphUri).getUnicodeString();
                }
                Object graphName = service.getProperty("graph.name");
                Object graphDescription = service.getProperty("graph.description");
                if (!(graphUri instanceof String) || !(graphName instanceof String) || !(graphDescription instanceof String)) continue;
                this.tripleCollections.add(new TripleCollectionInfo((String)graphUri, (String)graphName, (String)graphDescription));
            }
        }
    }

    private LinkedHashMap<ServiceReference, TripleCollection> getServices(String graphUri) throws InvalidSyntaxException {
        LinkedHashMap<ServiceReference, TripleCollection> registeredGraphs = new LinkedHashMap<ServiceReference, TripleCollection>();
        BundleContext bundleContext = ContextHelper.getBundleContext((ServletContext)this.servletContext);
        ServiceReference[] refs = bundleContext.getServiceReferences(TripleCollection.class.getName(), this.getFilter(graphUri));
        if (refs != null) {
            if (refs.length > 1) {
                Arrays.sort(refs, SERVICE_RANKING_COMPARATOR);
            }
            for (ServiceReference ref : refs) {
                registeredGraphs.put(ref, (TripleCollection)bundleContext.getService(ref));
            }
        }
        return registeredGraphs;
    }

    private String getFilter(String graphUri) {
        StringBuilder filterString;
        String constraint = "(%s=%s)";
        if (graphUri != null) {
            filterString = new StringBuilder("(&");
            filterString.append(String.format(constraint, GRAPH_URI, graphUri));
        } else {
            filterString = new StringBuilder();
        }
        filterString.append(String.format(constraint, "objectClass", TripleCollection.class.getName()));
        if (graphUri != null) {
            filterString.append(')');
        }
        return filterString.toString();
    }

    public List<TripleCollectionInfo> getTripleCollectionList() {
        return this.tripleCollections;
    }

    public class TripleCollectionInfo {
        private String graphUri;
        private String graphName;
        private String graphDescription;

        public TripleCollectionInfo(String graphUri, String graphName, String graphDescription) {
            this.graphUri = graphUri;
            this.graphName = graphName != null ? graphName : "";
            this.graphDescription = graphDescription != null ? graphDescription : "";
        }

        public String getGraphUri() {
            return this.graphUri;
        }

        public String getGraphName() {
            return this.graphName;
        }

        public String getGraphDescription() {
            return this.graphDescription;
        }
    }
}

