/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.commons.web.sparql.resource;

import com.sun.jersey.api.view.Viewable;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.core.sparql.ParseException;
import org.apache.clerezza.rdf.core.sparql.QueryParser;
import org.apache.clerezza.rdf.core.sparql.query.ConstructQuery;
import org.apache.clerezza.rdf.core.sparql.query.DescribeQuery;
import org.apache.clerezza.rdf.core.sparql.query.Query;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.contenthub.servicesapi.store.Store;
import org.apache.stanbol.enhancer.servicesapi.SparqlQueryEngine;

@Path(value="/sparql")
public class SparqlEndpointResource
extends BaseStanbolResource {
    protected Store store;
    protected TcManager tcManager;

    public SparqlEndpointResource(@Context ServletContext ctx) {
        this.tcManager = (TcManager)ContextHelper.getServiceFromContext(TcManager.class, (ServletContext)ctx);
        this.store = (Store)ContextHelper.getServiceFromContext(Store.class, (ServletContext)ctx);
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html;qs=2", "application/sparql-results+xml", "application/rdf+xml", "application/xml"})
    public Response sparql(@QueryParam(value="query") String sparqlQuery, @Context HttpHeaders headers) throws SparqlQueryEngine.SparqlQueryEngineException, ParseException {
        if (sparqlQuery == null) {
            return Response.ok((Object)new Viewable("index", (Object)this), (String)"text/html").build();
        }
        Query query = QueryParser.getInstance().parse(sparqlQuery);
        String mediaType = "application/sparql-results+xml";
        if (query instanceof DescribeQuery || query instanceof ConstructQuery) {
            mediaType = "application/rdf+xml";
        }
        Object result = this.tcManager.executeSparqlQuery(query, (TripleCollection)this.store.getEnhancementGraph());
        Response.ResponseBuilder rb = Response.ok((Object)result, (String)mediaType);
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/sparql-results+xml", "application/rdf+xml", "application/xml"})
    public Response postSparql(@FormParam(value="query") String sparqlQuery, @Context HttpHeaders headers) throws SparqlQueryEngine.SparqlQueryEngineException, ParseException {
        return this.sparql(sparqlQuery, headers);
    }
}

