/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.search.related.ontologyresource;

import com.hp.hpl.jena.query.Query;

public final class QueryFactory {
    private static final String OWL = "PREFIX owl: <http://www.w3.org/2002/07/owl#>";
    private static final String RDF = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>";
    private static final String PF = "PREFIX pf: <http://jena.hpl.hp.com/ARQ/property#>";
    private static final String SEARCH = "PREFIX ss: <http://stanbol.apache.org/contenthub/search/>";
    private static final String CMS = "PREFIX cms: <http://www.apache.org/stanbol/cms#>";

    public static final Query getClassQuery(String keyword) {
        StringBuilder sb = new StringBuilder();
        sb.append(RDF).append("\n");
        sb.append(OWL).append("\n");
        sb.append(PF).append("\n");
        sb.append(SEARCH).append("\n");
        sb.append("SELECT ?class ?score WHERE {\n");
        sb.append("\t?class rdf:type owl:Class.\n");
        sb.append("\t?class ss:hasLocalName ?name.\n");
        sb.append("\t(?name ?score) pf:textMatch '+" + QueryFactory.normalizeKeyword(keyword) + "'.\n");
        sb.append("}");
        return com.hp.hpl.jena.query.QueryFactory.create((String)sb.toString());
    }

    public static final Query getIndividualQuery(String keyword) {
        StringBuilder sb = new StringBuilder();
        sb.append(RDF).append("\n");
        sb.append(OWL).append("\n");
        sb.append(PF).append("\n");
        sb.append(SEARCH).append("\n");
        sb.append("SELECT ?individual ?score WHERE {\n");
        sb.append("\t?individual rdf:type ?type.\n");
        sb.append("\t?type  rdf:type owl:Class.\n");
        sb.append("\t?individual ss:hasLocalName ?name.\n");
        sb.append("\t(?name ?score) pf:textMatch '+" + QueryFactory.normalizeKeyword(keyword) + "'.\n");
        sb.append("}");
        return com.hp.hpl.jena.query.QueryFactory.create((String)sb.toString());
    }

    public static final Query getCMSObjectQuery(String keyword) {
        StringBuilder sb = new StringBuilder();
        sb.append(RDF).append("\n");
        sb.append(OWL).append("\n");
        sb.append(PF).append("\n");
        sb.append(SEARCH).append("\n");
        sb.append(CMS).append("\n");
        sb.append("SELECT ?cmsobject ?score WHERE {\n");
        sb.append("\t?cmsobject rdf:type cms:CMSObject.\n");
        sb.append("\t?cmsobject ss:hasLocalName ?name.\n");
        sb.append("\t(?name ?score) pf:textMatch '+" + QueryFactory.normalizeKeyword(keyword) + "'.\n");
        sb.append("}");
        return com.hp.hpl.jena.query.QueryFactory.create((String)sb.toString());
    }

    private static String normalizeKeyword(String keyword) {
        if (!keyword.endsWith("*")) {
            keyword = keyword + "*";
        }
        return keyword.replace("'", "");
    }
}

