/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.search.related.ontologyresource;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;
import org.apache.stanbol.contenthub.servicesapi.Constants;

public class IndexingHelper {
    public static final Property HAS_LOCAL_NAME = IndexingHelper.property("hasLocalName");

    private static Property property(String local) {
        return ResourceFactory.createProperty((String)"http://stanbol.apache.org/contenthub/search/", (String)local);
    }

    public static void addIndexPropertyToOntResources(OntModel model) {
        for (OntClass klass : model.listClasses().toList()) {
            if (klass == null || klass.isAnon()) continue;
            klass.addProperty(HAS_LOCAL_NAME, klass.getLocalName());
        }
        for (OntResource ind : model.listIndividuals().toList()) {
            if (ind == null || ind.isAnon()) continue;
            ind.addProperty(HAS_LOCAL_NAME, ind.getLocalName());
        }
        Resource cmsObject = ResourceFactory.createResource((String)Constants.CMS_OBJECT.getUnicodeString());
        List cmsOBjects = model.listStatements(null, RDF.type, (RDFNode)cmsObject).toList();
        for (Statement stmt : cmsOBjects) {
            Resource subject = stmt.getSubject();
            String name = IndexingHelper.getCMSObjectName(subject);
            if (name.equals("")) continue;
            Statement s = ResourceFactory.createStatement((Resource)subject, (Property)HAS_LOCAL_NAME, (RDFNode)ResourceFactory.createPlainLiteral((String)name));
            model.add(s);
        }
    }

    public static String getCMSObjectName(Resource subject) {
        String name = "";
        Property cmsNameProp = ResourceFactory.createProperty((String)Constants.CMS_OBJECT_NAME.getUnicodeString());
        if (subject.hasProperty(cmsNameProp)) {
            name = subject.getProperty(cmsNameProp).getString();
        }
        return name;
    }
}

