/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.search.related;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.stanbol.contenthub.search.related.RelatedKeywordSearchResult;
import org.apache.stanbol.contenthub.search.related.ontologyresource.OntologyResourceSearch;
import org.apache.stanbol.contenthub.search.related.referencedsite.ReferencedSiteSearch;
import org.apache.stanbol.contenthub.servicesapi.search.SearchException;
import org.apache.stanbol.contenthub.servicesapi.search.featured.SearchResult;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeyword;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeywordSearch;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeywordSearchManager;

public class RelatedKeywordSearchManagerImpl
implements RelatedKeywordSearchManager {
    private List<RelatedKeywordSearch> rkwSearchers = new CopyOnWriteArrayList<RelatedKeywordSearch>();

    protected void bindRelatedKeywordSearch(RelatedKeywordSearch relatedKeywordSearch) {
        this.rkwSearchers.add(relatedKeywordSearch);
    }

    protected void unbindRelatedKeywordSearch(RelatedKeywordSearch relatedKeywordSearch) {
        this.rkwSearchers.remove(relatedKeywordSearch);
    }

    public SearchResult getRelatedKeywordsFromAllSources(String keyword) throws SearchException {
        return this.getRelatedKeywordsFromAllSources(keyword, null);
    }

    public SearchResult getRelatedKeywordsFromAllSources(String keyword, String ontologyURI) throws SearchException {
        HashMap relatedKeywords = new HashMap();
        for (RelatedKeywordSearch searcher : this.rkwSearchers) {
            relatedKeywords.putAll(searcher.search(keyword, ontologyURI));
        }
        HashMap<String, Map<String, List<RelatedKeyword>>> relatedKeywordsMap = new HashMap<String, Map<String, List<RelatedKeyword>>>();
        relatedKeywordsMap.put(keyword, relatedKeywords);
        return new RelatedKeywordSearchResult(relatedKeywordsMap);
    }

    private SearchResult getRelatedKeywordsFrom(String keyword, Class<? extends RelatedKeywordSearch> cls, String ... ontologyURI) throws SearchException {
        HashMap relatedKeywords = new HashMap();
        for (RelatedKeywordSearch searcher : this.rkwSearchers) {
            if (!cls.isAssignableFrom(searcher.getClass())) continue;
            if (ontologyURI != null && ontologyURI.length > 0) {
                relatedKeywords.putAll(searcher.search(keyword, ontologyURI[0]));
                break;
            }
            relatedKeywords.putAll(searcher.search(keyword));
            break;
        }
        HashMap<String, Map<String, List<RelatedKeyword>>> relatedKeywordsMap = new HashMap<String, Map<String, List<RelatedKeyword>>>();
        relatedKeywordsMap.put(keyword, relatedKeywords);
        return new RelatedKeywordSearchResult(relatedKeywordsMap);
    }

    public SearchResult getRelatedKeywordsFromOntology(String keyword, String ontologyURI) throws SearchException {
        return this.getRelatedKeywordsFrom(keyword, OntologyResourceSearch.class, ontologyURI);
    }

    public SearchResult getRelatedKeywordsFromReferencedSites(String keyword) throws SearchException {
        return this.getRelatedKeywordsFrom(keyword, ReferencedSiteSearch.class, new String[0]);
    }
}

