/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.contenthub.servicesapi.ldpath.LDProgramCollection;
import org.apache.stanbol.contenthub.web.util.JSONUtils;
import org.apache.stanbol.contenthub.web.util.RestUtil;
import org.codehaus.jettison.json.JSONException;

@Provider
public class LDProgramCollectionWriter
implements MessageBodyWriter<LDProgramCollection> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String mediaTypeString = mediaType.getType() + '/' + mediaType.getSubtype();
        return LDProgramCollection.class.isAssignableFrom(type) && RestUtil.supportedMediaTypes.contains(mediaTypeString);
    }

    public long getSize(LDProgramCollection t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(LDProgramCollection t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String mediaTypeString = mediaType.getType() + '/' + mediaType.getSubtype();
        String encoding = (String)mediaType.getParameters().get("charset");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if ("application/json".equals(mediaTypeString)) {
            try {
                String jsonstr = JSONUtils.createJSONString(t);
                IOUtils.write((String)jsonstr, (OutputStream)entityStream, (String)encoding);
            }
            catch (JSONException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
    }
}

