/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.rdf.core.Language;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.PlainLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.core.serializedform.Serializer;
import org.apache.clerezza.rdf.core.sparql.ParseException;
import org.apache.clerezza.rdf.ontologies.RDF;
import org.apache.commons.lang.StringUtils;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EnhancementException;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;
import org.apache.stanbol.enhancer.servicesapi.helper.ContentItemHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionMetadataHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.execution.ChainExecution;
import org.apache.stanbol.enhancer.servicesapi.helper.execution.Execution;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionMetadata;
import org.apache.stanbol.enhancer.servicesapi.rdf.OntologicalClasses;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;
import org.apache.stanbol.enhancer.servicesapi.rdf.TechnicalClasses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentItemResource
extends BaseStanbolResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final UriRef SUMMARY = new UriRef("http://www.w3.org/2000/01/rdf-schema#comment");
    public static final UriRef THUMBNAIL = new UriRef("http://dbpedia.org/ontology/thumbnail");
    public static final UriRef DEPICTION = new UriRef("http://xmlns.com/foaf/0.1/depiction");
    public final Map<UriRef, String> defaultThumbnails = new HashMap<UriRef, String>();
    protected ContentItem contentItem;
    protected String localId;
    protected String textContent;
    protected URI imageSrc;
    protected URI downloadHref;
    protected URI metadataHref;
    protected final Serializer serializer;
    protected String serializationFormat = "application/rdf+xml";
    protected DateFormat format = new SimpleDateFormat("HH-mm-ss.SSS");
    protected Map<UriRef, Map<EntityExtractionSummary, EntityExtractionSummary>> extractionsByTypeMap = new HashMap<UriRef, Map<EntityExtractionSummary, EntityExtractionSummary>>();
    private MGraph executionMetadata;
    private ChainExecution chainExecution;
    private ArrayList<Execution> engineExecutions;
    private EnhancementException enhancementException;

    public ContentItemResource(String localId, ContentItem ci, UriInfo uriInfo, String storePath, Serializer serializer, ServletContext servletContext, EnhancementException enhancementException) throws IOException {
        this.contentItem = ci;
        this.localId = localId;
        this.uriInfo = uriInfo;
        this.serializer = serializer;
        this.servletContext = servletContext;
        this.enhancementException = enhancementException;
        if (localId != null) {
            URI rawURI = uriInfo.getBaseUriBuilder().path(storePath).path("raw").path(localId).build(new Object[0]);
            Map.Entry plainTextContentPart = ContentItemHelper.getBlob((ContentItem)this.contentItem, Collections.singleton("text/plain"));
            if (plainTextContentPart != null) {
                this.textContent = ContentItemHelper.getText((Blob)((Blob)plainTextContentPart.getValue()));
            }
            if (ci.getMimeType().startsWith("image/")) {
                this.imageSrc = rawURI;
            }
            this.downloadHref = rawURI;
            this.metadataHref = uriInfo.getBaseUriBuilder().path(storePath).path("metadata").path(localId).build(new Object[0]);
        }
        this.defaultThumbnails.put(OntologicalClasses.DBPEDIA_PERSON, this.getStaticRootUrl() + "/home/images/user_48.png");
        this.defaultThumbnails.put(OntologicalClasses.DBPEDIA_ORGANISATION, this.getStaticRootUrl() + "/home/images/organization_48.png");
        this.defaultThumbnails.put(OntologicalClasses.DBPEDIA_PLACE, this.getStaticRootUrl() + "/home/images/compass_48.png");
        this.defaultThumbnails.put(OntologicalClasses.SKOS_CONCEPT, this.getStaticRootUrl() + "/home/images/black_gear_48.png");
        this.defaultThumbnails.put(null, this.getStaticRootUrl() + "/home/images/unknown_48.png");
        long start = System.currentTimeMillis();
        if (enhancementException == null) {
            this.initOccurrences();
        }
        try {
            this.executionMetadata = (MGraph)ci.getPart(ExecutionMetadata.CHAIN_EXECUTION, MGraph.class);
        }
        catch (NoSuchPartException e) {
            this.executionMetadata = null;
        }
        if (this.executionMetadata != null) {
            NonLiteral ce = ExecutionMetadataHelper.getChainExecution((TripleCollection)this.executionMetadata, (UriRef)ci.getUri());
            if (ce != null) {
                this.chainExecution = new ChainExecution((TripleCollection)this.executionMetadata, ce);
                this.engineExecutions = new ArrayList();
                for (NonLiteral ex : ExecutionMetadataHelper.getExecutions((TripleCollection)this.executionMetadata, (NonLiteral)ce)) {
                    this.engineExecutions.add(new Execution(this.chainExecution, (TripleCollection)this.executionMetadata, ex));
                }
                Collections.sort(this.engineExecutions);
            } else {
                this.chainExecution = null;
                this.engineExecutions = null;
            }
        }
        this.log.info(" ... {}ms fro parsing Enhancement Reuslts", (Object)(System.currentTimeMillis() - start));
    }

    public String getRdfMetadata(String mediatype) throws UnsupportedEncodingException {
        if (this.enhancementException == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.serializer.serialize((OutputStream)out, (TripleCollection)this.contentItem.getMetadata(), mediatype);
            return out.toString("utf-8");
        }
        StringWriter writer = new StringWriter();
        this.enhancementException.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public String getRdfMetadata() throws UnsupportedEncodingException {
        return this.getRdfMetadata(this.serializationFormat);
    }

    public ContentItem getContentItem() {
        return this.contentItem;
    }

    public String getLocalId() {
        return this.localId;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public URI getImageSrc() {
        return this.imageSrc;
    }

    public URI getDownloadHref() {
        return this.downloadHref;
    }

    public URI getMetadataHref() {
        return this.metadataHref;
    }

    public boolean hasOccurrences() {
        for (Map<EntityExtractionSummary, EntityExtractionSummary> occ : this.extractionsByTypeMap.values()) {
            if (occ.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Collection<UriRef> getOtherOccurrencyTypes() {
        HashSet<UriRef> types = new HashSet<UriRef>(this.extractionsByTypeMap.keySet());
        types.remove(OntologicalClasses.DBPEDIA_PERSON);
        types.remove(OntologicalClasses.DBPEDIA_ORGANISATION);
        types.remove(OntologicalClasses.DBPEDIA_PLACE);
        types.remove(OntologicalClasses.SKOS_CONCEPT);
        types.remove(null);
        return types;
    }

    public String extractLabel(UriRef uri) {
        String fullUri = uri.getUnicodeString();
        int index = Math.max(fullUri.lastIndexOf(35), fullUri.lastIndexOf(47));
        if ((index = Math.max(index, fullUri.lastIndexOf(58))) > 0 && index + 1 < fullUri.length()) {
            return StringUtils.capitalize((String)fullUri.substring(index + 1).replaceAll("[\\-_]", " "));
        }
        return uri.getUnicodeString();
    }

    public Collection<EntityExtractionSummary> getOccurrences(UriRef type) {
        Map<EntityExtractionSummary, EntityExtractionSummary> typeMap = this.extractionsByTypeMap.get(type);
        Collection<Object> typeOccurrences = typeMap != null ? typeMap.values() : Collections.emptyList();
        return typeOccurrences;
    }

    public Collection<EntityExtractionSummary> getPersonOccurrences() throws ParseException {
        return this.getOccurrences(OntologicalClasses.DBPEDIA_PERSON);
    }

    public Collection<EntityExtractionSummary> getOtherOccurrences() throws ParseException {
        return this.getOccurrences(null);
    }

    public Collection<EntityExtractionSummary> getOrganizationOccurrences() throws ParseException {
        return this.getOccurrences(OntologicalClasses.DBPEDIA_ORGANISATION);
    }

    public Collection<EntityExtractionSummary> getPlaceOccurrences() throws ParseException {
        return this.getOccurrences(OntologicalClasses.DBPEDIA_PLACE);
    }

    public Collection<EntityExtractionSummary> getConceptOccurrences() throws ParseException {
        return this.getOccurrences(OntologicalClasses.SKOS_CONCEPT);
    }

    private void initOccurrences() {
        MGraph graph = this.contentItem.getMetadata();
        LiteralFactory lf = LiteralFactory.getInstance();
        HashMap<UriRef, ArrayList<NonLiteral>> suggestionMap = new HashMap<UriRef, ArrayList<NonLiteral>>();
        HashMap entitySuggestionMap = new HashMap();
        Iterator entityAnnotations = graph.filter(null, RDF.type, (Resource)TechnicalClasses.ENHANCER_ENTITYANNOTATION);
        while (entityAnnotations.hasNext()) {
            NonLiteral entityAnnotation = ((Triple)entityAnnotations.next()).getSubject();
            EnumMap<EAProps, Object> eaData = new EnumMap<EAProps, Object>(EAProps.class);
            eaData.put(EAProps.entity, EnhancementEngineHelper.getReference((TripleCollection)graph, (NonLiteral)entityAnnotation, (UriRef)Properties.ENHANCER_ENTITY_REFERENCE));
            eaData.put(EAProps.label, EnhancementEngineHelper.getString((TripleCollection)graph, (NonLiteral)entityAnnotation, (UriRef)Properties.ENHANCER_ENTITY_LABEL));
            eaData.put(EAProps.confidence, EnhancementEngineHelper.get((TripleCollection)graph, (NonLiteral)entityAnnotation, (UriRef)Properties.ENHANCER_CONFIDENCE, Double.class, (LiteralFactory)lf));
            entitySuggestionMap.put(entityAnnotation, eaData);
            Iterator textAnnotations = EnhancementEngineHelper.getReferences((TripleCollection)graph, (NonLiteral)entityAnnotation, (UriRef)Properties.DC_RELATION);
            while (textAnnotations.hasNext()) {
                UriRef textAnnotation = (UriRef)textAnnotations.next();
                ArrayList<NonLiteral> suggestions = (ArrayList<NonLiteral>)suggestionMap.get(textAnnotation);
                if (suggestions == null) {
                    suggestions = new ArrayList<NonLiteral>();
                    suggestionMap.put(textAnnotation, suggestions);
                }
                suggestions.add(entityAnnotation);
            }
        }
        Iterator textAnnotations = graph.filter(null, RDF.type, (Resource)TechnicalClasses.ENHANCER_TEXTANNOTATION);
        while (textAnnotations.hasNext()) {
            NonLiteral textAnnotation = ((Triple)textAnnotations.next()).getSubject();
            String text = EnhancementEngineHelper.getString((TripleCollection)graph, (NonLiteral)textAnnotation, (UriRef)Properties.ENHANCER_SELECTED_TEXT);
            if (text == null) continue;
            Integer start = (Integer)EnhancementEngineHelper.get((TripleCollection)graph, (NonLiteral)textAnnotation, (UriRef)Properties.ENHANCER_START, Integer.class, (LiteralFactory)lf);
            Integer end = (Integer)EnhancementEngineHelper.get((TripleCollection)graph, (NonLiteral)textAnnotation, (UriRef)Properties.ENHANCER_END, Integer.class, (LiteralFactory)lf);
            Double confidence = (Double)EnhancementEngineHelper.get((TripleCollection)graph, (NonLiteral)textAnnotation, (UriRef)Properties.ENHANCER_CONFIDENCE, Double.class, (LiteralFactory)lf);
            Iterator<UriRef> types = EnhancementEngineHelper.getReferences((TripleCollection)graph, (NonLiteral)textAnnotation, (UriRef)Properties.DC_TYPE);
            if (!types.hasNext()) {
                types = Collections.singleton(null).iterator();
            }
            while (types.hasNext()) {
                EntityExtractionSummary existingSummary;
                UriRef type = types.next();
                Map<EntityExtractionSummary, EntityExtractionSummary> occurrenceMap = this.extractionsByTypeMap.get(type);
                if (occurrenceMap == null) {
                    occurrenceMap = new TreeMap<EntityExtractionSummary, EntityExtractionSummary>();
                    this.extractionsByTypeMap.put(type, occurrenceMap);
                }
                EntityExtractionSummary entity = new EntityExtractionSummary(text, type, start, end, confidence, this.defaultThumbnails);
                Collection suggestions = (Collection)suggestionMap.get(textAnnotation);
                if (suggestions != null) {
                    for (NonLiteral entityAnnotation : suggestions) {
                        Map eaData = (Map)entitySuggestionMap.get(entityAnnotation);
                        entity.addSuggestion((UriRef)eaData.get((Object)EAProps.entity), (String)eaData.get((Object)EAProps.label), (Double)eaData.get((Object)EAProps.confidence), (TripleCollection)graph);
                    }
                }
                if ((existingSummary = occurrenceMap.get(entity)) == null) {
                    occurrenceMap.put(entity, entity);
                    continue;
                }
                existingSummary.addMention(new Mention(text, start, end, confidence));
            }
        }
    }

    public ChainExecution getChainExecution() {
        return this.chainExecution;
    }

    public Collection<Execution> getEngineExecutions() {
        return this.engineExecutions;
    }

    public String getExecutionOffsetText(Execution ex) {
        if (ex.getChain() == null || ex.getChain().getStarted() == null || ex.getStarted() == null) {
            return null;
        }
        return String.format("%6dms", ex.getStarted().getTime() - ex.getChain().getStarted().getTime());
    }

    public String getExecutionDurationText(Execution ex) {
        if (ex.getDuration() == null) {
            return "[duration not available]";
        }
        if (ex.getDuration() < 1025L) {
            return ex.getDuration() + "ms";
        }
        return String.format("%.2fsec", Float.valueOf(ex.getDuration().floatValue() / 1000.0f));
    }

    public String getExecutionStartTime(Execution ex) {
        if (ex.getStarted() != null) {
            return this.format.format(ex.getStarted());
        }
        return "unknown";
    }

    public String getExecutionCompletionTime(Execution ex) {
        if (ex.getCompleted() != null) {
            return this.format.format(ex.getCompleted());
        }
        return "unknown";
    }

    public String getExecutionStatusText(Execution ex) {
        if (ExecutionMetadata.STATUS_COMPLETED.equals((Object)ex.getStatus())) {
            return "completed";
        }
        if (ExecutionMetadata.STATUS_FAILED.equals((Object)ex.getStatus())) {
            return "failed";
        }
        if (ExecutionMetadata.STATUS_IN_PROGRESS.equals((Object)ex.getStatus())) {
            return "in-progress";
        }
        if (ExecutionMetadata.STATUS_SCHEDULED.equals((Object)ex.getStatus())) {
            return "scheduled";
        }
        if (ExecutionMetadata.STATUS_SKIPPED.equals((Object)ex.getStatus())) {
            return "skipped";
        }
        return "unknown";
    }

    public void setRdfSerializationFormat(String format) {
        this.serializationFormat = format;
    }

    public String getPlacesAsJSON() throws ParseException, UnsupportedEncodingException {
        IndexedMGraph g = new IndexedMGraph();
        LiteralFactory lf = LiteralFactory.getInstance();
        MGraph metadata = this.contentItem.getMetadata();
        for (EntityExtractionSummary p : this.getPlaceOccurrences()) {
            Iterator longitutes;
            EntitySuggestion bestGuess = p.getBestGuess();
            if (bestGuess == null) continue;
            UriRef uri = new UriRef(bestGuess.getUri());
            Iterator latitudes = metadata.filter((NonLiteral)uri, Properties.GEO_LAT, null);
            if (latitudes.hasNext()) {
                g.add(latitudes.next());
            }
            if (!(longitutes = metadata.filter((NonLiteral)uri, Properties.GEO_LONG, null)).hasNext()) continue;
            g.add(longitutes.next());
            g.add((Object)new TripleImpl((NonLiteral)uri, Properties.RDFS_LABEL, (Resource)lf.createTypedLiteral((Object)bestGuess.getLabel())));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializer.serialize((OutputStream)out, (TripleCollection)g, "application/rdf+json");
        String rdfString = out.toString("utf-8");
        return rdfString;
    }

    @GET
    @Produces(value={"text/html"})
    public Response get(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("index", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    public static class EntitySuggestion
    implements Comparable<EntitySuggestion> {
        protected final UriRef uri;
        protected final UriRef type;
        protected final String label;
        protected final Double confidence;
        protected TripleCollection entityProperties;
        protected final Map<UriRef, String> defaultThumbnails;

        public EntitySuggestion(UriRef uri, UriRef type, String label, Double confidence, TripleCollection entityProperties, Map<UriRef, String> defaultThumbnails) {
            this.uri = uri;
            this.label = label;
            this.type = type;
            this.confidence = confidence != null ? confidence : 0.0;
            this.entityProperties = entityProperties;
            this.defaultThumbnails = defaultThumbnails;
        }

        @Override
        public int compareTo(EntitySuggestion o) {
            return -this.confidence.compareTo(o.confidence);
        }

        public String getUri() {
            return this.uri.getUnicodeString();
        }

        public Double getConfidence() {
            return this.confidence;
        }

        public String getLabel() {
            return this.label;
        }

        public String getThumbnailSrc() {
            Resource object;
            Iterator thumbnails = this.entityProperties.filter((NonLiteral)this.uri, THUMBNAIL, null);
            while (thumbnails.hasNext()) {
                object = ((Triple)thumbnails.next()).getObject();
                if (!(object instanceof UriRef)) continue;
                return ((UriRef)object).getUnicodeString();
            }
            thumbnails = this.entityProperties.filter((NonLiteral)this.uri, DEPICTION, null);
            while (thumbnails.hasNext()) {
                object = ((Triple)thumbnails.next()).getObject();
                if (!(object instanceof UriRef)) continue;
                return ((UriRef)object).getUnicodeString();
            }
            return this.getMissingThumbnailSrc();
        }

        public String getMissingThumbnailSrc() {
            String source = this.defaultThumbnails.get(this.type);
            if (source == null) {
                source = this.defaultThumbnails.get(null);
            }
            return source;
        }

        public String getSummary() {
            Iterator abstracts = this.entityProperties.filter((NonLiteral)this.uri, SUMMARY, null);
            while (abstracts.hasNext()) {
                PlainLiteral abstract_;
                Resource object = ((Triple)abstracts.next()).getObject();
                if (!(object instanceof PlainLiteral) || !new Language("en").equals((Object)(abstract_ = (PlainLiteral)object).getLanguage())) continue;
                return abstract_.getLexicalForm();
            }
            return "";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntitySuggestion other = (EntitySuggestion)obj;
            return !(this.uri == null ? other.uri != null : !this.uri.equals((Object)other.uri));
        }
    }

    public static class EntityExtractionSummary
    implements Comparable<EntityExtractionSummary> {
        protected final String name;
        protected final UriRef type;
        protected List<EntitySuggestion> suggestions = new ArrayList<EntitySuggestion>();
        protected Set<UriRef> suggestionSet = new HashSet<UriRef>();
        protected List<Mention> mentions = new ArrayList<Mention>();
        public final Map<UriRef, String> defaultThumbnails;
        private Integer start;
        private Integer end;
        private Double confidence;

        public EntityExtractionSummary(String name, UriRef type, Integer start, Integer end, Double confidence, Map<UriRef, String> defaultThumbnails) {
            this.name = name;
            this.type = type;
            this.mentions.add(new Mention(name, start, end, confidence));
            this.defaultThumbnails = defaultThumbnails;
            this.start = start;
            this.end = end;
            this.confidence = confidence;
        }

        public void addSuggestion(UriRef uri, String label, Double confidence, TripleCollection properties) {
            EntitySuggestion suggestion = new EntitySuggestion(uri, this.type, label, confidence, properties, this.defaultThumbnails);
            this.suggestionSet.add(uri);
            if (!this.suggestions.contains(suggestion)) {
                this.suggestions.add(suggestion);
                Collections.sort(this.suggestions);
            }
        }

        public void addMention(Mention mention) {
            if (!this.mentions.contains(mention)) {
                this.mentions.add(mention);
                Collections.sort(this.mentions);
            }
        }

        public String getName() {
            EntitySuggestion bestGuess = this.getBestGuess();
            if (bestGuess != null) {
                return bestGuess.getLabel();
            }
            return this.name;
        }

        public String getSelected() {
            return this.name;
        }

        public String getUri() {
            EntitySuggestion bestGuess = this.getBestGuess();
            if (bestGuess != null) {
                return bestGuess.getUri();
            }
            return null;
        }

        public Double getConfidence() {
            EntitySuggestion bestGuess = this.getBestGuess();
            if (bestGuess != null) {
                return bestGuess.getConfidence();
            }
            return this.confidence;
        }

        public String getSummary() {
            if (this.suggestions.isEmpty()) {
                return "";
            }
            return this.suggestions.get(0).getSummary();
        }

        public Integer getStart() {
            return this.start;
        }

        public Integer getEnd() {
            return this.end;
        }

        public boolean hasOccurrence() {
            return this.start != null && this.end != null;
        }

        public String getThumbnailSrc() {
            if (this.suggestions.isEmpty()) {
                return this.getMissingThumbnailSrc();
            }
            return this.suggestions.get(0).getThumbnailSrc();
        }

        public String getMissingThumbnailSrc() {
            String source = this.defaultThumbnails.get(this.type);
            if (source == null) {
                source = this.defaultThumbnails.get(null);
            }
            return source;
        }

        public EntitySuggestion getBestGuess() {
            if (this.suggestions.isEmpty()) {
                return null;
            }
            return this.suggestions.get(0);
        }

        public List<EntitySuggestion> getSuggestions() {
            return this.suggestions;
        }

        public List<Mention> getMentions() {
            return this.mentions;
        }

        @Override
        public int compareTo(EntityExtractionSummary o) {
            int c = String.CASE_INSENSITIVE_ORDER.compare(this.getName(), o.getName());
            if (c == 0) {
                if (this.suggestionSet.equals(o.suggestionSet)) {
                    return 0;
                }
                if (this.start != null && o.start != null) {
                    c = this.start.compareTo(o.start);
                } else if (o.start != null) {
                    c = 1;
                } else if (this.start != null) {
                    c = -1;
                }
                if (c == 0) {
                    if (o.end != null && this.end != null) {
                        c = this.end.compareTo(o.end);
                    } else if (o.end != null) {
                        c = -1;
                    } else if (this.end != null) {
                        c = 1;
                    }
                }
            }
            return c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityExtractionSummary that = (EntityExtractionSummary)o;
            if (this.getName().equalsIgnoreCase(this.getName())) {
                return this.suggestionSet.equals(that.suggestionSet);
            }
            return false;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    public static class Mention
    implements Comparable<Mention> {
        private String name;
        private Integer start;
        private Integer end;
        private Double conf;

        Mention(String name, Integer start, Integer end, Double confidence) {
            if (name == null) {
                throw new IllegalStateException("The name for a Mention MUST NOT be NULL!");
            }
            this.name = name;
            this.start = start;
            this.end = end;
            this.conf = confidence;
        }

        public String getName() {
            return this.name;
        }

        public Integer getStart() {
            return this.start;
        }

        public Integer getEnd() {
            return this.end;
        }

        public Double getConfidence() {
            return this.conf;
        }

        public boolean hasOccurrence() {
            return this.start != null && this.end != null;
        }

        public boolean hasConfidence() {
            return this.conf != null;
        }

        public int hashCode() {
            return this.name.hashCode() + (this.start != null ? this.start.hashCode() : 0) + (this.end != null ? this.end.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Mention) {
                Mention o = (Mention)obj;
                if (o.name.equals(this.name) && (o.start != null && o.start.equals(this.start) || o.start == null && this.start == null)) {
                    if (o.end != null && o.end.equals(this.end)) {
                        return true;
                    }
                    return o.end == null && this.end == null;
                }
            }
            return false;
        }

        @Override
        public int compareTo(Mention o) {
            int c = String.CASE_INSENSITIVE_ORDER.compare(o.name, this.name);
            if (c == 0) {
                if (this.start != null && o.start != null) {
                    c = this.start.compareTo(o.start);
                } else if (o.start != null) {
                    c = 1;
                } else if (this.start != null) {
                    c = -1;
                }
                if (c == 0) {
                    if (o.end != null && this.end != null) {
                        c = this.end.compareTo(o.end);
                    } else if (o.end != null) {
                        c = -1;
                    } else if (this.end != null) {
                        c = 1;
                    }
                }
            }
            return c;
        }
    }

    static enum EAProps {
        label,
        entity,
        confidence;

    }
}

