/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.resources;

import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.contenthub.servicesapi.search.SearchException;
import org.apache.stanbol.contenthub.servicesapi.search.featured.SearchResult;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeywordSearchManager;
import org.apache.stanbol.contenthub.web.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contenthub/search/related")
public class RelatedKeywordResource
extends BaseStanbolResource {
    private static Logger log = LoggerFactory.getLogger(RelatedKeywordResource.class);
    private RelatedKeywordSearchManager relatedKeywordSearchManager;

    public RelatedKeywordResource(@Context ServletContext context) {
        this.relatedKeywordSearchManager = (RelatedKeywordSearchManager)ContextHelper.getServiceFromContext(RelatedKeywordSearchManager.class, (ServletContext)context);
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Produces(value={"application/json"})
    public final Response findAllRelatedKeywords(@QueryParam(value="keyword") String keyword, @QueryParam(value="graphURI") String graphURI, @Context HttpHeaders headers) throws SearchException {
        if (!RestUtil.isJSONaccepted(headers)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if ((keyword = RestUtil.nullify(keyword)) == null) {
            String msg = "RelatedKeywordResource.findAllRelatedKeywords requires \"keyword\" parameter. \"graphURI\" is optional";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        graphURI = RestUtil.nullify(graphURI);
        SearchResult searchResult = this.relatedKeywordSearchManager.getRelatedKeywordsFromAllSources(keyword, graphURI);
        return this.prepareResponse(searchResult, headers);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/ontology")
    public final Response findOntologyRelatedKeywords(@QueryParam(value="keyword") String keyword, @QueryParam(value="graphURI") String graphURI, @Context HttpHeaders headers) throws SearchException {
        if (!RestUtil.isJSONaccepted(headers)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if ((keyword = RestUtil.nullify(keyword)) == null) {
            String msg = "RelatedKeywordResource.findOntologyRelatedKeywords requires \"keyword\" and \"graphURI\" parameters.";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if ((graphURI = RestUtil.nullify(graphURI)) == null) {
            String msg = "RelatedKeywordResource.findOntologyRelatedKeywords requires \"keyword\" and \"graphURI\" parameters.";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        SearchResult searchResult = this.relatedKeywordSearchManager.getRelatedKeywordsFromOntology(keyword, graphURI);
        return this.prepareResponse(searchResult, headers);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/referencedsite")
    public final Response findReferencedSiteRelatedKeywords(@QueryParam(value="keyword") String keyword, @Context HttpHeaders headers) throws SearchException {
        if (!RestUtil.isJSONaccepted(headers)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if ((keyword = RestUtil.nullify(keyword)) == null) {
            String msg = "RelatedKeywordResource.findOntologyRelatedKeywords requires a \"keyword\" parameter.";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        SearchResult searchResult = this.relatedKeywordSearchManager.getRelatedKeywordsFromReferencedSites(keyword);
        return this.prepareResponse(searchResult, headers);
    }

    private Response prepareResponse(SearchResult searchResult, HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)searchResult);
        rb.header("Content-Type", (Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }
}

