/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.stanbol.contenthub.servicesapi.ldpath.LDProgramCollection;
import org.apache.stanbol.contenthub.servicesapi.search.featured.DocumentResult;
import org.apache.stanbol.contenthub.servicesapi.search.featured.FacetResult;
import org.apache.stanbol.contenthub.servicesapi.search.featured.SearchResult;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeyword;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger logger = LoggerFactory.getLogger(JSONUtils.class);

    public static Map<String, List<Object>> convertToMap(String jsonFields) {
        HashMap<String, List<Object>> fieldMap = new HashMap<String, List<Object>>();
        if (jsonFields == null) {
            return fieldMap;
        }
        try {
            JSONObject jObject = new JSONObject(jsonFields);
            Iterator itr = jObject.keys();
            while (itr.hasNext()) {
                ArrayList<Object> valueSet = new ArrayList<Object>();
                String jFieldKey = (String)itr.next();
                Object jFieldValue = jObject.get(jFieldKey);
                if (jFieldValue instanceof JSONArray) {
                    JSONArray jArray = (JSONArray)jFieldValue;
                    for (int i = 0; i < jArray.length(); ++i) {
                        if (jArray.get(i).equals(null)) continue;
                        valueSet.add(jArray.get(i));
                    }
                } else if (!jFieldValue.equals(null)) {
                    valueSet.add(jFieldValue);
                }
                if (jFieldKey == null || jFieldKey.equals("")) continue;
                fieldMap.put(jFieldKey, valueSet);
            }
            return fieldMap;
        }
        catch (JSONException e) {
            logger.error("Cannot parse Json in generating the search constraints", (Throwable)e);
            return null;
        }
    }

    public static String convertToString(Map<String, List<Object>> constraints) {
        JSONObject jObject = new JSONObject();
        if (constraints != null) {
            for (Map.Entry<String, List<Object>> constaint : constraints.entrySet()) {
                ArrayList<Object> collection = new ArrayList<Object>();
                for (Object obj : constaint.getValue()) {
                    collection.add(obj);
                }
                if (constaint.getValue().isEmpty()) continue;
                try {
                    jObject.put(constaint.getKey(), collection);
                }
                catch (JSONException e) {
                    logger.error("Cannot parse values for key {}", (Object)constaint.getKey(), (Object)e);
                }
            }
        }
        return jObject.toString();
    }

    private static JSONObject toJSON(DocumentResult resultantDocument) throws JSONException {
        JSONObject jObj = new JSONObject();
        if (resultantDocument != null) {
            jObj.put("uri", (Object)resultantDocument.getDereferencableURI());
            jObj.put("localid", (Object)resultantDocument.getLocalId());
            jObj.put("mimetype", (Object)resultantDocument.getMimetype());
            jObj.put("title", (Object)resultantDocument.getTitle());
            jObj.put("enhancementcount", resultantDocument.getEnhancementCount());
        }
        return jObj;
    }

    private static <T> JSONArray toJSON(List<T> list) throws JSONException {
        JSONArray jArr = new JSONArray();
        if (list != null) {
            for (T element : list) {
                if (DocumentResult.class.isAssignableFrom(element.getClass())) {
                    jArr.put((Object)JSONUtils.toJSON((DocumentResult)element));
                    continue;
                }
                if (FacetField.class.isAssignableFrom(element.getClass())) {
                    jArr.put((Object)JSONUtils.toJSON((FacetField)element));
                    continue;
                }
                if (FacetField.Count.class.isAssignableFrom(element.getClass())) {
                    jArr.put((Object)JSONUtils.toJSON((FacetField.Count)element));
                    continue;
                }
                if (RelatedKeyword.class.isAssignableFrom(element.getClass())) {
                    jArr.put((Object)JSONUtils.toJSON((RelatedKeyword)element));
                    continue;
                }
                if (!FacetResult.class.isAssignableFrom(element.getClass())) continue;
                jArr.put((Object)JSONUtils.toJSON((FacetResult)element));
            }
        }
        return jArr;
    }

    private static JSONObject toJSON(FacetResult facetResult) throws JSONException {
        JSONObject jObj = new JSONObject();
        if (facetResult != null) {
            jObj.put("facet", (Object)JSONUtils.toJSON(facetResult.getFacetField()));
            jObj.put("type", (Object)facetResult.getType());
        }
        return jObj;
    }

    private static JSONObject toJSON(RelatedKeyword relatedKeyword) throws JSONException {
        JSONObject jObj = new JSONObject();
        if (relatedKeyword != null) {
            jObj.put("keyword", (Object)relatedKeyword.getKeyword());
            jObj.put("score", relatedKeyword.getScore());
        }
        return jObj;
    }

    private static JSONObject toJSON(FacetField.Count count) throws JSONException {
        JSONObject jObj = new JSONObject();
        if (count != null) {
            jObj.put("name", (Object)count.getName());
            jObj.put("count", count.getCount());
        }
        return jObj;
    }

    private static JSONObject toJSON(FacetField facet) throws JSONException {
        JSONObject jObj = new JSONObject();
        if (facet != null) {
            jObj.put("name", (Object)facet.getName());
            jObj.put("values", (Object)JSONUtils.toJSON(facet.getValues()));
        }
        return jObj;
    }

    private static <V> JSONArray toJSON(Map<String, V> map) throws JSONException {
        JSONArray jArr = new JSONArray();
        if (map != null) {
            for (Map.Entry<String, V> entry : map.entrySet()) {
                JSONObject jObj = new JSONObject();
                if (Map.class.isAssignableFrom(entry.getValue().getClass())) {
                    jObj.put(entry.getKey(), (Object)JSONUtils.toJSON((Map)entry.getValue()));
                } else if (List.class.isAssignableFrom(entry.getValue().getClass())) {
                    jObj.put(entry.getKey(), (Object)JSONUtils.toJSON((List)entry.getValue()));
                }
                jArr.put((Object)jObj);
            }
        }
        return jArr;
    }

    public static String createJSONString(SearchResult searchResult) throws JSONException {
        JSONObject jObj = new JSONObject();
        if (searchResult != null) {
            jObj.put("documents", (Object)JSONUtils.toJSON(searchResult.getDocuments()));
            jObj.put("facets", (Object)JSONUtils.toJSON(searchResult.getFacets()));
            jObj.put("relatedkeywords", (Object)JSONUtils.toJSON(searchResult.getRelatedKeywords()));
        }
        return jObj.toString(4);
    }

    public static String createJSONString(LDProgramCollection ldpc) throws JSONException {
        JSONObject jObj = new JSONObject();
        for (Map.Entry entry : ldpc.asMap().entrySet()) {
            jObj.put((String)entry.getKey(), entry.getValue());
        }
        return jObj.toString(4);
    }
}

