/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.processor;

import com.sun.jersey.api.view.Viewable;
import com.sun.jersey.spi.resource.Singleton;
import com.sun.jersey.spi.template.ViewProcessor;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Provider
public class FreemarkerViewProcessor
implements ViewProcessor<Template> {
    public static final String FREEMARKER_TEMPLATE_PATH_INIT_PARAM = "freemarker.template.path";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Configuration freemarkerConfig;
    protected String rootPath;
    @Context
    protected ServletContext context;

    protected String getDefaultExtension() {
        return ".ftl";
    }

    protected Map<String, Object> getVariablesForTemplate(Map<String, Object> viewableVariables) {
        return Collections.emptyMap();
    }

    protected void onProcessException(Throwable t, Template template, Map<String, Object> templateContext, OutputStream out) throws IOException {
        this.log.error("Error processing freemarker template @ " + template.getName() + ": " + t.getMessage(), t);
        out.write("<pre>".getBytes());
        t.printStackTrace(new PrintStream(out));
        out.write("</pre>".getBytes());
    }

    protected void assignFreemarkerConfig(Configuration config, ServletContext context) {
        config.setNumberFormat("0");
        config.setLocalizedLookup(false);
        config.setTemplateUpdateDelay(2);
        this.log.info("Assigned default freemarker configuration");
    }

    protected Configuration getConfig() {
        if (this.freemarkerConfig == null) {
            Configuration config = new Configuration();
            if (this.context != null) {
                this.rootPath = (String)this.context.getAttribute(FREEMARKER_TEMPLATE_PATH_INIT_PARAM);
            }
            if (this.rootPath == null || this.rootPath.trim().length() == 0) {
                this.log.info("No 'freemarker.template.path' context-param, defaulting to '/WEB-INF/templates'");
                this.rootPath = "/WEB-INF/templates";
            }
            this.rootPath = this.rootPath.replaceAll("/$", "");
            config.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), this.rootPath));
            InputStream fmProps = this.context.getResourceAsStream("freemarker.properties");
            boolean loadDefaults = true;
            if (fmProps != null) {
                try {
                    config.setSettings(fmProps);
                    this.log.info("Assigned freemarker configuration from 'freemarker.properties'");
                    loadDefaults = false;
                }
                catch (Throwable t) {
                    this.log.warn("Failed to load/assign freemarker.properties, will use default settings instead: " + t.getMessage(), t);
                }
            }
            if (loadDefaults) {
                this.assignFreemarkerConfig(config, this.context);
            }
            this.freemarkerConfig = config;
        }
        return this.freemarkerConfig;
    }

    public Template resolve(String path) {
        String defaultExtension = this.getDefaultExtension();
        String filePath = path.endsWith(defaultExtension) ? path : path + defaultExtension;
        try {
            return this.getConfig().getTemplate(filePath);
        }
        catch (IOException e) {
            this.log.error("Failed to load freemaker template: " + this.rootPath + filePath);
            return null;
        }
    }

    public void writeTo(Template template, Viewable viewable, OutputStream out) throws IOException {
        out.flush();
        Object model = viewable.getModel();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (model instanceof Map) {
            vars.putAll((Map)model);
        } else {
            vars.put("it", model);
        }
        vars.putAll(this.getVariablesForTemplate(vars));
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            template.process(vars, (Writer)writer);
        }
        catch (Throwable t) {
            this.onProcessException(t, template, vars, out);
        }
    }
}

