/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.resources;

import com.sun.jersey.api.view.Viewable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.params.SolrParams;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.contenthub.search.solr.util.SolrQueryUtil;
import org.apache.stanbol.contenthub.servicesapi.Constants;
import org.apache.stanbol.contenthub.servicesapi.search.SearchException;
import org.apache.stanbol.contenthub.servicesapi.search.featured.FacetResult;
import org.apache.stanbol.contenthub.servicesapi.search.featured.FeaturedSearch;
import org.apache.stanbol.contenthub.servicesapi.search.featured.SearchResult;
import org.apache.stanbol.contenthub.servicesapi.store.vocabulary.SolrVocabulary;
import org.apache.stanbol.contenthub.web.util.JSONUtils;
import org.apache.stanbol.contenthub.web.util.RestUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contenthub/{index}/search/featured")
public class FeaturedSearchResource
extends BaseStanbolResource {
    private static final Logger log = LoggerFactory.getLogger(FeaturedSearchResource.class);
    private TcManager tcManager;
    private FeaturedSearch featuredSearch;
    private String indexName;
    private List<String> ontologies = null;
    private String queryTerm = null;
    private SearchResult searchResults = null;
    private String chosenFacets = null;
    private int offset = 0;
    private int pageSize = 10;

    public FeaturedSearchResource(@Context ServletContext context, @PathParam(value="index") String indexName) throws IOException, InvalidSyntaxException {
        this.indexName = indexName;
        this.featuredSearch = (FeaturedSearch)ContextHelper.getServiceFromContext(FeaturedSearch.class, (ServletContext)context);
        this.tcManager = (TcManager)ContextHelper.getServiceFromContext(TcManager.class, (ServletContext)context);
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Produces(value={"text/html", "application/json"})
    public final Response get(@QueryParam(value="queryTerm") String queryTerm, @QueryParam(value="solrQuery") String solrQuery, @QueryParam(value="constraints") String jsonCons, @QueryParam(value="graphURI") String graphURI, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="fromStore") String fromStore, @Context HttpHeaders headers) throws IllegalArgumentException, SearchException, InstantiationException, IllegalAccessException, SolrServerException, IOException {
        MediaType acceptedHeader = RestUtil.getAcceptedMediaType(headers);
        this.queryTerm = queryTerm = RestUtil.nullify(queryTerm);
        solrQuery = RestUtil.nullify(solrQuery);
        graphURI = RestUtil.nullify(graphURI);
        jsonCons = RestUtil.nullify(jsonCons);
        this.offset = offset;
        this.pageSize = limit;
        if (acceptedHeader.isCompatible(MediaType.TEXT_HTML_TYPE)) {
            if (fromStore != null) {
                return Response.ok((Object)new Viewable("index", (Object)this), (String)"text/html").build();
            }
            if (queryTerm == null && solrQuery == null) {
                this.ontologies = new ArrayList<String>();
                Set mGraphs = this.tcManager.listMGraphs();
                Iterator it = mGraphs.iterator();
                while (it.hasNext()) {
                    graphURI = ((UriRef)it.next()).getUnicodeString();
                    if (Constants.isGraphReserved((String)graphURI)) continue;
                    this.ontologies.add(graphURI);
                }
                return Response.ok((Object)new Viewable("index", (Object)this), (String)"text/html").build();
            }
            Response.ResponseBuilder rb = this.performSearch(queryTerm, solrQuery, jsonCons, graphURI, offset, limit, MediaType.TEXT_HTML_TYPE);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        if (queryTerm == null && solrQuery == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Either 'queryTerm' or 'solrQuery' should be specified").build();
        }
        Response.ResponseBuilder rb = this.performSearch(queryTerm, solrQuery, jsonCons, graphURI, offset, limit, MediaType.APPLICATION_JSON_TYPE);
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response.ResponseBuilder performSearch(String queryTerm, String solrQuery, String jsonCons, String ontologyURI, int offset, int limit, MediaType acceptedMediaType) throws SearchException {
        if (solrQuery != null) {
            this.searchResults = this.featuredSearch.search((SolrParams)new SolrQuery(solrQuery), ontologyURI, this.indexName);
        } else if (queryTerm != null) {
            SolrQuery sq;
            Map<String, List<Object>> constraintsMap = JSONUtils.convertToMap(jsonCons);
            this.chosenFacets = JSONUtils.convertToString(constraintsMap);
            if (this.chosenFacets != null) {
                List allAvailableFacets = this.featuredSearch.getAllFacetResults(this.indexName);
                sq = SolrQueryUtil.prepareFacetedSolrQuery((String)queryTerm, (List)allAvailableFacets, constraintsMap);
            } else {
                sq = SolrQueryUtil.prepareDefaultSolrQuery((String)queryTerm);
            }
            sq.setStart(Integer.valueOf(offset));
            sq.setRows(Integer.valueOf(limit + 1));
            this.searchResults = this.featuredSearch.search((SolrParams)sq, ontologyURI, this.indexName);
        } else {
            log.error("Should never reach here!!!!");
            throw new SearchException("Either 'queryTerm' or 'solrQuery' paramater should be set");
        }
        Response.ResponseBuilder rb = null;
        if (acceptedMediaType.isCompatible(MediaType.TEXT_HTML_TYPE)) {
            this.searchResults.setFacets(this.sortFacetResults(this.searchResults.getFacets()));
            rb = Response.ok((Object)new Viewable("result.ftl", (Object)this));
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        } else {
            rb = Response.ok((Object)this.searchResults);
            rb.header("Content-Type", (Object)"application/json; charset=utf-8");
        }
        return rb;
    }

    private List<FacetResult> sortFacetResults(List<FacetResult> facetResults) {
        ArrayList<FacetResult> orderedFacets = new ArrayList<FacetResult>();
        int annotatedFacetNum = 0;
        for (FacetResult fr : facetResults) {
            String facetName = fr.getFacetField().getName();
            if (fr.getFacetField().getValues() == null) continue;
            if (SolrVocabulary.SolrFieldName.isAnnotatedEntityFacet((String)facetName)) {
                orderedFacets.add(annotatedFacetNum, fr);
                ++annotatedFacetNum;
                continue;
            }
            boolean inserted = false;
            for (int j = annotatedFacetNum; j < orderedFacets.size(); ++j) {
                if (facetName.compareTo(((FacetResult)orderedFacets.get(j)).getFacetField().getName()) >= 0) continue;
                orderedFacets.add(j, fr);
                inserted = true;
                break;
            }
            if (inserted) continue;
            orderedFacets.add(fr);
        }
        return orderedFacets;
    }

    public Object getMoreRecentItems() {
        if (this.offset >= this.pageSize) {
            return new Object();
        }
        return null;
    }

    public Object getOlderItems() {
        if (this.searchResults.getDocuments().size() <= this.pageSize) {
            return null;
        }
        return new Object();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Object getSearchResults() {
        return this.searchResults;
    }

    public Object getDocuments() {
        if (this.searchResults.getDocuments().size() > this.pageSize) {
            return this.searchResults.getDocuments().subList(0, this.pageSize);
        }
        return this.searchResults.getDocuments();
    }

    public Object getOntologies() {
        return this.ontologies;
    }

    public Object getQueryTerm() {
        if (this.queryTerm != null) {
            return this.queryTerm;
        }
        return "";
    }

    public String getChosenFacets() {
        return this.chosenFacets;
    }

    public String getIndexName() {
        return this.indexName;
    }
}

