/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.resources;

import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.clerezza.rdf.ontologies.RDFS;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.contenthub.servicesapi.search.SearchException;
import org.apache.stanbol.contenthub.servicesapi.search.featured.SearchResult;
import org.apache.stanbol.contenthub.servicesapi.search.related.RelatedKeywordSearchManager;
import org.apache.stanbol.contenthub.web.util.RestUtil;
import org.apache.stanbol.entityhub.core.query.DefaultQueryFactory;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQueryFactory;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.query.TextConstraint;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteManager;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contenthub/search/related")
public class RelatedKeywordResource
extends BaseStanbolResource {
    private static Logger log = LoggerFactory.getLogger(RelatedKeywordResource.class);
    private static int AUTOCOMPLETED_KEYWORD_NUMBER = 10;
    private static String DEFAULT_AUTOCOMPLETE_SEARCH_FIELD = RDFS.label.getUnicodeString();
    private ReferencedSiteManager referencedSiteManager;
    private RelatedKeywordSearchManager relatedKeywordSearchManager;

    public RelatedKeywordResource(@Context ServletContext context) {
        this.referencedSiteManager = (ReferencedSiteManager)ContextHelper.getServiceFromContext(ReferencedSiteManager.class, (ServletContext)context);
        this.relatedKeywordSearchManager = (RelatedKeywordSearchManager)ContextHelper.getServiceFromContext(RelatedKeywordSearchManager.class, (ServletContext)context);
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Produces(value={"application/json"})
    public final Response findAllRelatedKeywords(@QueryParam(value="keyword") String keyword, @QueryParam(value="graphURI") String graphURI, @Context HttpHeaders headers) throws SearchException {
        if (!RestUtil.isJSONaccepted(headers)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if ((keyword = RestUtil.nullify(keyword)) == null) {
            String msg = "RelatedKeywordResource.findAllRelatedKeywords requires \"keyword\" parameter. \"graphURI\" is optional";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        graphURI = RestUtil.nullify(graphURI);
        SearchResult searchResult = this.relatedKeywordSearchManager.getRelatedKeywordsFromAllSources(keyword, graphURI);
        return this.prepareResponse(searchResult, headers);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/ontology")
    public final Response findOntologyRelatedKeywords(@QueryParam(value="keyword") String keyword, @QueryParam(value="graphURI") String graphURI, @Context HttpHeaders headers) throws SearchException {
        if (!RestUtil.isJSONaccepted(headers)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if ((keyword = RestUtil.nullify(keyword)) == null) {
            String msg = "RelatedKeywordResource.findOntologyRelatedKeywords requires \"keyword\" and \"graphURI\" parameters.";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if ((graphURI = RestUtil.nullify(graphURI)) == null) {
            String msg = "RelatedKeywordResource.findOntologyRelatedKeywords requires \"keyword\" and \"graphURI\" parameters.";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        SearchResult searchResult = this.relatedKeywordSearchManager.getRelatedKeywordsFromOntology(keyword, graphURI);
        return this.prepareResponse(searchResult, headers);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/referencedsite")
    public final Response findReferencedSiteRelatedKeywords(@QueryParam(value="keyword") String keyword, @Context HttpHeaders headers) throws SearchException {
        if (!RestUtil.isJSONaccepted(headers)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if ((keyword = RestUtil.nullify(keyword)) == null) {
            String msg = "RelatedKeywordResource.findOntologyRelatedKeywords requires a \"keyword\" parameter.";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        SearchResult searchResult = this.relatedKeywordSearchManager.getRelatedKeywordsFromReferencedSites(keyword);
        return this.prepareResponse(searchResult, headers);
    }

    private Response prepareResponse(SearchResult searchResult, HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)searchResult);
        rb.header("Content-Type", (Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/autocomplete")
    public final Response bringSuggestion(@QueryParam(value="pattern") String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return Response.noContent().build();
        }
        pattern = pattern.trim();
        pattern = pattern + "*";
        FieldQueryFactory qf = DefaultQueryFactory.getInstance();
        FieldQuery fieldQuery = qf.createFieldQuery();
        ArrayList<String> selectedFields = new ArrayList<String>();
        selectedFields.add(DEFAULT_AUTOCOMPLETE_SEARCH_FIELD);
        fieldQuery.addSelectedFields(selectedFields);
        fieldQuery.setConstraint(DEFAULT_AUTOCOMPLETE_SEARCH_FIELD, (Constraint)new TextConstraint(pattern, TextConstraint.PatternType.wildcard, false, new String[]{"en"}));
        fieldQuery.setLimit(Integer.valueOf(AUTOCOMPLETED_KEYWORD_NUMBER));
        fieldQuery.setOffset(0);
        ArrayList<String> result = new ArrayList<String>();
        QueryResultList entityhubResult = this.referencedSiteManager.find(fieldQuery);
        for (Representation rep : entityhubResult) {
            result.add(rep.getFirst(DEFAULT_AUTOCOMPLETE_SEARCH_FIELD).toString());
        }
        JSONObject jResult = new JSONObject();
        try {
            jResult.put("completedKeywords", result);
        }
        catch (Exception e) {
            // empty catch block
        }
        return Response.ok((Object)jResult.toString()).build();
    }
}

