/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.web.resources;

import com.sun.jersey.api.view.Viewable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.contenthub.servicesapi.ldpath.LDPathException;
import org.apache.stanbol.contenthub.servicesapi.ldpath.LDProgram;
import org.apache.stanbol.contenthub.servicesapi.ldpath.LDProgramCollection;
import org.apache.stanbol.contenthub.servicesapi.ldpath.SemanticIndexManager;
import org.apache.stanbol.contenthub.web.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contenthub/ldpath")
public class SemanticIndexManagerResource
extends BaseStanbolResource {
    private static final Logger logger = LoggerFactory.getLogger(SemanticIndexManagerResource.class);
    private SemanticIndexManager programManager;

    public SemanticIndexManagerResource(@Context ServletContext context) {
        this.programManager = (SemanticIndexManager)ContextHelper.getServiceFromContext(SemanticIndexManager.class, (ServletContext)context);
        if (this.programManager == null) {
            logger.error("Missing LDProgramManager = {}", (Object)this.programManager);
            throw new WebApplicationException(404);
        }
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/program")
    public Response handleCorsPreflightProgram(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @OPTIONS
    @Path(value="/exists")
    public Response handleCorsPreflightExists(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Produces(value={"text/html", "application/json"})
    public Response retrieveAllPrograms(@Context HttpHeaders headers) {
        MediaType acceptedHeader = RestUtil.getAcceptedMediaType(headers);
        if (acceptedHeader.isCompatible(MediaType.TEXT_HTML_TYPE)) {
            return Response.ok((Object)new Viewable("index", (Object)this), (String)"text/html").build();
        }
        LDProgramCollection ldProgramCollection = this.programManager.retrieveAllPrograms();
        Response.ResponseBuilder rb = Response.ok((Object)ldProgramCollection, (String)"application/json");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @POST
    @Path(value="/program")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response submitProgram(@FormParam(value="name") String programName, @FormParam(value="program") String program, @Context HttpHeaders headers) throws LDPathException {
        try {
            this.programManager.submitProgram(programName, program);
        }
        catch (LDPathException e) {
            logger.error("LDPath program cannot be submitted", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)"LDPath program has been successfully saved and corresponding Solr Core has been successfully created.");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="/program")
    public Response getProgramByName(@QueryParam(value="name") String programName, @Context HttpHeaders headers) {
        String ldPathProgram = this.programManager.getProgramByName(programName);
        if (ldPathProgram == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)ldPathProgram);
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @DELETE
    @Path(value="/program/{name}")
    public Response deleteProgram(@PathParam(value="name") String programName, @Context HttpHeaders headers) {
        this.programManager.deleteProgram(programName);
        Response.ResponseBuilder rb = Response.ok();
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="/exists")
    public Response isManagedProgram(@QueryParam(value="name") String programName, @Context HttpHeaders headers) {
        if (this.programManager.isManagedProgram(programName)) {
            Response.ResponseBuilder rb = Response.ok();
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.NOT_FOUND);
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    public List<LDProgram> getLdPrograms() {
        return this.programManager.retrieveAllPrograms().asList();
    }
}

