/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.entityhublinking;

import java.util.List;
import java.util.Set;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQueryFactory;
import org.apache.stanbol.entityhub.servicesapi.query.TextConstraint;

public class EntitySearcherUtils {
    public static final FieldQuery createFieldQuery(FieldQueryFactory factory, UriRef field, Set<UriRef> includeFields, List<String> search, String ... languages) {
        if (field == null || field.getUnicodeString().isEmpty()) {
            throw new IllegalArgumentException("The parsed search field MUST NOT be NULL nor empty");
        }
        if (search == null || search.isEmpty()) {
            throw new IllegalArgumentException("The parsed list of search strings MUST NOT be NULL nor empty");
        }
        FieldQuery query = factory.createFieldQuery();
        if (includeFields == null) {
            query.addSelectedField(field.getUnicodeString());
        } else {
            if (!includeFields.contains(field.getUnicodeString())) {
                query.addSelectedField(field.getUnicodeString());
            }
            for (UriRef select : includeFields) {
                query.addSelectedField(select.getUnicodeString());
            }
        }
        query.setLimit(Integer.valueOf(20));
        query.setConstraint(field.getUnicodeString(), (Constraint)new TextConstraint(search, languages));
        return query;
    }
}

