/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.entityhublinking;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.stanbol.commons.namespaceprefix.NamespacePrefixService;
import org.apache.stanbol.enhancer.engines.entityhublinking.EntityhubSearcher;
import org.apache.stanbol.enhancer.engines.entityhublinking.ReferencedSiteSearcher;
import org.apache.stanbol.enhancer.engines.entityhublinking.TrackingEntitySearcher;
import org.apache.stanbol.enhancer.engines.entitylinking.LabelTokenizer;
import org.apache.stanbol.enhancer.engines.entitylinking.config.EntityLinkerConfig;
import org.apache.stanbol.enhancer.engines.entitylinking.config.TextProcessingConfig;
import org.apache.stanbol.enhancer.engines.entitylinking.engine.EntityLinkingEngine;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.ServiceProperties;
import org.apache.stanbol.entityhub.servicesapi.Entityhub;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityhubLinkingEngine
implements ServiceTrackerCustomizer {
    private final Logger log = LoggerFactory.getLogger(EntityhubLinkingEngine.class);
    NamespacePrefixService prefixService;
    public static final String SITE_ID = "enhancer.engines.linking.entityhub.siteId";
    protected EntityLinkingEngine entityLinkingEngine;
    protected Dictionary<String, Object> engineMetadata;
    protected ServiceRegistration engineRegistration;
    private TrackingEntitySearcher<?> entitySearcher;
    int trackedServiceCount = 0;
    private ServiceTracker labelTokenizerTracker;
    private NavigableSet<ServiceReference> labelTokenizersRefs = new TreeSet<ServiceReference>();
    protected String siteName;
    private BundleContext bundleContext;

    protected void activate(ComponentContext ctx) throws ConfigurationException {
        Dictionary properties = ctx.getProperties();
        this.bundleContext = ctx.getBundleContext();
        EntityLinkerConfig linkerConfig = EntityLinkerConfig.createInstance((Dictionary)properties, (NamespacePrefixService)this.prefixService);
        TextProcessingConfig textProcessingConfig = TextProcessingConfig.createInstance((Dictionary)properties);
        Object value = properties.get(SITE_ID);
        if (value == null) {
            throw new ConfigurationException(SITE_ID, "The ID of the Referenced Site is a required Parameter and MUST NOT be NULL!");
        }
        this.siteName = value.toString();
        if (this.siteName.isEmpty()) {
            throw new ConfigurationException(SITE_ID, "The ID of the Referenced Site is a required Parameter and MUST NOT be an empty String!");
        }
        this.engineMetadata = new Hashtable<String, Object>();
        value = properties.get("stanbol.enhancer.engine.name");
        if (value == null || value.toString().isEmpty()) {
            throw new ConfigurationException("stanbol.enhancer.engine.name", "The EnhancementEngine name MUST BE configured!");
        }
        String engineName = value.toString();
        this.engineMetadata.put("stanbol.enhancer.engine.name", value);
        value = properties.get("service.ranking");
        this.engineMetadata.put("service.ranking", value == null ? Integer.valueOf(0) : value);
        this.trackedServiceCount = 0;
        this.entitySearcher = Entityhub.ENTITYHUB_IDS.contains(this.siteName.toLowerCase()) ? new EntityhubSearcher(this.bundleContext, 10, this) : new ReferencedSiteSearcher(this.bundleContext, this.siteName, 10, (ServiceTrackerCustomizer)this);
        this.labelTokenizerTracker = new ServiceTracker(this.bundleContext, LabelTokenizer.class.getName(), new ServiceTrackerCustomizer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object addingService(ServiceReference reference) {
                Object service = EntityhubLinkingEngine.this.bundleContext.getService(reference);
                NavigableSet navigableSet = EntityhubLinkingEngine.this.labelTokenizersRefs;
                synchronized (navigableSet) {
                    LabelTokenizer lt;
                    EntityhubLinkingEngine.this.labelTokenizersRefs.add(reference);
                    ServiceReference higest = (ServiceReference)EntityhubLinkingEngine.this.labelTokenizersRefs.last();
                    EntityLinkingEngine engine = EntityhubLinkingEngine.this.entityLinkingEngine;
                    if (engine != null && !(lt = (LabelTokenizer)(higest.equals(reference) ? service : EntityhubLinkingEngine.this.labelTokenizerTracker.getService(higest))).equals(engine.getLabelTokenizer())) {
                        EntityhubLinkingEngine.this.log.info(" ... setting LabelTokenizer of Engine '{}' to {}", (Object)engine.getName(), (Object)lt);
                        engine.setLabelTokenizer(lt);
                    }
                }
                return service;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference reference, Object service) {
                NavigableSet navigableSet = EntityhubLinkingEngine.this.labelTokenizersRefs;
                synchronized (navigableSet) {
                    EntityhubLinkingEngine.this.labelTokenizersRefs.remove(reference);
                    EntityLinkingEngine engine = EntityhubLinkingEngine.this.entityLinkingEngine;
                    if (engine != null) {
                        if (EntityhubLinkingEngine.this.labelTokenizersRefs.isEmpty()) {
                            EntityhubLinkingEngine.this.log.info(" ... setting LabelTokenizer of Engine '{}' to null", (Object)engine.getName());
                            engine.setLabelTokenizer(null);
                        } else {
                            LabelTokenizer lt = (LabelTokenizer)EntityhubLinkingEngine.this.labelTokenizerTracker.getService((ServiceReference)EntityhubLinkingEngine.this.labelTokenizersRefs.last());
                            if (!lt.equals(engine.getLabelTokenizer())) {
                                EntityhubLinkingEngine.this.log.info(" ... setting LabelTokenizer of Engine '{}' to {}", (Object)engine.getName(), (Object)lt);
                                engine.setLabelTokenizer(lt);
                            }
                        }
                    }
                }
                EntityhubLinkingEngine.this.bundleContext.ungetService(reference);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifiedService(ServiceReference reference, Object service) {
                NavigableSet navigableSet = EntityhubLinkingEngine.this.labelTokenizersRefs;
                synchronized (navigableSet) {
                    LabelTokenizer lt;
                    EntityhubLinkingEngine.this.labelTokenizersRefs.remove(reference);
                    EntityhubLinkingEngine.this.labelTokenizersRefs.add(reference);
                    ServiceReference higest = (ServiceReference)EntityhubLinkingEngine.this.labelTokenizersRefs.last();
                    EntityLinkingEngine engine = EntityhubLinkingEngine.this.entityLinkingEngine;
                    if (engine != null && !(lt = (LabelTokenizer)(higest.equals(reference) ? service : EntityhubLinkingEngine.this.labelTokenizerTracker.getService(higest))).equals(engine.getLabelTokenizer())) {
                        EntityhubLinkingEngine.this.log.info(" ... setting LabelTokenizer of Engine '{}' to {}", (Object)engine.getName(), (Object)lt);
                        engine.setLabelTokenizer(lt);
                    }
                }
            }
        });
        this.entityLinkingEngine = new EntityLinkingEngine(engineName, this.entitySearcher, textProcessingConfig, linkerConfig, null);
        this.labelTokenizerTracker.open();
        this.entitySearcher.open();
    }

    protected void deactivate(ComponentContext context) {
        ServiceRegistration reg = this.engineRegistration;
        if (reg != null) {
            reg.unregister();
            this.engineRegistration = null;
        }
        this.entityLinkingEngine = null;
        this.engineMetadata = null;
        this.labelTokenizerTracker.close();
        this.labelTokenizerTracker = null;
        this.entitySearcher.close();
        this.entitySearcher = null;
    }

    public Object addingService(ServiceReference reference) {
        BundleContext bc = this.bundleContext;
        if (bc != null) {
            Object service = bc.getService(reference);
            if (service != null) {
                if (this.trackedServiceCount == 0) {
                    this.engineRegistration = bc.registerService(new String[]{EnhancementEngine.class.getName(), ServiceProperties.class.getName()}, (Object)this.entityLinkingEngine, this.engineMetadata);
                }
                ++this.trackedServiceCount;
            }
            return service;
        }
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        BundleContext bc = this.bundleContext;
        if (bc != null) {
            --this.trackedServiceCount;
            if (this.trackedServiceCount == 0 && this.engineRegistration != null) {
                this.engineRegistration.unregister();
            }
            bc.ungetService(reference);
        }
    }

    protected void bindPrefixService(NamespacePrefixService namespacePrefixService) {
        this.prefixService = namespacePrefixService;
    }

    protected void unbindPrefixService(NamespacePrefixService namespacePrefixService) {
        if (this.prefixService == namespacePrefixService) {
            this.prefixService = null;
        }
    }
}

