/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.entityhublinking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.stanbol.enhancer.engines.entityhublinking.EntitySearcherUtils;
import org.apache.stanbol.enhancer.engines.entityhublinking.EntityhubEntity;
import org.apache.stanbol.enhancer.engines.entityhublinking.TrackingEntitySearcher;
import org.apache.stanbol.enhancer.engines.entitylinking.Entity;
import org.apache.stanbol.enhancer.engines.entitylinking.EntitySearcher;
import org.apache.stanbol.enhancer.engines.entitylinking.EntitySearcherException;
import org.apache.stanbol.entityhub.servicesapi.Entityhub;
import org.apache.stanbol.entityhub.servicesapi.EntityhubException;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class EntityhubSearcher
extends TrackingEntitySearcher<Entityhub>
implements EntitySearcher {
    private final Integer limit;
    private Map<UriRef, Collection<Resource>> originInfo;

    public EntityhubSearcher(BundleContext context, Integer limit) {
        this(context, limit, null);
    }

    public EntityhubSearcher(BundleContext context, Integer limit, ServiceTrackerCustomizer customizer) {
        super(context, Entityhub.class, null, customizer);
        this.limit = limit != null && limit > 0 ? limit : null;
        this.originInfo = Collections.singletonMap(new UriRef(RdfResourceEnum.site.getUri()), Collections.singleton(new PlainLiteralImpl("entityhub")));
    }

    public Entity get(UriRef id, Set<UriRef> fields, String ... languages) throws EntitySearcherException {
        org.apache.stanbol.entityhub.servicesapi.model.Entity entity;
        if (id == null || id.getUnicodeString().isEmpty()) {
            return null;
        }
        Entityhub entityhub = (Entityhub)this.getSearchService();
        if (entityhub == null) {
            throw new EntitySearcherException("The Entityhub is currently not active");
        }
        try {
            entity = entityhub.getEntity(id.getUnicodeString());
        }
        catch (EntityhubException e) {
            throw new EntitySearcherException("Exception while getting " + id + " from the Entityhub", (Throwable)e);
        }
        if (entity != null) {
            Set<String> languageSet = languages == null || languages.length < 1 ? null : (languages.length == 1 ? Collections.singleton(languages[0]) : new HashSet<String>(Arrays.asList(languages)));
            return new EntityhubEntity(entity.getRepresentation(), fields, languageSet);
        }
        return null;
    }

    public Collection<? extends Entity> lookup(UriRef field, Set<UriRef> includeFields, List<String> search, String[] languages, Integer limit, Integer offset) throws EntitySearcherException {
        QueryResultList results;
        Entityhub entityhub = (Entityhub)this.getSearchService();
        if (entityhub == null) {
            throw new EntitySearcherException("The Entityhub is currently not active");
        }
        FieldQuery query = EntitySearcherUtils.createFieldQuery(entityhub.getQueryFactory(), field, includeFields, search, languages);
        if (limit != null && limit > 0) {
            query.setLimit(limit);
        } else if (this.limit != null) {
            query.setLimit(this.limit);
        }
        if (offset != null && offset > 0) {
            query.setOffset(offset.intValue());
        }
        try {
            results = entityhub.find(query);
        }
        catch (EntityhubException e) {
            throw new EntitySearcherException("Exception while searchign for " + search + '@' + Arrays.toString(languages) + "in the Entityhub", (Throwable)e);
        }
        if (!results.isEmpty()) {
            HashSet<String> languagesSet = new HashSet<String>(Arrays.asList(languages));
            ArrayList<EntityhubEntity> entities = new ArrayList<EntityhubEntity>(results.size());
            for (Representation result : results) {
                entities.add(new EntityhubEntity(result, null, languagesSet));
            }
            return entities;
        }
        return Collections.emptyList();
    }

    public boolean supportsOfflineMode() {
        return true;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Map<UriRef, Collection<Resource>> getOriginInformation() {
        return this.originInfo;
    }
}

