/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.poschunker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.stanbol.enhancer.engines.poschunker.PhraseTypeDefinition;
import org.apache.stanbol.enhancer.nlp.NlpAnnotations;
import org.apache.stanbol.enhancer.nlp.model.Chunk;
import org.apache.stanbol.enhancer.nlp.model.Section;
import org.apache.stanbol.enhancer.nlp.model.Token;
import org.apache.stanbol.enhancer.nlp.model.annotation.Value;
import org.apache.stanbol.enhancer.nlp.phrase.PhraseTag;
import org.apache.stanbol.enhancer.nlp.pos.LexicalCategory;
import org.apache.stanbol.enhancer.nlp.pos.PosTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhraseBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final double DEFAULT_SCORE = 0.1;
    private final PhraseTypeDefinition phraseType;
    private final ChunkFactory chunkFactory;
    private final double minPosSocre;
    private final PhraseTag phraseTag;
    private List<Token> current = new ArrayList<Token>();
    boolean valid;

    public PhraseBuilder(PhraseTypeDefinition phraseType, ChunkFactory chunkFactory, double minPosSocre) {
        if (phraseType == null) {
            throw new IllegalArgumentException("The parsed PhraseTypeDefinition MUST NOT be NULL!");
        }
        this.phraseType = phraseType;
        this.log.debug("Create {} for {}", (Object)this.getClass().getSimpleName(), (Object)phraseType);
        this.phraseTag = new PhraseTag(phraseType.getPhraseType().name(), phraseType.getPhraseType());
        if (chunkFactory == null) {
            throw new IllegalArgumentException("The parsed ChunkFactory MUST NOT be NULL");
        }
        this.chunkFactory = chunkFactory;
        if (minPosSocre < 0.0 || minPosSocre > 1.0) {
            throw new IllegalArgumentException("The parsed minPosScore '" + minPosSocre + "' MUST BE within the ranve [0..1]!");
        }
        this.minPosSocre = minPosSocre;
    }

    public void nextToken(Token token) {
        if (this.current.isEmpty()) {
            this.checkStart(token);
        } else if (!this.checkContinuation(token)) {
            this.buildPhrase(token);
        }
    }

    public void nextSection(Section section) {
        this.buildPhrase(null);
        this.log.trace("-- next {} --", (Object)section);
    }

    private void checkStart(Token token) {
        boolean[] states = this.checkCategories(token, this.phraseType.getStartType(), this.phraseType.getRequiredType());
        if (states[0]) {
            this.current.add(token);
            if (this.log.isTraceEnabled()) {
                this.log.trace("-- {} phrase start --", (Object)this.phraseType.getPhraseType().name());
                this.log.trace(" {}. {} {}", new Object[]{this.current.size(), token, this.logPosCategories(token)});
            }
            this.valid = states[1];
        }
    }

    private boolean checkContinuation(Token token) {
        boolean[] states = !this.valid ? this.checkCategories(token, this.phraseType.getPrefixType(), this.phraseType.getRequiredType()) : this.checkCategories(token, this.phraseType.getContinuationType());
        if (states[0]) {
            this.current.add(token);
            if (this.log.isTraceEnabled()) {
                this.log.trace(" {}. {} {}", new Object[]{this.current.size(), token, this.logPosCategories(token)});
            }
        }
        if (states.length > 1) {
            this.valid = states[1];
        }
        return states[0];
    }

    private void buildPhrase(Token token) {
        Token lastConsumedToken = null;
        if (this.valid) {
            int endIndex;
            for (endIndex = this.current.size() - 1; endIndex > 0 && !this.checkCategories(this.current.get(endIndex), this.phraseType.getEndType())[0]; --endIndex) {
            }
            lastConsumedToken = this.current.get(endIndex);
            if (endIndex > 0) {
                Chunk chunk = this.chunkFactory.createChunk(this.current.get(0), lastConsumedToken);
                chunk.addAnnotation(NlpAnnotations.PHRASE_ANNOTATION, Value.value((Object)this.phraseTag));
                if (this.log.isTraceEnabled()) {
                    this.log.trace("  << add {} phrase {} '{}'", new Object[]{this.phraseType.getPhraseType().name(), chunk, chunk.getSpan()});
                }
            } else if (this.log.isTraceEnabled()) {
                this.log.trace("  >> ignore {} phrase with single {} ", (Object)this.phraseType.getPhraseType().name(), (Object)this.current.get(0));
            }
        } else if (!this.current.isEmpty() && this.log.isTraceEnabled()) {
            this.log.trace("  << ignore invalid {} phrase [{},{}]", new Object[]{this.phraseType.getPhraseType().name(), this.current.get(0).getStart(), this.current.get(this.current.size() - 1).getEnd()});
        }
        this.current.clear();
        this.valid = false;
        if (token != null && !token.equals(lastConsumedToken)) {
            this.checkStart(token);
        }
    }

    private boolean[] checkCategories(Token token, Set<LexicalCategory> ... categories) {
        boolean scorePresent = false;
        double sumScore = 0.0;
        double[] matchScores = new double[categories.length];
        for (Value pos : token.getAnnotations(NlpAnnotations.POS_ANNOTATION)) {
            double score = pos.probability();
            if (score == -1.0) {
                score = 0.1;
            } else {
                scorePresent = true;
            }
            sumScore += pos.probability();
            Set tokenCategories = ((PosTag)pos.value()).getCategories();
            for (int i = 0; i < categories.length; ++i) {
                Set<LexicalCategory> category = categories[i];
                if (Collections.disjoint(tokenCategories, category)) continue;
                matchScores[i] = matchScores[i] + pos.probability();
            }
        }
        boolean[] matches = new boolean[matchScores.length];
        double normScore = scorePresent ? Math.max(1.0, sumScore) : sumScore;
        for (int i = 0; i < matchScores.length; ++i) {
            matches[i] = matchScores[i] / normScore >= this.minPosSocre;
        }
        return matches;
    }

    private String logPosCategories(Token token) {
        List posTags = token.getAnnotations(NlpAnnotations.POS_ANNOTATION);
        ArrayList<String> catNames = new ArrayList<String>(posTags.size());
        for (Value tag : posTags) {
            Set cats = ((PosTag)tag.value()).getCategories();
            if (cats.size() > 1) {
                catNames.add(cats.toString());
                continue;
            }
            if (!cats.isEmpty()) {
                catNames.add(((LexicalCategory)cats.iterator().next()).toString());
                continue;
            }
            catNames.add(((PosTag)tag.value()).getTag());
        }
        return ((Object)catNames).toString();
    }

    public static interface ChunkFactory {
        public Chunk createChunk(Token var1, Token var2);
    }
}

