/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.poschunker;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.stanbol.enhancer.nlp.pos.LexicalCategory;

public class PhraseTypeDefinition {
    protected final LexicalCategory phraseType;
    private final Set<LexicalCategory> startTypes;
    protected final Set<LexicalCategory> readOnlyStartTypes;
    private final Set<LexicalCategory> prefixTypes;
    protected final Set<LexicalCategory> readOnlyPrefixTypes;
    private final Set<LexicalCategory> continuationTypes;
    protected final Set<LexicalCategory> readOnlyContinuationTypes;
    private final Set<LexicalCategory> requiredTypes;
    protected final Set<LexicalCategory> readOnlyRequiredTypes;
    private final Set<LexicalCategory> endTypes;
    protected final Set<LexicalCategory> readOnlyEndTypes;

    public PhraseTypeDefinition(LexicalCategory phraseType) {
        if (phraseType == null) {
            throw new IllegalArgumentException("The parsed PhraseType MUST NOT be NULL!");
        }
        this.phraseType = phraseType;
        this.startTypes = EnumSet.of(phraseType);
        this.readOnlyStartTypes = Collections.unmodifiableSet(this.startTypes);
        this.prefixTypes = EnumSet.of(phraseType);
        this.readOnlyPrefixTypes = Collections.unmodifiableSet(this.prefixTypes);
        this.continuationTypes = EnumSet.of(phraseType);
        this.readOnlyContinuationTypes = Collections.unmodifiableSet(this.continuationTypes);
        this.requiredTypes = EnumSet.of(phraseType);
        this.readOnlyRequiredTypes = Collections.unmodifiableSet(this.requiredTypes);
        this.endTypes = EnumSet.of(phraseType);
        this.readOnlyEndTypes = Collections.unmodifiableSet(this.startTypes);
    }

    public boolean addStartType(LexicalCategory ... types) {
        return this.add(this.startTypes, types);
    }

    public boolean addPrefixType(LexicalCategory ... types) {
        return this.add(this.prefixTypes, types);
    }

    public boolean addContinuationType(LexicalCategory ... types) {
        return this.add(this.continuationTypes, types);
    }

    public boolean addRequiredType(LexicalCategory ... types) {
        return this.add(this.requiredTypes, types);
    }

    public boolean addEndType(LexicalCategory ... types) {
        return this.add(this.endTypes, types);
    }

    public boolean removeStartType(LexicalCategory ... types) {
        return this.remove(this.startTypes, types);
    }

    public boolean removePrefixType(LexicalCategory ... types) {
        return this.remove(this.prefixTypes, types);
    }

    public boolean removeContinuationType(LexicalCategory ... types) {
        return this.remove(this.continuationTypes, types);
    }

    public boolean removeRequiredType(LexicalCategory ... types) {
        return this.remove(this.requiredTypes, types);
    }

    public boolean removeEndType(LexicalCategory ... types) {
        return this.remove(this.endTypes, types);
    }

    public LexicalCategory getPhraseType() {
        return this.phraseType;
    }

    public Set<LexicalCategory> getStartType() {
        return this.readOnlyStartTypes;
    }

    public Set<LexicalCategory> getPrefixType() {
        return this.readOnlyPrefixTypes;
    }

    public Set<LexicalCategory> getContinuationType() {
        return this.readOnlyContinuationTypes;
    }

    public Set<LexicalCategory> getRequiredType() {
        return this.readOnlyRequiredTypes;
    }

    public Set<LexicalCategory> getEndType() {
        return this.readOnlyEndTypes;
    }

    private boolean add(Set<LexicalCategory> set, LexicalCategory ... types) {
        boolean changed = false;
        if (types != null) {
            for (LexicalCategory type : types) {
                if (type == null || !set.add(type)) continue;
                changed = true;
            }
        }
        return changed;
    }

    private boolean remove(Set<LexicalCategory> set, LexicalCategory ... types) {
        boolean changed = false;
        if (types != null) {
            for (LexicalCategory type : types) {
                if (type == null || !set.remove(type)) continue;
                changed = true;
            }
        }
        return changed;
    }

    public String toString() {
        return this.phraseType.name();
    }
}

