/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.poschunker.engine;

import java.util.concurrent.locks.ReadWriteLock;
import org.apache.stanbol.enhancer.engines.poschunker.PhraseBuilder;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.model.Chunk;
import org.apache.stanbol.enhancer.nlp.model.Token;

public class ChunkFactoryImpl
implements PhraseBuilder.ChunkFactory {
    private final AnalysedText at;
    private final ReadWriteLock lock;

    public ChunkFactoryImpl(AnalysedText at, ReadWriteLock lock) {
        this.at = at;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk createChunk(Token start, Token end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Parst start Token '" + start + "' and end Token '" + end + "' MUST NOT be NULL!");
        }
        this.lock.writeLock().lock();
        try {
            Chunk chunk = this.at.addChunk(start.getStart(), end.getEnd());
            return chunk;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

