/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.poschunker.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.stanbol.enhancer.engines.poschunker.PhraseBuilder;
import org.apache.stanbol.enhancer.engines.poschunker.PhraseTypeDefinition;
import org.apache.stanbol.enhancer.engines.poschunker.engine.ChunkFactoryImpl;
import org.apache.stanbol.enhancer.nlp.NlpProcessingRole;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.model.Section;
import org.apache.stanbol.enhancer.nlp.model.Token;
import org.apache.stanbol.enhancer.nlp.pos.LexicalCategory;
import org.apache.stanbol.enhancer.nlp.utils.LanguageConfiguration;
import org.apache.stanbol.enhancer.nlp.utils.NlpEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.ServiceProperties;
import org.apache.stanbol.enhancer.servicesapi.impl.AbstractEnhancementEngine;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosChunkerEngine
extends AbstractEnhancementEngine<RuntimeException, RuntimeException>
implements ServiceProperties {
    private static final Map<String, Object> SERVICE_PROPERTIES;
    public static final String CONFIG_LANGUAGES = "enhancer.engine.poschunker.languages";
    public static final String MIN_POS_SCORE = "enhancer.engine.poschunker.minPosScore";
    public static final double DEFAULT_MIN_POS_SCORE = 0.5;
    public static final String NOUN_PHRASE_STATE = "enhancer.engine.poschunker.nounPhrase";
    public static final boolean DEFAULT_NOUN_PHRASE_STATE = true;
    public static final String VERB_PHRASE_STATE = "enhancer.engine.poschunker.verbPhrase";
    public static final boolean DEFAULT_VERB_PHRASE_STATE = false;
    private static final PhraseTypeDefinition NOUN_PHRASE_TYPE;
    private static final PhraseTypeDefinition VERB_PHRASE_TYPE;
    private static Logger log;
    private LanguageConfiguration languageConfiguration = new LanguageConfiguration("enhancer.engine.poschunker.languages", new String[]{"*"});
    private double minPosScore = -1.0;
    private List<PhraseTypeDefinition> phraseTypeDefinitions;

    public int canEnhance(ContentItem ci) throws EngineException {
        if (this.phraseTypeDefinitions.isEmpty()) {
            return 0;
        }
        String language = NlpEngineHelper.getLanguage((EnhancementEngine)this, (ContentItem)ci, (boolean)false);
        if (language == null) {
            return 0;
        }
        if (!NlpEngineHelper.isLangaugeConfigured((EnhancementEngine)this, (LanguageConfiguration)this.languageConfiguration, (String)language, (boolean)false)) {
            return 0;
        }
        if (NlpEngineHelper.getAnalysedText((EnhancementEngine)this, (ContentItem)ci, (boolean)false) == null) {
            return 0;
        }
        return 2;
    }

    public void computeEnhancements(ContentItem ci) throws EngineException {
        AnalysedText at = NlpEngineHelper.getAnalysedText((EnhancementEngine)this, (ContentItem)ci, (boolean)true);
        String language = NlpEngineHelper.getLanguage((EnhancementEngine)this, (ContentItem)ci, (boolean)true);
        NlpEngineHelper.isLangaugeConfigured((EnhancementEngine)this, (LanguageConfiguration)this.languageConfiguration, (String)language, (boolean)true);
        ChunkFactoryImpl chunkFactory = new ChunkFactoryImpl(at, ci.getLock());
        ArrayList<PhraseBuilder> phraseBuilders = new ArrayList<PhraseBuilder>(this.phraseTypeDefinitions.size());
        for (PhraseTypeDefinition ptd : this.phraseTypeDefinitions) {
            phraseBuilders.add(new PhraseBuilder(ptd, chunkFactory, this.minPosScore));
        }
        Iterator<AnalysedText> sentences = at.getSentences();
        if (!sentences.hasNext()) {
            sentences = Collections.singleton(at).iterator();
        }
        while (sentences.hasNext()) {
            Section sentence = (Section)sentences.next();
            for (PhraseBuilder pb : phraseBuilders) {
                pb.nextSection(sentence);
            }
            Iterator tokens = sentence.getTokens();
            while (tokens.hasNext()) {
                Token token = (Token)tokens.next();
                for (PhraseBuilder pb : phraseBuilders) {
                    pb.nextToken(token);
                }
            }
        }
        for (PhraseBuilder pb : phraseBuilders) {
            pb.nextSection(null);
        }
    }

    public Map<String, Object> getServiceProperties() {
        return SERVICE_PROPERTIES;
    }

    protected void activate(ComponentContext ce) throws ConfigurationException {
        Double minPosScore;
        log.info("activating POS tagging engine");
        super.activate(ce);
        Dictionary properties = ce.getProperties();
        Object value = properties.get(MIN_POS_SCORE);
        if (value instanceof Number) {
            minPosScore = ((Number)value).doubleValue();
        } else if (value != null && !value.toString().isEmpty()) {
            try {
                minPosScore = Double.parseDouble(value.toString());
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(MIN_POS_SCORE, "The configured minumum chunk score MUST BE a floating pointnumber in the range > 0 < 1.", (Throwable)e);
            }
        } else {
            minPosScore = null;
        }
        if (minPosScore != null && (minPosScore >= 1.0 || minPosScore < 0.0)) {
            throw new ConfigurationException(MIN_POS_SCORE, "The configured minumum chunk score '" + minPosScore + "' MUST BE a " + "floating point number in the range > 0 < 1.");
        }
        this.minPosScore = minPosScore == null ? 0.5 : minPosScore;
        log.info(" > set minimum POS score to {} (Engine: {})", (Object)this.minPosScore, (Object)this.getName());
        this.languageConfiguration.setConfiguration(properties);
        this.phraseTypeDefinitions = new ArrayList<PhraseTypeDefinition>(2);
        value = properties.get(NOUN_PHRASE_STATE);
        if (value != null && Boolean.parseBoolean(value.toString()) || value == null) {
            this.phraseTypeDefinitions.add(NOUN_PHRASE_TYPE);
        }
        if ((value = properties.get(VERB_PHRASE_STATE)) == null || !Boolean.parseBoolean(value.toString())) {
            if (value == null) {
                // empty if block
            }
        } else {
            this.phraseTypeDefinitions.add(VERB_PHRASE_TYPE);
        }
    }

    protected void deactivate(ComponentContext context) {
        this.languageConfiguration.setDefault();
        this.minPosScore = -1.0;
        super.deactivate(context);
    }

    static {
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("org.apache.stanbol.enhancer.engine.order", ServiceProperties.ORDERING_NLP_CHUNK);
        props.put("org.apache.stanbol.enhancer.engine.nlp.role", (Integer)NlpProcessingRole.Chunking);
        SERVICE_PROPERTIES = Collections.unmodifiableMap(props);
        PhraseTypeDefinition nounPD = new PhraseTypeDefinition(LexicalCategory.Noun);
        nounPD.addStartType(LexicalCategory.PronounOrDeterminer, LexicalCategory.Adjective);
        nounPD.addPrefixType(LexicalCategory.PronounOrDeterminer, LexicalCategory.Adjective);
        nounPD.addContinuationType(LexicalCategory.Punctuation);
        nounPD.addEndType(LexicalCategory.PronounOrDeterminer, LexicalCategory.Adjective);
        NOUN_PHRASE_TYPE = nounPD;
        PhraseTypeDefinition verbPD = new PhraseTypeDefinition(LexicalCategory.Verb);
        verbPD.addStartType(LexicalCategory.Adverb);
        verbPD.addContinuationType(LexicalCategory.Adverb, LexicalCategory.Punctuation);
        verbPD.addEndType(LexicalCategory.Adverb);
        VERB_PHRASE_TYPE = verbPD;
        log = LoggerFactory.getLogger(PosChunkerEngine.class);
    }
}

