/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.restful.nlp.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.clerezza.rdf.core.Language;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.stanbol.enhancer.nlp.NlpAnnotations;
import org.apache.stanbol.enhancer.nlp.json.AnalyzedTextParser;
import org.apache.stanbol.enhancer.nlp.model.AnalysedText;
import org.apache.stanbol.enhancer.nlp.model.AnalysedTextFactory;
import org.apache.stanbol.enhancer.nlp.model.Span;
import org.apache.stanbol.enhancer.nlp.model.annotation.Value;
import org.apache.stanbol.enhancer.nlp.ner.NerTag;
import org.apache.stanbol.enhancer.nlp.utils.LanguageConfiguration;
import org.apache.stanbol.enhancer.nlp.utils.NlpEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.ServiceProperties;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.impl.AbstractEnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulNlpAnalysisEngine
extends AbstractEnhancementEngine<IOException, RuntimeException>
implements ServiceProperties {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String ANALYSIS_SERVICE_URL = "enhancer.engine.restful.nlp.analysis.service";
    public static final String ANALYSIS_SERVICE_USER = "enhancer.engine.restful.nlp.analysis.service.user";
    public static final String ANALYSIS_SERVICE_PWD = "enhancer.engine.restful.nlp.analysis.service.pwd";
    public static final String CONFIG_LANGUAGES = "enhancer.engine.restful.nlp.languages";
    private static final int DEFAULT_SELECTION_CONTEXT_PREFIX_SUFFIX_SIZE = 50;
    private static final Map<String, Object> SERVICE_PROPERTIES;
    private static Logger log;
    private URI analysisServiceUrl;
    private LanguageConfiguration languageConfig = new LanguageConfiguration("enhancer.engine.restful.nlp.languages", new String[]{"*"});
    private final Set<String> supportedLanguages = new HashSet<String>();
    protected DefaultHttpClient httpClient;
    private BasicHttpParams httpParams;
    private PoolingClientConnectionManager connectionManager;
    private AnalysedTextFactory analysedTextFactory;
    private AnalyzedTextParser analyzedTextParser;

    public int canEnhance(ContentItem ci) throws EngineException {
        Map.Entry entry = NlpEngineHelper.getPlainText((EnhancementEngine)this, (ContentItem)ci, (boolean)false);
        if (entry == null || entry.getValue() == null) {
            return 0;
        }
        String language = NlpEngineHelper.getLanguage((EnhancementEngine)this, (ContentItem)ci, (boolean)false);
        if (language == null) {
            return 0;
        }
        if (!this.languageConfig.isLanguage(language)) {
            log.trace(" > can NOT enhance ContentItem {} because language {} is not enabled by this engines configuration", (Object)ci, (Object)language);
            return 0;
        }
        if (!this.supportedLanguages.contains(language)) {
            log.trace(" > the RESTful Analysis service does not support '{}' (supported: {})", (Object)language, this.supportedLanguages);
            return 0;
        }
        log.trace(" > can enhance ContentItem {} with language {}", (Object)ci, (Object)language);
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeEnhancements(ContentItem ci) throws EngineException {
        final AnalysedText at = NlpEngineHelper.initAnalysedText((EnhancementEngine)this, (AnalysedTextFactory)this.analysedTextFactory, (ContentItem)ci);
        Blob blob = at.getBlob();
        String language = NlpEngineHelper.getLanguage((EnhancementEngine)this, (ContentItem)ci, (boolean)true);
        final HttpPost request = new HttpPost(this.analysisServiceUrl);
        request.addHeader("Content-Language", language);
        request.setEntity((HttpEntity)new InputStreamEntity(blob.getStream(), blob.getContentLength(), ContentType.create((String)blob.getMimeType(), (String)((String)blob.getParameter().get("charset")))));
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<AnalysedText>(){

                @Override
                public AnalysedText run() throws ClientProtocolException, IOException {
                    return (AnalysedText)RestfulNlpAnalysisEngine.this.httpClient.execute((HttpUriRequest)request, (ResponseHandler)new AnalysisResponseHandler(at));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ClientProtocolException) {
                throw new EngineException((EnhancementEngine)this, ci, "Exception while executing Request on RESTful NLP Analysis Service at " + this.analysisServiceUrl, (Throwable)e);
            }
            if (!(e instanceof IOException)) throw (RuntimeException)RuntimeException.class.cast(e);
            throw new EngineException((EnhancementEngine)this, ci, "Exception while executing Request on RESTful NLP Analysis Service at " + this.analysisServiceUrl, (Throwable)e);
        }
        Iterator spans = at.getEnclosed(EnumSet.of(Span.SpanTypeEnum.Sentence, Span.SpanTypeEnum.Chunk));
        Object context = null;
        MGraph metadata = ci.getMetadata();
        Language lang = new Language(language);
        LiteralFactory lf = LiteralFactory.getInstance();
        ci.getLock().writeLock().lock();
        try {
            block8: while (spans.hasNext()) {
                Span span = (Span)spans.next();
                switch (span.getType()) {
                    case Sentence: {
                        continue block8;
                    }
                }
                Value nerAnno = span.getAnnotation(NlpAnnotations.NER_ANNOTATION);
                if (nerAnno == null) continue;
                UriRef ta = EnhancementEngineHelper.createTextEnhancement((ContentItem)ci, (EnhancementEngine)this);
                metadata.add((Object)new TripleImpl((NonLiteral)ta, Properties.ENHANCER_SELECTED_TEXT, (Resource)new PlainLiteralImpl(span.getSpan(), lang)));
                metadata.add((Object)new TripleImpl((NonLiteral)ta, Properties.ENHANCER_START, (Resource)lf.createTypedLiteral((Object)span.getStart())));
                metadata.add((Object)new TripleImpl((NonLiteral)ta, Properties.ENHANCER_END, (Resource)lf.createTypedLiteral((Object)span.getEnd())));
                metadata.add((Object)new TripleImpl((NonLiteral)ta, Properties.ENHANCER_SELECTION_CONTEXT, (Resource)new PlainLiteralImpl(context == null ? this.getDefaultSelectionContext(at.getSpan(), span.getSpan(), span.getStart()) : context.getSpan(), lang)));
                if (((NerTag)nerAnno.value()).getType() != null) {
                    metadata.add((Object)new TripleImpl((NonLiteral)ta, Properties.DC_TYPE, (Resource)((NerTag)nerAnno.value()).getType()));
                }
                if (!(nerAnno.probability() >= 0.0)) continue;
                metadata.add((Object)new TripleImpl((NonLiteral)ta, Properties.ENHANCER_CONFIDENCE, (Resource)lf.createTypedLiteral((Object)nerAnno.probability())));
            }
            return;
        }
        finally {
            ci.getLock().writeLock().unlock();
        }
    }

    public Map<String, Object> getServiceProperties() {
        return SERVICE_PROPERTIES;
    }

    protected void activate(ComponentContext ce) throws ConfigurationException, IOException {
        String supported;
        String pwd;
        String usr;
        super.activate(ce);
        log.info("activate {} '{}'", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getName());
        Dictionary properties = ce.getProperties();
        this.languageConfig.setConfiguration(properties);
        Object value = properties.get(ANALYSIS_SERVICE_URL);
        if (value == null) {
            throw new ConfigurationException(ANALYSIS_SERVICE_URL, "The RESTful Analysis Service URL is missing in the provided configuration!");
        }
        try {
            this.analysisServiceUrl = new URI(value.toString());
            log.info("  ... service: {}", (Object)this.analysisServiceUrl);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(ANALYSIS_SERVICE_URL, "The parsed RESTful Analysis Service URL '" + value + "'is not a valid URL!", (Throwable)e);
        }
        value = properties.get(ANALYSIS_SERVICE_USER);
        if (value != null && !value.toString().isEmpty()) {
            usr = value.toString();
            value = properties.get(ANALYSIS_SERVICE_PWD);
            pwd = value == null ? null : value.toString();
        } else {
            usr = null;
            pwd = null;
        }
        this.httpParams = new BasicHttpParams();
        this.httpParams.setParameter("http.useragent", (Object)"Apache Stanbol RESTful NLP Analysis Engine");
        this.httpParams.setBooleanParameter("http.protocol.handle-redirects", true);
        this.httpParams.setIntParameter("http.protocol.max-redirects", 3);
        this.httpParams.setBooleanParameter("http.socket.keepalive", true);
        this.connectionManager = new PoolingClientConnectionManager();
        this.connectionManager.setMaxTotal(20);
        this.connectionManager.setDefaultMaxPerRoute(20);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)this.connectionManager, (HttpParams)this.httpParams);
        if (usr != null) {
            log.info("  ... setting user to {}", (Object)usr);
            this.httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(usr, pwd));
            this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(), 0);
        }
        try {
            supported = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    return (String)RestfulNlpAnalysisEngine.this.httpClient.execute((HttpUriRequest)new HttpGet(RestfulNlpAnalysisEngine.this.analysisServiceUrl), (ResponseHandler)new BasicResponseHandler());
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)RuntimeException.class.cast(e);
        }
        StringTokenizer st = new StringTokenizer(supported, "{[\",]}");
        while (st.hasMoreElements()) {
            this.supportedLanguages.add(st.nextToken());
        }
    }

    protected void deactivate(ComponentContext context) {
        this.languageConfig.setDefault();
        this.supportedLanguages.clear();
        this.httpClient = null;
        this.httpParams = null;
        this.connectionManager.shutdown();
        this.connectionManager = null;
        super.deactivate(context);
    }

    private String getDefaultSelectionContext(String content, String selection, int selectionStartPos) {
        int endPos;
        int beginPos;
        if (selectionStartPos <= 50) {
            beginPos = 0;
        } else {
            int start = selectionStartPos - 50;
            beginPos = content.indexOf(32, start);
            if (beginPos < 0 || beginPos >= selectionStartPos) {
                beginPos = start;
            }
        }
        if (selectionStartPos + selection.length() + 50 >= content.length()) {
            endPos = content.length();
        } else {
            int start = selectionStartPos + selection.length() + 50;
            endPos = content.lastIndexOf(32, start);
            if (endPos <= selectionStartPos + selection.length()) {
                endPos = start;
            }
        }
        return content.substring(beginPos, endPos);
    }

    static {
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("org.apache.stanbol.enhancer.engine.order", ServiceProperties.ORDERING_NLP_TOKENIZING);
        SERVICE_PROPERTIES = Collections.unmodifiableMap(props);
        log = LoggerFactory.getLogger(RestfulNlpAnalysisEngine.class);
    }

    protected void bindAnalysedTextFactory(AnalysedTextFactory analysedTextFactory) {
        this.analysedTextFactory = analysedTextFactory;
    }

    protected void unbindAnalysedTextFactory(AnalysedTextFactory analysedTextFactory) {
        if (this.analysedTextFactory == analysedTextFactory) {
            this.analysedTextFactory = null;
        }
    }

    protected void bindAnalyzedTextParser(AnalyzedTextParser analyzedTextParser) {
        this.analyzedTextParser = analyzedTextParser;
    }

    protected void unbindAnalyzedTextParser(AnalyzedTextParser analyzedTextParser) {
        if (this.analyzedTextParser == analyzedTextParser) {
            this.analyzedTextParser = null;
        }
    }

    private static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthScope authScope;
            Credentials creds;
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                authState.update((AuthScheme)new BasicScheme(), creds);
            }
        }
    }

    protected class AnalysisResponseHandler
    implements ResponseHandler<AnalysedText> {
        protected final AnalysedText at;

        protected AnalysisResponseHandler(AnalysedText at) {
            this.at = at;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AnalysedText handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            InputStream in = null;
            try {
                in = entity.getContent();
                Charset charset = entity.getContentEncoding() != null ? Charset.forName(entity.getContentEncoding().getValue()) : UTF8;
                AnalysedText analysedText = RestfulNlpAnalysisEngine.this.analyzedTextParser.parse(in, charset, this.at);
                return analysedText;
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }
}

