/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.jobmanager.event.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.stanbol.enhancer.jobmanager.event.impl.EnhancementJob;
import org.apache.stanbol.enhancer.jobmanager.event.impl.EventJobManagerImpl;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngineManager;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionPlanHelper;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancementJobHandler
implements EventHandler {
    private EnhancementEngineManager engineManager;
    private EventAdmin eventAdmin;
    private Logger log = LoggerFactory.getLogger(EnhancementJobHandler.class);
    private Map<EnhancementJob, EnhancementJobObserver> processingJobs;
    private final ReadWriteLock processingLock = new ReentrantReadWriteLock();
    private Thread observerDaemon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancementJobHandler(EventAdmin eventAdmin, EnhancementEngineManager engineManager) {
        if (eventAdmin == null) {
            throw new IllegalArgumentException("The parsed EventAdmin service MUST NOT be NULL!");
        }
        if (engineManager == null) {
            throw new IllegalArgumentException("The parsed EnhancementEngineManager MUST NOT be NULL!");
        }
        this.eventAdmin = eventAdmin;
        this.engineManager = engineManager;
        this.processingLock.writeLock().lock();
        try {
            this.processingJobs = new LinkedHashMap<EnhancementJob, EnhancementJobObserver>();
        }
        finally {
            this.processingLock.writeLock().unlock();
        }
        this.observerDaemon = new Thread(new EnhancementJobObserverDaemon());
        this.observerDaemon.setName("Event Job Manager Observer Daemon");
        this.observerDaemon.setDaemon(true);
        this.observerDaemon.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.log.info("deactivate {}", (Object)this.getClass().getName());
        this.processingLock.writeLock().lock();
        try {
            Iterator<EnhancementJobObserver> i$ = this.processingJobs.values().iterator();
            while (i$.hasNext()) {
                EnhancementJobObserver o;
                EnhancementJobObserver enhancementJobObserver = o = i$.next();
                synchronized (enhancementJobObserver) {
                    o.notifyAll();
                }
            }
            this.processingJobs = null;
        }
        finally {
            this.processingLock.writeLock().unlock();
        }
        this.observerDaemon = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancementJobObserver register(EnhancementJob enhancementJob) {
        boolean init;
        EnhancementJobObserver observer;
        this.processingLock.writeLock().lock();
        try {
            if (enhancementJob == null || this.processingJobs == null) {
                EnhancementJobObserver enhancementJobObserver = null;
                return enhancementJobObserver;
            }
            observer = this.processingJobs.get(enhancementJob);
            if (observer == null) {
                observer = new EnhancementJobObserver(enhancementJob);
                if (this.log.isDebugEnabled()) {
                    EnhancementJobHandler.logJobInfo(this.log, enhancementJob, "Add EnhancementJob:", this.log.isTraceEnabled());
                }
                this.processingJobs.put(enhancementJob, observer);
                init = true;
            } else {
                this.log.warn("Request to register an EnhancementJob for an ContentItem {} that isalready registered " + enhancementJob.getContentItem().getUri());
                init = false;
            }
        }
        finally {
            this.processingLock.writeLock().unlock();
        }
        if (init) {
            observer.acquire();
            enhancementJob.startProcessing();
            this.log.trace("++ w: {}", (Object)"init execution");
            enhancementJob.getLock().writeLock().lock();
            try {
                this.log.trace(">> w: {}", (Object)"init execution");
                if (!this.executeNextNodes(enhancementJob)) {
                    String message = "Unable to start Execution of " + enhancementJob.getContentItem().getUri();
                    this.log.warn(message);
                    EnhancementJobHandler.logJobInfo(this.log, enhancementJob, null, true);
                    this.log.warn("finishing job ...");
                    this.finish(enhancementJob);
                }
            }
            finally {
                this.log.trace("<< w: {}", (Object)"init execution");
                enhancementJob.getLock().writeLock().unlock();
            }
        }
        return observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        EnhancementJob job = (EnhancementJob)event.getProperty("stanbol.enhancer.jobmanager.event.job");
        NonLiteral execution = (NonLiteral)event.getProperty("stanbol.enhancer.jobmanager.event.execution");
        if (job == null || execution == null) {
            this.log.warn("Unable to process EnhancementEvent where EnhancementJob {} or Execution node {} is null -> ignore", (Object)job, (Object)execution);
        }
        try {
            this.processEvent(job, execution);
        }
        catch (Throwable t) {
            String message = String.format("Unexpected Exception while processing ContentItem %s with EnhancementJobManager: %s", job.getContentItem().getUri(), EventJobManagerImpl.class);
            job.setFailed(execution, null, new IllegalStateException(message, t));
            this.log.error(message, t);
        }
        this.log.trace("++ w: {}", (Object)"check for next Executions");
        job.getLock().writeLock().lock();
        this.log.trace(">> w: {}", (Object)"check for next Executions");
        try {
            if (job.isFinished()) {
                this.finish(job);
            } else if (!job.isFailed()) {
                if (!this.executeNextNodes(job) && job.getRunning().isEmpty()) {
                    this.log.warn("Unexpected state in the Execution of ContentItem {}: Job is not finished AND no executions are running AND no further execution could be started! -> finishing this job :(");
                    this.finish(job);
                }
            } else if (this.log.isInfoEnabled()) {
                ArrayList<String> running = new ArrayList<String>(3);
                for (NonLiteral runningNode : job.getRunning()) {
                    running.add(ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionPlan(), (NonLiteral)job.getExecutionNode(runningNode)));
                }
                this.log.info("Job {} failed, but {} still running!", (Object)job.getContentItem().getUri(), running);
            }
        }
        finally {
            this.log.trace("<< w: {}", (Object)"check for next Executions");
            job.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(EnhancementJob job, NonLiteral execution) {
        String engineName = ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionPlan(), (NonLiteral)job.getExecutionNode(execution));
        EnhancementEngine engine = this.engineManager.getEngine(engineName);
        if (engine != null) {
            int engineState;
            EngineException exception = null;
            try {
                engineState = engine.canEnhance(job.getContentItem());
            }
            catch (EngineException e) {
                exception = e;
                this.log.warn("Unable to check if engine '" + engineName + "'(type: " + engine.getClass() + ") can enhance ContentItem '" + job.getContentItem().getUri() + "'!", (Throwable)e);
                engineState = 0;
            }
            if (engineState == 1) {
                this.log.trace("++ w: {}: {}", (Object)"start sync execution", (Object)engine.getName());
                job.getLock().writeLock().lock();
                this.log.trace(">> w: {}: {}", (Object)"start sync execution", (Object)engine.getName());
                try {
                    engine.computeEnhancements(job.getContentItem());
                    job.setCompleted(execution);
                }
                catch (EngineException e) {
                    this.log.warn(e.getMessage(), (Throwable)e);
                    job.setFailed(execution, engine, (Exception)((Object)e));
                }
                catch (RuntimeException e) {
                    this.log.warn(e.getMessage(), (Throwable)e);
                    job.setFailed(execution, engine, e);
                }
                finally {
                    this.log.trace("<< w: {}: {}", (Object)"finished sync execution", (Object)engine.getName());
                    job.getLock().writeLock().unlock();
                }
            } else if (engineState == 2) {
                try {
                    this.log.trace("++ n: start async execution of Engine {}", (Object)engine.getName());
                    engine.computeEnhancements(job.getContentItem());
                    this.log.trace("++ n: finished async execution of Engine {}", (Object)engine.getName());
                    job.setCompleted(execution);
                }
                catch (EngineException e) {
                    this.log.warn(e.getMessage(), (Throwable)e);
                    job.setFailed(execution, engine, (Exception)((Object)e));
                }
                catch (RuntimeException e) {
                    this.log.warn(e.getMessage(), (Throwable)e);
                    job.setFailed(execution, engine, e);
                }
            } else if (exception != null) {
                job.setFailed(execution, engine, (Exception)((Object)exception));
            } else {
                job.setCompleted(execution);
            }
        } else {
            job.setFailed(execution, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(EnhancementJob job) {
        EnhancementJobObserver observer;
        this.processingLock.writeLock().lock();
        try {
            observer = this.processingJobs.remove(job);
        }
        finally {
            this.processingLock.writeLock().unlock();
        }
        if (observer != null) {
            try {
                if (this.log.isDebugEnabled()) {
                    EnhancementJobHandler.logJobInfo(this.log, job, "Finished EnhancementJob:", this.log.isTraceEnabled());
                }
                this.log.trace("++ n: finished processing ContentItem {} with Chain {}", (Object)job.getContentItem().getUri(), (Object)job.getChainName());
            }
            finally {
                observer.release();
            }
        } else {
            this.log.warn("EnhancementJob for ContentItem {} is not registered with {}. Will not send notification!", (Object)job.getContentItem().getUri(), (Object)this.getClass().getName());
        }
    }

    protected boolean executeNextNodes(EnhancementJob job) {
        boolean startedExecution = false;
        for (NonLiteral executable : job.getExecutable()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("PREPARE execution of Engine {}", (Object)ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionPlan(), (NonLiteral)job.getExecutionNode(executable)));
            }
            Hashtable<String, EnhancementJob> properties = new Hashtable<String, EnhancementJob>();
            ((Dictionary)properties).put("stanbol.enhancer.jobmanager.event.job", job);
            ((Dictionary)properties).put("stanbol.enhancer.jobmanager.event.execution", (EnhancementJob)executable);
            job.setRunning(executable);
            if (this.log.isTraceEnabled()) {
                this.log.trace("SHEDULE execution of Engine {}", (Object)ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionPlan(), (NonLiteral)job.getExecutionNode(executable)));
            }
            this.eventAdmin.postEvent(new Event("stanbol/enhancer/jobmanager/event/topic", properties));
            startedExecution = true;
        }
        return startedExecution;
    }

    protected static void logJobInfo(Logger log, EnhancementJob job, String header, boolean logExecutions) {
        if (header != null) {
            log.info(header);
        }
        log.info("   finished:     {}", (Object)job.isFinished());
        log.info("   state:        {}", (Object)(job.isFailed() ? "failed" : "processing"));
        log.info("   chain:        {}", (Object)job.getChainName());
        log.info("   content-item: {}", (Object)job.getContentItem().getUri());
        if (logExecutions) {
            log.info("  executions:");
            for (NonLiteral completedExec : job.getCompleted()) {
                log.info("    - {} completed", (Object)ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionMetadata(), (NonLiteral)job.getExecutionNode(completedExec)));
            }
            for (NonLiteral runningExec : job.getRunning()) {
                log.info("    - {} running", (Object)ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionMetadata(), (NonLiteral)job.getExecutionNode(runningExec)));
            }
            for (NonLiteral executeable : job.getExecutable()) {
                log.info("    - {} executeable", (Object)ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionMetadata(), (NonLiteral)job.getExecutionNode(executeable)));
            }
        }
        if (job.getErrorMessage() != null) {
            log.info("Error Message: {}", (Object)job.getErrorMessage());
        }
        if (job.getError() != null) {
            log.info("Reported Exception:", (Throwable)job.getError());
        }
    }

    private class EnhancementJobObserverDaemon
    implements Runnable {
        private Logger observerLog = LoggerFactory.getLogger(EnhancementJobObserverDaemon.class);

        private EnhancementJobObserverDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.observerLog.debug(" ... init EnhancementJobObserver");
            while (EnhancementJobHandler.this.processingJobs != null) {
                List<Object> jobs;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                Lock readLock = EnhancementJobHandler.this.processingLock.readLock();
                readLock.lock();
                try {
                    jobs = EnhancementJobHandler.this.processingJobs != null ? new ArrayList(EnhancementJobHandler.this.processingJobs.keySet()) : Collections.emptyList();
                }
                finally {
                    readLock.unlock();
                }
                if (!jobs.isEmpty()) {
                    this.observerLog.debug(" -- {} active Enhancement Jobs", (Object)jobs.size());
                    if (!this.observerLog.isDebugEnabled()) continue;
                    for (EnhancementJob job : jobs) {
                        Lock jobLock = job.getLock().readLock();
                        jobLock.lock();
                        try {
                            EnhancementJobHandler.logJobInfo(this.observerLog, job, null, true);
                        }
                        finally {
                            jobLock.unlock();
                        }
                    }
                    continue;
                }
                EnhancementJobHandler.this.log.debug(" -- No active Enhancement Jobs");
            }
        }
    }

    public class EnhancementJobObserver {
        private static final int MIN_WAIT_TIME = 500;
        private final EnhancementJob enhancementJob;
        private final Semaphore semaphore;

        private EnhancementJobObserver(EnhancementJob job) {
            if (job == null) {
                throw new IllegalArgumentException("The parsed EnhancementJob MUST NOT be NULL!");
            }
            this.enhancementJob = job;
            this.semaphore = new Semaphore(1);
        }

        protected void acquire() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                EnhancementJobHandler.this.log.warn("Interrupted while acquireing Semaphore for EnhancementJob " + this.enhancementJob + "!", (Throwable)e);
            }
        }

        protected void release() {
            this.semaphore.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasCompleted() {
            this.enhancementJob.getLock().readLock().lock();
            try {
                boolean bl = this.enhancementJob.isFinished();
                return bl;
            }
            finally {
                this.enhancementJob.getLock().readLock().unlock();
            }
        }

        public boolean waitForCompletion(int maxEnhancementJobWaitTime) {
            boolean acquire = false;
            if (this.semaphore.availablePermits() < 1) {
                try {
                    acquire = this.semaphore.tryAcquire(1, Math.max(500, maxEnhancementJobWaitTime), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    acquire = false;
                }
            } else if (!this.hasCompleted()) {
                int wait = Math.max(100, maxEnhancementJobWaitTime / 10);
                EnhancementJobHandler.this.log.warn("Unexpected permit available for Semaphore of EnhancementJob of ContentItem {}. Fallback to wait({})for detecting if Job has finished. While the fallback should ensure correct Enhancement results this indicates a Bug in the EventHobManager. Please feel free to report This on dev@stanbol.apache.org or the Apache Stanbol Issue Tracker.", (Object)this.enhancementJob.getContentItem().getUri(), (Object)wait);
                try {
                    Thread.currentThread().wait(wait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                acquire = true;
            }
            return acquire;
        }
    }
}

